/* ------------------------------------------------------------------ */
/*								      */
/*		TIFF IMAGE DATA WRITE AND UPDATE FUNCTION	      */
/*								      */
/*		DEVELOPED BY:	VIJAY RANGARAJAN		      */
/*		DATE:		8/26/86 			      */
/*								      */
/*		DEST CORPORATION				      */
/*								      */
/* ------------------------------------------------------------------ */

/* this version is backedup as tifwrite.bak prior to new changes */
/* this version stores compressed data, but the image looks distorted */
/* changes - 9/15   10.00am */


#define  T_273	273
#define  T_279	279
#include "apptag.h"

#define NULL	0L

extern int tlpWrite();
extern int write();

extern short field_mem_tab[];
extern long	field_data_endpos;
extern long	field_data_pos;
extern long	ifdsize;
extern long	get_cpos();
extern int	field_data_write();
extern short fields_exist;

short	image_begin;

static long	strpofst_pos;
static long	strpbytcnt_pos;
static long	sav_fil_pos;
static long	*strpofst_mem_ptr;
static long	*strpbytcnt_mem_ptr;

static long	curnt_pos;
static long	strperimg;
static int	filhandle;

   /********* should be an array indexed by fhandle ***********************/
static short  status = 0;

static long offset_strip_mem[500];
static long count_strip_mem[500];

   /* included to handled compress data  9/11 */

extern char	far *bigalloc();
extern char	far *bigfree();
extern short compress_block();
static char	far *comp_buffer = 0L;
static char	far *comp_ptr = 0L;
static char	far *rawbuf_ptr;
static long	comp_size = 0L;
static long	lines_alloc = 0L;
static long	line_count;
static short compress_type;
static short comp_count;
static long	tot_comp_count;
static long	tot_byte_count;

  /* ---------------------------------------- */



short byte_width;

int set_position(), write_img_data(), write_strptrs(), rewrite_field_data();
void strpofst_update_ptr(), strpbytcnt_update_ptr(), write_tagval();
void update_strp_ifd();

long  write_image(fhandle,fdtype,plane,startpos,numlines,buffer_ptr)

int	 fhandle;
short fdtype;
short plane;
long  startpos;
long  numlines;
char  far *buffer_ptr;
{

	long   image_length;
	long   image_width;
	static long	 l_bytewidth;		/* 9/16 */
	static long	 rowsprstrp;
	long   get_tagval();
	long   num_bytes;
	long   i;
	int	  j;
	long bitssamp;
	long samppix;

	if (status == 0) {
		status = 1;
		image_begin = 1;

		image_length = get_tagval(T_IMG_LENGTH);
		image_width =  get_tagval(T_IMG_WIDTH);

		if((bitssamp = get_tagval(T_BITS_SAMPLE)) == NULL) {
			bitssamp = BITSSAMP;
		}

		if((samppix = get_tagval(T_SAMP_PIX)) == NULL) {
			samppix = SAMPPIXEL;
		}

		compress_type = (short) get_tagval(T_COMPRESS);  /* comp 9/11 */

		/* keep in mind here that data may be lost if the number */
		/* of bytes per line exceeds 65535 */

		byte_width = (short)(image_width * samppix * bitssamp + 7 ) / 8;
		l_bytewidth = (image_width * samppix * bitssamp + 7 ) / 8;
		tot_byte_count = 0L;

		rowsprstrp = get_tagval(T_RWPRSTRP);
		if (rowsprstrp == 0)
			rowsprstrp = image_length;

		filhandle = fhandle;
		strperimg = (image_length + rowsprstrp -1)/rowsprstrp;


		if (set_position(fhandle, field_data_endpos) < 0)
			return (0L);

		strpofst_mem_ptr = (long *) &(offset_strip_mem[0]);

		strpbytcnt_mem_ptr = (long *) &(count_strip_mem[0]);

		sav_fil_pos = get_cpos(fhandle);

		if (strperimg == 1) {
			*strpofst_mem_ptr =(long) sav_fil_pos;
			*strpbytcnt_mem_ptr =(long)(l_bytewidth * image_length);
		}

	}

/*  Get current file position */

	num_bytes = (long) (l_bytewidth * numlines);
	line_count = numlines;
	lines_alloc = line_count;

	if (strperimg != 1) {
		sav_fil_pos = get_cpos(fhandle);
		strpofst_update_ptr();
	}

/*  Check if data is to be compressed 9/11 */

	switch(compress_type) {

		case ONE_D_MOD:

	 /* Compress image data using 1D modified Huffman code technique
	  * and allocate necessary buffer size for compressed data    */

			j = 1; 		/* one line compression */
			comp_size = (l_bytewidth * (j * 6));
			if ((comp_buffer = bigalloc(comp_size)) == 
					(char far *) 0x0000) {
				return(0L);
			}
			comp_ptr = comp_buffer;
			rawbuf_ptr = buffer_ptr;
			while (line_count > 0) {

			    /* compress 1 line 9/15 */

				comp_count = compress_block(rawbuf_ptr,
						 comp_ptr, l_bytewidth, j);


				rawbuf_ptr += (l_bytewidth * j);
				tot_comp_count = (long) comp_count;


				if (write_img_data (fhandle, comp_buffer,
						 tot_comp_count) < 0) {
					bigfree(comp_buffer);
					return(0L);
				}

				tot_byte_count += tot_comp_count; /* 9/12 */

				line_count -= j;

			}  /* end of outer while loop */

/*  new addition 9/12 */

			if (strperimg ==1) {
				*strpbytcnt_mem_ptr = tot_byte_count;
			}
			else {
				strpbytcnt_update_ptr(tot_byte_count);
				tot_byte_count = 0L;	/* 10/9 vj */
			}

			bigfree(comp_buffer);
			break;
	 	 	 	 	 	 
		/* ----- end of case ---------- */

		default:     /*  Write image data onto the file */

			if (write_img_data (fhandle, buffer_ptr, num_bytes)<0){
				return (0L);
			}

			if (strperimg !=1)
				strpbytcnt_update_ptr(num_bytes); /* 9/12 */

	}	/* close braces for switch loop */


	return(numlines);
}


/*  Write image data function */


int write_img_data(fhndle, bufptr, bytesize)
   int	fhndle;
   char far *bufptr;
   long bytesize;

   {
   int smallbytesize;

   smallbytesize = (int) bytesize;
   if ((tlpWrite (fhndle, bufptr, smallbytesize)) != smallbytesize)
      return (-1);

   return (0);
   }


/*  Update stripoffset table */

void strpofst_update_ptr()
   {
   *strpofst_mem_ptr = (long) sav_fil_pos;
   ++strpofst_mem_ptr;
   }

/*  Update stripbytecount table */

void strpbytcnt_update_ptr(no_bytes)
   long no_bytes;
   {

   *strpbytcnt_mem_ptr = no_bytes;
   strpbytcnt_mem_ptr++;
   }








/*  Get the value of the specfied tag */

   long get_tagval(tag_num)
   short  tag_num;
   {

   short *field_ptr;
   short tag_index;
   long  tag_val, *ptr;
   short i;

   field_ptr = field_mem_tab+1;

   i = field_mem_tab[0];
   while (i-- > 0)
       {
       if (tag_num != *field_ptr)
	  {
	  field_ptr += 6;
	  }

       else
	  {
	  field_ptr += 4;
	  ptr = (long *) field_ptr;
	  tag_val = *ptr;
	  return(tag_val);
	  }

       }

   return(0L);
   }


/*  Position the file */

int set_position(fhandl, fil_pos)

  int	fhandl;
  long	fil_pos;

  {
     long	lseek();
     int	mode = 0;

     if (lseek(fhandl, fil_pos, mode) < 0)
	return (-1);

     return (0);
  }




/* Close TIFF creating subsystem */

   int close_create(fhndl)

   int	fhndl;

   {

   image_begin = 0;
   fields_exist = 0;
   status = 0;		/* reset for next file */

	if(strperimg != 1) {
		strpofst_pos = get_cpos(fhndl);
		if(write_strptrs(fhndl,&(offset_strip_mem[0]),(strperimg*4))< 0)
			return (0);

		strpbytcnt_pos = get_cpos(fhndl);
		if(write_strptrs(fhndl,&(count_strip_mem[0]),(strperimg*4)) < 0)
			return (0);

	}
	else {
		strpofst_pos = offset_strip_mem[0];
		strpbytcnt_pos = count_strip_mem[0];
	}

	update_strp_ifd(fhndl);

	if (rewrite_field_data(fhndl) < 0)
		return (0);

   return(1);
   }

/*  Write strip offset table onto the file */

int write_strptrs(handle, strp_mem, length)

   int	handle;
   long *strp_mem;
   long length;

   {
   int smalllength;

   smalllength = (int) length;
   if ((write (handle, strp_mem, smalllength)) != smalllength)
      return (-1);
   return (0);
   }


/*  Update strip tags data in ifd */

void update_strp_ifd(fl_handl)

   int fl_handl;
   {
   short tagnum = T_273;
   write_tagval(fl_handl, tagnum, strperimg, strpofst_pos);

   tagnum = T_279;
   write_tagval(fl_handl, tagnum, strperimg, strpbytcnt_pos);

   }



/*  Write tag length and tag value into the tag */

void write_tagval(handle, tagnum, tagln, tagval)

   int	handle;
   short tagnum;
   long  tagln;
   long  tagval;

   {
   short *field_ptr;
   long  tag_val, *ptr;
   short i;

   field_ptr = field_mem_tab+1;
   i = field_mem_tab[0];
   while (i-- > 0)
       {
       if (tagnum != *field_ptr)
	  {
	  field_ptr += 6;
	  }

       else
	  {
	  field_ptr += 2;
	  ptr = (long *) field_ptr;
	  *ptr++ = tagln;
	  *ptr++ = tagval;
	  break;
	  }
       }
   }


/*  Rewrite the field data */

int rewrite_field_data(handle)

   int handle;

   {

   if (set_position(handle, field_data_pos) < 0)
      return (-1);
   field_data_write (handle, ifdsize);
   return (0);
   }
