/* ------------------------------------------------------------------ */
/*								      */
/*		TIFF CREATING SYSTEM				      */
/*								      */
/*		DEVELOPED BY:	VIJAY RANGARAJAN		      */
/*								      */
/*		DATE:		8/21/1986			      */
/*								      */
/*		DEST CORPORATION				      */
/*								      */
/*								      */
/* ------------------------------------------------------------------ */

#include "tifstruc.h"

#define MAX_TAG		301		/* the maximum tag value */

   extern int write();
   extern int set_position();

   void init_tif_hdr();
   void check_tag();
   int	field_data_write();
   int	write_tag_val();
   int	find_type();
   long get_cpos();
   short check_strp_tags();
   long header_fil1_pos;		      /* header file position */
   long field_data_pos; 		      /* ifd file position */
   long field_data_endpos;		      /* ifd end position */
   long next_val_pos;
   long ifdsize;			      /* total byte size in ifd */

   short del_tag_flag = 0;
   short no_more_strp_del = 0;
   short fields_exist;
   short *field_mem_ptr;
   char tag_273;
   char tag_279;
   int tot_tag_num;
   short no_of_tags;
   int filehandle;

   short field_mem_tab[256];

   ifdstrc subfile, strpofst, strpbtcnt;

   short write_fields(thandle, filetype, buf_ptr, sizebytes)

   int	thandle;
   short filetype;
   short far *buf_ptr;
   long sizebytes;

   {
   int header_write(), build_tags(), header_rewrite();

     fields_exist = 1;
     del_tag_flag = 0;
     no_more_strp_del = 0;
     filehandle = thandle;
     init_tif_hdr();				/* create Tiff header */

/* Get current position of the file and save it */
/* Write header information into the file */

     header_fil1_pos = get_cpos(thandle);

     if (header_write(thandle) < 0)
	return (0);

     if (build_tags(buf_ptr, filetype, sizebytes) < 0)
	return (0);

     field_data_pos = get_cpos(thandle);

     if (field_data_write(thandle, ifdsize) < 0)
	return(0);

     field_data_endpos = get_cpos(thandle);

     tiff_header.first_ifd_addr = field_data_pos;
     if (header_rewrite(thandle, header_fil1_pos) < 0)
	return(0);

     return(no_of_tags);
   }



/* Create TIFF header */

void init_tif_hdr()

   {
     tiff_header.byteorder = INTEL_FMT;
     tiff_header.version = TIF_VERSION;
     tiff_header.first_ifd_addr = ZERO;

     tag_273 = 0;
     tag_279 = 0;
     tot_tag_num = 0;
     no_of_tags = 0;
   }


/* write header structure into the file */

int header_write(flhndle)

   int	 flhndle;

   {
     if ((write (flhndle, &tiff_header, sizeof(struct header_tiff_struc)))
	  != sizeof(struct header_tiff_struc))
	return (-1);

     return (0);
   }




/* Gives current position in the file */

   long get_cpos(fhndl)
   int	fhndl;

   {
     long   lseek();
     long current_pos;

     current_pos = lseek(fhndl, 0L, 1);
     return(current_pos);
   }



/* Build tags */

   int build_tags(bfpointer, filetype, size)

   short far *bfpointer;
   short filetype;
   long size;

   {
     short del_bytes;	/*9/24, 5.15pm */
     short tag_num;
     short count;
     short bcount;
     short data_len;
     int   field_type;
     long  *ptr, field_len;
     char  *cptr;
     char  tmp;
     char  far *bptr;
     long  val_fil_pos;
     int   j;
     long  next_ifd_ptr;
     void  build_sbfile_tag();
     int write_data(), find_type();

     field_mem_ptr = (short *) field_mem_tab;
     build_sbfile_tag(filetype);
     tot_tag_num++;
     memcpy( &(field_mem_tab[1]), &subfile, sizeof(ifdstrc));
     field_mem_ptr += 7;

     while (size > 0)

     {
	tag_num = *bfpointer++;

/* 9/24, 5.17pm -------------------------------------*/

	del_bytes = check_strp_tags(tag_num, bfpointer);
	if(del_tag_flag)
	  {
	  size -= (del_bytes +4);
	  bfpointer += ((del_bytes + 2)/2);
	  tag_num = *bfpointer++;
	  }
/* --------------------------------------------------*/


	check_tag(tag_num, field_mem_ptr);
	no_of_tags++;
	tot_tag_num++;
	if ((field_type = find_type(tag_num)) < 0)
	   return (-1);
	count = *bfpointer++;
	bcount = count;
	*field_mem_ptr++ = tag_num;
	*field_mem_ptr++ = (short) field_type;

	switch (field_type) {
	  case 1:
		  data_len = 1;
		  break;

	  case 2:
		  data_len = 1;
		  break;

	  case 3:
		  data_len = 2;
		  break;

	  case 4:
		  data_len = 4;
		  break;

	  case 5:
		  data_len = 8;
		  break;

	  default:
		  data_len = 0;

	}

	if (data_len == 0)
	   return (-1);

	field_len = (long) (count/data_len);
	ptr = (long *) field_mem_ptr;
	*ptr++ = field_len;
	field_mem_ptr = (short *) ptr;

	if (data_len <= 4)
	   {
	   cptr = (char *) field_mem_ptr;
	   bptr = (char far *) bfpointer;
	   while(count-- > 0)
	      {
	      tmp = *bptr++;
	      *cptr++ = tmp;
	      }
	    for (j = 4-bcount; j > 0; j--)
		*cptr++ = 0;

	    field_mem_ptr = (short *) cptr;
	    bfpointer = (short far *) bptr;

	   }

	else
	   {
	   val_fil_pos = get_cpos(filehandle);
	   if (write_data(filehandle, bfpointer, count) < 0)
	      return (-1);
	   bfpointer += (count/2);
	   ptr = (long *) field_mem_ptr;
	   *ptr = val_fil_pos;
	   *field_mem_ptr++;
	   *field_mem_ptr++;
	   next_val_pos = get_cpos(filehandle);
	   }



/*	check_tag(tag_num, field_mem_ptr);		*/
	size -= (bcount+4);


     }

     field_mem_tab[0] = (short) tot_tag_num;
     ifdsize = (2+(tot_tag_num * 12));
     field_mem_ptr = field_mem_tab;
     field_mem_ptr += (ifdsize/2);
     next_ifd_ptr = 0;
     ptr = (long *) field_mem_ptr;
     *ptr = next_ifd_ptr;
     ifdsize += 4;
     del_tag_flag = 0;
     return (0);

   }



/* Build subfile tag data */

void build_sbfile_tag(ftype)

   short ftype;
   {
     subfile.tagnum = TAG255;
     subfile.fieldtype = TSHORT;
     subfile.fieldlen = 1;
/***********************************??????? ask vj about this ????**********/
     subfile.offset_rvalue = (long) ftype;
   }



/* Write ifd data into the file */

int field_data_write(hndle, ifdsize)
   int	 hndle;
   long  ifdsize;

   {
     int smallifdsize;

     smallifdsize = (int) ifdsize;
     if ((write(hndle, field_mem_tab, smallifdsize)) != smallifdsize)
	return (-1);

     return (0);
   }



/*  Write any kind of data onto the file */

int write_data(fhndle, bufptr, bytsize)
   int	fhndle;
   char far *bufptr;
   short bytsize;

   {

   if ((tlpWrite (fhndle, bufptr, bytsize)) != bytsize)
      return (-1);

   return (0);
   }



/*  Check the tag if stripoffset / stripbytecount tags are to be attached */

void check_tag(tag_num, field_ptr)
short tag_num;
short *field_ptr;

{
   void build_strpofst_tag(), build_strpbytcnt_tag();

   if (tag_num == TAG273)
      tag_273 = 1;

   if (tag_num == TAG279)
      tag_279 = 1;

   if (tag_num > TAG273) {
	if (tag_273 == 0) {
		tag_273 = 1;
		build_strpofst_tag(field_ptr);
	}

	if (tag_num > TAG279) {
		if (tag_279 == 0) {
			tag_279 = 1;
			build_strpbytcnt_tag(field_mem_ptr);
		}
	}
   }

}


/*  Build stripoffset tag */

void build_strpofst_tag(field_ptr)
  short *field_ptr;

   {

     strpofst.tagnum = TAG273;
     strpofst.fieldtype = TLONG;
     strpofst.fieldlen = 0;
     strpofst.offset_rvalue = 0L;

     memcpy ( field_ptr, &strpofst, sizeof(ifdstrc));
     field_mem_ptr += 6;
     tot_tag_num++;
   }



/*  Build stripbytecount tag */

void build_strpbytcnt_tag(field_ptr)
   short *field_ptr;


   {

     strpbtcnt.tagnum = TAG279;
     strpbtcnt.fieldtype = TLONG;
     strpbtcnt.fieldlen = 0;
     strpbtcnt.offset_rvalue = 0L;

     memcpy ( field_ptr, &strpbtcnt, sizeof(ifdstrc));
     field_mem_ptr += 6;
     tot_tag_num++;
   }

/*  Find field type for the specified tag number */


   int find_type(tag_no)

   short tag_no;
   {

	/* type table for the various tags.  The table begins at tag 255 */
	/* and runs to tag number 301.  If you add tags that have a numeric */
	/* value greater than 301, be sure to change the maxtagno manifest */
	/* to reflect this change */

   static int tagfield[] = {3, 3, 3, 3, 3,
			    0, 0, 3, 3, 3,
			    3, 3, 0, 0, 2,
			    2, 2, 2, 4, 3,
			    0, 0, 3, 4, 4,
			    3, 3, 5, 5, 3,
			    2, 5, 5, 4, 4,
			    3, 3, 4, 4, 0,
			    0, 3, 3, 0, 0,
			    3, 3};

   if (tag_no > MAX_TAG)
      return (-1);	/* table length exceeded */

   return (tagfield[tag_no - 255]);
   }




/*  Rewrite the file header */

int header_rewrite(fhandle, file_pos)
   int fhandle;
   long file_pos;

   {
   long lseek();
   int header_write();

   if (lseek (fhandle, file_pos, 0) < 0)
      return (-1);

   if (header_write(fhandle) < 0)
      return (-1);

   return (0);
   }


/* Write Tag function  9/16 */

int write_tag_val(fil_handle, fdtype, tagnum, dataptr, length)

int	fil_handle;
short	fdtype;
short	tagnum;
short far  *dataptr;
short	length; 	/* length in bytes */

   {
   char  *cptr;
   char far *bptr;
   short *field_ptr;
   short i, data_type;
   long  *ptr;
   long data_pos;

   field_ptr = field_mem_tab+1;
   i = field_mem_tab[0];
   while (i-- > 0)
       {
       if(tagnum != *field_ptr)
	 {
	 field_ptr += 6;
	 }

       else
	{
	field_ptr += 1;
	data_type = *field_ptr;
	field_ptr +=3;

	     if (data_type <= 4 && length <=4) {	/* be able to write */
		cptr = (char *) field_ptr;		/* arrays */
		bptr = (char far *) dataptr;
		while(length-- > 0)
		     {
		     *cptr++ = *bptr++;
		     }
	     }
	     else
	     {
	       ptr = (long *) field_ptr;
	       data_pos = *ptr;
	       if(set_position(fil_handle, data_pos) < 0)
		 return(0);
	       if(write_data(fil_handle, dataptr, length) < 0)
		 return(-1);
	       }

	return(tagnum);

	}

       }

      return(0);
   }




/* Check if stripbytcount and stripoffset tags already exists */
/* if so, delete them */

short	check_strp_tags(tag_no, buf_pontr)
short	tag_no;
short	far *buf_pontr;

   {
   short tag_byte_count;


   if (!no_more_strp_del)
      {
      if (tag_no == TAG273)
	 {
	 tag_273 = 0;
	 tag_byte_count = *buf_pontr++;
	 del_tag_flag = 1;
	 return (tag_byte_count);
	 }

      if (tag_no == TAG279)
	 {
	 tag_279 = 0;
	 tag_byte_count = *buf_pontr++;
	 del_tag_flag = 1;
	 no_more_strp_del = 1;
	 return (tag_byte_count);
	 }
      }
   del_tag_flag = 0;
   return(0);

   }

