#include <tiff.h>

extern LONG bigRead();
extern LONG lseek();
extern BOOL reorder();
extern BOOL correct_version();

BOOL _TIFF_reorder_bytes = FALSE;

/* read TIFF file header record */
SHORT
read_header(fhandle, header_buff)
SHORT fhandle;
TIFF_HEADER far *header_buff;
{
	LONG nbytes;

	/* make sure buffer isn't null */
	if(!header_buff)
	{
		return(0);
	}

	/* seek to start of file */
	if(lseek(fhandle, 0L, 0) == (LONG)(-1))
	{
		return(0);
	}

	/* do the read */
	nbytes = bigRead(fhandle, header_buff, (LONG)TIFF_HEADER_SIZE);
	if(nbytes != TIFF_HEADER_SIZE)
	{
		return(0);
	}

	/* reorder the bytes, if necessary */
	switch(header_buff->byte_order)
	{
	case INTEL:
		_TIFF_reorder_bytes = FALSE;
		break;

	case MOTOROLA:
		_TIFF_reorder_bytes = TRUE;
		break;

	default:		/* illegal byte order flag */
		return(0);
	}

	/* routine does nothing unless the _TIFF_reorder_bytes flag is set */
	reorder((LONGPTR)&(header_buff->version), SHORT_SIZE);
	reorder((LONGPTR)&(header_buff->dir_offset), LONG_SIZE);

	/* make sure version is correct */
	if(!correct_version(header_buff->version))
	{
		return(0);
	}

	return(LOWORD(nbytes));
}
