#include <tiff.h>

extern void debug();

extern LONG lseek();
extern LONG bigRead();
extern LONG get_1st_ifd();
extern SHORT type_length();
extern BOOL access_ifd();
extern BOOL read_dir();

SHORT
read_fields(fhandle, fdtype, buffer, max_length)
SHORT fhandle;
SHORT fdtype;
LONGPTR buffer;
LONG max_length;
{
	LONG ifd_offset = get_1st_ifd(fhandle);
	LONG new_offset;
	TIFF_DIR_ENTRY dirent;
	SHORT entry_count;
	SHORT subfile_type;

	/* go through IFD's ... stop at null IFD offset */
	while(ifd_offset)
	{
		/* get pertinent IFD data */
		if(access_ifd(fhandle, ifd_offset,
		  (TIFF_DIR_ENTRY far *)&dirent, &entry_count, &subfile_type,
		  &new_offset))
		{
			return(0);
		}

		/* match on subfile type? */
		if(fdtype == subfile_type)
		{
			SHORT n = entry_count - 1;
			/* go through each entry */
			while(n-- > 0 && !read_dir(fhandle,
			  (TIFF_DIR_ENTRY far *)&dirent))
			{
				LONG tot_len;
				LONG len;
debug("    tag %d, type %d, length %ld, offset %ld\n", dirent.tag,
 dirent.type, dirent.length, dirent.value_offset);
				/* get length of data to be copied */
				len = (LONG)type_length(dirent.type);
				len *= dirent.length;
				tot_len = len + SHORT_SIZE + SHORT_SIZE;

				/* length overflow? */
				max_length -= tot_len;
				if(max_length < 0)
				{
					return(0);
				}
				*((SHORT far *)buffer) = dirent.tag;
				buffer += SHORT_SIZE;
				*((SHORT far *)buffer) = LOWORD(len);
				buffer += SHORT_SIZE;
				if(len > LONG_SIZE)
				{
					LONG cur_pos = lseek(fhandle, 0L, 1);

					/* read data into user's buffer */
					if(lseek(fhandle, dirent.value_offset,
					  0) != dirent.value_offset)
					{
						return(0);
					}
					if(bigRead(fhandle, buffer, len) !=
					  len)
					{
						return(0);
					}
					buffer += len;
					lseek(fhandle, cur_pos, 0);
				}
				else
				{
					LONGPTR dp =
					  (LONGPTR)&(dirent.value_offset);
					while(len-- > 0)
					{
						*buffer++ = *dp++;
					}
				}
			}

			/* if we bombed out early, error exit */
			if(n > 0)
			{
				return(0);
			}

			/* since we matched, we can now go bye-bye */
			return(entry_count);
		}
		ifd_offset = new_offset;
	}
	return(0);
}
