;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
; Ints.asm
;
; Function: Handle interrupt switching
;   Handle interrupts when they occur with the CPU in the wrong mode
;   Handle software interrupt calls to real mode interrupt
;
	;MASM MODE
	.386p

include	 boot.asi 
include  page.asi 
include	 pic.ase 
include  ints.mac 
include  boot.ase 
include  tss.ase 
include  os.asi 
include  prints.ase 

	PUBLIC	intprot, realintcall, intreal
	PUBLIC  taskint, intnumber
	PUBLIC  regs
	assume	es:nothing	
segdata	SEGMENT	

regs	dosregs	<>
espsave	dd	0
sssave	dd	0
stacksave dd	0
pwait	dd	0
segdata	ENDS	


segdata	SEGMENT	
;
; Call a real mode interrupt
; We do this in the data segment so we can twiggle the
;   interrupt number while in protected mode
;
	assume	cs:dgroup
dorealint	proc far
	db	0cdh	;INT instruction
intnumber db	0
	retf
	assume	cs:cgroup
dorealint	endp
segdata	ENDS	

seg386	SEGMENT	
;
; This version does an interrupt from protected mode
;
doprotint:
	db	0cdh	
protmod	db	0
	ret
;
; Call protected mode interrupt when currently in real mode
;   USE PROTINT macro to generate a protected mode interrupt
;   It generates interrupt-specific code which loads al with the
;   interrupt number and then branches here
;
seg8086	SEGMENT	
intprot	PROC	
	mov	BYTE PTR cs:[protmod],al	; Save vector number
	INTTOPROT				; Go into protected mode
	inc	[canmultitask]			; Disable multitasking
	call	doprotint			; Do interrupt
	dec	[canmultitask]			; Enable multitasking
	INTFROMPROT				; Return to real mode
	pop	ax				; Restore register
	iret					; Out
intprot	ENDP	
seg8086	ENDS	
;
; call real int from protected int
;    USE CALLINT macro to generate a call to this
;    It generates interrupt-specific code which pushes EDI, loads
;    EDI with the address in the DOSVEC table which has the old value
;    of the REAL interrupt vector, and calls this routine
;
realintcall	PROC	
	INTTOREAL  save				; To real mode
	pushf					;Emulate real mode interupt
	call	DWORD PTR [di]			; Call interrupt 
						; from tDOSVEC table
	INTFROMREAL  save			; From prot mode
	ret					; Return to caller
realintcall	ENDP	
;
; do real int in protected mode
;    Use REALINT macro to generate a real mode interrupt
;    It generates interrupt-specific code which loads EDI with the address
;    in the real mode table where the interrupt vector can be found
;    and then branches here
;
intreal	PROC	
	INTTOREAL save				; Real mode
	sub	ax,ax				; Get real mode interrupt table
	mov	ds,ax				; to DS
	pushf					; Emulate real mode interrupt
	call	DWORD PTR [di]
	INTFROMREAL save			; Protected mode
	pop	edi				; Restore registers
	iretd					; Return to caller
intreal	ENDP	
;
; Call real mode interrupt from protected mode - task level
;
taskint	PROC	far			; Far because mimicking IRET later
	assume	ds:dgroup
	
	push	ds
	push	DS386			; Load DS
	pop    	ds
	mov	BYTE PTR [intnumber],al	; Save int number
	mov	[regs.rbx],ebx		; Save bx
   	pop	ds
	pop	eax
	FROMPROT save			; Enter real mode
	mov	bx,WORD PTR [regs.rbx]		; Get BX
	mov	es,[regs.res]
	mov	ds,[regs.rds]		; And segment regs
	call	dgroup:dorealint
	push	ds
	push	ds
	push	dgroup	 		; get data group
	pop	ds

	mov	WORD PTR [regs.rax],ax
	mov	WORD PTR [regs.rbx],bx		; Save regs
	mov	[regs.res],es
	pop	[regs.rds]
	pop	ds
	TOPROT	save			; Enter protected mode
	push	ds
	push	DS386			; Load BX up with return value
	pop	ds			;
	mov	ebx,[regs.rbx]		;
	mov	eax,[regs.rax]		;
	pop	ds			;
	retf	04
	push	eax
	lahf				; Get status flags
	mov	[esp+12],ah		; Save them for the iret
	pop	eax
	iretd
taskint	ENDP	
seg386	ENDS	
END
