;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
;
; Error handling not handled
; Not tested with huge sat tables
;
; Fs.asm
;
; Function: basic file system functionality
;   Handles Creating boot sector
;   Handles creating root directory sector ( empty)
;   Handles creating sector allocation tables( SATS)
;   Handles the OS MakeFS call
;
	;MASM MODE
	.386p

include  errors.asi 
include  segs.asi 
include  os.asi 
include  buffers.ase 
include  dispatch.ase 
include  floppy.asi 
include  fs.asi 
include  prints.ase 

	PUBLIC	ClearNumSats,AllocSector,fs_dispatch, AllocDirSector
	PUBLIC  LoadRootDir,DeAllocSector,roots
	extrn	dirtest
seg386data	SEGMENT	
sats	dd	?			; Number of sats to allocate
snumsats	dd	NUMDRIVES DUP (-1)	; Table of sats per drive
roots	dd	NUMDRIVES DUP (-1)	; Table of rootdirs per drive
idlab	=	$			; File system label
ident	db	"Davids FS*"		;
idlen	=	$ - idlab		;
DIRIDLAB = $	 			; Directory label
dirident db	"Davids Directory"	;
diridlen =	$ - diridlab		;
seg386data	ENDS	

seg386	SEGMENT	
;
; Clear the sat and root pointers if changed disk
;
ClearNumSats	PROC	
	jnc	short noclear		; Get out if no error
	cmp	al,DERR_CHANGED		; If changed, reset sats
	jz	short changed		;
	cmp	al,DERR_TIMEOUT		; IF not present, reset sats
	jnz	short nochange		;
changed:
	mov	edi,offset dgroup:snumsats	; Get sat table
	mov	DWORD PTR [edi + ebx *4],-1	; Clear it
nochange:
	stc				; Restore carry flag
noclear:
	ret
ClearNumSats	ENDP	
;
; Load up the number of sats
;
LoadSats	PROC	
	mov	edi,offset dgroup:snumsats	; Get table entry
	mov	ecx,[edi + ebx * 4]	;
	inc	ecx			; See if is -1
	jnz	short gotsats		; Got sats number if not
	sub	edx,edx			; Else read the boot sector
	call	ReadSector		;
	jc	ls_err			; Get out if can't
	mov	ecx,[esi + FSPAGE.NUMSATS]; Load sats from boot sector
	mov	[edi + ebx * 4],ecx	;
	mov	edi,offset dgroup:roots	; Load rootdir from boot sector
	mov	eax,[esi + FSPAGE.ROOTDIR];
	mov	[edi + ebx * 4],eax	;
	inc	ecx			;
gotsats:
	dec	ecx			;
	clc
	ret
ls_err:
	stc
	mov	al,ERR_NOSATS
	ret
LoadSats	ENDP	
;
; Load up the root directory sector
;
LoadRootDir	PROC	
	call	LoadSats		; Make sure we have the right disk
	jc	short badroot		;
	mov	edi,offset dgroup:roots	; Load rootdir from table
	mov	edx,[edi + ebx * 4]	;
	clc
	ret
badroot:
	mov	al,ERR_NOROOT
	stc
	ret
LoadRootDir	ENDP	
;
; Read a sat
;
ReadSat	PROC	
	push	edx			; Save 
	push	ecx
	mov	ecx,BITSPERSAT		; Divide by sectors per sat
	sub	edx,edx
	div	ecx			;

	add	eax,SATOFS		; OFfset to first sat
	xchg	edx,eax			;
	push	eax
	call	ReadSector              ; Read the sat
	jc	rs_err			; Get out if error
	pop	eax
	pop	ecx
	pop	edx
	ret
rs_err:
	pop	edx
	pop	ecx
	pop	edx
	ret
ReadSat	ENDP	
;
; Make the initial sat table
;
MakeSats	PROC	
	call	GetSectors		; Get sectors per disk
	sub	edx,edx			; Zero hi dword for division
	mov	ecx,BITSPERSAT		; Get number of sats required
	add	eax,ecx			;
	dec	eax			;
	div	ecx			;
	mov	[sats],eax		; Save it
	mov	ecx,eax			; Total count
	sub	edx,edx			; First sat
	add	edx,SATOFS		;
	push	ecx			; Save sat and count
	push	edx			;
writesats:
	push	ecx			; Save count
	call	WriteBuffer             ; Get a write buffer
	jc	short ms_err		; Get out if flush failed
	call	DirtyBuffer		; Dirty the buffer
	mov	ecx,SECTORSIZE / 4	; Getting ready to fill buffer
	mov	edi,esi			;
	sub	eax,eax			; Fill it with -1
	dec	eax			;
	cld
	rep	stosd			; Fill it
	pop	ecx			; Restore count
	inc	edx			; Next sector
	loop	writesats		; Do it

	pop	edx			; Restore sat and count
	pop	ecx			;
	call	ReadSector		; Read initial sat buffer
	btr	DWORD PTR [esi],0	; Mark boot sector allocated
cleansats:
	btr	DWORD PTR [esi],edx	; Mark one of the sat sectors allocated
	inc	edx			; Next sat
	loop	cleansats		; Loop till done
	clc				; No errors
	ret

ms_err:
	pop	ecx
	pop	edx
	pop	ecx
	ret
MakeSats	ENDP	
;
; Make the boot sector
;
MakeBootSect	PROC	
	sub	edx,edx			; Get a write buffer for boot sector
	call	WriteBuffer		;
	jc	short mbs_err		; Get out if flush failed
	call	DirtyBuffer		; Mark it dirty
	mov	edi,esi			; Getting ready to empty buffer
	push	edi			;
	mov	ecx,SECTORSIZE / 4	; Length of buffer
	sub	eax,eax			; Fill it with 0s
	cld
	rep	stosd			;
	pop	edi			;
	push	edi			;
	mov	esi,offset dgroup:ident	; Copy the FS ident into the ident field
	lea	edi,[edi + FSPAGE.ID]	;
	mov	ecx,idlen		;
	cld
	rep	movsb			;
	pop	edi			;
; Put in a jump instruction for when we want to boot
	mov	WORD PTR [edi + FSPAGE.JMPAROUND],JMPINST +( BOOTJMP SHL 8)
	mov	eax,[sats]		; Get number of sats
	mov	[edi  + FSPAGE.NUMSATS],eax	; Put it in boot sector
	mov	[edi  + FSPAGE.VER],0	; Blank the version field
	mov	eax,1			; Initialize the KBPERSAT field to 1
	mov	[edi + FSPAGE.KBPERSAT],eax	;
	ret
mbs_err:
	ret
MakeBootSect	ENDP	
;
; Deallocate a sector by setting its sat bit
;
DeallocSector	PROC	
	push	esi
	call	ReadSat			; Read the sat table
	jc	short ds_err
	bts	[esi],eax		; Set the bit
	call	DirtyBuffer		; Mark the sat buffer dirty
	pop	esi
	ret
ds_err:
	pop	esi
	ret
DeallocSector	ENDP	
;
; Scan a sat sector for a set bit
;
ScanForSector	PROC	
	push	ebx			; Save drive num
	mov	ebx,esi			; Get start of buffer
	mov	ecx,SECTORSIZE / 4	; Number of dwords to scan
bitsect:
	bsf	eax,[esi]		; Scan a dword
	jnz	gotbit			; Got a bit, go calc sector number
	add	esi,4			; Next dword
	loop	bitsect			; Continue
	mov	esi,ebx			; Restore sector buffer
	pop	ebx			; Restore drive num
	stc
	mov	al,ERR_DISKFULL
	ret
gotbit:
	btr	[esi],eax		; Clear the sector bit
	sub	esi,ebx			; Get total bytes scanned
	shl	esi,3			; Eight bits per byte
	add	eax,esi			; Add in the offset of the last word
	mov	esi,ebx			; Restore sector bufferx
	pop	ebx			;
	clc
	ret
ScanForSector	ENDP	
;
; Allocate a sector
;
AllocSector	PROC	
	call	LoadSats		; Load the number of sats
	jc	short as_err		; Get out if couldn't
	sub	edx,edx			; Start at onset of sats
satlp:
	mov	eax,edx			; Bit number in eax
	call	ReadSat			; Read a sat
	jc	as_err			; Get out if error
	call	ScanForSector		; Scan for sector
	jnc	gotSector		; If got a sector mark the sat dirty
	add	edx,BITSPERSAT		; Next sat
	loop	satlp			; Go do it
as_err:
	stc
	ret
gotsector:
	push	eax			; Now get total sectors on disk
	call	GetSectors		;
	pop	ecx			;
	xchg	eax,ecx			; Restore sector number
	cmp	eax,ecx			; Limit check
	jnc	as_err			; Failed, mark error
	call	DirtyBuffer		; Mark the sat as dirty
	clc
	ret
AllocSector	ENDP	
AllocDirSector	PROC	
	call	AllocSector		; Allocate a sector
	push	eax
	jc	short ads_error		; Error, get out
	mov	edx,eax			; Get the sector number to edx
	call	WriteBuffer		; Allocate a write buffer
	jc	short ads_error		; Get out on error
	call	DirtyBuffer		; Mark the buffer dirty
	mov	edi,esi			; Get ready to fill it with -1
	mov	ecx,SECTORSIZE / 4	; Length of buffer
	sub	eax,eax			; Fill value = -1
	dec	eax			;
	cld
	rep	stosd			; Fill the buffer
	push	esi
	mov	edi,esi
	mov	[esi + DIRPAGE.DPFLAGS],0	; Mark it as a leaf
	mov	[esi + DIRPAGE.ITEMS],0	; No items in dir
	mov	[esi + DIRPAGE.DPVER],0	; No version
	mov	[esi + DIRPAGE.PAGELESS],0	; No less page
	mov	esi,offset dgroup:dirident	; Get directory ident
	lea	edi,[edi + DIRPAGE.DPNM]	; Copy into root sector
	mov	ecx,diridlen		;
	cld
	rep	movsb			;
	clc
	pop	esi
	pop	eax
	ret
ads_error:
	pop	eax
	ret
AllocDirSector	ENDP	
	
AllocFirstLeaf	PROC	
	call	AllocDirSector		; Allocate a directory sector
	push	eax			; Save sector number
	jc	short afl_err2		; Get out if error
	sub	edx,edx			; Read boot sector
	call	ReadSector		;
	jc	short afl_err2		; Get out if error
	call	DirtyBuffer		; Boot sector is dirty
	pop	edx			; Get allocated sector
	mov	[esi + FSPAGE.ROOTDIR],edx ; Put it in the root
	mov	[roots + ebx *4],edx
	call	ReadSector		; Get the sector data
	jc	short afl_err		;
	call	DirtyBuffer		; Mark it dirty
	BTS	DWORD PTR [esi + DIRPAGE.DPFLAGS],DFL_LEAF;
	ret
afl_err2:
	pop	eax
afl_err:
	ret
AllocFirstLeaf	ENDP	
;
; Make a file system
;
MakeFS	PROC	
	call	MakeSats		; Create sats
	jc	short mfs_err		;
	call	MakeBootSect		; Create boot sector
	jc	short mfs_err		;
	call	AllocFirstLeaf		; Allocate first directory leaf
	jc	short mfs_err		;
	call	FlushBuffers		; Flush buffers
	jc	short mfs_err		;
	ret
mfs_err:
	ret
MakeFS	ENDP	
;
; Dispatch file system and directory commands
;
fs_dispatch	PROC	
	push	esi			; Save regs
	push	edi			;
	push	edx			;
	push	ecx			;
	push	ebx			;
	push	ds			;
	push	es			;
	push	ds386			; DS gets system data seg
	pop	ds			;
	push	ds386			; So does ES
	pop	es			;

	push	0			; Dispatch function
	call	TableDispatch		;
	dd	1
	dd	MakeFS
	dd	FlushBuffers
	pop	es			; Restore regs
	pop	ds			;
	pop	ebx			;
	pop	ecx			;
	pop	edx			;
	pop	edi			;
	pop	esi			;
	ret				;
fs_dispatch	ENDP	
seg386	ENDS	
END
