program Surfmodl_datafile_editor;

{ Names of all the systems currently supported by SURFMODL: }
const MAXSYS = 8;           { maximum # of systems currently supported }
      Sys_name: Array[1..MAXSYS] of string[30] = (
        'IBM Color Graphics Adapter',
        'IBM Enhanced Graphics Adapter',
        'Hercules Graphics Adapter',
        'Sanyo MBC-555',
        'Heath/Zenith Z-100',
        'CGA Compatible',
        'AT&T 6300',
        'IBM 3270');

      Up    = 242; Down = 250;  Left = 245;
      Right = 247; Esc  = 27;   Space= 32;
      Ret   = 13;
      Red   = 4;   Blue = 3;    Black = 0;

      STDCGA   = 1;      EGA      = 2;      HERCULES = 3;
      SANYO    = 4;      Z100     = 5;      TBCGA    = 6;
      ATT      = 7;      IBM3270  = 8;      QUAD480  = 9;
      QUAD752  = 10;

      NUMLGLSYS = 1;
      LGLSYS: Array[1..NUMLGLSYS] of integer = (EGA);
      { Global variables and constants for SURFMODL }
      MSDOS: boolean = TRUE;
      TOOLBOX: boolean = FALSE;
      MAXNODES = 4096;      { maximum # of nodes in the entire solid }
      MAXCONNECT = 16384;   { maximum # of connections in entire solid }
      MAXSURF = 5461;       { maximum # of surfaces in entire solid }
                            { (MAXSURF = MAXCONNECT / 3) }
      MAXMATL = 30;         { maximum # of materials in entire solid }
      MAXPTS = 600;         { maximum # of line points (in fillsurf) }
      MAXVAR = 20;          { maximum # of numeric inputs on a line }
      MAXLITE = 20;         { maximum # of light sources }
      maxobj = 10;            { maximum # of objects to include }


type  WindowType = ( elevation,plan,endview);
      Points = Array[1..MAXPTS] of integer;
      Realpts = Array[1..MAXPTS] of real;
      Text80 = string[80];
      VarType = Array[1..MAXVAR] of real;
      Surfaces = Array[1..MAXSURF] of real;
      Vector = Array[1..3] of real;
      NodeArray= Array[1..MAXNODES] of real;

      HeapArray1 = record Xworld:nodeArray; end;
      Hptr1 = ^heapArray1;
      HeapArray2 = record Yworld:nodeArray; end;
      HPtr2 = ^heapArray2;
      HeapArray3 = record Zworld:nodeArray; end;
      HPtr3 = ^heapArray3;
      HeapArray7 = record Connect :Array[1..MAXCONNECT] of integer; end;
      HPtr7 = ^heapArray7;
      HeapArray8 = record Nvert : Array[1..MAXSURF] of integer; end;
      HPtr8 = ^heapArray8;
      HeapArray9 = record Matl : Array[1..MAXSURF] of integer; end;
      hPtr9 = ^heapArray9;
      heapArray11 = record  Surfmin, Surfmax : surfaces; end;
      hPtr11 = ^heapArray11;

var   Ptra : hPtr1;   { Xworld }
      Ptrb : hPtr2;   { Yworld }
      Ptrc : hPtr3;   { Zworld }
      Ptrg : hPtr7;   { Connect }
      Ptrh : hPtr8;   { Nvert }
      Ptri : hPtr9;   { Matl }
      Ptrk : hPtr11;  { Surfmin, Surfmax }
      R1, R2, R3:   Array[1..MAXMATL] of real;
      Color:        Array[1..MAXMATL] of integer;
      Ambient:      Array[1..MAXMATL] of real;
      Xlite, Ylite,
      Zlite:        Array[1..MAXLITE] of real;
      Intensity:    Array[1..MAXLITE] of real;

      Flpurpose: string[127];              { title for plot }
      Xeye, Yeye, Zeye: real;              { coords of eye }
      Xfocal, Yfocal, Zfocal: real;        { coords of focal point }
      Maxvert: integer;                    { max # vertices per surface }
      Nsurf: integer;                      { # surfaces }
      Nnodes: integer;                     { # nodes }
      Nlite: integer;                      { # light sources }
      Magnify: real;                       { magnification factor }
      Viewtype: integer;                   { code for viewing type: }
                                           { 0=perspective, 1=XY, 2=XZ, 3=YZ }
      Fileread: boolean;                   { flag first file read }
      Nmatl: integer;                      { number of materials }
      GxMin, GxMax, GyMin, GyMax: integer; { graphics screen limits }
      System: integer;                     { computer being used (1..MAXSYS) }
      Nsides: integer;                     { #sides of surface used (1 or 2)}
      Interpolate: boolean;                { flag for Gouraud interpolation }
      Epsilon: real;                       { Gouraud interpolation range }
      Dorandom: boolean;                   { flag for randomness in Gouraud }
      Randshade: real;                     { random shade added to each pixel }
      Shadowing: boolean;                  { flag shadowing option }
      Inifile: text80;                     { name of INI file }
      XYadjust: real;                      { factor for screen width }
      Ngraphchar: integer;                 { #chars across graphics screen}
                                           { If 0 then no text will be
                                             displayed on the graphics screen }
      Showaxes: integer;                   { code to show (0) no axes; (1) }
                                           { axis directions; (2) full axes }
      Xaxislen,Yaxislen,Zaxislen: real;    { lengths of axes }
      Axiscolor: integer;                  { color to draw axes }
      Nwindow: integer;                    { # graphics windows on screen }
      Ncolors: integer;                    { #colors supported on computer }
      Mono: boolean;                       { Is picture to be displayed on }
                                           { monochrome monitor? }
      TBinit: boolean;                     { Has Toolbox been initialized? }
      Viewchanged: boolean;                { Has the viewing angle changed? }
      Xfotran, Yfotran, Zfotran: real;     { transformed focal point }
      XYmax: real;                         { limits of transformed coords }
      Memavail: real;                      { # bytes of available memory }
      Mxc: integer;                        { suggested value of MAXCONNECT }
      Realmaxsurf:      integer;           { max #surfaces, based on }
                                           { Maxvert and MAXCONNECT }
      line_num : integer;
      nobj:       integer;
      infile: text;
      comment,filename : text80;
      realvar:             vartype;
      i,Ch:                                integer;
      Curwindow,win:                       windowtype;
      Rotate:           vector;        { rotation angles }
      trans:        vector;        { transformation dist }
      Scale:            vector;        { scaling magnitude }
      firstnode,lastnode,
      firstsurf,lastsurf:                  array [1..maxobj] of integer;
      curobj:                              integer;
      Max,MIn:                             real;
      ElevTopX,elevTopY,elevBotX,elevBotY: real;
      EndTopX,endTopY,endBotX,endBotY:     real;
      PlanTopX,planTopY,planBotX,planBotY: real;
      TmpTopX,tmpTopY,tmpBotX,tmpBotY:     real;

{$i tbemega.pas}
{$i exgrega.pas}
{$i setsys.pas}
{$i inreal.pas}
{$i readini.pas}
{$i gx2de.pas}
{$i gxzoom.pas}
{$i gxgin.pas}

{ An important function for decoding the Connect Array: }

function KONNEC (Surf, Vert: integer): integer;
{ Decode the Connect Array to yield the connection data: Vertex Vert of
surface Surf. This function returns an index to the global Xtran, Ytran,
and Ztran Arrays (i.e., a node number) }
begin
with ptrg^ do
begin
  Konnec := Connect[(Surf-1) * Maxvert + Vert];
end; {with}
end; { function KONNEC }
procedure msg (p: integer;line : text80);
begin
     gotoxy (42,15+p);
     write (line,copy ('                                        ',
                        1,38-length(line)));
end; { msg }

procedure OPENFILE (var Filename: text80; var Infile: text);
{ Open a file with error checking. Prompt for new one if file not found }

begin   Fileread := FALSE;
  while (NOT Fileread) do begin
    assign (Infile, Filename);
    {$I-}
    reset (Infile);
    {$I+}
    if (ioresult <> 0) then begin
      writeln ('Error: file ',Filename,' does not exist.');
      write ('Enter new file name (or <enter> to exit): ');
      readln (Filename);
      if (Filename = '') then
        halt;
    end else
      Fileread := TRUE;
  end;
end;   { procedure OPENFILE }

procedure READFILE (Filename: text80);
{ read the input data from the file }

var
  Version: integer;       { used for multiple version input flag (only 4 now) }
  j: integer;             { counter for looping and reading into arrays}
  Infile: text;           { file to read}
  Realvar: vartype;       { temporary array for storage of line input }
  Num: integer;           { number of inputted values on the line }
  Comment: text80;        { comment at end of line }
  Line_num: integer;      { line number in input file }
  Nvread: integer;        { #vertices read so far in this surface }
  Vert: integer;          { vertex # }
  Nscript: integer;       { #script inputs }
  Cmmd: integer;          { script command number }
  Mat: integer;           { material # }
  Node: integer;          { node # }
  Surf: integer;          { surface # }
  Connection: integer;    { next connection number on surface }
  oldnmatl,oldnnodes,oldnsurf:   integer;

begin
with ptra^ do with ptrb^ do
with ptrc^ do with ptrg^ do
with ptrh^ do with ptri^ do
begin {with}
  oldnmatl  := nmatl;
  oldnnodes := nnodes;
  oldnsurf  := nsurf;

  openfile (Filename, Infile);
  readln (Infile, Flpurpose);
  Line_num := 2;
  Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
  if (Num <> 1) then begin
    writeln ('Bad input: Reading version number.');
    close (Infile);
    halt;
  end;
  Version := round(Realvar[1]);
  if (Version = 1) then begin
    Line_num := Line_num + 1;
    Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
    if (Num <> 4) then begin
      writeln ('Bad input: Reading #nodes, #surfaces, Maxvert and #materials',
          ' (line ',Line_num,')');
      close (Infile);
      halt;
    end;
    Nnodes  := round(Realvar[1]);
    Nsurf   := round(Realvar[2]);
    Maxvert := round(Realvar[3]);
    Nmatl   := nmatl + round(Realvar[4]);
    Nscript := 0;
    Nsides  := 1;
  end else if (Version = 2) then begin
    Line_num := Line_num + 1;
    Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
    if (Num <> 6) then begin
      writeln ('Bad input: Reading #matl, #nodes, #surf, #script, Maxvert,',
          ' #sides (line ',Line_num,')');
      close (Infile);
      halt;
    end;
    Nmatl := round(Realvar[1]);
    Nnodes := round(Realvar[2]);
    Nsurf := round(Realvar[3]);
    Nscript := round(Realvar[4]);
    Maxvert := round(Realvar[5]);
    Nsides := round(Realvar[6]);
  end else if (Version = 3) or (Version = 4) then begin
    Line_num := Line_num + 1;
    Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
    if (Num <> 5) then begin
      writeln ('Bad input: Reading #matl, #nodes, #surf, Maxvert,',
          ' #sides (line ',Line_num,')');
      close (Infile);
      halt;
    end;
    Nmatl := round(Realvar[1]);
    Nnodes := round(Realvar[2]);
    Nsurf := round(Realvar[3]);
    Maxvert := round(Realvar[4]);
    Nsides := round(Realvar[5]);
  end else begin
    writeln('Wrong data input version number specified');
    close (Infile);
    halt;
  end;

  if (Nnodes<=MAXNODES) and (Nsurf<=MAXSURF) and
     (Nmatl<=MAXMATL)   and (Maxvert*Nsurf<=MAXCONNECT) and
     (Nsides<=2)        and (Nnodes>0) and (Nsurf>0) and (Nmatl>0) then
  begin
    for mat := oldnmatl+1 to (oldnmatl+Nmatl) do
    begin
      Line_num := Line_num + 1;
      Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
      if (Version <= 2) then
      begin
        if (Num <> 3) then
        begin
          writeln ('Bad input: Reading data for material #',mat,' (line ',
              Line_num,')');
          close (Infile);
          halt;
        end;
        R1[mat] := Realvar[1];
        R2[mat] := Realvar[2];
        R3[mat] := 0.0;
        Color[mat] := round(Realvar[3]);
        Ambient[mat] := 0.1;
      end
      else
      if (Version = 3) then
      begin
        if (Num <> 4) then
        begin
           writeln ('Bad input: Reading data for material #',mat,' (line ',
              Line_num,')');
          close (Infile);
          halt;
        end;
        R1[mat] := Realvar[1];
        R2[mat] := Realvar[2];
        R3[mat] := Realvar[3];
        Color[mat] := round(Realvar[4]);
        Ambient[mat] := 0.1;
      end
      else
      begin
        if (Num <> 5) then
        begin
          writeln ('Bad input: Reading data for material #',mat,' (line ',
              Line_num,')');
          close (Infile);
          halt;
        end;
        R1[mat] := Realvar[1];
        R2[mat] := Realvar[2];
        R3[mat] := Realvar[3];
        Color[mat] := round(Realvar[4]);
        Ambient[mat] := Realvar[5];
      end; { if Version }
    end;  {for Mat}



    firstnode[curobj] := oldnnodes + 1;
    lastnode [curobj] := oldnnodes + nnodes+1;
    for Node := firstnode[curobj] to lastnode[curobj]-1 do
    begin
      Line_num := Line_num + 1;
      Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
      if (Num <> 3) then
      begin
        writeln ('Bad input: Reading data for node #',Node,' (line ',
             Line_num,')');
        close (Infile);
        halt;
      end;
      Xworld[Node] := Realvar[1];
      Yworld[Node] := Realvar[2];
      Zworld[Node] := Realvar[3];
    end; {for Node}



    firstsurf[curobj] := oldnsurf + 1;
    lastsurf [curobj] := oldnsurf + nsurf+1;
    for Surf := firstsurf[curobj] to lastsurf[curobj]-1 do
    begin
       Line_num := Line_num + 1;
       Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
       if (Num < 5) then
       begin
         writeln ('Bad input: Reading data for surface #',Surf,
                  ' (line ',Line_num,')');
         if (Num > 2) then
            writeln ('Must have at least 3 nodes on a surface!');
         close (Infile);
         halt;
       end;
       Nvert[Surf] := round(Realvar[1]);
       Matl[Surf]  := round(Realvar[2]);
       if (Nvert[Surf]<3) or (Nvert[Surf]>Maxvert)
          or (Nvert[Surf]<Num-2) or (Matl[Surf]<1)
          or (Matl[Surf]>Nmatl) then
       begin
         writeln ('Error in surface ',Surf,'(line ',Line_num,'): ');
         if (Nvert[Surf] < 3) then
            writeln ('Must have at least 3 nodes per surface')
         else
         if (Nvert[Surf] > Maxvert) then
            writeln ('#vertices exceeds Maxvert')
         else
         if (Matl[Surf]<1) or (Matl[Surf]>Nmatl) then
            writeln ('Matl no. not in range 0..Nmatl (',Nmatl,')')
         else
            writeln ('#vertices specified does not match #arguments');
         close (Infile);
         halt;
       end; { if Nvert... }

       Nvread := Num - 2;
       for Vert := 1 to Nvread do
       begin
         Connection := round(Realvar[Vert+2])+ oldnnodes;
         if (Connection<1) or (Connection>Nnodes+oldnnodes) then
         begin
           writeln ('Error in surface ',Surf,'(line ',Line_num,'): ');
           writeln ('Connection #,',Vert,' not in range 0..Nnodes (',
                     Nnodes,')');
           close (Infile);
           halt;
         end;
         Connect[(Surf-1)*Maxvert+Vert] := Connection;
       end; { for Vert }

       while (Nvread < Nvert[Surf]) do
       begin
         Line_num := Line_num + 1;
         Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
         if (Num < 1) or (Nvread + Num > Nvert[Surf]) then
         begin
           writeln ('Error in surface ',Surf,'(line ',Line_num,'): ');
           if (Num = 0) then writeln ('No data read.')
           else if (Nvread + Num > Nvert[Surf]) then
              writeln ('Too many vertices read.');
           close (Infile);
           halt;
         end; { if Num... }
         Vert := Nvread + 1;
         for j := 1 to Num do
         begin
           Connection := round(Realvar[j]) + oldnnodes;
           if (Connection<1) or (Connection>Nnodes+oldnnodes) then
           begin
             writeln ('Error in surface ',Surf,'(line ',Line_num,'): ');
             writeln ('Connection #,',Vert,
                      ' not in range 0..Nnodes (',Nnodes,')');
             close (Infile);
             halt;
          end;
          Connect[(Surf-1)*Maxvert+Vert] := Connection;
          Vert := Vert + 1;
        end;
        Nvread := Nvread + Num;
      end; { while }
    end; { for Surf }
  end
  else
  begin
    if (Nnodes>MAXNODES) or (Nnodes<1) then
       writeln('Nnodes (',Nnodes,') must be between 1 and ',MAXNODES);
    if (Nsurf>MAXSURF) or (Nsurf<1) then
       writeln('Nsurf (',Nsurf,') must be between 1 and ',MAXSURF);
    if (Nmatl>MAXMATL) or (Nmatl<1) then
       writeln('Nmatl (',Nmatl,') must be between 1 and ',MAXMATL);
    if Maxvert*Nsurf>MAXCONNECT then
    begin
       writeln('Number of surfaces or max number of vertices too large!');
       writeln('Maxvert (',Maxvert,') * Nsurf (',Nsurf,
               ') must be smaller than ',MAXCONNECT);
    end;
    if (Nsides<1) or (Nsides>2) then
        writeln('Nsides (',Nsides,') must be either 1 or 2');
    close (Infile);
    halt;
  end; { if Nnodes... }
  nmatl := nmatl + oldnmatl;
  nnodes := nnodes + oldnnodes;
  nsurf := nsurf + oldnsurf;
  close (Infile);
  readini (Filename);
end; {with}
end; { procedure READFILE }

procedure WRITEFILE (Filename: text80);
{ Write the new SURFMODL-format file }

var Outfile: text;              { file to write to }
    Vert: integer;              { vertex # }
    Node: integer;              { node # }
    Mat: integer;               { material # }
    Surf: integer;              { surface # }
    Nvertex: integer;           { # vertices in surface }
    Fileopen: boolean;          { flag opened file }
    Yorn: char;                 { user response }

begin
with ptra^ do with ptrb^ do
with ptrc^ do with ptrg^ do
with ptrh^ do with ptri^ do
begin {with}
  Fileopen := FALSE;
  while (NOT Fileopen) do begin
    assign (Outfile, Filename);
    {$I-}
    rewrite (Outfile);
    {$I+}
    if (ioresult <> 0) then begin
      writeln ('Error opening output file ',Filename);
      write ('Try again (Y or N)?');
      readln (Yorn);
      if (Yorn <> 'Y') and (Yorn <> 'y') then
        halt;
    end else
      Fileopen := TRUE;
  end; { while }

  writeln (Outfile, Flpurpose);
  writeln (Outfile, 4);
  writeln (Outfile, Nmatl,' ',Nnodes,' ',Nsurf,' ',Maxvert,' ',Nsides);

  for Mat := 1 to Nmatl do
    writeln (Outfile, R1[Mat],' ',R2[Mat],' ',R3[Mat],' ',Color[Mat],' ',
             Ambient[Mat]);

  for Node := 1 to Nnodes do
    writeln (Outfile, xworld[Node]:9:4,' ',yWorld[Node]:9:4,' ',
             zWorld[Node]:9:4);

  for Surf := 1 to Nsurf do begin
    Nvertex := nvert[Surf];
    write (Outfile, Nvertex,' ',Matl[Surf],' ');
    for Vert := 1 to Nvertex do
      write (Outfile, konnec (Surf, Vert),' ');
    writeln (Outfile);
  end; { for Surf }

  close (Outfile);
end; {with ptr do}
end; { procedure WRITEFILE }

{ procedures SCALENODES, SHIFTNODES, and ROTATENODES }
procedure SCALENODES (Firstnode, Lastnode: integer; Scale: vector);
{ Scale all nodes in this solid by the factors specified }

var Axis:       integer;  { axis to scale on }
    Node:       integer;  { node # }

begin
with ptra^ do with ptrb^ do with ptrc^ do
  for Axis := 1 to 3 do
    if (Scale[Axis] <> 0.0) and (Scale[Axis] <> 1.0) then
      for Node := Firstnode to Lastnode do
      case axis of
      1 : xWorld[node] := xworld[node] * Scale[Axis];
      2 : yWorld[node] := yworld[node] * Scale[Axis];
      3 : zWorld[node] := zworld[node] * Scale[Axis];
      end;
      { for Node }
    { if Scale... }
  { for Axis }
end; { procedure SCALENODES }

procedure Translate (Firstnode, Lastnode: integer; Shift: vector);
{ Shift all nodes in this solid by the vector specified }

var Axis:       integer;  { axis to scale on }
    Node:       integer;  { node # }

begin
with ptra^ do with ptrb^ do with ptrc^ do
  for Axis := 1 to 3 do
    if (Shift[Axis] <> 0.0) then
      for Node := Firstnode to Lastnode do
      case axis of
        1 : xWorld[node] := xworld[node] + Shift[axis];
        2 : yWorld[node] := yworld[node] + Shift[axis];
        3 : zWorld[node] := zworld[node] + Shift[axis];
      end;
      { for Node }
    { if Scale... }
  { for Axis }
end; { procedure translate }

function ATAN2 (Y, X: real): real;
{ returns the arc-tangent, in radians, of Y/X, in the range of -PI to PI. }

const PI = 3.141592654;
begin
  if (Y = 0.0) then begin
    if (X >= 0.0) then
      ATAN2 := 0.0
    else
      ATAN2 := PI;
  end else if (Y > 0) then begin
    if (X = 0.0) then
      ATAN2 := PI / 2.0
    else if (X > 0.0) then
      ATAN2 := arctan (Y / X)
    else
      ATAN2 := PI - arctan (Y / -X);
  end else begin
    if (X = 0.0) then
      ATAN2 := -PI / 2.0
    else if (X > 0.0) then
      ATAN2 := arctan (Y / X)
    else
      ATAN2 := -PI + arctan (Y/ X);
  end; { if Y }
end; { procedure ATAN2 }

procedure ROTATENODES (Firstnode, Lastnode: integer; Rotate: vector);
{ Rotate all nodes in this solid by the rotation vector specified }

var Anglerad:   real;     { angle in radians }
    Node:       integer;  { node # }
    Axis:       integer;  { axis to rotate about }
    A1, A2:     integer;  { other two axes }
    Dist:       real;     { distance to X,Y coord }
    Theta2:     real;     { new angle, after rotating }

begin
  with ptra^ do with ptrb^ do with ptrc^ do
  for Axis := 1 to 3 do begin
    if (Rotate[Axis] <> 0.0) then begin
      { Convert degrees to radians }
      Anglerad := 3.141592654 * Rotate[Axis] / 180.0;
      for Node := Firstnode to Lastnode do begin
        case Axis of
        1: begin
             Dist := sqrt (sqr(YWorld[node]) + sqr(ZWorld[Node]));
             Theta2 := atan2 (ZWorld[Node], YWorld[Node]) + Anglerad;
             YWorld[Node] := Dist * cos(Theta2);
             ZWorld[Node] := Dist * sin(Theta2);
           end;
        2: begin
             Dist := sqrt (sqr(ZWorld[node]) + sqr(xworld[Node]));
             Theta2 := atan2 (xWorld[Node], zworld[Node]) + Anglerad;
             ZWorld[Node] := Dist * cos(Theta2);
             xWorld[Node] := Dist * sin(Theta2);
           end;
        3: begin
             Dist := sqrt (sqr(xWorld[node]) + sqr(yworld[Node]));
             Theta2 := atan2 (yWorld[Node], xworld[Node]) + Anglerad;
             xWorld[Node] := Dist * cos(Theta2);
             yWorld[Node] := Dist * sin(Theta2);
           end;
        end; { case Axis of }
      end; { for Node }
    end; { if Rotate[Axis] }
  end; { for Axis }
end; { procedure ROTATENODES }

procedure INITIAL;
begin
  new (ptra);     new (ptrb);     new (ptrc);     new (ptrg);
  new (ptrh);     new (ptri);     new (ptrk);

  Line_num := 0;
  curobj := 1;
  maxvert := 10000;
  Nnodes := 0;
  Nsurf := 0;
  NMATL := 0;
  NNODES :=0;
  nsurf :=0;
  nsides := 2;
  realmaxsurf := Maxsurf;
  Inifile := ' ';
  Fileread := FALSE;

  write (' Data file name ');
  readln (filename);
  readfile (filename);
  nobj :=1;

  clipOn2d;
  graphicsopen;
  zoomcolour (12);
end;  { procedure INITIAL }


procedure BADSURF;
{ A bad surface was attempted to be plotted. Explain why and halt. }
begin
  graphicsclose;
  msg (1,'Error: You have attempted to plot a concave surface.');
  msg (2,'  This surface should be broken into at least two smaller');
  msg (3,'  surfaces. Alternatively, you may possibly be able to');
  msg (4,'  plot this surface anyway from a different angle or');
  msg (5,'  with a lower magnification factor.');
  halt;
end;  { procedure BADSURF }

procedure drawimage(state:boolean);
var
   vert,surf,node1,node2 : integer;

begin
  lineindex (black);
  with ptra^ do with ptrb^ do with ptrc^ do with ptri^ do with ptrh^ do
  begin
    for surf := 1 to nsurf do
    begin
      if state = true then lineindex(color[ matl[surf] ]);
      for vert := 1 to nvert[surf]-1 do
      begin
        node1 := konnec(surf,vert);
        node2 := konnec(surf,vert+1);
        case curwindow of
          elevation:clip2d ( xworld[node1], yworld[node1],
                             xworld[node2], yworld[node2]);
          endview:  clip2d ( zworld[node1], yworld[node1],
                             zworld[node2], yworld[node2]);
          plan:     clip2d ( xworld[node1], zworld[node1],
                             xworld[node2], zworld[node2]);
        end; { case }
      end; { for vert..}
    end; { for surf...}

    node1 := konnec(surf,nvert[surf]);
    node2 := konnec(surf,1);
    case curwindow of
      elevation:clip2d ( xworld[node1], yworld[node1],
                         xworld[node2], yworld[node2]);
      endview:  clip2d ( zworld[node1], yworld[node1],
                         zworld[node2], yworld[node2]);
      plan:     clip2d ( xworld[node1], zworld[node1],
                         xworld[node2], zworld[node2]);
   end; { case }
  end;{ with ptr..}
end; { Drawimage }

procedure selwindow (windo:windowtype);
begin
   case windo of
   elevation :
     begin
       window (elevbotx,elevboty,elevtopx,elevtopy);
       viewport (0,150,300,349);
       curwindow := elevation;
     end;
   endview:
     begin
       window (endbotx,endboty,endtopx,endtopy);
       viewport (310,150,600,349);
       curwindow := endview;
     end;
   plan:
     begin
       window (planbotx,planboty,plantopx,plantopy);
       viewport (0,0,300,145);
       curwindow := plan;
     end;
  end; {case windo of..}
end; { Selwindow }

procedure savewincoords;
begin
     case curwindow of
     elevation:begin
                 elevtopx := gxwxt;    elevbotx := gxwxb;
                 elevtopy := gxwyt;    elevboty := gxwyb;
               end;
     endview:  begin
                 endtopx := gxwxt;     endbotx := gxwxb;
                 endtopy := gxwyt;     endboty := gxwyb;
               end;
    plan:      begin
                 plantopx := gxwxt;    planbotx := gxwxb;
                 plantopy := gxwyt;    planboty := gxwyb;
               end;
    end; {case}

end; { Savewincoords }

procedure resetwindow;
var
   i : integer;
begin
     max := 0; min := 0;
     with ptra^ do with ptrb^ do with ptrc^ do
     for i := 1 to nnodes do
     begin
          if xworld[i] > max then max := xworld[i];
          if xworld[i] < min then min := xworld[i];

          if yworld[i] > max then max := yworld[i];
          if yworld[i] < min then min := yworld[i];

          if zworld[i] > max then max := zworld[i];
          if zworld[i] < min then min := zworld[i];
     end;
     elevtopx := max;    elevbotx := min;
     elevtopy := max;    elevboty := min;
     endtopx := max;     endbotx := min;
     endtopy := max;     endboty := min;
     plantopx := max;    planbotx := min;
     plantopy := max;    planboty := min;

end; { Resetwindow }







{------------------------------------------------------------------------}
{                     Editing section                                    }
{------------------------------------------------------------------------}

procedure edit;
var
   ch:             char;
   x, y,
   xvdiff, yvdiff,
   dxstep,dystep, xwdiff,
   ywdiff, xlen, ylen,
   Chx1,Chx2,Chy1,Chy2:      real;
   i:                        integer;

  function worldpointnum (x,y:real): integer;
  var
     mindx, mindy,
     dx,dy,x1,y1,x2,y2 : real;
     i,minnumpts,numpts:       integer;

  begin
     dx := xwdiff/2; minnumpts := nnodes;
     dy := ywdiff/2; numpts    := nnodes;

     repeat
       if minnumpts > numpts then
       begin
            minnumpts := numpts;
            mindx     := dx;   mindy := dy;
       end;

       dx := dx/2;         dy := dy/2;
       x1 := x - dx;       x2 := x + dx;
       y1 := y - dy;       y2 := y + dy;

       { draws concentric squares showing search area (interesting :-))
       clip2d (x1,y1,x1,y2);
       clip2d (x1,y2,x2,y2);
       clip2d (x2,y2,x2,y1);
       clip2d (x2,y1,x1,y1); }

       numpts := 0;
       with ptra^ do with ptrb^ do with ptrc^ do
       case curwindow of
         elevation: for i := 1 to nnodes do
                      if (xworld[i]>x1) and (xworld[i]<x2) and
                         (yworld[i]>y1) and (yworld[i]<y2) then
                         numpts := numpts +1;
         endview:   for i := 1 to nnodes do
                      if (zworld[i]>x1) and (zworld[i]<x2) and
                         (yworld[i]>y1) and (yworld[i]<y2) then
                         numpts := numpts +1;
         plan:      for i := 1 to nnodes do
                      if (xworld[i]>x1) and (xworld[i]<x2) and
                         (zworld[i]>y1) and (zworld[i]<y2) then
                         numpts := numpts +1;
      end; { case }

      if numpts = 0 then
      begin
           dx := dx * 3;
           dy := dy * 3;
      end;

    until numpts > minnumpts;

    dy := mindy;
    dx := mindx;
    i := 1;

    with ptra^ do with ptrb^ do with ptrc^ do
    case curwindow of
      elevation: while not((xworld[i]>x1) and (xworld[i]<x2) and
                           (yworld[i]>y1) and (yworld[i]<y2)) do
                            i := i +1;
      endview:   while not((zworld[i]>x1) and (zworld[i]<x2) and
                           (yworld[i]>y1) and (yworld[i]<y2)) do
                            i := i +1;
      plan:      while not((xworld[i]>x1) and (xworld[i]<x2) and
                           (zworld[i]>y1) and (zworld[i]<y2)) do
                            i := i +1;
   end; { case }

   gotoxy (45,19);
   with ptra^ do with ptrb^ do with ptrc^ do
   worldpointnum := i;

  end; { worldpointnum }


  procedure crosshairs (x,y : real;colour: integer);
  var c : integer;
  begin
     c := gxindex;
     lineindex (colour);
     clip2d (x-xlen, y, x+xlen, y);
     clip2d (x, y-ylen, x, y+ylen);
     lineindex (c);
  end; { crosshairs }

begin { edit }
     writemodexor;

     xwdiff := gxwxt - gxwxb;     ywdiff := gxwyt - gxwyb;
     xvdiff := gxvxt - gxvxb;     yvdiff := gxvyt - gxvyb;
     dxstep := xwdiff/xvdiff;     dystep := ywdiff/yvdiff;
     xlen := dxstep*5;            ylen := dystep*5;

     ginenable;
     gin (ch,chx1,chy1);
     gindisable;

     i := worldpointnum(chx1,chy1);

     with ptra^ do with ptrb^ do with ptrc^ do
     case curwindow of
       elevation: crosshairs (xworld[i],yworld[i],red);
       endview  : crosshairs (zworld[i],yworld[i],red);
       plan     : crosshairs (xworld[i],zworld[i],red);
     end; { case }

     msg (1,'Select new point'); msg (2,' ');
     ginenable;
     gin (Ch,Chx2,Chy2);
     gindisable;

     with ptra^ do with ptrb^ do with ptrc^ do { erase cross hairs }
     case curwindow of
       elevation: crosshairs (xworld[i],yworld[i],red);
       endview  : crosshairs (zworld[i],yworld[i],red);
       plan     : crosshairs (xworld[i],zworld[i],red);
     end; { case }

     writemodeset;

     drawimage(false);
     with ptra^ do with ptrb^ do with ptrc^ do
     case curwindow of
       elevation: begin
                    xworld[i] := chx2; yworld[i] := chy2;
                  end;
       endview  : begin
                    zworld[i] := chx2; yworld[i] := chy2;
                  end;
       plan     : begin
                    xworld[i] := chx2; zworld[i] := chy2;
                  end;
     end; { case }
     drawimage(true);

end; { Edit }



begin { main }
  initial;
  resetwindow;
  gxborderindex := blue;
  for win := elevation to endview do
  begin
    selwindow (win);
    drawimage(true);
  end;
  border(red);
  repeat
     msg (1,' select frame with arrow keys');
     msg (2,' Zoom Edit Options Rotate');
     msg (3,' Import Transform Magnify ');
     msg (4,' Write');
     repeat
           ch := getch
     until (ch in [up,down,left,right,esc]) or
           (upcase(chr(ch)) in ['Z','E','O','R','M','I','T','W']);

     case ch of
     up,left:begin
                border(blue);
                selwindow (elevation);
                border (red);
           end;
     right:  begin
                border(blue);
                selwindow (endview);
                border(red);
           end;
     down:   begin
                border(blue);
                selwindow (plan);
                border(red);
           end;
     end; { Case }
     case upcase(ch) of
     'Z': begin { z.... Zoom}
            msg (1,'Zoom: Use arrow keys to move frame');
            msg (2,'      +/- increase/decrease frame size');
            msg (3,'      5 to accept chosen frame');
            msg (4,'      7 to cancel');
            zoompan;

            for i := 1 to 4 do msg (i,'');
            tmptopx := gxwxt;    tmpbotx := gxwxb;
            tmptopy := gxwyt;    tmpboty := gxwyb;

            case curwindow of
                 elevation: selwindow(elevation);
                 endview:   selwindow(endview);
                 plan:      selwindow(plan);
            end; { case }

            msg(1,'erasing');
            drawimage(false);
            window(tmpbotx,tmpboty,tmptopx,tmptopy);
            savewincoords;

            border (red);
            msg (1,'drawing');
            drawimage(true);
        end; {Zoom}
    'E' : edit;
    'O' : begin { Options }
            msg (2,'');
            msg (1,'Options: Reset');
            repeat
              ch := getch;
            until ( ch in [esc]) or
                  ( upcase(chr(ch)) in ['R'] );
            case upcase(chr(ch)) of
            'R': begin { resetwindows}
                   graphics(0,-1);
                   resetwindow;
                   for win := elevation to endview do
                   begin
                     selwindow (win);
                     border(blue);
                     drawimage(true);
                   end;
                   border (red);
                 end;{ resetwindows }
           end; { case }
        end; { options }
    'R' : begin
            msg(2,''); msg(3,'');
            msg(1,'Rotate which object? ');
            gotoxy (67,16);
            write('(1..', nobj, ')');
            readln (curobj);
            if (curobj <> 0) then
            begin
              msg (1,'x,y,z angles ');
              gotoxy (56,16);
              i := inreal (infile,realvar,comment,0,true);
              if (i=3) and
              ((realvar[1]<>0) or (realvar[2]<>0) or (realvar[3]<>0)) then
              begin
                rotate[1] := realvar[1];
                rotate[2] := realvar[2];
                rotate[3] := realvar[3];

                msg (1,'Working....');
                gxborderindex := blue;
                for win := elevation to endview do
                begin
                  selwindow (win);
                  drawimage(false);
                end;
                msg (2,'rotating....');
                rotatenodes (firstnode[curobj],lastnode[curobj],rotate);
                for win := elevation to endview do
                begin
                  selwindow (win);
                  drawimage(true);
                end;
                border(red);
                msg (1,' ');
              end;
            end;
          end;
    'I':begin
          msg(1,'Enter filename');
          msg(2,'');
          gotoxy (57,16);
          readln (filename);

          If not ( filename='') then
          begin
            if curobj <> maxobj then
            begin
              curobj:= curobj +1;
              nobj  := nobj + 1;
              readfile (filename);
            end
            else msg(5,'Too many objects');

         end;
       end;
    'T':begin
          msg(2,''); msg(3,'');
          msg(1,'Transform which object? ');
          gotoxy (67,16);
          write('(1..', nobj, ')');
          readln (curobj);
          if (curobj <> 0) then
          begin
            msg(1,'X,Y,Z transformation ?');
            gotoxy(65,16);
            i := inreal (infile,realvar,comment,0,true);
            if i>0 then
            begin
              trans[1] := realvar[1];
              trans[2] := realvar[2];
              trans[3] := realvar[3];
              translate ( firstnode[curobj],lastnode[curobj],trans)
            end;
          end;
        end;
    'M':begin
          msg(2,''); msg(3,'');
          msg(1,'Magnify which object? ');
          gotoxy (67,16);
          write('(1..', nobj, ')');
          readln (curobj);
          if (curobj <> 0) then
          begin
            msg(1,'X,Y,Z magnification ?');
            gotoxy(65,16);
            i := inreal (infile,realvar,comment,0,true);
            if i>0 then
            begin
              scale[1] := realvar[1];
              scale[2] := realvar[2];
              scale[3] := realvar[3];
              scalenodes ( firstnode[curobj],lastnode[curobj],scale)
            end;
          end;
        end;
    'W': begin
              msg(3,''); msg(2,''); msg(1,'Write : Filename?');
              gotoxy (41,17);
              readln (filename);
              if not (filename ='') then
                 writefile (filename);
         end;
    end; {case}
  until ch = esc;
graphicsclose;
end.{main}
