/**************************************************************************

  EXAMPLE2.C

  Written by Eric Jorgensen (1995)

  The is an example program to illustrate how to use Varmint's Audio
  Tools to play .mid files.


**************************************************************************/

#include "sound.h"
#include <conio.h>


void main(void)
{
  int i;
                                          // The FM patchmap allows to to
                                          // specify which instrument patch
                                          // is assigned to each track.  In
                                          // this case, patch #6 (harpsichord)
                                          // has been assigned to all 32
                                          // tracks.
  BYTE myfmmap[32] = { 6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
                   6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6 };
                                           // You need a MIDI structure to
                                          // hold the data from the .mid file.
  MIDI far *song;
                                          // You will also need a character
                                          // string to catch any error
                                          // messages from LoadMidi().
  char errstring[100];

                                           // In general, it is good to perform
                                           // all file access before settup
                                           // up the sound blaster.
  song = LoadMidi("bach.mid",errstring);
  if(!song) {
    printf("ERROR loading midi:  %s\n",errstring);
    exit(1);
  }
                                           // Set up the sound blaster.
  if(!SBSetUp()) {
    printf("SB_Setup returned this error: %s \n",errname[sberr]);
    FreeMidi(song);                       // Free the Midi you just loaded.
    exit(1);
  }

  GoVarmint();                            // Start up the sound Kernel.

  FMReset();                              // Get the FM chip ready.

  midi_fmpatchmap = myfmmap;
  midi_data = song;                       // Tell VAT which song to play.
  MidiCommand(v_play);                    // Start the music!

  printf("Press a key to quit.\n");
  getch();

  DropDeadVarmint();                      // Stop the SB interrupt.
  SBCleanUp();                            // Clean up sound stuff.
  FreeMidi(song);                         // Free our sond effect.

}