TANDY DESKMATE .SND FORMAT NOTES (old .snd file format)

Tandy .snd files are created by Sound.pdm, a program that came with the 
proprietary DeskMate environment.  They are used by Music.pdm to create 
music modules (.sng files).  DeskMate Sound and Music require the Tandy 
sound chip.  There is a program to convert RIFF WAVE and other 8-bit PCM 
formats to .snd, Conv2snd, by Kenneth Udut.  Conv2snd v.2.00 comes with 
Snd2wav, which converts .snd to RIFF WAVE.

There are two types of DeskMate .snd files, sound files and instrument 
files.  Both contain 8-bit unsigned PCM samples.

Sound files are simpler.  These are garden-variety sample files with a 
fixed-length header giving the name of the sound, the recording frequency, 
and the length of the sound.  Sound files may be recorded at 5500Hz, 11kHz 
or 22kHz.

Instrument files contain samples as well as frequency and looping
information used by Music.pdm to represent an instrument.  Instrument files 
provide for attack, sustain, and decay with several samples having 
different implied frequencies and being used by Music.pdm to represent the 
instrument in different pitch ranges.  Up to 16 different notes (with 16 
different samples) can be contained in one instrument file.  Instrument 
files are always recorded at 11kHz.  Both sound files and instrument files 
may be compressed in one of two ways, "music" compression or "speech" 
compression, or they may be uncompressed.  I don't know the compression 
algorithms, but simple file comparison reveals that "music" and "speech" 
compression are almost identical.

The DeskMate .snd file header consists of 16 bytes of fixed header 
information followed by one or more 28-byte note records.  The sample 
information, which may be compressed, follows the header.

DeskMate .snd File Format - Fixed Header
----------------------------------------

  offset    size      what
  ------    ----      ----

  0         byte      1Ah (.snd ID byte)

  1         byte      Compression code:  0 = no compression; 1 = music
                      compression; 2 = sound compression.

  2         byte      Number of notes in the instrument file.  1 if sound
                      file.  There can be a maximum of 16 notes in an
                      instrument file.  Note:  when an instrument file is
                      created, it automatically has one unset note placed
                      in it.

  3         byte      Instrument number.  0 if sound file; 0FFh if instrument
                      file with no number set.  Valid instrument numbers in
                      an instrument file are 1 to 32.  Use this field to
                      distinguish a sound file from an instrument file.

  4         10 bytes  Sound or instrument name.  The name is null-terminated,
                      so the name may be at most 9 characters long.

  0Eh       word      Sampling rate in samples per second.  Note that although
                      a sampling rate other than 5500, 11000 and 22000 can be
                      entered here, Sound.pdm will not actually play at other
                      rates.

  10h       variable  Note records begin, 28 bytes each.  Number of records
                      given in byte 2 above.


DeskMate .snd File Format - Note Record
---------------------------------------

  0         byte      Pitch of the note:  1 = A1 in American Standard Pitch;
                      2 = A#1; etc.  A1 is lowest note allowed; highest note
                      allowed is B6 (3Fh).  Sound files have 0FFh here; so do
                      instrument files with no note set.
                          Note that Sound.pdm does not designate notes in the
                      standard manner to the user.  Although A1 and B6 in
                      Sound.pdm are the same as A1 and B6 in standard pitch,
                      Sound.pdm starts octaves at A rather than at C (as is
                      standard).  Thus, middle C, C4 in standard pitch, is C3
                      in Sound.pdm.

  1         byte      Sound files, and instrument files with no pitch set,
                      have 0 here.  If the pitch is set, this byte is 0FFh.

  2         2 bytes   Range of the note, first byte is lower limit, second
                      is higher limit.  Byte encoding as for offset 0 (i.e.,
                      01h to 3Fh).  Sound files have FF FF here; so do
                      instrument files with no range set.

  4         dword     Offset in the file where samples for this note begin
                      (zero-relative), after compression if that was done.

  8         dword     If compressed, the length of the compressed data in the
                      file for this note.  Uncompressed files have 0 here.

  0Ch       4 bytes   Unknown.  Set to zero.

  10h       dword     Number of samples in the note, after decompression if
                      necessary.

  14h       dword     Number of sample at start of sustain region for the
                      note, relative to the first (zeroth) sample of the note.
                      For sound files, or if sustain is not set, this field is
                      0.

  18h       dword     Number of sample at end of sustain region for the note,
                      relative to the first (zeroth) sample of the note.  For
                      sound files, or if sustain is not set, this field is 0.
