#include <blaster.h>

status_type	voice_stat;

void key_check()
{
	char ch;
	while(voice_stat!=0)
	{
		if (kbhit())
		{
			ch=	getch();
			if (ch==27)
				stop_snd();
			if (ch==32)
			{
				pause_snd();
				getch();
				cont_snd();
			}
		}
	}
}

void main()
{
	int		loop;
	sbvoc_type	snd;
	if (load_drv()!=SBOK)
	{
		printf("\nError loading driver.\n");
		exit(1);
	}
	if (init_drv()!=SBOK)
	{
		printf("\nError initializing driver.\n");
		uninstall_drv();
		exit(1);
	}
	if (load_snd("vroom.voc",&snd)!=SBOK)
	{	
		printf("\nError loading file.\n");
		uninstall_drv();
		exit(1);
	}
	set_status(&voice_stat);
	play_snd(snd);
	key_check();
	unload_snd(snd);
	uninstall_drv();
	exit(0);
}
