comment ^

  altmode3.asm - Alternative text mode.

  Jason Hood, 18, 19 and 21 February, 2000.
  
  Usage: altmode3 [<font>|<lines>] [s<col>] [b<col>] [a|e]
	 altmode3 [+|-] [r|u]

  where: font is the font height (8, 14 or 16);
	 lines is the screen height (25, 28 or 50);
	 s is the color to clear the screen;
	 b is the border (frame) color;
	 a or e will apply (execute) the mode;

  After installation:
	 no arguments will toggle off and on;
	 + will activate and set the mode;
	 - will disable and set the mode.
	 r or u will remove (uninstall);

  Default is the 14-line font (28 screen lines), bright yellow on blue
  screen color (30, 1eh) and blue border (1). All options can be changed
  at any time. Numbers can be hexadecimal by prefixing with '#' (eg. "s30"
  and "s#1e" are equivalent).

  Comments: jadoxa@yahoo.com.au

^
		.286

VERSION_NUM	equ	100h

__TINY__	equ	0		; Define tiny model for AMIS

		INCLUDE AMIS.MAC

		@Startup

TSRcode@

	HOOKED_INTS 10h

	ALTMPX	'Adoxa', 'AltMode3', VERSION_NUM


ISP_HEADER 10h, hw_reset_2Dh
	cmp	ax,3
turn_off label word
	je	mode3
	jmp	ORIG_INT10h
mode3:
	call	int10		; Set the mode
	pusha
	push	es

	mov	ax,1111h	; Get Monochrome (8x14) font
font_size equ $-2
	xor	bx,bx		; Block 0 (and set BH for below)
	call	int10

	mov	ah,0Bh		; Set frame color (BH = 0)
	mov	bl,1		; Blue
border_color equ $-1
	call	int10

	push	0b800h		; Clear video memory
	pop	es
	xor	di,di
	mov	ax,1e20h	; Bright yellow on blue and space
screen_color equ $-1
	mov	cx,4000h
	rep	stosw

	pop	es
	popa
	iret

int10:
	pushf
	call	ORIG_INT10h
	ret

TSRcodeEnd@

;-----------------------------------------------------------------------

_TEXT	SEGMENT 'CODE'
	ASSUME	cs:_TEXT, ds:_INIT, es:TGROUP, ss:NOTHING

CRLF	 equ	<13, 10>
EOL	 equ	<13, 10, '$'>

badopt	 db	"Unknown option: "
u_char	 db			"?", EOL
invalid  db	"Valid font sizes are:    8, 14 or 16.", CRLF
	 db	"Valid screen lines are: 25, 28 or 50.", EOL
install  db	"AltMode3 has been installed.", EOL
removed  db	"AltMode3 has been removed.", EOL
noremove db	"AltMode3 cannot be removed at this time.", EOL
notins	 db	"AltMode3 is not installed.", EOL
active	 db	"AltMode3 is active.", EOL
inactive db	"AltMode3 is disabled.", EOL

helpstr  db	"AltMode3 by Jason Hood <jadoxa@yahoo.com.au>.", CRLF
	 db	"Version 1.00 (21 February, 2000). Freeware.", CRLF
	 db	"http://tm.adoxa.cjb.net/", CRLF
	 db	CRLF
	 db	"Usage: altmode3 [<font>|<lines>] [s<col>] [b<col>] [a|e]", CRLF
	 db	"       altmode3 [+|-] [r|u]", CRLF
	 db	CRLF
	 db	"font:   8, 14 or 16", CRLF
	 db	"lines: 25, 28 or 50", CRLF
	 db	"s:     screen color (prefix with '#' for hex)", CRLF
	 db	"b:     border color", CRLF
	 db	"a, e:  apply (execute)", CRLF
	 db	CRLF
	 db	"Once installed:", CRLF
	 db	"none:  toggle off and on", CRLF
	 db	"+:     activate and set mode", CRLF
	 db	"-:     disable and set mode", CRLF
	 db	"r, u:  remove (uninstall)", CRLF
	 db	CRLF
	 db	"Default is font 14 (28 lines), screen 30 (bright yellow on"
	 db	" blue) ", CRLF
	 db	"and border 1 (blue). They can be changed at any time.", EOL

installed db	0
apply	  db	0

	@Startup2 PSP

	push	es
	xor	ax,ax			; If you want to load low,
	xchg	ax,ds:[002Ch]		;  free the environment
	mov	es,ax			;  so there's space for it.
	mov	ah,49h			; (AMIS does this only if
	int	21h			;  relocating within the PSP.)
	pop	es

	push	cs
	pop	ds
	ASSUME	ds:_TEXT

	IF_INSTALLED <short get_segment>
	jmp	short main

get_segment:
	mov	al,0
	int	2dh
	mov	es,dx		; Modify the resident code directly
	inc	installed

main:
	mov	si,81h		; Start of the command line
	mov	ah,0		; Flag to indicate argument(s) specified
args:
	call	get_arg
	or	al,al
	jne	args1
	jmp	args_done
args1:
	or	ah,1
	cmp	al,'R'
	je	remove
	cmp	al,'S'
	jne	try_B
	mov	byte ptr screen_color,cl
	jmp	short args

try_B:
	cmp	al,'B'
	jne	try_A
	mov	byte ptr border_color,cl
	jmp	short args

try_A:
	cmp	al,'A'
	jne	must_be_F
	inc	apply
	jmp	short args

must_be_F:
	cmp	cl,8
	je	font8
	cmp	cl,50
	jne	try_14
font8:
	mov	al,12h
	jmp	short set_font
try_14:
	cmp	cl,14
	je	font14
	cmp	cl,28
	jne	try_16
font14:
	mov	al,11h
	jmp	short set_font
try_16:
	cmp	cl,16
	je	font16
	cmp	cl,25
	jne	bad_font
font16:
	mov	al,14h
set_font:
	mov	byte ptr font_size,al
	jmp	short args

bad_font:
	mov	dx,offset invalid
	jmp	short bad_exit

remove:
	cmp	installed,0
	jne	remove1
not_installed:
	mov	dx,offset notins
	jmp	short bad_exit

remove1:
	UNINSTALL <short error>
	mov	dx,offset removed
good_exit:
	mov	ah,9
	int	21h
good_ret:
	mov	ax,4c00h
	int	21h

error:
	mov	dx,offset noremove
bad_exit:
	mov	ah,9
	int	21h
	mov	ax,4c01h
	int	21h

args_done:
	cmp	installed,0
	jne	toggle

	INSTALL_TSR ,,,mcbname

mcbname:
	push	ds es		; Lowercase the MCB name (as displayed
	push	ss		;  by MEM) 'cos it looks good.
	pop	ds		; Point DS to _INIT
	dec	ax
	mov	es,ax
	mov	di,8
	mov	si,offset _INIT:ALTMPX_SIGNATURE+8
	movsw
	movsw
	movsw
	movsw
	pop	es ds
	cmp	apply,0
	je	no_mode
	mov	ax,3
	int	10h
no_mode:
	DISPLAY_STRING install
	ret

toggle:
	or	ah,ah				; If we didn't see any options
	je	off_on				;  switch status
	cmp	apply,0
	je	good_ret1
mode_set:
	mov	ax,3
	int	10h
good_ret1:
	jmp	good_ret

off_on:
	xor	turn_off,0574h xor 9090h	; je mode3 <-> NOP; NOP
	mov	ax,turn_off
	mov	dx,offset inactive
	cmp	ax,9090h
	je	good_exit1
	mov	dx,offset active
good_exit1:
	jmp	good_exit

switch_on:
	mov	turn_off,0574h
	jmp	short is_inst

switch_off:
	mov	turn_off,9090h
is_inst:
	cmp	installed,0
	jne	mode_set
	jmp	not_installed


get_arg:
	segss			; SS is the only segment pointing
	lodsb			;  to the command line
	cmp	al,13		; Command line ends in CR
	je	done
	cmp	al,' '          ; Skip all spaces and control characters
	jbe	get_arg
	cmp	al,'/'          ; Ignore switch characters
	je	get_arg
	cmp	al,'-'
	jne	try_help
	cmp	byte ptr ss:[si],' ' ; Distinguish between minus and switchar
	jbe	switch_off
	jmp	short get_arg
try_help:
	cmp	al,'?'
	je	help
	cmp	al,'+'
	je	switch_on
	mov	u_char,al	; Use unmodified character for error display
	and	al,0dfh 	; Force uppercase
	cmp	al,'U'
	jne	get_arg1
	mov	al,'R'
get_arg1:
	cmp	al,'R'
	jne	get_arg2
get_arg_exit:
	ret
get_arg2:
	cmp	al,'S'
	je	parse_num
	cmp	al,'B'
	je	parse_num
	cmp	al,'E'
	jne	get_arg3
	mov	al,'A'
get_arg3:
	cmp	al,'A'
	je	get_arg_exit
	dec	si		; Reload the digit
	call	parse_num
	or	cx,cx
	jz	bad_opt
	mov	al,'F'
	ret

done:
	mov	al,0
	ret

bad_opt:
	mov	dx,offset badopt
	jmp	bad_exit

help:
	mov	dx,offset helpstr
	jmp	good_exit

parse_num:
	push	ax			; Remember option
	xor	cx,cx			; CX stores the number
	cmp	byte ptr ss:[si],'#'
	je	hex
	mov	bx,10			; Base 10 multiplier
digit:
	segss
	lodsb
	sub	al,'0'
	jb	end_num
	cmp	al,9
	ja	end_num
	xchg	ax,cx
	mul	bx
	add	al,cl
	xchg	ax,cx
	jmp	short digit

end_num:
	dec	si			; Back to the character that stopped
	pop	ax			;  conversion
	ret

hex:
	inc	si			; Skip the hash
hexit:
	segss
	lodsb
	or	al,20h			; Force lowercase (forcing uppercase
	sub	al,'0'                  ;  translates digits as well)
	jb	end_num
	cmp	al,9
	jbe	hex1
	cmp	al,'a' - '0'
	jb	end_num
	cmp	al,'f' - '0'
	ja	end_num
	sub	al,'a' - '0' - 10
hex1:
	shl	cl,4
	add	cl,al
	jmp	short hexit

_TEXT	ENDS

	end	INIT
