/*
 *  This is PIPE, version 2.00; Written by Josh Assing
 *  on Turbo-C, Version 1.0; The purpose of this pipe
 *  is to route output to the screen and to a file for
 *  viewing and/or editing at a later date.  The switches
 *  are discussed with the /h switch, so I shall not
 *  discuss them now.  This program is given to the general
 *  public at no charge.  HOWEVER, this program still
 *  belongs to me, so any modifications, I would appreciate
 *  you sending them to me.  Via REDWOOD BBS, or mail:
 *  1376 H st, Apt. A, Arcata, CA  95521
 *  I found a use for it, so I assume others might be
 *  able to use it as well.
 *  (Sorry, comments are not my strong point, but I
 *   will make some.)
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <dir.h>
#include <string.h>
#include <ctype.h>
#include <pipe.h>

#define boolean int
#define true 1
#define false 0
#define EOI 255

main(argc, argv)
  int argc;
  char *argv[];  {

  char ch, write_name[100];
  boolean backup, append, help;
  FILE *fpp;

  backup = append = help = false;

  --argc;

/*
 *  Get file name to work with, if it's there, otherwise
 *  use the default.
 */

  {
  boolean defaultn = false;
  int argn;

  if(argc == 0)
    defaultn = true;
  else
    if(argv[1][0] == '/')
      if(argc >= 2)
        argn = 2;
      else
        defaultn = true;
      else
        argn = 1;
  if(defaultn)
    strcpy(write_name,"PIPE-OUT.PUT");
  else
    strcpy(write_name,argv[argn]);
  }

/*
 *  Get the switches, and set the boolean values.
 */

  if(argc >= 1 && argv[1][0] == '/') {
    int i = 1;

    for(; i < strlen(argv[1]); ++i)
      switch(toupper(argv[1][i])) {
        case 'H':
           help = true;
           break;
        case 'A':
           append = true;
           break;
        case 'B':
          backup = true;
          break;
        case '/':
          break;
        default:
          printf("\nIllegal switch %c.\nTerminating.",argv[1][i]);
          exit(1);
      }
    if(append && backup)
      append = false;

/*
 *  Now, test for help, then for backup, then append, then
 *  run the pipe.
 */

    if(help) {
      helpf(argv[0]);
      exit(0);
    }
    if(backup) {
      char back_name[13];
      int result;

      result = backupf(back_name);
      if(result != 0) {
        printf("\nError (%d) in using file name: %s.\nTerminating.",result, back_name);
        exit(1);
      }
      result = rename(write_name,back_name);
      if(result != 0) {
        printf("\nError (%d) backing up file %s to %s.\nTerminating.",result, write_name, back_name);
        exit(1);
      }
    } /* Backup */
  } /* Command line params */

  if(append)
    fpp = fopen(write_name,"a");
  else
    fpp = fopen(write_name,"w");

  if(fpp == NULL) {
    printf("\nError using file: %s\nTerminating.",write_name);
    exit(1);
  }

  do {
    putchar(ch = getchar());
    putc(ch,fpp);
  } while(ch != EOI);
  putc('\n',fpp);
  exit(0);
}



int backupf(fname)
  char fname[];  {

  strcpy(fname,"PIPED-XXXXXX");
  fname = mktemp(fname);
  return(0);
}


void helpf(name)
  char name[];  {
  printf("\n\n%s (PIPE), Version 2.00",name);
  puts("\n\nTo use this program, use the Following:");
  puts("\ncommand |pipe [/bah] [file name]");
  puts("/b means: back up the file (given name or default)");
  puts("          then do the pipe.");
  puts("/h means: print this descrpition.  (NO pipe done.)");
  puts("/a means: append the file before writting.  Do the pipe.");
  puts("\n\nThe purpose of this program is to write data to");
  puts("the screen and a file.");
  puts("\n\nThis program is written by Josh Assing.\n\n");
  return;
}