
; VGA Video Parameters Table Entry definition.

; 100 x 30 characters on screen in 08x16 character matrix
; for 28.322 MHz Master Clock (H.freq = 30.0 KHz; V.freq = 60.0 Hz)

;
;  Dimensions:
    CHAR_HEIGHT = 16    ;character height
    CHAR_WIDTH  = 08    ;character width (should be 8 or 9 only)
    COLMS       = 100   ;screen text columns
    ROWS        = 30    ;screen text rows
;
;  Misc Output register parameters:
                        ;horizontal resolution used:  350  400  480  reserved
    VSYNCPOL  = 1       ;V. Sync Polarity             1    0    1    0
    HSYNCPOL  = 1       ;H. Sync Polarity             0    1    1    0
    CLOCKSEL  = 01b     ;Master Clock Select;  00 - 25MHz, 01 - 28MHz, 10 - ext

;  CRTC register values (no recalculations into register values necessary!):
    HT   = 118          ;H. Total
    HDE  = 99           ;H. Displ.  End
    HBS  = 100          ;H. Blank   Start
    HBE  = 116          ;H. Blank   End
    HRS  = 104          ;H. Retrace Start
    HRE  = 112          ;H. Retrace End
    VT   = 500          ;V. Total
    VDE  = 479          ;V. Displ.  End
    VBS  = 480          ;V. Blank   Start
    VBE  = 498          ;V. Blank   End
    VRS  = 480          ;V. Retrace Start
    VRE  = 482          ;V. Retrace End
    SSL  = 1024-1       ;Start screen split Line (Line Compare)



VP_DATA         segment
                org     100h            ;to create .COM file
VP_Table_org    label   near


; Used literal definitions:
;
        _4bits =  00001111b
        _5bits =  00011111b
        _7bits =  01111111b
        _8bits =  11111111b
        bit0   =   00000001b
        bit1   =   00000010b
        bit2   =   00000100b
        bit3   =   00001000b
        bit4   =   00010000b
        bit5   =   00100000b
        bit6   =   01000000b
        bit7   =   10000000b
        bit8   =  100000000b
        bit9   = 1000000000b


; Actual video parameter table element data starts here:
;
;    colms, rows, scan lines, buffer size:
  db    COLMS
  db    ROWS - 1
  db    CHAR_HEIGHT
  dw    COLMS*ROWS*2+256
;
;    Sequencer Regs:
  db    00h  OR  (00000001b XOR (CHAR_WIDTH AND 00000001b))
  db    03h, 00h, 02h
;
;    Misc Out Reg:
  db    00100011b                    OR    \
        (VSYNCPOL SHL 7)             OR    \
        (HSYNCPOL SHL 6)             OR    \
        (CLOCKSEL SHL 2)
;
;   CRTC registers:                             REG  meaning:
  db    HT-05                                   ;00: H. Total - 05
  db    HDE                                     ;01: H. Disp. End
  db    HBS                                     ;02: Start H. Blank
  db    00000000b OR (HBE AND _5bits)           ;03: CR, DES & End H. Blank
  db    HRS                                     ;04: Start H. Retrace
  db    ((HBE AND bit5) SHL 2)       OR    \    ;05: End H. Blnk overflow
        00000000b                    OR    \    ;    H. Retrace Delay (skew)
        (HRE AND _5bits)                        ;    H. Retrace End
  db    (VT-02) AND _8bits                      ;06: V. Total - 02
  db    ((VRS AND bit9) SHR 2)       OR    \    ;07: Overflows
        ((VDE AND bit9) SHR 3)       OR    \
        (((VT-02) AND bit9) SHR 4)   OR    \
        ((SSL AND bit8) SHR 4)       OR    \
        ((VBS AND bit8) SHR 5)       OR    \
        ((VRS AND bit8) SHR 6)       OR    \
        ((VDE AND bit8) SHR 7)       OR    \
        (((VT-02) AND bit8) SHR 8)
  db    00000000b                               ;08: Preset Row Scan
  db    00000000b                    OR    \    ;09: 200-to-400 conversion
        ((SSL AND bit9) SHR 3)       OR    \    ;    Split Line overfl.
        ((VBS AND bit9) SHR 4)       OR    \    ;    V. Blnk Start overfl
        CHAR_HEIGHT - 1                         ;    scan lines / char (-1)
  db    CHAR_HEIGHT - 3                         ;0A: Curs. Start
  db    CHAR_HEIGHT - 1                         ;0B: Curs. End
  dw    0000h                                   ;0C+0D: Buffer start
  dw    0000h                                   ;0E+0F: Cursor loc
  db    VRS AND _8bits                          ;10: Start V. Retrace
  db    10000000b                    OR    \    ;11: Flags (modes) ???
        (VRE AND _4bits)                        ;    V. Retrace End
  db    VDE AND _8bits                          ;12: V. Displ. End
  db    COLMS/2                                 ;13: Next log. Line offset (wrd)
  db    00000000b                    OR    \    ;14: Count by 4 & Dword modes
        ((32-1) AND _5bits)                     ;    Underline Loc
  db    VBS AND _8bits                          ;15: Start V. Blank
  db    VBE AND _8bits                          ;16: End V. Blank
  db    10100011b                               ;17: Mode Control
  db    SSL AND _8bits                          ;18: Line Compare (Scr Split)
;
;       Attr. Controller registers:
  db      00h, 01h, 02h, 03h, 04h, 05h, 14h, 07h          ;Attr 00-07 regs
  db      38h, 39h, 3Ah, 3Bh, 3Ch, 3Dh, 3Eh, 3Fh          ;Attr 08-0F regs
  db      08h                           OR  \             ;Attr 10-13 regs
          (((CHAR_WIDTH AND 00000001b)) SHL 2)
  db      00h, 0Fh
  db      00h  OR  ((CHAR_WIDTH AND 00000001b) SHL 3)

;       Graphics Controller registers:
  db      00h, 00h, 00h, 00h, 00h, 10h, 0Eh, 00h, 0FFh    ;Grph 00-08 regs


VP_DATA         ends
                end     VP_Table_org
