;RM82TS8,16,24,32,40,48,56,64
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

DOSSEG
.model medium, Basic

.data
	;external data so all video routines can access
	EVEN
	EXTRN	B$DVIDEOSEG:WORD
	EXTRN   B$DVIDEOINSTL:BYTE
.code

INCLUDE  NOWAIT.INC
EXTRN   Get_Adapter:FAR

EVEN
Page_Size       DW      0       ; store size of display in words
Num_Times       DB      0       ; store loop counter

;============================================================================
; DECLARE SUB FADE ()
; CALL FADE
; Purpose: Clever visual effect, fades out display to white on black.
; Changes all characters to spaces.
; Works in TextMode only.  Sensitive to all video modes (i.e. no snow on CGA's)
; Assumes: Display width is 80 * 25, 80 * 43 or 80 * 50
;============================================================================

EVEN
FADE Proc FAR BASIC USES SI DI DS
	Mov   Num_Times,12      ; loop counter (go through loop 12 times)
				; which is (255-32) / 19
	Cmp   B$DVIDEOINSTL,1   ; See if we have done this before
	JE    Didit             ; yep, so skip ahead
	Call  Get_Adapter       ; call routine to find display type

Didit:
				; determine video page size
				; do it the hard way because of error
				; in certain HERC clones
	Xor   AX,AX             ; clear AX
	Mov   ES,AX             ; set ES to BIOS ram
	Xor   BH,BH             ; clear high byte
	Mov   BL,Byte Ptr ES:[0484h]  ; read ROW from BIOS ram
	Or    BL,BL             ; is ROW 0? (i.e. is this CGA, HERC or MONO?)
	JNZ   @f                ; nope, it is a EGA, MCGA or VGA
	Mov   BL,24             ; set default ROW to 24
@@:
	Inc   BL                ; remove 0 bias of ROW
	Mov   AX,ES:[044Ah]     ; read COLUMN from BIOS ram
	Mul   BX                ; multiply ROW times COLUMN
	Mov   CS:[Page_Size],AX ; store Page_Size in memory
	Mov   AX,B$DVIDEOSEG    ; get default video segment
	Mov   ES,AX             ; store in ES
	Mov   DS,AX             ; store in DS too
	Mov   DX,03DAh          ; assume color retrace port
	Cmp   AX,0B800h         ; is it a Color display?
	JE    @f                ; yes, so jump ahead
	Mov   DX,03BAh          ; else, retrace port for mono display
@@:
	Cld                     ; clear the direction flag
				; to move data forward
EVEN                            ; speed up loops on AT's and above
Main_Loop:
	Xor   DI,DI             ; start at Row 0, Col 0
	Mov   SI,DI             ; (1 clock faster than XOR)
	Mov   CX,CS:[Page_Size] ; number of bytes to change
	Mov   AH,7              ; make attribute white on black
EVEN
Disp_Loop:
	CLI                     ; prevent interrupts to speed routine
	Wait_CGA_Retrace        ; wait for retrace on CGA MACRO
	Lodsb                   ; get character from DS:SI and increment SI
	STI                     ; this prevents snow on CGA
	Sub   AL,19             ; subtrace 19 from character each loop
	Cmp   AL,32             ; don't let it drop below 32, ASCII space
	JAE   @f
	Mov   AL,32             ; if below 32, make it 32
@@:
	Mov   BX,AX             ; store AX in BX since retrace
	CLI                     ; macro destroys AX
	Wait_CGA_Retrace        ; wait for retrace on CGA MACRO
	Xchg  AL,BL		; one less byte than Mov AL,BL
	Stosw                   ; store character & attribute at ES:DI
	STI                     ; allow interrupts again
	;Call  NEAR PTR Delay    ; waste time
	Inc   SI                ; skip over attribute to next cell
	Loop  Disp_Loop         ; loop until CX is zero

Exit:
	Dec   Num_Times         ; have we done it 12 times?
	Jz    Finis             ; yep, so end
	Jmp   Short  Main_Loop
EVEN
Finis:
	Ret                     ; return
FADE    Endp
END
