TITLE  'Fill Bit Block EGA'
NAME   FILLSCN
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1991 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      11 Feb 91                                              |
; function:      fill screen starting at row for # rows of pixel value  |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call FILLSCN(0,349,0)                                  |
;    stack:     +06 = pixel value                                       |
;                08 = lines to fill                                     |
;                10 = start line                                        |
;  returns:      none                                                   |
;------------------------------------------------------------------------

PARMS           = 3
ARGstart        EQU [bp+10] ;row start
ARGrows         EQU [bp+08] ;rows to fill
ARGfill         EQU [bp+06] ;value of fill

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

EXTRN PixelAddr:far

FillScn_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:FillScn_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  FillScn
FillScn         PROC    FAR

                push    bp
                mov     bp,sp
                push    ds
                push    si
                push    di

                cld
                mov     ax,bpl
                shr     ax,1            ;make bytes to words
                mov     cx,ax
                mov     bx,ARGfill
                mov     ax,[bx]
                mov     PixelValue,ax
                mov     bx,ARGstart
                mov     di,[bx]
                mov     bx,ARGrows
                mov     ax,[bx]

                mul     cx              ;ax=rows
                mov     cx,ax           ;ax=pixel rows x words per row

                mov     ax,bpl
                mul     di              ;ax=bytes to skip from start of buffer

                mov     di,0A000h
                mov     es,di

                mov     di,ax           ;line start
                mov     dx,03CEh        ;graphics controller port

                mov     ax,PixelValue   ;fill value
                xchg    ah,al           ; into ah
                mov     al,0            ;set\reset reg number
                out     dx,ax

                mov     ax,0F01h        ;ah=mask for enable set\reset
                out     dx,ax           ;al=reg number
                rep     stosw           ;fill it cx times

                mov     ax,0001         ;default enable set(0)\reset & reg (01)
                out     dx,ax

                pop     di
                pop     si
                pop     ds
                mov     sp,bp
                pop     bp
                RET     PARMS*2

FillScn         ENDP
FillScn_TEXT    ENDS
                END

