'***********************************************************************
'                              ALARM.BAS                               *
'    ALARM allows a pseudo alarm clock to be set and then rings the    *
' system bell when that time is reached.  Alarm is designed to operate *
' in the background or in a small window under DESQview.               *
'    WARNING:  ALARM must be compiled for standalone ("/O" switch)     *
'              for DVSHADOW to operate.                                *
'                  Written by M. L. Lesser, 12/25/90                   *
'             Compiled with Microsoft BC 7.1, switch "/O"              *
'     Linked to HUNDSECS, DVAWARE, and the BASIC 7 stub file NOFLTIN   *
'                        with switches "/E/NOE"                        *
'***********************************************************************

   DEFINT H,M                   'Integer variables: HERE, HOURS, MINUTES
   DEFLNG N,A                   'Long variables:  NOW, ALARM
   DECLARE FUNCTION HUNDSECS& ()
   DECLARE SUB DVBREAK ()
   DECLARE SUB DVSHADOW ()

   DVSHADOW                     'No effect if not running under DV
   CLS
RESTART:                'Restart point for invalid input alarm time
   LET HERE = CSRLIN
   GOSUB SHOWTIME               'Use GOSUB to save space and time
   PRINT
   INPUT "Enter alarm-set time (hh,mm):  ", HOURS, MINUTES
   IF HOURS < 0 OR HOURS > 23 OR MINUTES < 0 OR MINUTES > 59 THEN
      PRINT  "Invalid set-alarm time.  Enter again."
      GOTO RESTART
   END IF
   LET ALARM = 360000& * HOURS + 6000& * MINUTES
' ALARM is the alarm setting in hundredths of seconds. If alarm is set
'   before current time, assume alarm is intended to be pm; add
'   4,320,000 hundredth-seconds (12 hours) to setting time.  If the
'   result is now greater than 8,640,000 hundredth-seconds, or is still
'   less than current time, assume an attempt was made to set the alarm
'   for tomorrow and terminate the program. 
   IF ALARM <= HUNDSECS THEN
       LET ALARM = ALARM + 4320000&
       IF ALARM >= 8640000& OR ALARM <= HUNDSECS THEN
          PRINT "  Can not set alarm for tomorrow"
          PRINT "Press any key to terminate program"
          WHILE LEN(INKEY$) = 0: WEND
          END
       ELSE
          LET HOURS = HOURS + 12
       END IF
   END IF
   PRINT "  Alarm is set for" STR$(HOURS) ":";
   IF LEN(STR$(MINUTES)) = 2 THEN PRINT "0";
   PRINT LTRIM$(STR$(MINUTES))
   LET HERE = CSRLIN
   WHILE HUNDSECS < ALARM               'Wait for the alarm to go off
      GOSUB SHOWTIME                    '  showing current time
      IF INKEY$ = CHR$(3) THEN END      '   but allow Ctrl-C escape
      DVBREAK                           'Exit time slice if under DV
   WEND
   PRINT: PRINT "Press any key to turn off bell and terminate program."
   IF CSRLIN = 24 THEN LET HERE = 22
AROUND:                         'Start of GOTO loop ringing alarm bell
   LET NOW = HUNDSECS + 100&            'Actually, one second from now!
   BEEP                                 'Ring bell at
   WHILE HUNDSECS < NOW                 '  one-second intervals
      DVBREAK
      GOSUB SHOWTIME                    '  showing time of day   
   WEND
   IF LEN(INKEY$) = 0 THEN GOTO AROUND  '  until key is pressed
   PRINT
END

SHOWTIME:      'Local subroutine displaying time of day in place:
   IF HERE > 23 THEN
      PRINT: PRINT
      LET HERE = HERE - 2
   END IF
   LOCATE HERE, 3
   PRINT "It is now:  " TIME$;
RETURN
