	title	miscellaneous
	include	asm.inc


	public	close_file
	public	exit_program
	public	get_input_state
	public	open_input_file
	public	open_output_file
	public	move_file_pointer
	public	putchar_newline
	public	putchar_space
	public	put_hex_byte
	public	put_hex_word
	public	read_from_file
	public	save_most
	public	select_min_count
	public	write_to_file


	.code
	extn	putchar,ms_dos,ms_dos_strerror


;;	close file
;
;	entry	BX	handle
;	exit	Cf	0
;	uses	AX
;
close_file proc
	mov	ah,3Eh
	jmp	ms_dos_strerror
close_file endp


;;	exit program
;
exit_program proc
	mov	ax,4C00h
	jmp	ms_dos
exit_program endp


;;	get input state
;
;	exit	Zf	if no key waiting
;	uses	AX
;	note	returns TRUE for keyboard, mouse, and timer under Windows
;
get_input_state proc
	mov	ah,1
	int	16h
	ret
get_input_state endp


;;	open input file
;
;	entry	DS:SI	string
;	exit	AX,BX	handle
;		Cf	if error, error text set
;	calls	offset_dos_error, ms_dos
;
open_input_file proc
	mov	ax,3D00h		; (use 3D20 for shared access read)
	xchg	dx,si
	call	ms_dos_strerror
	xchg	dx,si
	mov	bx,ax
	ret
open_input_file endp


;;	open output file
;
;	entry	DS:SI	string
;	exit	AX,BX	handle
;		Cf	if error, error text set
;	calls	offset_dos_error, ms_dos
;
open_output_file proc
	push	cx
	mov	ax,3C00h
	xor	cx,cx
	xchg	dx,si
	call	ms_dos_strerror
	xchg	dx,si
	mov	bx,ax
	pop	cx
	ret
open_output_file endp


;;	move file pointer
;
;	entry	BX	file handle
;		DX AX	file position
;	exit	Cf	if error
;	uses	AX
;
move_file_pointer proc
	push	cx
	mov	cx,dx
	mov	dx,ax
	mov	ax,4200h
	call	ms_dos
	pop	cx
	ret
move_file_pointer endp


;;	put hex byte
;
;	entry	AL	byte
;	uses	AX
;	note	calls putchar to write chrs
;
put_hex_byte proc
	push	ax
	sar	al,1
	sar	al,1
	sar	al,1
	sar	al,1
	call	ohb1
	pop	ax
ohb1:	and	al,0Fh
	add	al,90h
	daa
	adc	al,40h
	daa
	jmp	putchar
put_hex_byte endp


;;	put hex word
;
;	entry	AX	word
;	uses	AX
;
put_hex_word proc
	push	ax
	mov	al,ah
	call	put_hex_byte
	pop	ax
	jmp	put_hex_byte
put_hex_word endp


;;	putchar newline
;
;	uses	AX
;
putchar_newline proc
	mov	al,13
	call	putchar
	mov	al,10
	jmp	putchar
putchar_newline endp


;;	putchar space
;
;	uses	AX
;
putchar_space proc
	mov	al,' '
	jmp	putchar
putchar_space endp


;;	read from file
;
;	entry	BX	file handle
;		CX	byte count
;		ES:DI	destination
;	exit	AX	number of bytes read
;		Cf	if error
;
read_from_file proc
	push	ds
	mov	ah,3Fh
	push	es
	pop	ds
	xchg	dx,di
	call	ms_dos
	xchg	di,dx
	pop	ds
	ret
read_from_file endp


	even
;;	restore most
;
;	note	never call this routine
;
restore_most proc
	popm	bp,es,ds,si,di,dx,cx,bx
	ret
restore_most endp

	even
;;	save most
;
;	note	saves all registers except AX and BP.  however, the current
;		version also saves BP because the code works out that way.
;		the registers are automatically restored.  this routine is
;		called with a return address as the top of stack.
;
save_most proc				; +16 inner ret adr, +18 outer ret adr
	push	cx			; +14
	push	dx			; +12
	push	di			; +10
	push	si			; +8
	push	ds			; +6
	push	es			; +4
	push	bp			; +2
	lea	bp,restore_most		;     after execution of inner
	push	bp			; +0  routine, return to restore_most
	mov	bp,sp
	xchg	bx,[bp+16]		;	bx above cx
	push	bx			; -2	setup return to inner routine
	mov	bx,[bp+16]		;	restore original BX and BP
	mov	bp,[bp+2]
	ret
save_most endp


;;	select min count
;
;	entry	CX	count1
;		DX AX	count2
;	exit	CX	minimum of count1 and count2
;
select_min_count proc
	or	dx,dx
	jnz	smc1			; if count2 > 64k
	cmp	ax,cx
	ja	smc1			; if count2 > count1
	mov	cx,ax
smc1:	ret
select_min_count endp


;;	write to file
;
;	entry	BX	file handle
;		CX	byte count
;		ES:DI	buffer
;	exit	Cf	if error
;
write_to_file proc
	push	ds
	mov	ah,40h
	push	es
	pop	ds
	xchg	dx,di
	call	ms_dos
	xchg	di,dx
	pop	ds
	ret
write_to_file endp

	end
