// mouse.cls	a C++ Mouse class -- for DOS.
//
// (c) Aspen Scientific 1989. All Rights Reserved.
// Author: Vaughn Vernon

#ifndef __MOUSE_CLASS__

# define __MOUSE_CLASS__ 	1

# include "point.cls"

// Mouse class

class Mouse {

protected:
	// used by derived class
	int	installed;
	int	numButtons;
public:

	Mouse();
	~Mouse();

	// tell user how many buttons the mouse has
	int		buttons() { return numButtons; }
	virtual void	hide();
	virtual void	show();
	virtual int getEvent(Point &,unsigned & b1,unsigned & b2,unsigned & b3);
	virtual void	setPosition(Point &);
	virtual void	flush();

	// this method is strictly system dependant.
	// to use this, a class must be derived and the
	// virtual function replace.  the argument points
	// to an implementation dependant struct of some
	// sort which defines the type of mouse-pointer needed.

	virtual void makePointer(const void *) { }
};

#endif // __MOUSE_CLASS__
