// dots.cpp	draw dots on the display with mouse.  button 1 (left)
//		puts dots on, and buttons 2&3 (middle/right, right)
//		take dots off.
//
// (c) Aspen Scientific 1989.  All Rights Reserved.
// author: Vaughn Vernon

#include "point.cls"
#include "display.cls"
#include "mouse.cls"
#include "keyboard.cls"

int
main()
{
	Mouse mouse;
	Display display(&mouse);
	Keyboard kb;
	KeyTypes ktype;
	DisplayAttr attr;

	if (display.hasColor())
		attr.set( attr.foreWhite() | attr.backBlue() );
	else
		attr.set( attr.reverse() );

	display.putString(Point(0, 0), " Press [Esc] to quit. ", attr);

	if (display.hasColor())
		attr.set( attr.foreYellow() | attr.backBlack() );
	else
		attr.set( attr.normal() );

	display.cursorOff();

	Point mpoint;
	unsigned b1, b2, b3;

	while( 1 ) {
		if (mouse.getEvent(mpoint, b1, b2, b3) != 0) {
			if (b1)
				display.putChar(mpoint, '.', attr);
			else if (b2 || b3)
				display.putChar(mpoint, ' ', attr);

			display.draw();
		}
		else if (kb.input(0) == ktype.Escape())
			break;
	}

	display.cursorOn();
}
