'Wed  May 10, 1989   9:21:44 pm 
'***********************************************************************
' PROGRAM TO PRINT OUT FORMATTED ASCII FILES, customized for Dr.Download
' written by David A. Wesson  24 Fairview St.  W. Hartford, CT 06119
'***********************************************************************

DECLARE SUB printpage ()
DECLARE SUB getfilename ()
DECLARE SUB makelist ()
DECLARE FUNCTION newtime$ ()
DECLARE SUB getkey ()
DECLARE SUB checkprinter ()
DECLARE SUB checkinputfile ()
DECLARE SUB goodbye ()
DECLARE SUB header ()
DECLARE FUNCTION printer ()
DECLARE SUB helpscreen ()
DECLARE SUB readcommandline ()
DECLARE SUB splitline (in$)
DECLARE SUB outputroutine ()
DECLARE FUNCTION newdate$ ()

TYPE RegType
     ax    AS INTEGER
     bx    AS INTEGER
     cx    AS INTEGER
     dx    AS INTEGER
     bp    AS INTEGER
     si    AS INTEGER
     di    AS INTEGER
     flags AS INTEGER
END TYPE

DIM SHARED inregs AS RegType, outregs AS RegType
DIM SHARED day$(7), month$(12), word$(10), l$(70)

COMMON SHARED in$, esc$, margin, lines, readlist, filename$, datafile$, nl$
COMMON SHARED page, suppress, ff$, clear$, lf$, top, preview, jump, row, col
COMMON SHARED killtemp

esc$ = CHR$(27)
ff$ = CHR$(12)
lf$ = CHR$(10)
clear$ = CHR$(24)
nl$ = STRING$(79, 45)

'************************ MAIN PROGRAM BEGINS HERE **********************
     readcommandline
     outputroutine
     goodbye
'************************* MAIN PROGRAM ENDS HERE ***********************

SUB checkinputfile
     IF filename$ = "" THEN filename$ = "%.%"
     OPEN filename$ FOR RANDOM AS 1
     IF LOF(1) = 0 THEN
          header
          LOCATE 3, 1
          PRINT "No filename by that name found. Hit a key to ABORT."
          getkey
          CLOSE 1
          KILL filename$
          goodbye
     END IF
     CLOSE 1
     OPEN filename$ FOR INPUT AS 1
END SUB

SUB checkprinter
     DO
          IF printer = 0 THEN
               LOCATE 3, 1
               PRINT "Printer is offline. Fix and hit a key, or hit [Esc] to EXIT."
               getkey
          END IF
          IF in$ = esc$ THEN goodbye
     LOOP UNTIL printer = 1
END SUB

SUB getfilename
     IF EOF(2) THEN
          goodbye
          ELSE LINE INPUT #2, filename$
     END IF
END SUB

SUB getkey
in:     in$ = INKEY$: IF in$ = "" THEN GOTO in
END SUB

SUB goodbye
     CLOSE
     IF printer = 1 THEN LPRINT clear$;
     IF killtemp = 1 THEN KILL "copycat.tmp"
     VIEW PRINT
     CLS
     PRINT "Thank you for using COPYCAT."
     END
END SUB

SUB header
     CLS
     LOCATE 1, 1: PRINT STRING$(80, 196);
     PRINT "COPYCAT printing "; filename$;
     PRINT " beginning at "; newtime$; TAB(72); "Page"; page
     LOCATE 4, 1: PRINT STRING$(80, 196);
END SUB

SUB helpscreen
     CLS
     PRINT "COPYCAT prints ASCII files with header and other options."
     PRINT ""
     PRINT "Syntax: COPYCAT filename [ /Mn /Tn /Ln /Jn /S /P ]"
     PRINT " where  filename is any legal path and filename"
     PRINT "        * or ? may be used as wildcards in the filename      "
     PRINT "        /Mn sets left margin to n characters "
     PRINT "        /Tn sets top margin to n lines"
     PRINT "        /Ln sets number of lines on page [default 55]"
     PRINT "        /Jn jump to page n"
     PRINT "        /S  suppresses header"
     PRINT "        /P  previews to screen only"
     PRINT ""
     PRINT "        If filename begins with @ then filename is name of"
     PRINT "        datafile with list of filenames to print, one per line."
     PRINT ""
     PRINT "Written for the public domain and Dr.Download by"
     PRINT "David Wesson  24 Fairview St.  W. Hartford, CT 06119"
     END
END SUB

SUB makelist
        com$ = "dir " + filename$ + " > copycat.dir"
        SHELL com$
        OPEN "copycat.dir" FOR INPUT AS 3
        OPEN "copycat.tmp" FOR OUTPUT AS 4
        WHILE NOT EOF(3)
                LINE INPUT #3, l$
                IF LEFT$(l$, 1) > CHR$(32) THEN
                        f$ = RTRIM$(LEFT$(l$, 8)) + "." + MID$(l$, 10, 3)
                        PRINT #4, f$
                END IF
        WEND
        CLOSE 3
        CLOSE 4
        KILL "copycat.dir"
        filename$ = "@copycat.tmp"
        killtemp = 1
END SUB

FUNCTION newdate$
     day$(0) = "Sunday"
     day$(1) = "Monday"
     day$(2) = "Tuesday"
     day$(3) = "Wednesday"
     day$(4) = "Thursday"
     day$(5) = "Friday"
     day$(6) = "Saturday"
     month$(1) = "Jan"
     month$(2) = "Feb"
     month$(3) = "Mar"
     month$(4) = "Apr"
     month$(5) = "May"
     month$(6) = "Jun"
     month$(7) = "Jul"
     month$(8) = "Aug"
     month$(9) = "Sep"
     month$(10) = "Oct"
     month$(11) = "Nov"
     month$(12) = "Dec"
     t1 = &H2A00: t2 = 0: t3 = 0: t4 = 0
     inregs.ax = t1: inregs.bx = t2: inregs.cx = t3: inregs.dx = t4
     CALL interrupt(&H21, inregs, outregs)
     t1 = outregs.ax: t2 = outregs.bx: t3 = outregs.cx: t4 = outregs.dx
     day = t1 - ((FIX(t1 / 256)) * 256)
     day$ = day$(day)
     year = t3
     year$ = LTRIM$(RTRIM$(STR$(year)))
     month = FIX(t4 / 256)
     month$ = month$(month)
     date = t4 - (month * 256)
     newdate$ = day$ + SPACE$(2) + month$ + STR$(date) + "," + STR$(year)
END FUNCTION

FUNCTION newtime$
     intime$ = TIME$
      hour$ = MID$(intime$, 1, 2)
      min$ = MID$(intime$, 4, 2)
      sec$ = MID$(intime$, 7, 2)
      hour = VAL(hour$)
           IF hour < 12 THEN ampm$ = "am" ELSE ampm$ = "pm"
           IF hour > 12 THEN hour = hour - 12
      hour$ = STR$(hour)
     newtime$ = hour$ + ":" + min$ + ":" + sec$ + " " + ampm$
END FUNCTION

SUB outputroutine
DO
     IF readlist = 1 THEN getfilename
     checkinputfile
     checkprinter
     header
     LOCATE 3, 1
     IF preview = 1 THEN
          PRINT "Hit [Esc] to terminate preview, or any key to continue previewing pages."
          ELSE PRINT "Hit [Esc] to terminate printing.                                         "
     END IF
     row = 5: col = 1
     DO
          x = 0
          page = page + 1
          VIEW PRINT
          LOCATE 2, 76: PRINT page;
          DO
               x = x + 1
               l$(x) = ""
               IF NOT EOF(1) THEN LINE INPUT #1, l$(x)
               in$ = INKEY$
          LOOP UNTIL x = lines OR in$ = esc$
          IF page >= jump THEN printpage
     LOOP UNTIL in$ = esc$ OR EOF(1)
     CLOSE 1
     VIEW PRINT
     page = 0
LOOP
END SUB

FUNCTION printer
     inregs.ax = 2 * 256: inregs.dx = 0
     CALL interrupt(&H17, inregs, outregs)
     ah = FIX(outregs.ax / 256)
     bit7 = FIX(ah / 128)
     bit6 = FIX((ah - (bit7 * 128)) / 64)
     printer = ABS(bit6)
END FUNCTION

SUB printpage
     VIEW PRINT 5 TO 25
     LOCATE row, col
     PRINT STRING$(top, lf$)
     IF preview = 0 THEN LPRINT STRING$(top, lf$)
     IF suppress = 0 THEN
          PRINT SPC(margin); STRING$((79 - margin), 42)
          PRINT SPC(margin); UCASE$(filename$); TAB(20 + margin);
          PRINT newdate$; TAB(45 + margin); newtime$; SPC(16 - margin); "Page"; page
          PRINT SPC(margin); STRING$((79 - margin), 42)
          PRINT lf$;
          IF preview = 0 THEN
               LPRINT SPC(margin); STRING$((79 - margin), 42)
               LPRINT SPC(margin); UCASE$(filename$); TAB(20 + margin);
               LPRINT newdate$; TAB(42 + margin); newtime$; SPC(19 - margin); "Page"; page
               LPRINT SPC(margin); STRING$((79 - margin), 42)
               LPRINT lf$;
          END IF
     END IF
     x = 0
     DO
          x = x + 1
          PRINT SPC(margin); LEFT$(l$(x), 79 - margin)
          IF preview = 0 THEN LPRINT SPC(margin); LEFT$(l$(x), 79 - margin)
          IF LEN(l$(x)) > (80 - margin) THEN
               IF preview = 0 THEN LPRINT SPC(margin); ">"; MID$(l$(x), 80 - margin)
               PRINT SPC(margin); ">"; MID$(l$(x), 80 - margin)
          END IF
          in$ = INKEY$
     LOOP UNTIL x = lines OR in$ = esc$
     PRINT LEFT$(nl$, 80)
     IF preview = 0 THEN LPRINT ff$ ELSE getkey
     row = CSRLIN: col = POS(0)
END SUB

SUB readcommandline
     in$ = COMMAND$
     IF in$ = "" THEN helpscreen
     splitline in$
     x = 0: lines = 55
     DO
          x = x + 1
          wp$ = LEFT$(word$(x), 2)
          SELECT CASE wp$
               CASE "/M": margin = VAL(MID$(word$(x), 3))
               CASE "/T": top = VAL(MID$(word$(x), 3))
               CASE "/L": lines = VAL(MID$(word$(x), 3))
               CASE "/J": jump = VAL(MID$(word$(x), 3))
               CASE "/S": suppress = 1
               CASE "/P": preview = 1
               CASE ELSE
                    IF word$(x) <> "" THEN
                         filename$ = word$(x)
                    END IF
          END SELECT
     LOOP UNTIL word$(x) = ""
     IF filename$ = "" THEN
          LOCATE 3, 1
          INPUT "Enter filename: ", filename$
     END IF
     IF INSTR(filename$, "*") > 0 OR INSTR(filename$, "?") > 0 THEN makelist
     IF suppress = 0 THEN lines = lines - 4
     IF LEFT$(filename$, 1) = "@" THEN
          datafile$ = MID$(filename$, 2)
          OPEN datafile$ FOR INPUT AS 2
          readlist = 1
     END IF
END SUB

SUB splitline (in$) STATIC
     w = 1: word$ = ""
     q1 = INSTR(in$, CHR$(34))
     IF q1 > 0 THEN
          q2 = INSTR(MID$(in$, q1 + 1), CHR$(34))
          test$ = MID$(in$, q1 + 1, q2 - 1)
          in$ = LEFT$(in$, q1 - 1) + MID$(in$, q1 + LEN(test$) + 2)
     END IF
     FOR x = 1 TO LEN(in$)
     ch$ = MID$(in$, x, 1): ch = ASC(ch$)
          IF ch = 32 AND LEN(word$) > 1 THEN
               word$(w) = LTRIM$(RTRIM$(word$)): w = w + 1: word$ = ""
               ELSE word$ = word$ + ch$
          END IF
     NEXT x
     IF LEN(word$) > 1 THEN word$(w) = LTRIM$(RTRIM$(word$))
END SUB

