; TASM EXAMPLE CODE FOR DPMI CALLBACK USE WITH WDOSX
;
; This one will install a costum mouse handler, display a 'L' in left upper
; screen corner if left button pressed, exit on right button press.
;
; ************ No error handling at all! ***************


; realmode callback structure

s	struc
_edi	label	dword
_di	dw	?
	dw	?
_esi	label	dword
_si	dw	?
	dw	?
_ebp	label	dword
_bp	dw	?
	dw	?
_esp	label	dword
_spl	dw	?
	dw	?
_ebx	label	dword
_bx	label	word
_bl	db	?
_bh	db	?
	dw	?
_edx	label	dword
_dx	label	word
_dl	db	?
_dh	db	?
	dw	?
_ecx	label	dword
_cx	label	word
_cl	db	?
_ch	db	?
	dw	?
_eax	label	dword
_ax	label	word
_al	db	?
_ah	db	?
	dw	?
_flags	dw	?
_es	dw	?
_ds	dw	?
_fs	dw	?
_gs	dw	?
_ip	dw	?
_cs	dw	?
_sp	dw	?
_ss	dw	?	
s	ends



.386p
code segment use32
assume cs:code,ds:code

rmcallbackstruc	db	50 dup (?)

nullsel		dw	?
datasel		dw	?

; ------ the procedure that will be called from real mode -------

mousehandler	proc
		push	ds

                ; set return info

		push	ax

		mov	ax,ds:[esi]
		mov	es:_ip[edi],ax

		mov	ax,ds:[esi+2]
		mov	es:_cs[edi],ax

		add	es:_sp[edi],4
		mov	ds,cs:[datasel]

                ; right button pressed?

		test	es:_bx[edi],2
		jz	norbut

		mov	rbpressed,1			
		jmp	outtahere
norbut:
                ; left button pressed?

		mov	al,'L'
		test	es:_bx[edi],1
		jnz	putvideo
		mov	al,' '
putvideo:
		mov	ds,nullsel
		mov	ds:[0b8000h],al

outtahere:
                ; terminate the handler

		pop	ax
		pop	ds
		iretd
mousehandler	endp

rbpressed	db	0

; ------------- main program goes here ---------------

start:
                ; enable virtual interrupts

		mov	ax,0901h
		int	31h

                ; store ds for use in the callback procedure

		mov	datasel,ds

                ; get a selector to low memory

		sub	ax,ax
		mov	cx,1
		int	31h
		mov	bx,ax

                ; set the limit to 4G

		mov	ax,8
		stc
		sbb	ecx,ecx
		sbb	edx,edx
		int	31h

                ; set access rights

		lar	cx,bx
		mov	cl,ch
		and	cl,60h
		or	cl,92h
		mov	ch,0cfh
		mov	ax,9
		int	31h

                ; set descriptor base to 0

		sub	cx,cx
		sub	dx,dx
		mov	ax,7
		int	31h

                ; store selector for use in the callback procedure

		mov	nullsel,bx

                ; reset mouse driver

		sub	ax,ax
		int	33h

                ; allocate callback

		push	ds
		pop	es
		mov	esi,offset mousehandler
		mov	edi,offset rmcallbackstruc
		push	ds
		mov	bx,cs
		mov	ds,bx
		mov	ax,0303h
		int	31h
		pop	ds

                ; install the costum mouse event handler

		mov	edi,offset rmcallbackstruc

		push	cx
		push	dx
		mov	_es[edi],cx
		mov	_dx[edi],dx
		mov	_cx[edi],0eh
		mov	_ax[edi],0ch

		mov	bl,33h
		sub	cx,cx
		mov	ax,0300h
		int	31h

                ; mouse handler now installed
                ; loop until right button pressed

havetowait:
		cmp	rbpressed,0
		jz	havetowait

                ; reset the mouse driver

		sub	ax,ax
		int	33h

                ; free the previously allocated callback

		pop	dx
		pop	cx
		mov	ax,0304h
		int	31h

                ; terminate

		mov	ah,4ch
		int	21h
code ends
end  start

