; ############################################################################
; ##          This file is part of the Wudebug 0.1 aplha sourcecode         ##
; ##                 Copyright (C) 1997, Michael Tipppach                   ##
; ############################################################################


; error codes

ENotWdosx	equ	80000000h
ELoadFile	equ	40000000h
ELoadDpmi	equ	20000000h

_LoadProgram	proc	near
; int LoadProgram(char * Filename)

		mov	_Deax,1
		mov	_Debx,0

		; try opening the file

		mov	edx,[esp+4]
		mov	eax,3d00h
		int	21h
		jnc	@@lp00
		mov	eax,ELoadFile
		ret
@@lp00:
		mov	_Debx,eax

		pushad

		; read wdosx exe header

		mov	_Deax,2
		mov	ebx,eax
		mov	edx,offset Buffer32
		mov	ecx,32
		mov	ah,3fh
		int	21h
		jnc	@@lp01
@@lpb0:
		mov	ebx,_Debx
		test	ebx,ebx
		jz	@@lpnocl
		mov	ah,3eh
		int	21h
@@lpnocl:
		popad
		mov	eax,ELoadFile
		add	eax,_Deax
		ret
@@lp01:
		cmp	eax,32
		jnz	@@lpb0

		; cmp signature

		mov	_Deax,2

		cld
		mov	esi,offset ThatsMe
		mov	edi,offset Buffer32+32-7
		mov	ecx,7
		repe	cmpsb
		je	@@lp03
@@lp02:
		mov	ah,3eh
		int	21h
		popad
		mov	eax,ENotWdosx
		ret
@@lp03:
		cmp	word ptr [offset Buffer32],'ZM'
		jne	@@lp02		

		; get size of extender

		sub	edx,edx
		sub	ecx,ecx
		mov	eax,dword ptr [offset Buffer32+2]	; size mod 512
		shld	edx,eax,16				; size div 512
		neg	eax
		and	eax,511
		shl	edx,9
		sub	edx,eax

		; edx = size, jmp to next header

		shld	ecx,edx,16	; wdosx will never be > 64k, but anyway
		mov	edi,edx
		mov	esi,ecx
		mov	eax,4200h
		int	21h
		jc	@@lpb0

		; file pointer now at the beginning of the executable to load

		mov	_Deax,3

		; get selectors

		sub	eax,eax
		mov	ecx,2
		int	31h
		jnc	@@lp05
@@lpdpmi:
		mov	ebx,_Debx
		test	ebx,ebx
		jz	@@lpnocl1
		mov	ah,3eh
		int	21h
@@lpnocl1:
		popad
		mov	eax,ELoadDpmi
		add	eax,_Deax
		ret
@@lp05:

		mov	_Deax,4

		and	eax,0ffffh
		sub	edx,edx
		mov	ebp,eax
		mov	UserDataSel,eax

		; add selector to free list

		shld	edx,eax,29
		mov	_Dds,eax
		mov	_Dss,eax
		mov	_Dfs,0
		mov	_Dgs,0

		or	al,80h		; mark valid

		mov	[edx+offset AllocSelectors],al

		; get increment, just to satisfy the official protocol 

		mov	eax,3
		int	31h

		add	eax,ebp
		and	eax,0ffffh
		mov	UserCodeSel,eax
		mov	edx,eax
		mov	_Dcs,eax
		shr	edx,3
	
		; set limits to 4G

		mov	ebx,eax

		; add selector to free list

		or	al,80h
		mov	[edx+offset AllocSelectors],al

		mov	eax,8
		mov	ecx,-1
		mov	edx,ecx
		int	31h
		jc	@@lpdpmi
		mov	ebx,ebp
		int	31h	
		jc	@@lpdpmi

		; get cpl, set access rights

		mov	_Deax,5

		lar	cx,bx
		mov	cl,ch
		and	cl,060h
		or	cl,092h
		mov	ch,0c0h
		mov	eax,9
		int	31h
		jc	@@lpdpmi
		mov	ebx,UserCodeSel
		or	cl,9ah
		int	31h
		jc	@@lpdpmi

		mov	_Deax,6

		; current file pointer in si:di

		; read user exe header

		mov	edx,offset Buffer32
		mov	ebx,_Debx
		mov	ah,3fh
		mov	ecx,32
		int	21h
		jc	@@lpb0
		cmp	eax,32
		jnz	@@lpb0

		mov	_Deax,7

		; check for .exe - header

		cmp	word ptr [edx],'ZM'
		jnz	@@lpbinary

		mov	_Deax,8

		; -------------- MZ EXE ------------------------

		; 2do check for loader signature

		; get size of user pgm

		sub	edx,edx
		sub	ecx,ecx
		mov	eax,dword ptr [offset Buffer32+2]	; size mod 512
		shld	edx,eax,16				; size div 512
		neg	eax
		and	eax,511
		shl	edx,9
		sub	edx,eax
		movzx	eax,word ptr [offset Buffer32+8]	; size of header
		shl	eax,4			; para -> byte
		sub	edx,eax

		; edx = bytes to load

		push	edx
		sub	eax,32			; bytes already loaded
		jz	@@lp08
		mov	edx,eax
		sub	ecx,ecx
		shld	ecx,edx,16		; exe header > 64k ??? :-)
		mov	eax,4201h
		int	21h
@@lp08:		
		pop	edx
		jc	@@lpb0


		movzx	eax,word ptr [offset Buffer32+20]	; entry point
		mov	_Deip,eax

		jmp	@@lpgetmem

;-------------- FLAT FORM BINARY ONLY ------------------	

@@lpbinary:
		; set fp to eof
		mov	_Deax,9


		sub	ecx,ecx
		sub	edx,edx
		mov	ax,4202h
		int	21h
		jc	@@lpb0
		shl	eax,16
		shld	edx,eax,16		

		; sub extender size

		sub	edx,edi


		mov	_Deax,10

		; reset file pointer

		push	edx
		mov	edx,edi
		mov	ecx,esi
		mov	eax,4200h
		int	21h
		pop	edx
		jc	@@lpb0

		mov	_Deip,0

@@lpgetmem:

		; don't allocate nothing

		mov	_Deax,11

		test	edx,edx
		jz	@@lpb0

		; get bytes to read

		mov	_Deax,12


		push	edx

		; align on dword and add stack

		add	edx,1027
		and	edx,0fffffffch

		mov	ecx,edx
		shld	ebx,edx,16

		; save initial esp

		mov	_Desp,edx

		; grab mem

		mov	eax,501h
		int	31h
		pop	ebp		; size of bytes to read
		jc	@@lpdpmi

		; save handle

		mov	word ptr ds:[offset UserMemHnd],di
		mov	word ptr ds:[offset UserMemHnd+2],si

		; register the segment as the first one

		mov	word ptr [UserSegs.MsLinearAd],cx
		mov	word ptr [UserSegs.MsLinearAd+2],bx
		mov	word ptr [UserSegs.MsHandle],di
		mov	word ptr [UserSegs.MsHandle+2],si
		mov	[UserSegs.MsSize],edx

		mov	NumSegments,1

		mov	_Deax,13

		; set descriptor base for new cs,ds

		mov	eax,7
		mov	edx,ecx
		mov	ecx,ebx
		mov	ebx,UserCodeSel
		int	31h
		jc	@@lpdpmi

		mov	_Deax,14

		mov	ebx,UserDataSel
		int	31h
		jc	@@lpdpmi


		mov	_Deax,15

		; read file

		sub	edx,edx
		mov	ebx,_Debx
		push	ds
		mov	ds,UserDataSel
		mov	ecx,ebp
		mov	ah,3fh
		int	21h
		pop	ds
		jc	@@lpdpmi

		mov	_Deax,16

		cmp	eax,ebp
		jnz	@@lpb0

		; close file

		mov	ah,3eh
		int	21h

; check for a loader

		mov	esi,offset ThatsMe
		mov	edi,offset Buffer32+32-7
		mov	ecx,7
		repe	cmpsb
		jne	@@NoLoader

		; starting convention:
		; es = psp- selector
		; cs,ds,ss = flat segment
		; esp = user file size + stack size (1k), dword aligned
		; eip = 0
		; interrupts disabled!
		; all other registers - undefined

		; just run the loader ( don't do this at home, kids! )

		mov	edx,_Desp
		sub	edx,1024
		shld	ecx,edx,16
		mov	ebx,_Dcs
		mov	eax,8
		int	31h
		jc	@@lpdpmi

		; let it run until it GPFs

		call	_Run
		cmp	al,13
		jnz	@@lpdpmi

		stc
		sbb	ecx,ecx
		sbb	edx,edx
		mov	ebx,_Dcs
		mov	eax,8
		int	31h
		jc	@@lpdpmi
		call	_SingleStep

@@NoLoader:
		popad
		sub	eax,eax
		ret

_LoadProgram	endp
