/****************************************************************************
*                                                                           *
*   File name:   RS_232.C                                                   *
*                                                                           *
*****************************************************************************
*                                                                           *
*  Copyright 1999-2000 Advanced Web Communication, division of Xecom, Inc.  *
*                                                                           *
*  This software is the property of Advanced Web Communication, Division    *
*  of Xecom, Inc. which specifically grants the user the right to modify,   *
*  use and distribute this  software provided this notice and the           *
*  "Running on AWC (Xecom) Web-Controller"  sign on the created web pages is*
*  not removed or altered. All other rights are reserved by AWC (Xecom).    *
*                                                                           *
*  XECOM MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, WITH REGARD TO  *
*  THIS SOFTWARE.  IN NO EVENT SHALL XECOM BE LIABLE FOR INCIDENTAL OR      *
*  CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING FROM THE FURNISHING, *
*  PERFORMANCE, OR USE OF THIS SOFTWARE.                                    *
*                                                                           *
*  So that all may benefit from your experience, please report any problems *
*  or suggestions about  this  software back to Xecom  Please include your  *
*  name, company, telephone number, Xecom product requiring  support   and  *
*  question or problem encountered.                                         *
*                                                                           *
*  Advanced WEB Communication (AWC), Division of Xecom, Inc.                *
*        374 Turquoise Street, Milpitas, CA 95035                           *
*                                                                           *
*  Worldwide support and contact information available at:                  *
*        http://www.xecom.com/                                              *
*        http://www.xecom.com/support/web-controller.htm                    *
*                                                                           *
*****************************************************************************
*                                                                           *
*  AWC86                                                                    *
*  AWC86 is a Web Controller designed for embedded control applications     *
*  which requires remote monitoring, update, or control.                    *
*                                                                           *
*  WEB SERVER FEATURES:                                                     *
*                                                                           *
*     10Base-T Ethernet MAC and PHY interface needs only RJ45 Style         *
*     connector.                                                            *
*                                                                           *
*     Embedded Web Server supports applications which use CGI Programming to*
*     control/monitor processes and communicate through the serial port.    *
*                                                                           *
*     Compatible with all current browsers including Internet Explorer and  *
*     Netscape Navigator.                                                   *
*                                                                           *
*     Development tools, Internet utilities and example web pages library   *
*     file provided with Development Kit.                                   *
*                                                                           *
*  PACKAGING FEATURES:                                                      *
*                                                                           *
*     Small size: 2.75" L x 1.38" W x 0.42" H                               *
*                                                                           *
*     Sturdy, encapsulated construction seals circuits from harsh           *
*     environment;                                                          *
*                                                                           *
*     Industrial temperature range available (-40C to +85C)                 *
*                                                                           *
*  SOFTWARE DESIGN TOOLS:                                                   *
*                                                                           *
*     Compatible with Borland Turbo C++ versions 3.0, 3.1, 4.5 and 4.52.    *
*                                                                           *
*     Source Code Licenses available for XERTOS, Real-Time Kernel, TCP/IP   *
*     Stack and HTTP Server.                                                *
*                                                                           *
*     CONTROLLER FEATURES:                                                  *
*                                                                           *
*     Fully integrated micro-controller in a single module.                 *
*                                                                           *
*     AM186 Processor with real time clock on board                         *
*                                                                           *
*     34 I/O functions pins software selectable and configurable:           *
*        - Two serial port (RS232-TTL)                                      *
*        - Eight 12-bit analog inputs and Two 12-bit analog outputs (AWC86A)*
*        - Digital I/O, Timers.                                             *
*                                                                           *
*     512KB Flash memory for user application code, Web page layouts and    *
*     control data;                                                         *
*                                                                           *
*     512KB SRAM for fun time code and data buffering                       *
*                                                                           *
*     Monitor firmware with real time kernel using serial port to support   *
*     application development.                                              *
*                                                                           *
*     Development kit available with wire wrap area, supporting circuitry   *
*     and network connectors.                                               *
*                                                                           *
*  MicroRTOS(TM)                                                            *
*  MicroRTOS(TM) is an Internet enabled Real-Time Operating System. It is   *
*  developed for using with SlimLink(R) Web-Controllers. MicroRTOS(TM) has  *
*  integrated with these features:                                          *
*                                                                           *
*     Preemptive Real-time Kernel for multi-tasking applications.           *
*                                                                           *
*     Embedded (HTTP) Web Server supports user applications with static web *
*     pages and dynamic web pages created using CGI Programming.            *
*                                                                           *
*     Integrated Telnet server allows remote operation through the Internet *
*     with a common Telnet tool.                                            *
*                                                                           *
*     Supporting SMTP Email functions permits electronic sending of messages*
*     for data transfer or alarm reporting.                                 *
*                                                                           *
*     Multiple consoles tasks for user development and application platform *
*     including two local consoles (Console A and Console B) and two remote *
*     consoles (Console R and Console T).                                   *
*                                                                           *
*     MicroRTOS includes debug utility which can be used to troubleshoot the*
*     overall system design.                                                *
*                                                                           *
*     The MicroRTOS command line interface provides user control over many  *
*     functions including the   embedded Web Server and user account status.*
*                                                                           *
*****************************************************************************
*                                                                           *
*  Source file:  RS_232.C                                                   *
*  Batch File:   MAKE_BC.BAT (for BC 4.5/4.52)                              *
*                MAKE_MC.BAT (for MC 1.0/1.52)                              *
*  Created file: RS_232.CGI                                                 *
*                                                                           *
*                                                                           *
*  Re-build the RS_232.cgi                                                  *
*  =========================                                                *
*                                                                           *
*  To re-build this file is the first step towards creating your own        *
*  Embedded Web site on the Web-Controller. The following are procedures    *
*  AWC (Xecom) developed for the Web-Controller, which has been implemented *
*  using a batch  file  as  above  mentioned  combined  with a  make file   *
*  (xeappBC.mak or xeappMC.mak).                                            *
*                                                                           *
*   1.For Borland C compiler users:                                         *
*   - Use Borland C++ V4.5/4.52 to compile this C source code to generate   *
*     a .obj file;                                                          *
*   - Use TLINK.EXE to generate a binary files similar to .COM format;      *
*   - Use BIN2HEX.EXE to convert the above generated file to an Intel Hex   *
*     format files downloadable to AWC86/86A.                               *
*                                                                           *
*   2.For Microsoft C compiler users:                                       *
*   - Use Microsoft VC++ 1.00-1.52 to compile this C source code and        *
*     generate a .obj file;                                                 *
*   - Use LINK.EXE to generate a binary files similar to .COM format;       *
*   - Use BIN2HEX.EXE to convert the above generated file to an Intel Hex   *
*     format files downloadable to AWC86/86A.                               *
*                                                                           *
*  The xeappbc.mak or xeappmc.mak is a make file supported by MAKE tools.   *
*  It will be called by make_bc.bat or make_mc.bat to build the target      *
*  files. Normally, the .mak file do not needs to be modified, It can be    *
*  used to process other user CGI and task programs. If you need to build   *
*  another program, you can modify the MAKE_BC.BAT or MAKE_MC.BAT file.     *
*                                                                           *
*****************************************************************************
*  Revision record:                                                         *
*                                                                           *
*  07-28-2000 MicroRTOS Revision 1.50 released                              *
*  03-20-2000 Revision 1.01 released                                        *
*  03-08-2000 Resource Request Table added                                  *
*  02-01-2000 Revision 1.00 released                                        *
*  01-15-2000 Application tasks separated from the MicoRTOS                 *
*  10-11-1999 MicroRTOS established with Web-Server function                *
*  08-01-1999 Initiated for the Embedded Web Server Controller              *
*                                                                           *
*****************************************************************************
*                                                                           *
*  The cgi functions in this file can be separated into two different       *
*  categories, the  CGI Web Pages and CGI subroutines.  The CGI web         *
*  pages are functions invoked to generate a page of display. The CGI       *
*  subroutines are functions to be called by other functions. All the       *
*  functions will have its definition in front of the functions.            *
*                                                                           *
*  Note that the User CGI table in the end of this file is for all CGI      *
*  Web pages.  You have to have all the CGI Web Pages listed in this        *
*  table to make them executable in the system. The MicroRTOS will look     *
*  up this table to find a CGI web page to serve a CGI call.                *
*                                                                           *
*  You should define all I/O pins you need to use in the Resource           *
*  Request Table. MicroRTOS will setup them for you when it started.        *
*                                                                           *
****************************************************************************/

// Define this file as a CGI file

    #define  CGIFILE
    #define  CMDFILE

// Include XEWC86 library functions
 
    #include "AwcAp150.h"

// background color number and data

    int  bgcolorn = 0;
    char *bgcolor[5] =
    {
        "#FDE3F0","#F4D7C4","#E6F8FF","#D8FEDD","#F9FCC5"
    };

// Baudrate table

    unsigned long bt[] = 
    {
        300,600,2400,4800,9600,14400,19200,28800,38400,57600,115200
    };

/****************************************************************************
*                                                                           *
*   CGI Subroutines are lower level functions called by other Subroutines   *
*   or by "CGI Web Pages". Here are the CGI subroutinr names:               *
*                                                                           *
*       atolx                                                               *
*       ctoh                                                                *
*       get_bgcolor                                                         *
*       send_message                                                        *
*       web_tit                                                             *
*       web_idx                                                             *
*                                                                           *
*****************************************************************************
*                                                                           *
*   CGI Subroutine: Send an HTML page header.                               *
*                                                                           *
****************************************************************************/
void web_tit(char far *title,   char far *label, char far *bgcolor, 
             char far *reftime, char far *reffile)
{
    WebSend("<html><head><title>");
    WebSend(title);
    WebSend("</title>");
    if(reftime != NULL) 
    {
        WebSend("<meta http-equiv=\"refresh\" content=\"");
        WebSend(reftime);
        WebSend(";url=");
        WebSend(reffile);
        WebSend("\">");
    }
    else if(reffile != NULL) 
    {
        WebSend(reffile);
    }
    WebSend("<meta http-equiv=Pragma content=no-cache></head><body");
    if(bgcolor != NULL) 
    {
        WebSend(" bgcolor=\"");
        WebSend(bgcolor);
        WebSend("\"");
    }
    WebSend("><center><strong><font color=#C92737 face=Impact size=5>");
    WebSend(label);
    WebSend("</font></strong><hr></center>");
}

/****************************************************************************
*                                                                           *
*   CGI Subroutine: Send ending message for a CGI page                      *
*                                                                           *
****************************************************************************/
void web_idx(void)
{
    WebSend("<font color=#FF0000 size=1><strong><p align=center>&copy;"
            "2000 - Xecom, Inc. all rights reserved</p>"
            "<p align=center>Running on AWC/XECOM Web-Controller</p>"
            "</strong></font></body></html>\r\n");
}

/****************************************************************************
*                                                                           *
*   CGI Subroutine: Get a background color number.                          *
*                                                                           *
****************************************************************************/
char far *get_bgcolor(void)
{
    bgcolorn = (bgcolorn + 1) % 5;
    return bgcolor[bgcolorn];
}

/****************************************************************************
*                                                                           *
*   CGI Subroutine: Send a message in HTML format                           *
*                                                                           *
****************************************************************************/
void send_message(char far *wbuf, char far *htmlfile)
{
    web_tit("Server MSG","Server Message",get_bgcolor(),"2",htmlfile);
    WebSend("<center><h1><small><font color=\"#FF8040\">");
    WebSend(wbuf);
    WebSend("</font></small></h1></center><br>");
    web_idx();
    WebSend("</body></html>");
}

/****************************************************************************
*                                                                           *
*    CGI Subroutine: Convert a string into a Hex number                     *
*                                                                           *
****************************************************************************/
unsigned long atolx(char far * str)
{
    unsigned long lret=0L;
    unsigned int i;

    for(i=0;i<strlen(str);i++) 
    {
        if((str[i]<'0') || (str[i]>'9' && str[i]<'A') || 
            (str[i]>'Z' && str[i]<'a') || (str[i]>'z'))
        {
            return lret;
        }
        lret<<=4;
        lret+=(str[i]>='A') ? ((str[i] & 0xDF) -'A' +10) : (str[i] - '0');
    }
    return lret;
}

/****************************************************************************
*                                                                           *
*   CGI Subroutine: Convert a character to hex number.                      *
*                                                                           *
****************************************************************************/
int ctoh(char c)
{
    if(c >= '0' && c <='9') return c - '0';
    if(c >= 'A' && c <='F') return c - 'A' + 10;
    if(c >= 'a' && c <='f') return c - 'a' + 10;
    return 16;
}

/****************************************************************************
*                                                                           *
*   CGI Subroutine: Convert a string to unsigned long.                      *
*                                                                           *
****************************************************************************/
unsigned long atolu(char far *s)
{
    unsigned long d = 0;

    while(*s != 0 && d < 429496728) 
    {
        if(*s >= '0' && *s <='9') 
            {
                d = (d * 10) + (*s - '0');
                s++;
            }
        else
            break;
    }
    return d;       
}

/****************************************************************************
*                                                                           *
*   CGI for serial port                                                     *
*                                                                           *
****************************************************************************/
int far cgi_serial(void)
{
    char far *p;
    char far *out;
    char ss[200];
    int i;
    int l;
    unsigned long n;

    if((p = CGIGetParaValue("baud")) != NULL ) 
    {    // if there is "baud"
        n = atolu(p);                            // get baudrate to n
        if(BbaudSet(n)) 
        {                                        // if set baudrate is OK
            sprintf(ss,"Set baud to %s Bps",p);  // make the message
        }
        else 
        {                                        // if can set baudrate
            sprintf(ss,"Set baud rate false!",p);// make the message
        }
        send_message(ss,"serial.cgi");           // send the message
        return 0;                                // return
    }

    if((p = CGIGetParaValue("outascii")) != NULL ) 
    {
        out = p;                                 // save ASCII pointer
        while(*p) 
        {
            Bputch(*p++);                        // send ASCII to SIO
        }
        Bputch(0x0d);                            // send a "return"
        Bputch(0x0a);                            // send a "new line"
        sprintf(ss,"Send out string: %s",out);   // make the message
        send_message(ss,"serial.cgi?type=a");    // send the message
        return 0;
    }

    if((p = CGIGetParaValue("outhex")) != NULL ) 
    {
        out = p;                                 // save the pointer                                    
        while(*p)                                // while *p not zero
        {                                 
            if((i = ctoh(*p)) < 16)              // get the hex code
            {               
                p++;
                if(*p && ((l = ctoh(*p)) < 16))  // get the next hex code
                {   
                    p++;
                    i = i * 16 + l;              // combine to a BYTE
                }
                Bputch((char)i);                 // send the BYTE
            }
            else 
            {
                p++;                             // skip it
            }
        }
        sprintf(ss,"Send out Hex code: %s",out);
        send_message(ss,"serial.cgi?type=h");    // send the message
        return 0;
    }

    p = CGIGetParaValue("type");
    
    WebSend("<html><head><meta http-equiv=Content-Typecontent=\"te"
            "xt/html; charset=iso-8859-1\"><meta name=\"GENERATOR\" c"
            "ontent=\"Microsoft FrontPage 2.0\"><title>Demo for Seria"
            "l Port B</title></head><body bgcolor=#F5E4BC><p align=ce"
            "nter><font color=#800040 size=6 face=Impact><em>Demo for"
            " Xecom Web-Controller's Serial Port B</em></font></p><p "
            "align=center> </p><div align=center><center><table borde"
            "r=3 width=80% bgcolor=#C7EBCF><tr><td><br><p align=cente"
            "r><strong>Set the baud rate same as the connected device"
            "</strong></p><blockquote><font size=2><p>If you type '41"
            " 20 42 20 43 20 44 20 45' in 'Hexadecimal bytes' box and"
            " press 'send' button, you will see display 'A B C D E' o"
            "n your terminal connected to the Web-Controller port B. "
            "If you type '12345' on the terminal and push the 'send' "
            "button again, you will see '31 32 33 34 35' in the respo"
            "se box. </p><p>The initial baud rate is the current Web-"
            "Controller port B's. If you want to change it, you must "
            "select one in the pull down manu and press the 'Set' but"
            "ton to enable it.</p></font></blockquote><center><form a"
            "ction=serial.cgi method=GET><select name=baud>");

    n = BbaudGet();                              // get current baudrate

    for(i = 0; i < 11; i++)                      // make the baudrate table
    {                    
        if(n == bt[i])                           // for CGI page
        {                        
            sprintf(ss,"<option selected>%ld",bt[i]);
        }
        else 
        {
            sprintf(ss,"<option>%ld",bt[i]);
        }
        WebSend(ss);
    }

    WebSend("</select> <input type=submit value=SET></font></form></center><"
            "/td></tr></table></center></div><center><table valign=center bo"
            "rder = 0><tr><td valign=center><form method=GET>Hexadecimal Byt"
            "es <input type=text size=24 name=outhex><input type=submit name"
            "=S1 value=\"Send &#38 Receive\"></form></td> <td valign=top>&nb"
            "sp;&nbsp;Response <input type=text size=20 name=T1");

    if(*p == 'h') 
    {
        WebSend(" value=\"");
        while(Bkbhit()) 
        {
            sprintf(ss,"%02x ",Bgetch());
            WebSend(ss);
        }
        WebSend("\"");
    }

    WebSend("></td></tr><tr><td valign=center><form method=GET>ASCII Charact"
            "ers <input type=text size=25 name=outascii><input type=submit n"
            "ame=S2 value=\"Send &#38 Receive\"></form></td><td valign=top>&"
            "nbsp;&nbsp;Response <input type=text size=20 name=T2");

    if(*p == 'a') 
    {
        WebSend(" value=\"");
        while(Bkbhit())                          // while there is char
        {                   	                 
            sprintf(ss,"%c",Bgetch());
            WebSend(ss);
        }
        WebSend("\"");
    }

    WebSend("></td></tr></table></center><p align=center><font color=#FF0000"
            " size=1><strong>&copy;2000 - Xecom, Inc. all rights reserved</s"
            "trong></font></p><p align=center><font color=#FF0000 size=1><st"
            "rong>Running on AWC/XECOM Web-Controller</strong></font></p></b"
            "ody></html>");
    return 0;
}

/****************************************************************************
*                                                                           *
*   User command "#TER" for Terminal                                        *
*                                                                           *
****************************************************************************/
void far PassCmd(void)
{
    char ch0,ch1;

    // Send a message to COM-A and COM-B
    printf((char far *)"[ User Terminal Mode, use '~' to quit. ]\r\n");
    for (;;)
    {
        if(Bkbhit()) 
        {
            ch0=Bgetch();                 	 // get it
            putch(ch0);                   	 // pass it to COM_A
        }       
        if(kbhit())                              // if COM_A has an input 
        {                     
            ch1=getch();                  	 // get it
            Bputch(ch1);                  	 // pass it to COM_B
        }
        if( ch1==0x7E )                          // if char is equal '~' 
        {                   
            printf((char far *)"\r\n\n"); 	 //send '\r\n\n' to COM_A
            Bputs((char far *)"\r\n\n");  	 //send '\r\n\n' to COM_B
            return ;                      	 //exit #pass command
        }
    }      
}

/****************************************************************************
*                                                                           *
*   CGI Subroutine: Initialization                                          *
*                                                                           *
****************************************************************************/
int far cgi_init(void)
{
    return TRUE;
}

/****************************************************************************
*                                                                           *
*  Resource Request Table                                                   *
*  ======================                                                   *
*                                                                           *
*  The Resource Request Table is for user to request the digital I/O and    *
*  devices. it can suppress some other tasks to be loaded if they use same  *
*  I/O or device.                                                           *
*                                                                           *
*  When system load a task or install CGI, system will check this tabel     *
*  first, if all of the devices requested are idle, system will refer these *
*  devices to this task or CGI, and any other task can't get them again.    *
*                                                                           *
*  There are four parts in the Devices Request Table:                       *
*       . DEVICE_USED                                                       *
*       . DIO_INPUT                                                         *
*       . DIO_OUTPUT_0                                                      *
*       . DIO_OUTPUT_1                                                      *
*                                                                           *
*  The table must ended with 'USED_END'.                                    *
*                                                                           *
*  DEVICE_USED                                                              *
*       If you are using A/D, D/A, COM-B (serial port B) or timer_0 in      *
*       your application task, you should remove the '//' at the beginning  *
*       of the line.                                                        *
*                                                                           *
*  DIO_INPUT                                                                *
*       If you are using DIO pin(s) as input, you should remove the '//'    *
*       at the beginning of tes line. System will setup the pin as input    *
*       when this task is loaded.                                           *
*                                                                           *
*  DIO_OUTPUT_0                                                             *
*       If you use some DIO pin as output, you should remove the '//'       *
*       at the head of this line. system will setup these pin as output     *
*       when this task is loaded, and set it to 0(low level).               *
*                                                                           *
*  DIO_OUTPUT_1                                                             *
*       If you use some DIO pin as output, you should remove the '//'       *
*       at the beginning of the line. system will setup the pin as output   *
*       when the task loaded, and set it to a low level output(0).          *
*                                                                           *
****************************************************************************/
DEVICE_USED
//  USE_ADC             // A/D converter will be used (for 86A only)
//  USE_DAC             // D/A converter will be used (for 86A only)
//  USE_TIMER_0         // Timer 0 will be used
//  USE_CONSOLE_A       // Console A will be used
    USE_CONSOLE_B       // Console B will be used
//  NOT_DETECT_MODEM    // Do not detect the modem
//
DIO_INPUT
// DIO pins in this group will be initialized as input.
// Remember you can always leave some pins alone (not enabled) but
// can not make the same pin enebled in different groups
//
//  PIN10_DIO00_TXDA    // DIO pin 00 used as input
//  PIN11_DIO01_RXDA    // DIO pin 01 used as input
//  PIN12_DIO02_RTSB    // DIO pin 02 used as input
//  PIN13_DIO03_CTSB    // DIO pin 03 used as input
//  PIN14_DIO04_TXDB    // DIO pin 04 used as input
//  PIN15_DIO05_RXDB    // DIO pin 05 used as input
//  PIN16_DIO06         // DIO pin 06 used as input
//  PIN17_DIO07         // DIO pin 07 used as input
//  PIN18_DIO08_INT2    // DIO pin 08 used as input
//  PIN19_DIO09_INT4    // DIO pin 09 used as input
//  PIN40_DIO10         // DIO pin 10 used as input
//  PIN41_DIO11         // DIO pin 11 used as input
//  PIN42_DIO12         // DIO pin 12 used as input
//  PIN43_DIO13_INT6    // DIO pin 13 used as input
//  PIN44_DIO14_INT5    // DIO pin 14 used as input
//  PIN45_DIO15_TIN0    // DIO pin 15 used as input
//  PIN46_DIO16_TOUT0   // DIO pin 16 used as input
//  PIN47_DIO17         // DIO pin 17 used as input
//  PIN48_DIO18         // DIO pin 18 used as input
//  PIN49_DIO19         // DIO pin 19 used as input
//  PIN50_DIO20         // DIO pin 20 used as input
//  PIN51_DIO21         // DIO pin 21 used as input
//  PIN36_DIO22         // DIO pin 22 used as input
//  PIN37_DIO23         // DIO pin 23 used as input
//  PIN38_DIO24         // DIO pin 24 used as input
//  PIN39_DIO25         // DIO pin 25 used as input
//
DIO_OUTPUT_0
// DIO pins in this group will be initialized to output low (0).
// Remember you can always leave some pins alone (not enabled) but
// not make the same pin enebled in different groups
//
//  PIN10_DIO00_TXDA    // DIO pin 00 set to output 0
//  PIN11_DIO01_RXDA    // DIO pin 01 set to output 0
//  PIN12_DIO02_RTSB    // DIO pin 02 set to output 0
//  PIN13_DIO03_CTSB    // DIO pin 03 set to output 0
//  PIN14_DIO04_TXDB    // DIO pin 04 set to output 0
//  PIN15_DIO05_RXDB    // DIO pin 05 set to output 0
//  PIN16_DIO06         // DIO pin 06 set to output 0
//  PIN17_DIO07         // DIO pin 07 set to output 0
//  PIN18_DIO08_INT2    // DIO pin 08 set to output 0
//  PIN19_DIO09_INT4    // DIO pin 09 set to output 0
//  PIN40_DIO10         // DIO pin 10 set to output 0
//  PIN41_DIO11         // DIO pin 11 set to output 0
//  PIN42_DIO12         // DIO pin 12 set to output 0
//  PIN43_DIO13_INT6    // DIO pin 13 set to output 0
//  PIN44_DIO14_INT5    // DIO pin 14 set to output 0
//  PIN45_DIO15_TIN0    // DIO pin 15 set to output 0
//  PIN46_DIO16_TOUT0   // DIO pin 16 set to output 0
//  PIN47_DIO17         // DIO pin 17 set to output 0
//  PIN48_DIO18         // DIO pin 18 set to output 0
//  PIN49_DIO19         // DIO pin 19 set to output 0
//  PIN50_DIO20         // DIO pin 20 set to output 0
//  PIN51_DIO21         // DIO pin 21 set to output 0
//  PIN36_DIO22         // DIO pin 22 set to output 0 (for AWC86 only)
//  PIN37_DIO23         // DIO pin 23 set to output 0 (for AWC86 only)
//  PIN38_DIO24         // DIO pin 24 set to output 0 (for AWC86 only)
//  PIN39_DIO25         // DIO pin 25 set to output 0 (for AWC86 only)

DIO_OUTPUT_1
// DIO pins in this group will be initialized to output high (1).
// Remember you can always leave some pins alone (not enabled) but
// not make the same pin enebled in different groups
//
//  PIN10_DIO00_TXDA    // DIO pin 00 set to output 1
//  PIN11_DIO01_RXDA    // DIO pin 00 set to output 1
//  PIN12_DIO02_RTSB    // DIO pin 00 set to output 1
//  PIN13_DIO03_CTSB    // DIO pin 00 set to output 1
//  PIN14_DIO04_TXDB    // DIO pin 00 set to output 1
//  PIN15_DIO05_RXDB    // DIO pin 00 set to output 1 
//  PIN16_DIO06         // DIO pin 00 set to output 1 
//  PIN17_DIO07         // DIO pin 00 set to output 1 
//  PIN18_DIO08_INT2    // DIO pin 00 set to output 1 
//  PIN19_DIO09_INT4    // DIO pin 00 set to output 1 
//  PIN40_DIO10         // DIO pin 00 set to output 1 
//  PIN41_DIO11         // DIO pin 00 set to output 1 
//  PIN42_DIO12         // DIO pin 00 set to output 1 
//  PIN43_DIO13_INT6    // DIO pin 00 set to output 1 
//  PIN44_DIO14_INT5    // DIO pin 00 set to output 1 
//  PIN45_DIO15_TIN0    // DIO pin 00 set to output 1 
//  PIN46_DIO16_TOUT0   // DIO pin 00 set to output 1 
//  PIN47_DIO17         // DIO pin 00 set to output 1 
//  PIN48_DIO18         // DIO pin 00 set to output 1 
//  PIN49_DIO19         // DIO pin 00 set to output 1 
//  PIN50_DIO20         // DIO pin 00 set to output 1 
//  PIN51_DIO21         // DIO pin 00 set to output 1 
//  PIN36_DIO22         // DIO pin 00 set to output 1 (for AWC86 only)
//  PIN37_DIO23         // DIO pin 00 set to output 1 (for AWC86 only)
//  PIN38_DIO24         // DIO pin 00 set to output 1 (for AWC86 only)
//  PIN39_DIO25         // DIO pin 00 set to output 1 (for AWC86 only)
USED_END

/****************************************************************************
*                                                                           *
*  User CGI Table                                                           *
*  ==============                                                           *
*                                                                           *
*  The User CGI Table is for linking the  user CGI file  names  to User CGI *
*  function names. There are danymic web pages created by CGI programs in   *
*  the MicroRTOS system.  We use a CGI  "function" to create a "web page".  *
*  In normal Internet web server system a page could be  generated by a CGI *
*  program file or a combination of several different  files.  But for an   *
*  easier  Web-Controller operation,  we have multiple CGI web pages (CGI   *
*  functions) in a single program file.  When this program file installed   *
*  into the system,  all CGI page functions are treated like  different CGI *
*  files.  The  Embedded  Web Server calls up the function  when a request  *
*  is received from the Internet.  The Web-Server searches for  the  file   *
*  name in the system,  and it looks up in the User CGI Table,  it  is      *
*  then  transferred  to a function name to be called to get the requested  *
*  job done.                                                                *
*                                                                           *
*  You need to have a line for each CGI web page(CGI function) you create,  *
*  in the table, using the following format:                                *
*                                                                           *
*  {CGI function name, "CGI file name"}                                     *
*                                                                           *
*  CGI function name: A name to refer to the called function, a piece of C  *
*                     code to create a web page.                            *
*  CGI file name:     It is a link used by the embedded web  server to      *
*                     find the CGI function needed. It is like a file name  *
*                     in the MicroRTOS system.  but you can not see those   *
*                     names  by using the console command "DIR".            *
*                                                                           *
****************************************************************************/
//User CGI Table
CGI_TABLE
            { cgi_init,         "__init.cgi" },
            { cgi_serial,       "serial.cgi" },
CGI_TABLEEND

/****************************************************************************
*                                                                           *
*  User Command Table                                                       *
*  ==================                                                       *
*                                                                           *
*  User command is for user created MicroRTOS console operations.  The User *
*  Command Table is the link between created commands and MicroRTOS system. *
*  MicroRTOS will look up for this table to attach all commands to the      *
*  system. After MicroRTOS boots up, User command can be listed by typing   *
*  "#?" command in a console process.                                       *
*                                                                           *
*  You need to have a line for each created command function in the table,  * 
*  using the following format:                                              *
*                                                                           *
*  {function name, "Command name", Priority, "Help message}                 *
*                                                                           *
*  Function name: A label of the created code for the command, which means  *
*                 when the command name with a "#" as its prefix input from *
*                 a console process, it will start to run from this         *
*                 entrance.                                                 *
*  Command name:  The command name is an ascii string used as a name for    *
*                 the command                                               *
*  Priority:      A number defines the command priority level.              *
*  Help message:  An ASCII string to be listed when queried by "#?" command.*
*                                                                           *
****************************************************************************/

CMD_TABLE
            {PassCmd, "Terminal",  3, "#Terminal - Terminal mode on COM-B."},
CMD_TABLEEND

// END OF THIS FILE.
