//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVBUTTON.H                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Buttons interface                    |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#ifndef _PVBUTTON_H
#define _PVBUTTON_H
class Tbutton : public Titem
{
//<R> means read-only
//<R/W> means read/write
  public:
    char *title; //<R> button's title
    uint command; //<R> command to be generated when button pressed
    boolean pressed; //<R> button held down
    uint shortcut; //<R/W> button's keyboard shortcut
    Tbutton( char *t, uint cmd );
    virtual ~Tbutton( void );
    virtual void set_flags( uint _flags_word, boolean enable );
    virtual void set_state( uint _state_word, boolean enable );
    void set_title( char *t );
    void set_cmd( uint cmd );

  protected:
    virtual void set_palette( void );
    virtual void draw( void );
    virtual void get_focused( void );
    virtual boolean release_focus( void );
    virtual void event_handler( Tevent &ev );
    virtual void press( void );
    void grab_default( void );
    void release_default( void );
};

class Ticon : public Tbutton
{
  public:
    Ticon( char *t, uint cmd, uint _shortcut );

  protected:
    virtual void calc_bounds( int delta_xl, int delta_yl );
    virtual void set_palette( void );
    virtual void draw( void );
    virtual void event_handler( Tevent &ev );
};

class Tkey : public Titem
{
//<R> means read-only
//<R/W> means read/write
  public:
    uint command; //<R/W>
    uint shortcut; //<R/W>
    Tkey( uint k, uint cmd );

  protected:
    virtual void event_handler( Tevent &ev );
};
#endif

//CONSTRUCTORS FOR USE WITH DIALOG BOXES

Tbutton *button( char *t, uint cmd );
Tbutton *dbutton( char *t, uint cmd );
Tbutton *dcbutton( char *t, uint cmd );
Tbutton *kbutton( char *t );
Tbutton *cbutton( char *t );
Tbutton *hbutton( char *t );
Tkey *key( uint k, uint cmd );
