
/*--------------------------------------------------------------------------
 *
 *	MOUKEY v1.0 for C/C++
 *	Event-driven mouse & keyboard interface
 *
 *	EVTEST.CPP: Test program
 *
 *	May 1997
 *
 *	Copyright (c) 1997 Tanescu A. Horatiu
 *	Author's address: alpha@lego.soroscj.ro
 *
 *	Written and compiled under Borland C++ Version 3.1.
 *
 *	Permission is granted to incorporate any or all code and
 *	information contained in this file into other programs
 *	provided that proper credit is given to Tanescu A. Horatiu.
 *
 *--------------------------------------------------------------------------
 *
 *	Revision history:
 *      1.0	May 1997	Initial coding.
 *
 */

#include "mouse.h"
#include "events.h"
#include <dos.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#define	EV_SHUTDOWN	0x0400			// shutdown event code

/*  Build a text attribute from a background and text color
 */

#define MAKEATTR(backcolor, textcolor)		(backcolor*16 + textcolor)

/*  Defines active text-mode window and clears it with a text attribute.
 */

void win(int left, int top, int right, int bottom, int attr)
  { window(left, top, right, bottom); textattr(attr); clrscr(); }

/*  Writes a string in the center of a row.
 */

int ccputs(const char *str, int y)
{
  struct text_info ti; gettextinfo(&ti);
  gotoxy((ti.winright - ti.winleft + 1 - strlen(str))/2 + 1, y);
  return (cputs(str));
}

/*  Display information about an event
 */

void displayevent(TEvent& event)
{
  mouseHide();

  if (event.event & ET_MOUSE)	// display information about a mouse event
  {
    textcolor(14); cputs("Mouse:    "); textcolor(7);
    switch (event.event)
    {
      case EV_MOUSEDOWN:				// mouse down event
	if (event.mouse.info.leftPressed) cputs("left ");
	if (event.mouse.info.rightPressed) cputs("right ");
	if (event.mouse.info.middlePressed) cputs("middle ");
	if (event.mouse.info.dblClick) cputs("button double-clicked");
	else cputs("button pressed");
	cprintf(" at (%2d, %2d)", event.mouse.X, event.mouse.Y);
	if (event.mouse.Y > 24) event.event = EV_SHUTDOWN;
	break;
      case EV_MOUSEUP:					// mouse up event
	if (event.mouse.info.leftReleased) cputs("left ");
	if (event.mouse.info.rightReleased) cputs("right ");
	if (event.mouse.info.middleReleased) cputs("middle ");
	cprintf("button released at (%2d, %2d)", event.mouse.X, event.mouse.Y);
	break;
      case EV_MOUSEMOVE:				// mouse move event
	cprintf("moved from (%2d, %2d) to (%2d, %2d)",
		event.mouse.lastX, event.mouse.lastY,
		event.mouse.X,     event.mouse.Y);
	break;
      case EV_MOUSEAUTO:				// mouse auto event
	cprintf("mouse auto at (%2d, %2d)", event.mouse.X, event.mouse.Y);
    }
  }
  else				// display information about a keyboard event
  {
    textcolor(11); cputs("Keyboard: "); textcolor(7);
    cprintf("Key: %4XH  ASCII: %2XH  SCAN: %2XH", event.key.key,
	    event.key.code.ascii, event.key.code.scan);
    if (event.key.key == 0x011B) event.event = EV_SHUTDOWN;	// Esc key
  }

  // display event's time stamp
  gotoxy(58, wherey());
  textcolor(15); cputs("Time stamp: ");
  textcolor(7);  cprintf("%lu\r\n", event.time);

  mouseShow();
}

/*  Background routine (display time of day)
 */

void idle(void)
{
  static time_t oldtime = 0L;
  time_t t; time(&t);					// get time of day

  // if update is not required return
  if (oldtime == t) return;

  // save current cursor coordinates to be able to restore them later
  int oldx = wherex();
  int oldy = wherey();

  // display time of day
  window(71, 1, 80, 2); textattr(MAKEATTR(1, 15));	// clock window
  char *date = ctime(&t); date[19] = '\0';		// extract time
  mouseHide(); cputs(date + 10); mouseShow();		// display time
  oldtime = t;

  // restore old window and cursor coordinates
  window(1,  6, 80, 23); textattr(MAKEATTR(0, 15)); gotoxy(oldx, oldy);
}

/*  Init screen and mouse
 */

void init(void)
{

  /*** init mouse ***/

  mouseReset();					// init mouse driver
  if (!mouseInstalled)
  {
    cputs("Error: can't find a mouse driver\r\n"); exit(-1);
  }

  /*** init screen ***/

  _setcursortype(_NOCURSOR);			// hide hardware cursor
  textmode(C80);				// change text mode to C80x25

  // create caption line, working area, status line
  win( 1,  1, 80,  1, MAKEATTR(1, 15));
  ccputs("Mouse & Key Event Inspector", 1);
  win( 1,  2, 80,  2, MAKEATTR(3, 0));
  ccputs("MOUKEY v1.0 - Event-driven mouse & keyboard interface for Borland C/C++", 1);
  win( 1, 25, 80, 25, MAKEATTR(1, 15));
  ccputs(" Click any mouse button on this line or press Esc to end", 1);
  win( 1,  3, 80, 24, MAKEATTR(0, 15));
  ccputs("Copyright (c) 1997 Tanescu A. Horatiu", 1);
  ccputs("Waiting for mouse or keyboard events...", 22);
  window(1,  6, 80, 23);
}

/*  Perform clean-up
 */

void done(void)
{
  // clear screen and restore hardware cursor
  win(1, 1, 80, 25, MAKEATTR(0, 7));
  cputs("Shutdown event occured.");
  _setcursortype(_NORMALCURSOR);
}

/*  Control-break handler
 */

int newctrlbreak(void)
{
  suspendMouseEvents();	    	// suspend the event-driven mouse interface
  done();                       // perform clean-up
  return (0);			// abort program
}

/*  Run program
 */

void run(void)
{
  TEvent event;

  initMouseEvents();	     // install the event-driven mouse interface
  ctrlbrk(newctrlbreak);     // set a new control-break handler
  while (1)
  {
    getMouseEvent(event);    // get a mouse event form the mouse event queue
    if (!(event.event)) getKeyEvent(event); // if no mouse event is
					    // available get a key event
    if (event.event)         // if we have an event
    {
      displayevent(event);   // display information about the current event
      if (event.event == EV_SHUTDOWN) break;	// break on shutdown event
    }
    else idle();	     // perform background routine
  };
  suspendMouseEvents();	    // uninstall the event-driven mouse interface
}

/*  Main
 */

int main(void)
{
  init();
  run();
  done();

  return (0);
}