org 100h            ; Second decoder - 58 bytes

decoder:
    mov si,028Ch    ; Offset of main program
    mov di,0100h
    mov cl,11       ; Initial insertion point
    xor bx,bx
decloop:
    lodsb           ; Load byte into AL, zero AH
    cbw
    sub al,'0'      ; If less than '0' (i.e. CR or LF), ignore
    jc decloop
    cmp al,'Z'-'0'  ; If it's a 'Z', then exit
    je decdone
    cmp al,10       ; If it was a letter, then subtract 7
    jb number
    sub al,7
number:
    shl ax,cl       ; Shift left to insertion point
    or bx,ax        ; OR into the bit buffer
    sub cl,5        ; Move insertion point right by 5 bits
    cmp cl,3        ; Loop unless a byte can be shifted out
    jg decloop

    add cl,8        ; Move insertion point left by a byte
    mov al,bh       ; AL = byte, shift a byte out of BX
    mov bh,bl
    xor bl,bl
    stosb           ; Store the byte in memory, then loop
    jmp short decloop

decdone:
    pop di          ; Restore the registers pushed at startup
    pop si
    pop cx
    pop bx
    mov ax,bx       ; AX is equal to BX, and SI is always 0100h
    jmp si          ; when a .COM program starts
decend:
