/*+
    Name:	hlgrafit.c
    Date:	07-Sep-1988
    Author:	Kent J. Quirk
		(c) Copyright 1988 Ziff Communications Co.
    Abstract:	Contains routines to draw certain graphics displays.
    History:	09-Sep-88   kjq     Version 1.00
-*/    
#include <stdio.h>
#include <stdlib.h>
#include <graph.h>
#include <conio.h>
#include <string.h>
#include "hl.h"
#include "hltimes.h"

#define MAXROWS 10
#define MAXCOLS 10

int nrows = 3;
int ncols = 3;
long vmax = -1;

int graphdata[MAXROWS][MAXCOLS] = { 0 };

extern int *colorlist;
int base_color = 0;
struct videoconfig config;

int check_vga_mono(), plotstr();

/**** f a t _ r e c t a n g l e ****
    Abstract:	Draws a rectangle with a drop shadow
    Parameters: short x1, y1, x2, y2 -- the corners of the rectangle
		short depth - the depth of the shadow (in pixels)
		int shadow, front -- the color of the shadow and front
		    (which is modified by base_color for visual interest)
    Returns:	nothing
****************************/
void fat_rectangle(x1, y1, x2, y2, depth, shadow, front)
short x1, y1, x2, y2, depth;
int shadow, front;
{
    int i;

    _setcolor(colorlist[(base_color+shadow) % 16]);
    for (i=depth; i>0; i--)
	_rectangle(_GBORDER, x1+i, y1-i, x2+i, y2-i);
    _setcolor(colorlist[(base_color+front) % 16]);
    _rectangle(_GFILLINTERIOR, x1, y1, x2, y2);
    _setcolor(0);	    /* draw detail for corners */
    if (check_vga_mono())
    {
	_moveto(x2+depth+1, y2-depth);
	_lineto(x2, y2);
	_lineto(x2, y1);
	_moveto(x1, y2);
	_lineto(x2, y2);
    }
    else
    {
	_moveto(x2+depth+1, y2-depth);
	_lineto(x2+1, y2);
    }

    if ((y2 - y1) == 0)
    {
	_setcolor(colorlist[0]);
	_moveto(x1, y1);
	_lineto(x2+depth, y2-depth);
	_moveto(x1+depth, y2-depth);
	_lineto(x2, y2);
    }
}

#define ROWSIZE (config.numypixels/config.numtextrows)
#define COLSIZE (config.numxpixels/config.numtextcols)

/**** b a r _ g r a p h ****
    Abstract:	Given the global graphdata[], this draws a bar graph
		with that data.
    Parameters: int x, y -- the position of the lower left corner
		int max_x, max_y -- the position of the upper right corner
    Returns:	Nothing
****************************/
void bar_graph(x, y, max_x, max_y)
int x, y, max_x, max_y;
{
    int barwidth;
    int yscale;
    int i, j;
    long t;
    int xl, hgt;
    int max_hgt;
    long tsave = -1;
    int depth;
    char buf[20];

    buf[1] = 0;
    _setlogorg(x, y);

    barwidth = max_x / (ncols * (nrows+1) - 1);
    depth = barwidth / 4;

    for (i=0; i<ncols; i++)
    {
	for (j=0; j<nrows; j++)
	{
	    xl = (i * (nrows+1) + j) * barwidth;
	    t = (long)graphdata[j][i] * (long)max_y;
	    hgt = (int)(t / vmax);
	    if (tsave < (long)graphdata[j][i])
	    {
		max_hgt = hgt;
		tsave = (long)graphdata[j][i];
	    }
	    fat_rectangle(xl+1, 0, xl + barwidth, hgt, depth, j, j+8);
	    if (j == 1)
	    {
		itoa(i+1, buf, 10);
		plotstr(buf, xl, 1, 0xFF, _GOR);
	    }
	}
    }
    
    _setcolor(0xFF);
    _moveto(0, max_y);
    _lineto(0, 0);
    _moveto(-COLSIZE, 0);
    _lineto(max_x, 0);
    plotstr("0", -COLSIZE*2, -ROWSIZE, 0xFF, _GOR);
    plotstr(time_secs(tsave), -COLSIZE*7, max_hgt-ROWSIZE, 0xFF, _GOR);
    _moveto(0, max_hgt);
    _lineto(-COLSIZE, max_hgt);
    if (++base_color >= 16)
	base_color = 0;
}

/**** d r a w _ t i m e s ****
    Abstract:	Given pointers to two arrays of time data, this 
		draws a comparison graph.
****************************/
draw_times(data1, data2, text, npts, f1, f2)
long *data1, *data2;
int npts;
char text[][80];
char *f1, *f2;
{
    int xl, xr, yt, yb;
    int i,j;
    char buf[80];

    if (!init_video((struct videoconfig far *)&config))
    {
	printf("Couldn't set any graphics mode!\n");
	exit(1);
    }
    _setcolor(colorlist[0]);
    _clearscreen(_GCLEARSCREEN);

    for (i=0; i<npts; i++)
    {
	graphdata[0][i] = max((int)data1[i], 0);
	graphdata[1][i] = max((int)data2[i], 0);

	if ((long)graphdata[0][i] > vmax)
	    vmax = (long)graphdata[0][i];

	if ((long)graphdata[1][i] > vmax)
	    vmax = (long)graphdata[1][i];
    }
    nrows = 2;
    ncols = npts;
    vmax =  6L * vmax / 5L;
    base_color = 2;

    /* We need eight columns on the left for numbers, one line at the top,
    and six lines at the bottom for text, and one for labels */
    xl = COLSIZE * 8;
    xr = config.numxpixels - COLSIZE;	/* just to leave a little room */
    yt = ROWSIZE;
    yb = config.numypixels - ROWSIZE * 7;
    bar_graph(xl, yb, xr-xl, yt-yb);
    _settextposition(1,1);
    _settextcolor(colorlist[2+8]);
    _outtext(f1);
    _settextposition(1,16);
    _settextcolor(colorlist[3+8]);
    _outtext(f2);
    
    if (config.numtextcols >= 60)
    {
	_settextposition(1,47);
	_settextcolor(0xFF);
	_outtext("PC Tech Journal System Benchmarks");
	_settextposition(config.numtextrows,70);
	_settextcolor(0xFF);
	_outtext("Press ESC");
    }

    for (i=0; i<npts; i++)
    {
	_settextposition(config.numtextrows-ncols+i+1, 1);
	_settextcolor(0xFF);
	strcpy(buf, text[i]);
	_outtext(strtok(buf, "~"));
	if (config.numtextcols >= 60)
	{
	    _settextcolor(colorlist[2+8]);
	    _outtext(strtok(NULL, "~"));
	    _settextcolor(colorlist[3+8]);
	    _outtext(strtok(NULL, "~"));
	    _settextcolor(0xFF);
	    _outtext(strtok(NULL, ""));     /* return rest */
	}
    }

    getch();
    _setvideomode(_DEFAULTMODE);

    return(0);
}
