      SUBROUTINE CENTER (INPUT, OUTPUT, N)
C ............................................................
C        Center a Smaller String within A Larger String
C SOURCE OR AUTHOR:  Thomas Wm. Madron. 
C PURPOSE:  To center 'INPUT' string in 'OUTPUT' string of 'N'
C      characters. 
C USAGE:
C      CALL CENTER (INPUT, OUTPUT, N)
C DESCRIPTION OF PARAMETERS:
C      INPUT - Input   character   variable   of   length   80
C              containing  string  to be centered.  The actual
C              text of the string must be  terminated  with  a
C              backslash (\). 
C      OUTPUT- Output string of length 80 printed or otherwise
C              used by the calling program returned with INPUT
C              centered on a line length of N characters.
C      N     - Total length < 80  in  which  INPUT  is  to  be
C              centered. 
C REMARKS:  None. 
C SUBPROGRAMS REQUIRED:
C      INSTR
C      MOVE
C METHOD:  Not applicable. 
C ............................................................
      CHARACTER INPUT*80, BLANK*80, BLK(80), OUTPUT*80
      EQUIVALENCE (BLANK, BLK(1))
      DATA BLK/80*' '/
      OUTPUT = BLANK
      II = INSTR(INPUT, '\', 1) - 1
      JJ = (N-II)/2
      CALL MOVE (INPUT, 1, OUTPUT, JJ+1, II)
      RETURN
      END
      SUBROUTINE CLS
C ............................................................
C                         Clear Screen
C SOURCE OR AUTHOR:  Thomas Wm. Madron. 
C PURPOSE:  To clear the MS-DOS display screen. 
C USAGE:
C      CALL CLS
C DESCRIPTION OF PARAMETERS:  None. 
C REMARKS:  On IBM  PC  systems,  or  close  compatibles,  the
C      ANSI.SYS device driver must be installed.  For machines
C      like  the TIPC ANSI screen handling is always in place.
C SUBPROGRAMS REQUIRED:  None. 
C METHOD:   See  the  section  in  your  MS-DOS/PC-DOS  manual
C      describing  the  ANSI  escape  sequences and how to use
C      them. 
C ............................................................
      WRITE (*,10)
10    FORMAT (' [2J'\)
      RETURN
      END
      SUBROUTINE CORR (N, NV, R, FMEAN, STD, T, FMT,
     * INPDEV, IDISK1, IOUT, ND)
C ............................................................
C             Pearson Product Moment Correlations
C SOURCE OR AUTHOR:  Thomas Wm. Madron.  Such subroutines  are
C      easily available in a wide variety of textbooks.
C PURPOSE:    Computes  means,  standard  deviations,  and   a
C      correlation  matrix from raw data from either a file or
C      keyboard.  If the data are from keyboard, they  may  be
C      optionally saved to a file for subsequent use.
C USAGE:
C      CALL CORR (N, NV, R, FMEAN, STD, T, FMT, INPDEV,
C     *  IDISK1, IOUT, ND)
C DESCRIPTION OF PARAMETERS:
C      N     - Number   of    Observations    calcualted    by
C              subroutine.
C      NV    - Number of Variables.
C      R     - Output correlation matrix.
C      FMEAN - Output vector of means.
C      STD   - Output vector of standard deviations.
C      FMT   - Character variable containing  variable  format
C              statement.
C      INPDEV- Data input device (>-2-Disk; 1-Keyboard).
C      IDISK1- Data input Logical Unit Number.
C      IOUT  - Data Output Flag (0-No ouput;  2-Disk  output).
C      ND    - Number of Rows Dimensioned  for  R  in  calling
C              program. 
C REMARKS:  CORR cannot handle missing  data.    It  can  take
C      input from keyboard or disk, however. 
C SUBPROGRAMS REQUIRED:
C      KEYBD - Keyboard Input Routine.
C      LOCATE - Place  cursor  at  specified  screen  Row  and 
C               Column.
C METHOD:  Product Moment Correlations are computed. 
C ............................................................
      CHARACTER FMT*80
      REAL*4 R(ND,NV), FMEAN(NV), STD(NV), A, B, C
      N = 0
      IEND = 0
      DO 5 I = 1,NV
      FMEAN(I) = 0.0
      STD(I) = 0.0
      DO 5 J = 1,NV
      R(I,J) = 0.0
5     CONTINUE
      CALL HEADER
C     BEGIN DATA INPUT LOOP
10    GO TO (15, 20), INPDEV
C     INPUT FROM KEYBOARD
15         CALL KEYBD (STD, NV, N, IOUT, IEND)
           IF (IEND .EQ. 1) GO TO 50
           CALL WAIT (NCALL)
           GO TO 25
C     INPUT FROM DISK
20         READ (IDISK1,FMT,END=50) (STD(I),I=1,NV)
C          A  LITTLE  SPEED  IN  EXECUTION  CAN BE GAINED BY
C          ELIMINATING  THE  FOLLOWING  FIVE  LINES  AT  THE 
C          EXPENSE OF A LITTLE USER FRIENDLINESS.
           NX = N + 1
           NROW = 10
           NCOL = 28
           CALL LOCATE (NROW,NCOL)
           WRITE (*,'(''READING RECORD #'',I8)') NX
25    N = N + 1
      DO 40 I = 1,NV
           FMEAN(I) = FMEAN(I) + STD(I)
           DO 30 J = I,NV
                R(I,J) = R(I,J) + STD(I) * STD(J)
30         CONTINUE
40    CONTINUE
      GO TO 10
C     END OF DATA INPUT LOOP
50    T = N
C     CALCULATE THE CORRELATIONS
      DO 70 I = 1,NV
           DO 65 J = I,NV
                IF (I .EQ. J) GO TO 65
                A = T*R(I,J) - (FMEAN(I)*FMEAN(J))
                B = T*R(I,I) - FMEAN(I)**2
                C = T*R(J,J) - FMEAN(J)**2
                IF (B * C .EQ. 0.0) GO TO 65
                R(I,J) = A / SQRT(B * C)
65         CONTINUE
70    CONTINUE
C     DO MEANS AND STANDARD DEVIATIONS
      DO 80 I = 1,NV
           FMEAN(I) = FMEAN(I) / T
           STD(I) = SQRT(R(I,I) / T - FMEAN(I)**2)
80    CONTINUE
C ............................................................
C For consistency with a correlation program that accounts for
C missing  data,  "N"  (sample  size) is placed  in  both  the
C diagonal  of  the  Correlation Matrix and  fills  the  lower
C diagonal  matrix  as well.   If you modify this  program  to
C allow  for  missing  data,  you  will  need  the  number  of
C observations with all data present for each variable and the
C number  of observations with all data present for each  pair
C of  variables.   Programs that calculate significance  tests
C usually  need  an  estimate of the number  of  observations.
C Subsequent  programs use the LOWEST number  of  observations
C taken  from  the  lower diagonal matrix  as  a  conservative
C estimate since any significance tests based on a data matrix
C with missing data are suspect.
C ............................................................
      DO 100 I = 1,NV
           DO 90 J = I,NV
                R(J,I) = T
90         CONTINUE
100   CONTINUE
      RETURN
      END
      SUBROUTINE FILES (TITLE, IO, FILENM, STA)
C ............................................................
C                       Open Disk FILES
C SOURCE OR AUTHOR:  Thomas Wm. Madron. 
C PURPOSE:  To request filespecs from the  operator  and  open
C      appropriate  files.   The filespecs are returned to the
C      calling program for other uses. 
C USAGE:
C      CALL FILES (TITLE, IO, FILENM, STA)
C DESCRIPTION OF PARAMETERS:
C      TITLE - 28 Character variable for prompt  to  operator.
C      IO    - FORTRAN logical unit number (LUN) to be opened.
C              Passed to FILES from the calling program. 
C      FILENM- Character*14 variable containing filespecs. 
C      STA   - STAtus for file ('NEW' or 'OLD'). 
C REMARKS:  None.
C SUBPROGRAMS REQUIRED:  None.
C METHOD:  Not applicable.
C ............................................................
      CHARACTER TITLE*28, FILENM*14, STA*3
      IOD = 1
      WRITE (*,'(1H ,A)') TITLE
C IF INPUT IS FROM DISK, THEN:
      WRITE (*,
     * '(1H ,''Please Enter Filespecs <d:filename.ext>: ''\)')
      READ (*,'(A)') FILENM
      IF (STA .EQ. 'NEW') THEN
           OPEN (IO, FILE=FILENM, STATUS='NEW',
     *          ACCESS='SEQUENTIAL')
      ELSEIF (STA .EQ. 'OLD') THEN
           OPEN (IO, FILE=FILENM, STATUS='OLD',
     *          ACCESS='SEQUENTIAL')
      ENDIF
      RETURN
      END
      SUBROUTINE HEADER
C ............................................................
C             Print a HEADER on the Video Display
C SOURCE OR AUTHOR:  Thomas Wm. Madron. 
C PURPOSE:  To print  a  HEADER  at  the  top  of  the  screen
C      consisting of three lines:
C      Line 1:  First title (TITLE1). 
C      Line 2:  Second title (TITLE2). 
C      Line 3:  Horizontal  divider  bar  entered   as   ASCII
C               character  205.    This  can  be  changed,  of
C               course,   to  anything  else.    One  possible
C               alternative might be an equals ('=') sign. 
C REMARKS:  A named  COMMON  statement  (/HEAD/)  is  used  to
C      transmit  the two title lines to HEADER.FOR.  COMMON is
C      used, rather than a parameter list, so that the  titles
C      can be initialized once in the main program, and not in
C      every   subprogram   that   might   call  HEADER,  thus
C      conserving memory and programming effort. 
C SUBPROGRAMS REQUIRED:
C      CLS
C      CENTER
C      LOCATE
C METHOD:  Not applicable. 
C ............................................................
C     SPECIFICATIONS:
      CHARACTER*80 TITLE1, TITLE2, OUTPUT
      COMMON /HEAD/ TITLE1, TITLE2
C     Clear the Screen:
      LL = 80
      CALL CLS
C     Center and Print Program Name
      CALL CENTER (TITLE1, OUTPUT, LL)
      IROW=1
      ICOL=1
      CALL LOCATE (IROW, ICOL)
      WRITE (*,'(A78)') OUTPUT
C     Center and Print Author Name
      CALL CENTER (TITLE2, OUTPUT, LL)
      IROW=2
      ICOL=1
      CALL LOCATE (IROW, ICOL)
      WRITE (*,'(A78)') OUTPUT
C     Print a Horizontal Bar (ASCII CODE 205)
C     NOTE:  The Ms in FORMAT statement 10,  below,  is  the
C            character representation of the horizontal rule
C            --the ASCII character 205.   With  some editors
C            the  characters beyond decimal 127 can be added
C            by pressing the <ALT> key and at  the same time
C            entering  the  decimal equivalent of the letter
C            on the numeric keypad.   A possible alternative
C            character might be an equals (=) sign.
      WRITE (*,10)
10    FORMAT ('',
     1        '')
      RETURN
      END
      FUNCTION ICLS(IOUT)
C ............................................................
C                    Top of Forms Function
C SOURCE OR AUTHOR:  Thomas Wm. Madron.
C PURPOSE:  To send an output device a  top-of-forms  command.
C USAGE:
C      II = ICLS(IOUT)
C DESCRIPTION OF PARAMETERS:
C      IOUT  - Output device: 1=video; 2=printer; >=3 =  disk.
C REMARKS:  None. 
C SUBPROGRAMS REQUIRED:
C      HEADER
C METHOD:  Not applicable.
C ............................................................
      ICRT = 5
      IPRT = 6
      IF (IOUT .EQ. IPRT) THEN
C          SEND TOP OF PAGE TO PRINTER
10         WRITE (IOUT,'(1H1)')
      ELSEIF (IOUT .EQ. IPRT) THEN
C          CLEAR VIDEO DISPLAY
30         CALL HEADER
      ELSE
C          SEND ONE BLANK LINE TO DISK FILE
50         WRITE (IOUT,60)
60         FORMAT (' ')
      ENDIF
      ICLS = IOUT
      RETURN
      END
      SUBROUTINE INPMNU (TITLE,IQ)
C ............................................................
C                       Data Input Menu
C SOURCE OR AUTHOR:  Thomas Wm. Madron. 
C PURPOSE:    To  allow  a  selection  for  raw  data   input,
C      initialize IQ, for return to the calling program. 
C USAGE:
C      CALL INPMNU (TITLE, IQ)
C DESCRIPTION OF PARAMETERS:
C      TITLE - Character*64  variable  passed   from   calling
C              program. 
C      IQ    - Pointer for input data type:
C              1 - from keyboard;
C              2 - from disk;
C              3 - return to DOS. 
C REMARKS:  None. 
C SUBPROGRAMS REQUIRED:
C      HEADER
C METHOD:  Not applicable. 
C ............................................................
      CHARACTER TITLE*64
1     CALL HEADER
      WRITE (*,'('' '',A)') TITLE
      WRITE (*,10)
10    FORMAT (' ARE THE DATA FROM:'//
     1 '      (1) KEYBOARD, OR'/
     2 '      (2) DISK, OR'/
     3 '      (3) RETURN TO DOS?'//
     4 ' WHICH DATA INPUT DEVICE? '\)
      READ (*,'(I5)') IQ
      IF (IQ .LT. 1 .OR. IQ .GT. 3) GO TO 1
      RETURN
      END
      FUNCTION INSTR (STRING, VALUE, LENVAL)
C ............................................................
C                    String Search Function
C SOURCE OR AUTHOR:  Thomas Wm. Madron. 
C PURPOSE:  To find  the  location  of  substring  'VALUE'  in
C      'STRING'. 
C USAGE:
C      II = INSTR(STRING, VALUE, LENVAL)
C DESCRIPTION OF PARAMETERS:
C      STRING- Character*80  variable  is  the  string  to  be
C              searched. 
C      VALUE - Character*80 variable is the source string. 
C      LENVAL- The length of VALUE. 
C REMARKS:  This is an attempt to provide in FORTRAN  some  of
C      the functionality of the INSTR$ function in BASIC. 
C SUBPROGRAMS REQUIRED:  None. 
C METHOD:  Not applicable. 
C ............................................................
      CHARACTER STRING*80, VALUE*80, ST*80, VL*80, STR, VALX
      DIMENSION STR(80), VALX(80)
      EQUIVALENCE (ST,STR(1)), (VL,VALX(1))
      ST = STRING
      VL = VALUE
      DO 100 I = 1,80
           IX = 0
           J = I
           DO 50 K = 1,LENVAL
                IF (STR(J) .NE. VALX(K)) THEN
                     GO TO 100
                ELSE
                     IX = IX + 1
                     J =  J + 1
                ENDIF
50         CONTINUE
           IF (IX .EQ. LENVAL) THEN
                K = I
                GO TO 150
           ENDIF
100   CONTINUE
      INSTR = 0
      RETURN
150   INSTR = K
      RETURN
      END
      SUBROUTINE KEYBD (X, NV, NOBS, IOUT, IEND)
C ............................................................
C                   Data Input from Console
C SOURCE OR AUTHOR:  Thomas Wm. Madron. 
C PURPOSE:  To provide raw data input from the keyboard. 
C USAGE:
C      CALL KEYBD (X, NV, NOBS, IOUT, IEND)
C DESCRIPTION OF PARAMETERS:
C      X(i)  - Input data  array  or  record  buffer.    Input
C              fields are placed in X(i). 
C      NV    - Number  of  variables   passed   from   calling
C              program. 
C      NOBS  - Number of observations accumulated  in  calling
C              program and passed to KEYBD. 
C      IOUT  - Flag  for  saving  data  to  disk  passed  from
C              calling program.  Save if IOUT=2. 
C      IEND  - Flag for  end-of-data  passed  to  the  calling
C              program to terminate data input. 
C REMARKS:  This is a relatively slow and unsophisticated data
C      entry routine  for  quick  and  dirty  entry  of  small
C      datasets.   Large datasets should be entered with other
C      software. 
C SUBPROGRAMS REQUIRED:
C      CLS SUBS
C METHOD:  Not applicable. 
C ............................................................
      CHARACTER ID*8
      CHARACTER DAT, DAT2*10, EN1, EN2, DOT, BLK, REC, REC2*8
      DIMENSION X(NV), REC(8), DAT(10)
      COMMON /FILEX/ IDISK1,IDISK2,IDISK3,IDISK4
      EQUIVALENCE (DAT(1),DAT2), (REC(1),REC2)
      DATA EN1/'E'/,EN2/'e'/,DOT/'.'/,BLK/' '/
      IEND = 0
      IOD = 1
      CALL CLS
      N = NOBS + 1
      WRITE (*,5)
5     FORMAT ('BEGIN ENTERING YOUR DATA -')
      DO 50 I = 1,NV
           DO 6 J = 1,10
                DAT(J) = BLK
6          CONTINUE
           WRITE (*,20) N, I
           READ (*,35) DAT
           DO 8 J = 1,10
                IF (DAT(J) .NE. EN1 .AND. DAT(J) .NE. EN2)
     *               GO TO 8
                IEND = 1
                GO TO 60
8          CONTINUE
           DO 9 J = 1,10
                IF (DAT(J) .EQ. DOT) GO TO 40
9          CONTINUE
           DO 11 J = 1,10
                IF (DAT(J) .NE. BLK) GO TO 11
                DAT(J) = DOT
                GO TO 40
11         CONTINUE
40         READ (DAT2,30) X(I)
50    CONTINUE
      WRITE (REC2,70) N
      READ (REC2,80) ID
      IF (IOUT .EQ. 2) CALL SUBS (X, NV, IDISK2, ID)
60    RETURN    
C     FORMAT STATEMENTS
20    FORMAT (' OBSERVATION',I6,' VARIABLE',I4,': '\)
30    FORMAT (F10.0)
35    FORMAT (10A1)
70    FORMAT (I5,'  1')
80    FORMAT (A8)
      END
      SUBROUTINE LOCATE (IROW, ICOL)
C ............................................................
C               Locate the Cursor on the Screen
C SOURCE OR AUTHOR:  Thomas Wm. Madron. 
C PURPOSE:  To locate the cursor at IROW and ICOL. 
C USAGE:
C      CALL LOCATE (IROW, ICOL)
C DESCRIPTION OF PARAMETERS:
C      IROW  - Row to which cursor is to be moved passed  from
C              calling program. 
C      ICOL  - Column to which cursor is to  be  moved  passed
C              from calling program. 
C REMARKS:  Using ANSI screen control, this is  an  effort  to
C      implement  in  FORTRAN  a function similar to LOCATE in
C      MS-BASIC.  It requires that the ANSI.SYS device  driver
C      be installed on IBM PC type machines. 
C SUBPROGRAMS REQUIRED:  None. 
C METHOD:  Uses ANSI screen control. 
C ............................................................
      CHARACTER AROW*2, ACOL*2, AFILE*2, BUF(2)*1, Z*1, B*1
      EQUIVALENCE (BUF(1), AFILE)
      Z='0'
      B=' '
      WRITE (AFILE,'(I2)') IROW
      IF (BUF(1) .EQ. B) BUF(1)=Z
      AROW=AFILE
      WRITE (AFILE,'(I2)') ICOL
      IF (BUF(1) .EQ. B) BUF(1)=Z
      ACOL=AFILE
      WRITE (*,10) AROW, ACOL
10    FORMAT (' [',A,';',A,'H'\)
      RETURN
      END
      SUBROUTINE MOVE (FROM,LOC1,TO,LOC2,LENGTH)
C ............................................................
C                          Move Data
C SOURCE OR AUTHOR:  Thomas Wm. Madron. 
C PURPOSE:  To provide a means for moving a block of data from
C      one string to another. 
C USAGE:
C      CALL MOVE (FROM, LOC1, TO, LOC2, LENGTH)
C DESCRIPTION OF PARAMETERS:
C      FROM  - Source string to be moved, <= 80 characters. 
C      LOC1  - Starting location  in  FROM  for  block  to  be
C              moved. 
C      TO    - Destination  string  for  FROM  data,   <=   80
C              characters  but  >=  the  amount  of data to be
C              moved. 
C      LOC2  - Starting location of the destination in TO. 
C      LENGTH- Length of the block to be  moved,  passed  from
C              the calling program. 
C REMARKS:  None. 
C SUBPROGRAMS REQUIRED:  None. 
C METHOD:  Not applicable. 
C ............................................................
      CHARACTER FROM*80, TO*80, F2*80, T2*80, FROMX, TOX
      DIMENSION FROMX(80), TOX(80)
      EQUIVALENCE (F2,FROMX),(T2,TOX)
      F2 = FROM
      T2 = TO
      LOCA = LOC1 + LENGTH - 1
      LOCB = LOC2 - 1
      DO 100 I = LOC1,LOCA
           LOCB = LOCB + 1
           TOX(LOCB) = FROMX(I)
100   CONTINUE
      FROM = F2
      TO = T2
      RETURN
      END
      SUBROUTINE OUTMNU (IOD, IDISK3, TITLE3)
C ............................................................
C                   Output Destination Menu
C SOURCE OR AUTHOR:  Thomas Wm. Madron. 
C PURPOSE:  To allow the user to specify the output device for
C      the normal 'printed' output:  video, printer, or  disk.
C USAGE:
C      CALL OUTMNU (IOD, IDISK3, TITLE3)
C DESCRIPTION OF PARAMETERS:
C      IOD   - Destination logical unit number  returned  from
C              subroutine. 
C      IDISK3- Logical unit number for disk output if disk  is
C              destination  for  output.  If this is opted, IO
C              is set equal to IDISK3. 
C      TITLE3- Title for filespec for disk output,  passed  to
C              subroutine FILES.
C REMARKS:  None.
C SUBPROGRAMS REQUIRED:
C      HEADER
C      WAIT
C      FILES
C METHOD:  Not applicable.
C ............................................................
      CHARACTER FILENM*14, TITLE3*28
      INTEGER*2 DRIVE
      ICRT = 5
      IPRT = 6
      NCALL = 0
5     CALL HEADER
      WRITE (*,10)
10    FORMAT (' DESTINATION OF OUTPUT:'//
     1 '      (1) VIDEO DISPLAY'/
     2 '      (2) PRINTER'/
     3 '      (3) DISK FILE'//
     4 ' WHICH OUTPUT DEVICE (ENTER APPROPRIATE NUMBER)? '\)
      READ (*,'(I5)') IOD
      GO TO (50, 30, 40), IOD
      IF (IOD .LT. 1 .OR. IOD .GT. 3) GO TO 5
C     OUTPUT TO PRINTER
30    CALL HEADER
      IROW = 4
      ICOL = (80-25)/2
           CALL LOCATE (IROW, ICOL)
      WRITE (*,'(''* * * READY PRINTER * * *'')')
      CALL WAIT (NCALL)
      OPEN (IPRT, FILE='LPT1')
      IOD = IPRT
      RETURN
C     OUTPUT TO DISK FILE
40    CALL FILES (TITLE3,IDISK3,FILENM,'NEW')
      IOD = IDISK3
      RETURN
C     OUTPUT TO VIDEO DISPLAY
50    OPEN (ICRT, FILE='CON')
      IOD = ICRT
      RETURN
      END
      SUBROUTINE PCDS (X, N, M, FH, IO, IDIAG, ND)
C ............................................................
C                     Save Arrays to Disk
C SOURCE OR AUTHOR:  Modified from Donald J. Veldman,  FORTRAN
C      PROGRAMMING  FOR  THE  BEHAVIORAL  SCIENCES  (New York:
C      Holt, Rinehart and Winston, 1967),  pp.  135-37.    The
C      original was written for FORTRAN IV and was designed to
C      punch cards, hence the name 'PCDS' (Punch CarDS). 
C PURPOSE:  To  save  records  from  an  array  in  12-element
C      blocks.    A matrix is recorded by rows, beginning each
C      row with a new physical record. 
C USAGE:
C      CALL PCDS (X, N, M, FH, IO, IDIAG, ND)
C DESCRIPTION OF PARAMETERS:
C      X     = NAME OF ARRAY TO BE OUTPUT. 
C      N     = NUMBER OF ROWS IF X IS MATRIX, OR ELEMENTS IF A
C              VECTOR.
C      M     = NUMBER OF COLUMNS IF X IS MATRIX.  SET = 1  FOR
C              A VECTOR. 
C      FH    = OUTPUT LABEL.  HOLLERITH BLOCK  (MAX  =  4)  IN
C              CALL STATEMENT.
C      IO    = OUTPUT LOGICAL UNIT NUMBER. 
C      ND    = NUMBER OF ROWS DIMENSIONED  FOR  X  IN  CALLING
C              PROGRAM. 
C REMARKS:  None.
C SUBPROGRAMS REQUIRED:  None.
C METHOD:  Not applicable.
C ............................................................
      CHARACTER FH*4
      DIMENSION X(ND, M)
      L = 1
      IF (M .EQ. 1) THEN
           DO 10 I = 1,N,12
                J = MIN0(I + 11, N)
                WRITE (IO,5) FH, M, L, (X(K,1), K = I,J)
5               FORMAT (A4,I2,I2,12F10.4)
                L = L + 1
10         CONTINUE
      ELSE
           DO 30 I = 1,N
                LL = 1
                DO 20 J = 1,M,12
                     K = MIN0(J + 11, M)
                     WRITE (IO,5) FH, I, LL, (X(I,L), L = J,K)
                     LL = LL + 1
20              CONTINUE
30         CONTINUE
      ENDIF
      RETURN
      END
      SUBROUTINE PRTS (X,N,M,NVAR,KH,ND,NSET,IDIAG)
C ............................................................
C                        Print a Matrix
C SOURCE OR AUTHOR:  Modified from Donald J. Veldman,  FORTRAN
C      PROGRAMMING  FOR  THE  BEHAVIORAL  SCIENCES  (New York:
C      Holt, Rinehart and Winston, 1967),  pp.  135-37.    The
C      original was written in FORTRAN IV.  PURPOSE:  To print
C      a matrix or vector in 10-column partitions. 
C USAGE:
C      CALL PRTS (X,N,M,NVAR,KH,ND,NSET,IDIAG)
C DESCRIPTION OF PARAMETERS:
C      X(i)  - Array to be output. 
C      N     - Number of rows  (or  elements)  of  X()  to  be
C              printed. 
C      M     - Number of columns of X() to be printed (set = 1
C              if X() is a vector). 
C      NVAR  - Vector of variable numbers. 
C      KH    - Character*8 variable passed as a  constant  for
C              output heading. 
C      ND    - Number of rows (or  elements)  dimensioned  for
C              X() in the calling program. 
C      NSET  - Output Logical Unit Number. 
C      IDIAG - Flag for diagonal matrix (0=no; 1=yes). 
C REMARKS:  None. 
C SUBPROGRAMS REQUIRED:  None. 
C METHOD:  Not applicable. 
C ............................................................
      CHARACTER KH*8
      INTEGER*2 NVAR(1), I, J
      REAL*4 X(ND,1)
C     WRITE A VECTOR
      IF (M .EQ. 1) THEN
      WRITE (NSET,15)
      DO 10 I = 1,N,10
           J = MIN0(I + 9,N)
           WRITE (NSET,5) KH, (NVAR(K), K = I,J)
           WRITE (NSET,15) (X(K,1), K = I,J)
10    CONTINUE
C     WRITE A DIAGONAL MATRIX
      ELSEIF (IDIAG .GT. 0) THEN
      WRITE (NSET,15)
      DO 110 I = 1,N,10
           J = MIN0(I + 9,N)
           WRITE (NSET,5) KH, (NVAR(K), K = I,J)
           WRITE (NSET,15) (X(K,K), K = I,J)
110   CONTINUE
C     WRITE AN N X M MATRIX
      ELSEIF (M .GT. 1) THEN
      DO 25 K = 1,M,10
           WRITE (NSET,15)
           L = MIN0(K + 9,M)
           WRITE (NSET,5) KH, (NVAR(J),J = K,L)
           DO 20 I = 1,N
                WRITE (NSET,30) NVAR(I), (X(I,J), J = K,L)
20         CONTINUE
25    CONTINUE
      ENDIF
      WRITE (NSET,'(/'' '')')
      RETURN
C     FORMAT STATEMENTS
   5  FORMAT (1H ,A8,10I11)
  15  FORMAT (1H , 10X, 10F11.4)
  30  FORMAT (1H , I6, 4X, 10F11.4)
      END
      SUBROUTINE SUBS (X, N, IO, ID)
C ............................................................
C                 Write an Output Data Record
C SOURCE OR AUTHOR:  Modified from Donald J. Veldman,  FORTRAN
C      PROGRAMMING  FOR  THE  BEHAVIORAL  SCIENCES  (New York:
C      Holt, Rinehart and Winston, 1967),  pp.  135-37.    The
C      original was written for FORTRAN IV and was designed to
C      punch cards. 
C PURPOSE:  To 'punch' one  subject's  score  vector  in  real
C      mode. 
C USAGE:
C      CALL SUBS (X, N, IO, ID)
C DESCRIPTION OF PARAMETERS:
C      X(i)  - Array containing output data. 
C      N     - Number of scores to be punched. 
C      IO    - Output Logical Unit Number. 
C      ID    - Character subject identification (Max=8). 
C REMARKS:  None. 
C SUBPROGRAMS REQUIRED:  None. 
C METHOD:  Not applicable. 
C ............................................................
      CHARACTER ID*8
      REAL*4 X(1)
      M = IABS(N)
      L = 1
      DO 10 I = 1,M,7
           K = MIN0(I + 6, M)
           WRITE (IO,5) ID, L, (X(J), J = I,K)
           L = L + 1
10    CONTINUE
      RETURN
5     FORMAT (A8, I2, 7F10.4)
      END
      FUNCTION UPPER (CHARX)
C ............................................................
C               Lower to Upper Case Translation
C SOURCE OR AUTHOR:  Thomas Wm. Madron
C PURPOSE:  To convert an ASCII character from lower to  upper
C      case. 
C USAGE:
C      II = UPPER(CHARX)
C DESCRIPTION OF PARAMETERS:
C      CHARX - Character*1 variable  used  to  pass  character
C              from the calling program.
C REMARKS:  If the function is compiled with the main program,
C      then UPPER must be declared as CHARACTER*1 only in  the
C      calling program.  If the function is added to a program
C      library,  then the CHARACTER declaration must be within
C      the function.
C SUBPROGRAMS REQUIRED:  None.
C METHOD:  Not applicable.
C ............................................................
      INTEGER*2 IUPPER
C     CHARACTER CHARX
      CHARACTER CHARX, UPPER
      II = 0
      JJ = ICHAR(CHARX)
      IF (95 .LT. JJ) II = -1
      IUPPER = JJ + (32 * II)
      UPPER = CHAR(IUPPER)
      RETURN
      END
      SUBROUTINE VPRTS (TITLE,NVAR,X,NR,NC,FH,IDIAG,NCALL,ND)
C ............................................................
C                       Display a Matrix
C SOURCE OR AUTHOR:  Modified from Donald J. Veldman,  FORTRAN
C      PROGRAMMING  FOR  THE  BEHAVIORAL  SCIENCES  (New York:
C      Holt, Rinehart and Winston, 1967),  pp.  135-37.    The
C      original was written in FORTRAN IV.  
C PURPOSE:    To  print  a  matrix  or  vector  in  ten-column
C      partitions on an 80 column video display.  
C USAGE:
C      CALL VPRTS (TITLE,NVAR,X,NR,NC,FH,IDIAG,NCALL,ND)
C DESCRIPTION OF PARAMETERS:
C      TITLE - Character*64 variable containing  a  title  for
C              the matrix.  
C      NVAR  - Vector of variable labels.  
C      X()   - Matrix to be printed.
C      NR    - Number of rows in the matrix.  
C      NC    - Number of columns in the matrix (set = 1 if X()
C              is a vector).  
C      FH    - Character*4 variable containing a name for  the
C              matrix for output.  
C      IDIAG - Flag for  printing  a  diagonal  matrix  (0=no;
C              1=yes).  
C      NCALL - Counter for the number of times VPRTS is called
C              during an analysis.  Must be set  before  entry 
C              to the subroutine.
C      ND    - Number of rows dimensioned in X().  
C REMARKS:  None.  
C SUBPROGRAMS REQUIRED:  None.  
C METHOD:  Not applicable.  
C ............................................................
      CHARACTER TITLE*64, FH*4
      INTEGER*2 NVAR(NR), I, J, M, IA, JA
      REAL*4 X(ND,NC)
C     PRINT AN N X M MATRIX
      IF (NC .GT. 1) THEN
      DO 100 I=1,NR,10
      IA = I+9
      IF (IA-NR) 15,10,10
10    IA = NR
15         DO 75 J=1,NC,10
                JA = J+9
                IF (JA-NC) 25,20,20
20              JA = NC
25              CALL HEADER
                WRITE (*,'('' '',A)') TITLE
                WRITE (*,50) FH, (NVAR(M),M=J,JA)
                DO 70 L=I,IA
                     WRITE (*,65) NVAR(L),(X(L,M),M=J,JA)
70              CONTINUE
                CALL WAIT (NCALL)
                IF (NCALL .GE. 1) GO TO 15
75          CONTINUE
100   CONTINUE
C     RETURN
C     PRINT A VECTOR
      ELSEIF (NC .EQ. 1) THEN
110   CALL HEADER
      WRITE (*,'('' '',A)') TITLE
      DO 130 I=1,NR,10
           J = MIN0(I + 9, NR)
           WRITE (*,115) FH, (NVAR(K), K = I,J)
           WRITE (*,120) (X(K,1), K=I,J)
130   CONTINUE
      CALL WAIT (NCALL)
      IF (NCALL .GE. 1) GO TO 110
C     RETURN
C     PRINT A DIAGONAL MATRIX
      ELSEIF (IDIAG .GT. 0) THEN
210   CALL HEADER
      WRITE (*,'(A)') TITLE
      DO 230 I = 1,NR,10
           J = MIN0(I + 9, NR)
           WRITE (*,115) FH, (NVAR(K), K=I,J)
           WRITE (*,120) (X(K,K), K=I,J)
230   CONTINUE
      CALL WAIT (NCALL)
      IF (NCALL .GE. 1) GO TO 210
      ENDIF
      RETURN
C     FORMAT STATEMENTS
50    FORMAT (1H ,A4,10I7)
65    FORMAT (1H ,I4,10F7.3)
115   FORMAT (1H ,A4,10I7)
120   FORMAT (1H ,4X,10F7.3)
      END
      SUBROUTINE WAIT (NCALL)
C ............................................................
C                      Wait for Response
C SOURCE OR AUTHOR:  Thomas Wm. Madron.
C PURPOSE:  To pause for  operator  intervention  to  continue
C      execution of a program.
C USAGE: CALL WAIT (NCALL)
C DESCRIPTION OF PARAMETERS:
C      NCALL - Counter for the number of times VPRTS is called
C              to determine the help file to call.
C REMARKS:  If no help subroutines are used, a dummy help sub-
C      routine should accompany the main program.
C SUBPROGRAMS REQUIRED:
C      LOCATE (nrow, ncol)
C      INSTR (string, srchchar, len) [function]
C      UPPER (char) [function]
C      HELP (ncall)
C METHOD:  Uses ANSI screen control, see  your  MS-DOS  manual
C      for further information.
C ............................................................
      CHARACTER A, HELPX, UPPER, INPUT*80, OUTPUT*80
C     CHARACTER A, HELPX, INPUT*80, OUTPUT*80
      HELPX = 'H'
      IROW = 25
      LL = 80
      IF (NCALL .GT. 0) THEN
           INPUT =
     1       '<<Press {ENTER} to Continue or {H} for Help>>\'
           CALL CENTER (INPUT, OUTPUT, LL)
           ICOL = 1
           CALL LOCATE (IROW,ICOL)
           WRITE (*, '(A78\)') OUTPUT
           READ (*, '(A1)') A
           A = UPPER(A)
           IF (A .EQ. HELPX) THEN
                CALL HELP (NCALL)
           ELSE
                NCALL = 0
           ENDIF
      ELSE
           INPUT = '<<Press {ENTER} to Continue>>\'
           CALL CENTER (INPUT, OUTPUT, LL)
           ICOL = 1
           CALL LOCATE (IROW,ICOL)
           WRITE (*, '(A78\)') OUTPUT
           READ (*,'(A1)') A
      ENDIF
      RETURN
      END
      SUBROUTINE WTMAT (R, FMEAN, STD, NV, DTFILE, FMT,
     1 TITLE, IDISK4, IDIAG, N, LL, ND)
C ............................................................
C               Write a Standard Matrix to Disk
C SOURCE OR AUTHOR:  Thomas Wm. Madron.
C PURPOSE:  To save a standard matrix to disk.
C USAGE: CALL WTMAT (R, FMEAN, STD, NV, DTFILE, FMT, TITLE,
C     1 IDISK4, IDIAG, N, LL, ND)
C DESCRIPTION OF PARAMETERS:
C      R -       Doubly   Subscripted   array   containing   a
C                correlation or similar matrix.
C      FMEAN -   Singly  subscripted  array of means for  each
C                variable.
C      STD -     Singly   subscripted   array   of    standard
C                deviations for each variable.
C      NV -      Number of Variables.
C      DTFILE -  CHARACTER*14  character  variable  containing
C                the name of a raw data input file.
C      FMT -     CHARACTER*80  character variable containing a
C                standard format statement describing the  raw
C                data file.
C      TITLE -   CHARACTER*64  character variable containing a
C                title or label for the file.
C      IDISK4 -  Logical  Unit Number (LUN) for output  matrix
C                file.
C      IDIAG -   Flag  for  array type for use  of  Subroutine
C                SUBS.
C      N -       Number  of  observations represented  by  the
C                summary    statistics    (means,     standard
C                deviations, and correlations).
C      LL -      Line  Length for the  video  display--usually
C                80.
C      ND -      Number  of  row  dimensions  for  the  doubly
C                subscripted variable.
C REMARKS:
C      THE  STANDARD MATRIX FILE:   The standard matrix   file
C      is  an ASCII file with a well defined format,  produced
C      in  part  with  SUBROUTINE PCDS.   It consists  of  six
C      record types:
C      1.   Header Record containing the number  of  variables
C           and  title  (not  to exceed 64 characters) for the
C           matrix in the following format: (I5, A64)
C      2.   Record(s) containing a vector of  means,  one  for
C           each  variable.  The second field is a row number,
C           the third is a physical record number  within  the
C           logical  record,  followed  by  up  to 12 floating
C           point numbers per physical record.  For  a  vector
C           the   row  number  is  always  one  (1).    For  a
C           correlation matrix the number of rows  will  equal
C           the  number of variables in the matrix.  The first
C           four columns contain 'MEAN": (A4,I2,I2,12F10.4)
C      3.   Record(s)  containing   a   vector   of   standard
C           deviations  for  each  variable.    The  format is
C           identical to (2), above.
C      4.   Records containing a N  x  M  correlation  matrix,
C           including  the  correlation coefficients above the
C           diagonal, the  number  of  observations  for  each
C           variable on the diagonal, and the number of obser-
C           vations  present  for  each  pair  of variables on
C           which each corresponding  correlation  was  based.
C           The format is identical to (2), above.
C      5.   File  specifications  (d:filename.ext)   for   the
C           original  dataset  not  to  exceed  14 characters.
C           This is used if subsequent programs require access
C           to  the  original  data  for  residuals  or  other
C           predicted scores.  
C      6.   Format statement for the raw data as read by CORL.
C           This is also used if subsequent  programs  require
C           access to the original data.  
C SUBPROGRAMS REQUIRED:  
C      CENTER (INPUT, OUTPUT, N)
C      HEADER
C      LOCATE (IROW, ICOL)
C      PCDS (X, N, M, FH, IO, IDIAG, ND)
C          NOTE:  IDISK4 must be opened prior to entry.
C METHOD:   Not Applicable.   
C ............................................................
C     SPECIFICATION STATEMENTS
      CHARACTER DTFILE*14, FMT*80, TITLE*64, INPUT*80,
     1 OUTPUT*80
      REAL*4 R(ND,NV), FMEAN(NV), STD(NV)
      INTEGER*2 I, J
C     PREPARE TO WRITE THE STANDARD MATRIX
           CALL HEADER
           INPUT =
     1       '* * * Writing the Matrix, Please Wait * * *\'
           CALL CENTER (INPUT, OUTPUT, LL)
           NROW = 10
           NCOL = 1
           CALL LOCATE (NROW, NCOL)
           WRITE (*,'(A\)') OUTPUT
C     WRITE STANDARD MATRIX
           WRITE (IDISK4,'(I5,A)') NV, TITLE
           CALL PCDS (FMEAN,NV,1,'MEAN',IDISK4,IDIAG,ND)
           CALL PCDS (STD,NV,1,'STDV',IDISK4,IDIAG,ND)
           CALL PCDS (R,NV,NV,'CORL',IDISK4,IDIAG,ND)
           WRITE (IDISK4,'(A)') DTFILE
           WRITE (IDISK4,'(A)') FMT
           CLOSE (IDISK4, STATUS='KEEP')
      RETURN
      END
