(*********************************************)
(*                                           *)
(*        SIMPLE16.PAS      March 98         *)
(*                                           *)
(*    16-bit DPMI Protected Mode Version     *)
(*    Compile:  BPC /CP SIMPLE16             *)
(*                                           *)
(*  This program is donated to the Public    *)
(*  Domain by MarshallSoft Computing, Inc.   *)
(*  It is provided as an example of the use  *)
(*  of the Personal Communications Library.  *)
(*                                           *)
(*  Be sure to read BUGS.TXT                 *)
(*********************************************)


Program Simple16;
Uses Crt, WinAPI, pcl4p16, use_dpmi;

var
   BaudCode : Integer;
   RetCode  : Integer;
   Byte : Char;
   i    : Integer;
   Port : Integer;
   ResetFlag : Boolean;
   Handle    : LongInt;
   RxSelector  : Integer;
   TxSelector  : Integer;
   DPMIversion : LongInt;

procedure SayError( Code : Integer );
var
   RetCode : Integer;
begin
   if Code < 0 then RetCode := SioError( Code )
   else if (Code and (FramingError or ParityError or OverrunError)) <> 0 then
      begin (* Port Error *)
         if (Code and FramingError) <> 0 then WriteLn('Framing Error');
         if (Code and ParityError)  <> 0 then WriteLn('Parity Error');
         if (Code and OverrunError) <> 0 then WriteLn('Overrun Error')
      end
end;

procedure MyHalt( Code : Integer );
var
   RetCode : Integer;
begin
   if Code < 0 then SayError( Code );
   if ResetFlag then RetCode := SioDone(Port);
   WriteLn('*** HALTING ***');
   Halt;
end;

function MatchBaud(BaudString : String) : Integer;
const
   BaudRateArray : array[1..10] of LongInt =
       (0,300,1200,2400,4800,9600,19200,38400,57600,115200);
var
   i : Integer;
   BaudRate: LongInt;
   RetCode : Integer;
begin
  Val(BaudString,BaudRate,RetCode);
  if RetCode <> 0 then
  begin
    MatchBaud := -1;
    exit;
  end;
  for i := 1 to 10 do if BaudRateArray[i] = BaudRate then
  begin
    MatchBaud := i - 1;
    exit;
  end;
  (* no match *)
  MatchBaud := -1;
end;

function AllocDosBytes(Bytes:Integer) : LongInt;
var
   Result  : LongInt;
begin
   Result := GlobalDosAlloc(Bytes);
   if Result = 0 then
     begin
       WriteLn('Cannot allocate ',Bytes,' bytes');
       MyHalt(0)
     end;
   WriteLn('allocating ',Bytes,' bytes');
   AllocDosBytes := Result
end;

begin   (* main program *)  
   WriteLn('SIMPLE16    ');
   ResetFlag := FALSE;
   RxSelector := 0;
   TxSelector := 0;
   (* fetch PORT # from command line *)
   if ParamCount <> 2 then
      begin
         WriteLn('USAGE: "SIMPLE16 <port> <baud rate>" where port = 1 to 20');
         halt;
      end;
   Val( ParamStr(1),Port, RetCode );
   if RetCode <> 0 then
      begin
         WriteLn('Port must be 1 to 20');
         Halt;
      end;
   (* COM1 = 0, COM2 = 1, etc. *)
   Port := Port - 1;
   if (Port<COM1) or (Port>COM20) then
      begin
         WriteLn('Port must be 1 to 20');
         Halt
      end;
   (* get baud rate *)
   BaudCode := MatchBaud(ParamStr(2));
   (* check for pre-loaded DPMI *)
   if DPMI_Detect = 0 then
     begin
       WriteLn('DPMI not detected, using Borlands DPMI server!');
     end;
   DPMIversion := LOWORD( DPMI_GetVersion );
   WriteLn('DPMI version ', (DPMIversion SHR 8),'.',(255 and DPMIversion) );
   (* setup 1K receive buffer in DOS memory *)
   Handle := AllocDosBytes(1024);
   RxSelector :=  LOWORD(Handle);
   RetCode := SioRxBuf(Port, RxSelector, Size1024);
   if RetCode < 0 then MyHalt( RetCode );
   if SioInfo('I') > 0 then
     begin
       (* setup 128 transmit buffer in DOS memory *)
       Handle := AllocDosBytes(256);
       TxSelector := LOWORD(Handle);
       RetCode := SioTxBuf(Port, TxSelector, Size128);
       if RetCode < 0 then MyHalt( RetCode );
     end;
   (* reset port *)
   RetCode := SioReset(Port,BaudCode);
   (* if error then try one more time *)
   if RetCode <> 0 then RetCode := SioReset(Port,BaudCode);
   (* Was port reset ? *)
   if RetCode <> 0 then
     begin
        WriteLn('Cannot reset COM',Port+1);
        MyHalt( RetCode );
     end;
   (* Port successfully reset *)
   WriteLn;
   WriteLn('COM',1+Port,' @ ',ParamStr(2));
   ResetFlag := TRUE;
   (* specify parity, # stop bits, and word length for port *)
   RetCode := SioParms(Port, NoParity, OneStopBit, WordLength8);
   if RetCode < 0 then MyHalt( RetCode );
   (* set FIFO level if have 16550/16650/16750 *)
   RetCode := SioFIFO(Port, LEVEL_4TH);
   if RetCode < 0 then MyHalt(RetCode); 
   case RetCode of
       0: WriteLn('8250/16450 detected.'); 
       1: WriteLn('16550 detected.');
       2: WriteLn('16650 detected.');
       3: WriteLn('16750 detected.');
   end; 
   (* set DTR & RTS *)
   RetCode := SioDTR(Port,SET_LINE);
   RetCode := SioRTS(Port,SET_LINE);
   (* begin terminal loop *)
   WriteLn('Enter terminal loop ( Type ^Z to exit )');
   while TRUE do
      begin
         (* did user press Ctrl-BREAK ? *)
         if SioBrkKey then
            begin
               WriteLn('User typed Ctl-BREAK');
               RetCode := SioDone(Port);
               Halt;
            end;
         (* anything incoming over serial port ? *)
         RetCode := SioGetc(Port,0);
         if RetCode < -1 then MyHalt( RetCode );
         if RetCode > -1 then Write( chr(RetCode) );
         (* has user pressed keyboard ? *)
         if KeyPressed then
            begin
               (* read keyboard *)
               Byte := ReadKey;
               (* quit if user types ^Z *)
               if Byte = chr($1a) then
                  begin
                     WriteLn('User typed ^Z');
                     RetCode := SioDone(Port);
                     (* free DOS memory *)
                     if RxSelector <> 0 then RetCode := GlobalDosFree(RxSelector);
                     if TxSelector <> 0 then RetCode := GlobalDosFree(TxSelector);
                     Halt;
                  end;
               (* send out over serial line *)
               RetCode := SioPutc(Port, Byte );
               if RetCode < 0 then MyHalt( RetCode );
            end
      end
end.
                                                                                                        
