program lowname;
var
   param : integer;

   procedure syntax;
   begin
      writeln('lowname');
      writeln('SYNTAX: lowname file(s) ...');
      halt
   end;

   procedure ConvertFile(fname : filename);
   var
      f : text;
   begin
      writeln(fname, ' -> ', lowercase(fname));
      assign(f, fname);
      rename(f, lowercase(fname))
   end;

   procedure ConvertTextFiles(f : filename);
   var
      DirPart, NamePart, ExtPart : filename;
      fname : filename;
      d : Dir;

   begin (* ConvertTextFiles *)
      f := fexpand(f);
      writeln(f);
      fsplit(f, DirPart, NamePart, ExtPart);
      NamePart := NamePart + ExtPart;
      OpenDir(d, DirPart);
      repeat
         ReadDir(d, fname);
         if fname <> '' then    (* if there are more files in directory *)
            begin
               if FileMatch(NamePart, fname) then
                  begin
                     if fname <> lowercase(fname) then
                        ConvertFile(DirPart+fname)
                  end
            end
      until fname = '';
      CloseDir(d)
   end; (* ConvertTextFiles *)

begin
   if paramcount = 0 then
      syntax;
   for param := 1 to paramcount do
      ConvertTextFiles(paramstr(param));
end.
