program header(f, g, hdr, output);
const
   HeaderPrefixValue = '#!';
   NewLine = 10;
type
   binary = file of char;
var
   f, g : binary;
   hdr : string;
   HeaderPrefix : string[2];
   c : char;

   procedure DisplaySyntax;
   begin
      writeln('PURPOSE: Creates a copy of an IVM executable, with the header');
      writeln('         specified, or no header if none was specified.');
      writeln('SYNTAX: ivm header input output [header]');
      writeln('  where:');
      writeln('   input is the input executable');
      writeln('   output is the output executable');
      writeln('   header is the optional header');
      halt
   end;

   procedure SkipHeader(var f : binary);
   var
      c : char;
   begin
      if f^ =  HeaderPrefix[1] then
         repeat
            read(f, c)
         until c = chr(NewLine);
   end;

   procedure WriteHeader(var f : binary; hdr : string);
   var
      i : 1..maxint;
   begin
      if hdr <> '' then
         begin
            for i := 1 to length(HeaderPrefix) do
               write(f, HeaderPrefix[i]);
            for i := 1 to length(hdr) do
               write(f, hdr[i]);
            write(f, chr(NewLine))
         end
   end;

begin
   writeln('HEADER 1.0 - Irie Header Utility');
   writeln('Copyright (c) 1999, Stuart King');
   if paramcount < 2 then
      DisplaySyntax;
   reset(f);
   rewrite(g);
   HeaderPrefix := HeaderPrefixValue;
   SkipHeader(f);
   WriteHeader(g, hdr);
   while not eof(f) do
      begin
         read(f, c);
         write(g, c)
      end
end.
