@echo off
echo .
echo This batch file is a sample of how you can add a user object.
echo . It assumes: 
echo .  Main network drive is H:
echo .  The batch files are located in SYS:\
echo .
goto end

@echo off
echo  .
echo  Purpose:  Setup the User's object with the appropiate values.
echo  .
echo  .             = Description =       = Type =         = Sample =
echo  Parameter: 1  New user object name  common           dcollins
echo  Parameter: 2  Default group         common           is
echo  Parameter: 3  Default container     distinguished    mercury.hq.dart
echo  Parameter: 4  Default server        common           mercury
echo  Parameter: 5  Employee #            number           12345
echo  .
echo  Note:  if the sample does not have a leading period (.) then don't
echo  use one.  (use exactly the same syntax.)
echo  .

if [%1] == [] goto end
if [%2] == [] goto error
if [%3] == [] goto error
if [%4] == [] goto error
if [%5] == [] goto error

Rem  If user object does exist then 'error' out.
n4object %1 "/c=user" /l
if errorlevel 1 goto error

Rem  If group object does not exist then 'error' out.
n4object %2 "/c=group" /l
if not errorlevel 1 goto error

Rem  If server object does not exist then 'error' out.
n4object %4 "/c=NCP Server" /l
if not errorlevel 1 goto error

echo  .  Press anykey to start the 'add' or else CTRL-C
pause

rem  Log the command parameter used to help in later debugging.
nlogmsg h:\add-me.log "%1 %2 %3 %4"

@echo on

map i:=%4/sys:
map j:=%4/vol1:
if not exist i:\public\*.* goto error

I:
CD\

Rem  Create the user object to the specified container.

n4objmgr add USER %1.%3 %1

Rem  Set the default server

:server-loop
n4attr %1.%3 "Message Server" O %4 /O=H:\ADD-ME.LOG
if errorlevel 1 pause
if errorlevel 1 goto server-loop

Rem  Document in the description attribute the add...

n4attr %1.%3 "Description" O "<date> <time> - object created."

Rem  Place the user's employee number into the Attribute CN.
Rem  This attribute is seen as 'Other Name' in NetAdmin/NWAdmin.
Rem  This will help you keep track of employees in large companies.

n4attr %1.%3 cn + %5

Rem  Set the password restrictions

n4attr %1.%3 "Login Disabled" O F /O=H:\ADD-ME.LOG
if errorlevel 1 pause
n4attr %1.%3 "Login Grace Limit" O 6 /O=H:\ADD-ME.LOG
if errorlevel 1 pause
n4attr %1.%3 "Login Grace Remaining" O 6 /O=H:\ADD-ME.LOG
if errorlevel 1 pause
n4attr %1.%3 "Login Maximum Simultaneous" O 1 /O=H:\ADD-ME.LOG
if errorlevel 1 pause

n4attr %1.%3 "Password Allow Change" O T /O=H:\ADD-ME.LOG
if errorlevel 1 pause
n4attr %1.%3 "Password Expiration Interval" O 7776000 /O=H:\ADD-ME.LOG
if errorlevel 1 pause
n4attr %1.%3 "Password Minimum Length" O 5 /O=H:\ADD-ME.LOG
if errorlevel 1 pause
n4attr %1.%3 "Password Required" O True /O=H:\ADD-ME.LOG
if errorlevel 1 pause
n4attr %1.%3 "Password Unique Required" O T /O=H:\ADD-ME.LOG
if errorlevel 1 pause
n4attr %1.%3 "Password Expiration Time" O "01-01-1996 01:01:01" /O=H:\ADD-ME.LOG
if errorlevel 1 pause

Rem  Add user to their favorite groups

n4attr + %1.%3 EVERYONE.DART /O=H:\ADD-ME.LOG
if errorlevel 1 pause
n4attr + %1.%3 %2.%3 /O=H:\ADD-ME.LOG
if errorlevel 1 pause

Rem  Set up the user's L: (personal) drive subdirectory

I:
cd\
md I:\usr\%1
rights I:\usr\%1 r w c e m f /name=.%1.%3

Rem  Provide for the user, their 'group'erize (personalized for the group)
Rem  files for Office Logic Email.  (cfm and cfg)
Rem

J:
cd\
cd\grp\%2\rhm
md\grp\%2\rhm\%1
copy \grp\%2\rhm\%2\logic.* %1
cd\

h:
cd\

goto exit

:error
@echo off
echo  Error occurred!

:exit

Rem  To 'authenticate' to Venus for Office Logic.
Rem  Server Venus is the 'Logic Master' server.
map k:=venus/sys:

@echo off
echo .
echo Ok, now, you will need to:
echo   Rconsole to IO.
echo   Load NGMAdmin.
echo      Select 'This Server'.
echo      Select 'Passive Servers'.
echo      Choose the correct default server.
echo      Add the user to the GMHS database.
echo   Load Office Logic Email, change to the 'Global' user.
echo      Add the user record. 
echo      Add the user to their workgroup's group mail listing.
echo .

h:
cd \logic

:end
