MY_SOCKET EQU  4444h    ; application socket number
;*
;*   Structure for ECB for IPX protocol.
;*
IPXECB   STRUC
Link     DD    0   ; IPX use it for creating ECB's queue
ESR      DD    0   ; address of Event Service Routine
InUse    DB    0   ; In Use indicator
                   ; 0ffh - ecb's in use for transmitting
                   ; 0feh - ecb's "listening"
                   ; 0fdh - ecb has been schedulled with AES
                   ; 0fbh - a send or receive event has occured
                   ; 0 - request has beed completed
RetCode  DB    0   ; completion code
                   ; for SEND
                   ; 0 - SEND was completed successfully
                   ; 0ffh - physically unable to send the packet
                   ; 0feh - dest. invalid or hardware failure
                   ; 0fdh - total length less then 30 or too large
                   ; 0fch - the SEND request was cancelled
                   ; for RECEIVE
                   ; 0 - the packet was received successfully
                   ; 0ffh - socket closed
                   ; 0fdh - packet overflow
                   ; 0fch - the listen request was cancelled
SocNum   DW    0   ; sockets number
Rsrv1    DB    4 dup(0) ; work araea for IPX
Rsrv2    DB   12 dup(0) ; driver's work area
PAddr    DB    6 dup(0) ; partner's address
FragNum  DW    0   ; count of fragments; for SEND must be greater then zero.
;*
;*  Structure for fragment's description
;*
FAddr    DD    0   ; address of first fragment
FLt      DW    0   ; length of first fragment
SAddr    DD    0   ; address of second fragment
SLt      DW    0   ; length of second fragment
IPXECB   ENDS

;*
;*   Structure for AES ECB
;*
AESECB   STRUC
LinkAES  DD    0   ; IPX use it for creating ECB's queue
ESRAES   DD    0   ; address of Event Service Routine
InUseAES DB    0   ; In Use indicator
AesWork  DB  5 dup (?) ; AES workspace
AESECB   ENDS


;*
;*   IPX header
;*
IPXHDR   STRUC

CRC      DW    0   ; control sum of this header
                   ; not used by NetWare v. 2.0.
PLt      DW    0   ; total pocket's length  (max. - 546 + 30)
CtlSnd   DB    0   ; send control feild
PType    DB    4   ; pocket type
                   ; may be 0 or 4

NtDest   DD    0   ; destignation network number
                   ; 0 if the same network
NdAddr   DB 6 dup(0) ; address of destignation node
                   ; this is a physical address; and it's
                   ; length depends on harware.
                   ; 6 dup (0ffh) indicates broadcast message,
                   ; may or may not supported.
SkDest   DW    0   ; destignation socket

NtSour   DD    0   ; source network number (use by bridge)
                   ; may be 0
NdSour   DB 6 dup(0) ; address of source node
SkSour   DW    0   ; source socket

IPXHDR   ENDS

INTADDR  STRUC
;*
;*  Structure for InterNetwork Address description
;*
NetwAddr DB    4 DUP(0)  ; for same network
NodeAddr DB    6 DUP(?)  ; node name
SocketFl DW    MY_SOCKET ; socket field

INTADDR  ENDS
