#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#define MONO  1 			/* Constant values for adapter */
#define CGA   2                         /*   variable */
#define EGA   3


extern int vmode;

/* Initialize video adapter indicator.
 *
 * Determine whether adapter is monochrome, ega, or cga.
 * Issue set mode BIOS command, using standard mode for color,
 * B&W, or monochrome.
 */
init_adapter()
{
	int mode;                 /* Value returned by BIOS call */
	union REGS regs;

	regs.h.ah = 0xF;
	int86(0x10, &regs, &regs);   /* Get video mode, place in AL */
	mode = regs.h.al;
	if (mode == 7)               /* 7 and 15 are MONO modes */
        vmode = MONO;
	else if (mode == 15) {
        vmode = MONO;
		set_mode(7);         /* Set to 7, standard MONO mode */
	} else {
        vmode = is_ega();         /* Test for CGA vs. EGA */
		if (mode >= 8 && mode <=14)
			set_mode(3);
		else switch (mode) {
		case 1:			    /* Color */
		case 3:
		case 4:	set_mode(3);	    /* 3 is standard color mode */
			break;
		case 0:			    /* B & W */
		case 2:
		case 5:
		case 6:	set_mode(2);        /* 2 is standard B & W mode */
			break;
		} /* end switch */
	} /* end else */
}


is_ega()
{
	union REGS regs;
	char far *ega_byte = (char far *) 0x487;
	int  ega_inactive;

	regs.h.ah = 0x12;
	regs.x.cx = 0;
	regs.h.bl = 0x10;
	int86(0x10, &regs, &regs);
	if (regs.x.cx == 0)
		return (CGA);
	ega_inactive = *ega_byte & 0x8;
	if (ega_inactive)
		return (CGA);
	return (EGA);
}

set_mode(mode)
int	mode;
{
	union REGS regs;

	regs.h.al = (char) mode;
	regs.h.ah = 0;
	int86(0x10, &regs, &regs);
	regs.h.al = 0;
	regs.h.ah = 5;
	int86(0x10, &regs, &regs);
}
