 /********************************************************
 *                                                       *
 *                    CHKPARM                            *
 *             Check verb parametrs.                     *
 *                                                       *
 * INPUT : pointer to the verb record, pointer           *
 *         to the communication area.                    *
 * OUTPUT: fill comm. area or set the return code        *
 *         in the verb if function was failed.           *
 *                                                       *
 * CopyRight 1995. Nicholas Poljakov all rights reserved.*
 *                                                       *
 ********************************************************/
#include <cma.h>
#include <state1.h>
#include <lucb.h>
#include <tcb.h>
#include <rcb.h>
#include <psp.h>
#include <common.h>
#include <stdio.h>
#include <string.h>

struct psp psp_ini;

chkparm(s_ptr, ar)
struct com *s_ptr;
struct cma *ar;
{
    struct rcb *p_rcb;
    struct tcb *p_tcb;
    struct lucb *p_lucb;
    char tid[8];
    unsigned long rid;
    char *p;
    int i;

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;       /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "chkparm");
pnum = 1;
lenr = 0;
drec = NULL;
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif

    p = s_ptr -> tp_id;
    for (i = 0; i < 8; i++) {
        tid[i] = *(p + i);
    }
    rid = s_ptr -> conv_id;

     /* looking for an appopriate LUCB */

      p_lucb = psp_ini.lucb_list_ptr; /* We've got only one LUCB */

     /* searching for an appopriate TCB */

       p_tcb = p_lucb ->tcb_list_ptr;
       while (p_tcb != NULL) {
       if (memcmp(p_tcb->tcb_id, tid, 8) == 0)
                break;
           p_tcb = p_tcb->next;
       }
       if (p_tcb == NULL) {
	    s_ptr->prim_rc = PARAMETR_CHECK;
	    s_ptr->sec_rc = BAD_TP_ID;
            return(-1);
       }
     /* searching for an appopriate RCB */

       p_rcb = p_tcb ->rcb_list_ptr;
       while (p_rcb != NULL) {
       if (rid == p_rcb -> rcb_id)
                break;
           p_rcb = p_rcb->next;
       }
       if (p_rcb == NULL) {
	    s_ptr->prim_rc = PARAMETR_CHECK;
	    s_ptr->sec_rc = BAD_CONV_ID;
            return(-1);
       }
       ar -> p_tcb = p_tcb;
       ar -> p_rcb = p_rcb;
       return(0);
}
