/**************************************************************/
/*                                                            */
/*                ALLOCATE_RCB_PROC                           */
/*                    alloc_rcb                               */
/*                                                            */
/*   FUNCTION : This procedure has deal with allocation and   */
/*   initialisation of the  Resource Control Blocks (RCBs)    */
/*                                                            */
/*   INPUT : Allocate_RCB record.                             */
/*   OUTPUT: Rcb_allocated record.                            */
/**************************************************************/
/*
 * CopyRight 1995. Nicholas Poljakov all rights reserved.
 *
 */
#include <stdio.h>
#include <arcb.h>
#include <rcb.h>
#include <tcb.h>
#include <psp.h>
#include <lucb.h>
#include <rcballoc.h>
#include <state1.h>
#include <malloc.h>
#include <string.h>

struct psp psp_ini;
int sk_r_wt(void *);
int SendBlock(void *, void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendhs(void *);
int sendbm(void *, void *);
int sendat(void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int recwait(void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int psrm(int, void *, void *);
int ps_conv(int, void *);
int proterr(void *, unsigned long);
int preptrcv(void *, void *);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int obtsess(void *, unsigned char);
int Lrf_handler(void *);
int get_sess(void *, void *);
int get_attr(void *);
int fsm_error(unsigned char, void *);
int fsm_conv(unsigned char, unsigned char, void *);
int flush (void *);
int dcp(void *);
int dealloc(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
int check_end(unsigned int, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int allocate(void *);
int clsdst(void *);

alloc_rcb(in, out)
char *in;
char *out;
{
    struct arcb *p_arcb;
    struct rcballoc *p_rcba;
    struct rcb *p_rcb;
    struct rcb *temp;
    struct tcb *p_tcb;
    char *p;
    unsigned long ui;

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;       /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "alloc_r");
pnum = 1;
drec = NULL;
lenr = 0;
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif


    p_arcb = (struct arcb *)in;
    p_rcba = (struct rcballoc *)out;
    p_rcba -> rc = OK;
    p_tcb = p_arcb -> p_tcb;

    if ((p_rcb = calloc(1, sizeof(struct rcb))) == NULL) {
        p_rcba -> rc = UNSUCCESSFUL;
	return 0;
    }
    p_rcb -> p_tcb = p_tcb;
    memcpy(p_rcb -> lu_name, p_arcb -> lu_name, 8);
    memcpy(p_rcb -> mode_name, p_arcb -> mode_name, 8);
    p_rcb -> p_lucb = psp_ini.lucb_list_ptr;
    p_rcb -> conv_type = BASED;
    p_rcb -> code = ASCII;
    p_rcb -> session_parm_ptr = NULL;
    p_rcb -> ps_to_hs_record = NULL;
    p_rcb -> send_ll_remainder = 0;
    p_rcb -> receive_remainder = 0;
    p_rcb -> send_ll_byte = 0;
    p_rcb -> saved_byte = 0;
    p_rcb -> sync_level = NONE;
    p_rcb -> rq_to_send_rcvd = No;
    p_rcb -> hsps = No;
    p_rcb -> cdind = 0;
    p_rcb -> rbptr = NULL;
    p_rcb -> verb_ptr = NULL;
    p_rcb -> next = NULL;
    p_rcb -> prev = NULL;
    p_rcb -> Dir_next = NULL;
    p_rcb -> In_count = 0;
    p_rcb -> Out_count= 0;
    p_rcb -> first_in = NULL;
    p_rcb -> first_out = NULL;
    p_rcb -> p_scb = NULL;
    p_rcb -> error_state = NO_RQS;
    p_rcb -> conv_state = RESET;
/*
 * Set RCB_ID
 */
    p_tcb -> cur_conv++;

    p = (char *)&((*p_rcb).rcb_id);
    p[0] = 'C';
    p[1] = '.';
    ui = p_rcb;
    p += 2;
    memcpy(p, &ui, 2);

 /*
  * Place RCB in rcb list.
  */
    temp = p_tcb -> rcb_list_ptr;
    if (temp == NULL) {
        p_tcb -> rcb_list_ptr = p_rcb;
    }
    else
            {
                while (temp -> next != NULL) {
                    temp = temp -> next;
                }
                temp -> next = p_rcb;
                p_rcb -> prev = temp;
            }

    p_rcba -> rcb_ptr = p_rcb;
    return 0;
}
