@echo off

set TX=C:\V\T3XR5

set OPT=n
set PREP=n
set NATIVE=n
set NOASM=n
set TXOPT=txopt
set S86=n

if not x%1 == x goto options

:usage
echo Usage: tx [-s86] [-h] [-L] [-nOPS] file
echo .      tx -h explains the options
goto end

:help
echo.
echo Usage: TX [-s86] [-h] [-L] [-nOPS] file
echo.
echo .      -s86 - use S86/SLD (default=TASM, implies -n)
echo .      -L   - show conditions of use
echo .      -n   - generate native code (default=Tcode)
echo .      -O   - enable the Tcode optimizer
echo .      -P   - enable the preprocessor
echo .      -S   - generate assembly language
echo.
echo Use TXX FILE to run a Tcode program
echo.
goto end

:license
echo.
echo T3X -- A Compiler for the Procedural Language T, version 3X
echo Copyright (C) 1996,2000 Nils M Holm.  All rights reserved.
echo.
echo Redistribution and use in source and binary forms, with or without
echo modification, are permitted provided that the following conditions
echo are met:
echo 1. Redistributions of source code must retain the above copyright
echo    notice, this list of conditions and the following disclaimer.
echo 2. Redistributions in binary form must reproduce the above copyright
echo    notice, this list of conditions and the following disclaimer in the
echo    documentation and/or other materials provided with the distribution.
echo.
echo THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
echo ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
echo IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
echo ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
echo FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
echo DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
echo OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
echo HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
echo LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
echo OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
echo SUCH DAMAGE.
echo.
goto end

:abort
if exist TXPP.ERR del TXPP.ERR
if exist TXTRN.ERR del TXTRN.ERR
if exist TXOPT.ERR del TXOPT.ERR
if exist TXCG.ERR del TXCG.ERR
if exist %1.tco del %1.tco
if exist %1.tmp del %1.tmp
if exist %1.$$$ del %1.$$$
if exist %1.s del %1.s
if exist %1.o del %1.o
if exist %1.x del %1.x
if exist %1.obj del %1.obj
if exist %1.exe del %1.exe
goto end

:options
if x%1 == x-L goto license
if x%1 == x-h goto help
if not x%1 == x-O goto noo
set OPT=y
shift
goto options
:noo
if not x%1 == x-P goto nop
set PREP=y
shift
goto options
:nop
if not x%1 == x-n goto non
set NATIVE=y
shift
goto options
:non
if not x%1 == x-S goto nos
set NOASM=y
shift
goto options
:nos
if not x%1 == x-s86 goto nos86
set S86=y
set NATIVE=y
shift
goto options
:nos86

if exist %1.t goto exists
echo tx: cannot open: %1.t
goto end

:exists
if %PREP% == n goto noprep
%TX%\txpp < %1.t >%1.tmp
if exist TXPP.ERR goto abort
goto prepdone
:noprep
type %1.t >%1.tmp
:prepdone

if %NATIVE% == y goto native

%TX%\txtrn < %1.tmp >%1
if exist TXTRN.ERR goto abort
if not %OPT% == y goto end
if exist %1.tmp del %1.tmp
ren %1 %1.tmp
%TX%\%TXOPT% <%1.tmp > %1
del %1.tmp
if exist TXOPT.ERR goto abort
goto end

:native

%TX%\txtrn < %1.tmp >%1.tco
if exist TXTRN.ERR goto abort
if not %OPT% == y goto noopt
if exist %1.tmp del %1.tmp
ren %1.tco %1.tmp
%TX%\%TXOPT% <%1.tmp >%1.tco
del %1.tmp
if exist TXOPT.ERR goto abort
:noopt

if %S86% == y goto uses86

%TX%\txcg86t <%1.tco >%1.s
del %1.tco
if exist TXCG.ERR goto abort
if %NOASM% == y goto end
tasm /t /ml %1.s
del %1.s
tlink %1.obj,%1.exe,nul,%TX%\libtx.lib
del %1.obj

goto end

:uses86
%TX%\txcg86a <%1.tco >%1.s
del %1.tco
if exist TXCG.ERR goto abort
if %NOASM% == y goto end
%TX%\s86b <%1.s >%1.o
del %1.s
echo -o %1.x >__ldctrl
echo %1.o >>__ldctrl
echo %TX%/libtx86.o >>__ldctrl
echo %TX%/libvio.o >>__ldctrl
%TX%\sld <__ldctrl
del %1.o
del __ldctrl
%TX%\cvexe <%1.x >%1.exe
del %1.x

:end
if exist %1.tmp del %1.tmp
set TX=
set OPT=
set PREP=
set NATIVE=
set S86=
