#!/bin/sh

FRAME=none

while true; do
	case $1 in
	-asm)
		FRAME=asm
		shift ;;
	-hll)
		FRAME=hll
		shift ;;
	*)
		break;;
	esac
done

if [ x$1 = x -o x$2 != x -o x$FRAME = xnone ]; then
	echo 'MAKEGEN: Usage: {-asm|-hll} type'
	exit 1
fi

OUTFILE=txcg$1.t
DEFFILE=cg$1.def
FRAMEFILE=txcg_${FRAME}_frame

if [ ! -f $DEFFILE ]; then
	echo "MAKEGEN: cannot open definition file: $DEFFILE"
	exit 1
fi

if [ ! -f $FRAMEFILE ]; then
	echo "MAKEGEN: cannot open file file: $FRAMEFILE"
	exit 1
fi

rm -f txcg_frame
ln -s $FRAMEFILE txcg_frame
./txcgg <$DEFFILE > $OUTFILE.pp
rm txcg_frame

../compiler/txpp <$OUTFILE.pp >$OUTFILE
rm $OUTFILE.pp

./txboot.sh $OUTFILE 
