/*
 *	Graphics support for T3X programs.
 *	Copyright (C) 1997 Nils M. Holm.
 *	See the file LICENSE for conditions of use.
 */

#define GFX_OK		0
#define GFX_NOGFX	-1
#define GFX_NOMEM	-2
#define GFX_NOFILE	-3
#define GFX_BADFILE	-4

#define GFX_OFF		0
#define GFX_ON		1
#define GFX_OR		2
#define GFX_XOR		3

#ifndef FNTPATH
#ifdef unix
#define FNTPATH		"/usr/local/t3x/r5/lib"
#endif
#ifdef plan9
#define FNTPATH		"/lib"
#endif
#ifdef msdos
#define FNTPATH		"C:/V/T3XR5"
#endif
#ifndef FNTPATH
#define FNTPATH		"."
#endif
#endif
#define GFX_SYSFONT	"system.vf"
#define GFX_MAGIC	"VF10"

#define GFX_FSX		500
#define GFX_FSY		1000

#define uchar		unsigned char
#define ushort		unsigned short

#define vfxsize(v)	((v)[0][1])
#define vfysize(v)	((v)[0][2])

struct event {
	short	x, y, buttons;
	short	key;
};

#define	XLIM		16000
#define YLIM		12000

#ifdef msdos
int far _g_init(void);
void far g_end(void);
void far g_point(int x, int y, int c);
void far g_line(int x, int y, int dx, int dy, int c);
void far g_box(int x, int y, int dx, int dy, int c);
void far g_clear(int mode);
int far g_reshaped(void);
#endif
