#	Makefile for DOS, TCC

TXDIR=C:\V\T3XR5	# the location of the T3X compiler

CC=		tcc
OPTIONS=	-DBASIC_EXT -DVIO_EXT -DGRAPHICS_EXT -Dmsdos -w-rvl

default:	txx.exe system.vf libtx.lib

txx.exe:	txx.obj lib.obj gfx.obj dos.obj dosgfx.obj dosvio.obj delay.obj
	$(CC) -etxx.exe -ml txx.obj lib.obj gfx.obj dos.obj delay.obj \
	dosgfx.obj dosvio.obj

txx.obj:	txx_ext.h

txx.obj:	txx.c
	$(CC) $(OPTIONS) -ml -c txx.c

libtx.lib:	s_libtx.obj s_gfx.obj s_dos.obj dosgfx.obj dosvio.obj \
		int86.obj delay.obj lib86.obj
	-del libtx.lib
	tlib libtx.lib /c /e +s_libtx.obj +s_gfx.obj +s_dos.obj +dosgfx.obj \
	+dosvio.obj +int86.obj +delay.obj +lib86.obj

int86.obj:	int86.s
	tasm /ml int86.s

delay.obj:	delay.s
	tasm /ml delay.s

lib86.obj:	lib86.s
	tasm /ml lib86.s

s_libtx.obj:	libtx.c gfx.h vio.h
	$(CC) $(OPTIONS) -os_libtx.obj -ms -c -Dmsdos libtx.c

s_gfx.obj:	gfx.c gfx.h
	$(CC) $(OPTIONS) -os_gfx.obj -ms -c -DLIB -Dmsdos gfx.c

s_dos.obj:	dos.c gfx.h vio.h
	$(CC) $(OPTIONS) -os_dos.obj -ms -c -Dmsdos dos.c

lib.obj:	lib.c gfx.h
	$(CC) $(OPTIONS) -ml -c -Dmsdos lib.c

gfx.obj:	gfx.c gfx.h
	$(CC) $(OPTIONS) -ml -c -Dmsdos gfx.c

dos.obj:	dos.c gfx.h vio.h
	$(CC) $(OPTIONS) -ml -c -Dmsdos dos.c

dosgfx.obj:	dosgfx.asm
	tasm /ml dosgfx.asm

dosvio.obj:	dosvio.asm
	tasm /ml dosvio.asm

system.vf:	sys6x12.vfd mkvfont.exe
	mkvfont 6 12 sys6x12.vfd system.vf

mkvfont.exe:	mkvfont.c
	tcc -ms mkvfont.c

install:
        copy txx.exe $(TXDIR)
        copy mkvfont.exe $(TXDIR)
        copy sys6x12.vfd $(TXDIR)
        copy system.vf $(TXDIR)
        copy libtx.lib $(TXDIR)
        copy ..\inc\graphics.inc $(TXDIR)
        copy ..\inc\vio.inc $(TXDIR)

clean:
	-del *.obj

clobber:	clean
	-del txx.exe
	-del mkvfont.exe
	-del system.vf
	-del libtx.lib
