\
  Interface avec les fns de la lib runtime de TP
                                                 \
Package Runtime

Uses KbdCRT,Error

Interface

\ Maintenant qu'il y a GetStack, il faudra renommer : GetHeap, FreeHeap, ...
\
Sub GetMem(P as @Pointer,N as Word)
Sub FreeMem(P as Pointer,N as Word)
Def MemAvail as LongWord
Def MaxAvail as LongWord
Sub Mark(P as @Pointer)
Sub Release(P as @Pointer)

Def Random(Range as Word) as Word
Sub Randomize
\
Def FileExists(S as String) as Byte
Def FileLength(S as String) as LongWord
Sub BLoad(Buf as Pointer,S as String)
Sub BSave(Buf as Pointer,N as Word,S as String)\
\
Sub Assign(F as @File,S as String)
Sub Reset(F as @File,N as Word)
Sub Rewrite(F as @File,N as Word)
Def FileSize(F as @File) as LongWord
Def EOF(F as @File) as Byte
Sub BlockRead(F as @File,Buf as Reference,N as Word)
Sub BlockWrite(F as @File,Buf as Reference,N as Word)
Sub Close(F as @File)\

Implementation

Type
    File is Array[0..127] Of Byte
Var
   DSRuntime as Word

Sub GetMem(P as @Pointer,N as Word)
Enter
\ Check :: ATTENTION A N'Y RIEN CHANGER : CA FERAIT MERDER LE CALL FAR \
  If MaxAvail<N Then Error("GetMem : Out of memory");
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ PUSH [N] \
  InLine &HFF,&HB6,N
\ CALL FAR @GetMem \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
  P=Pointer(DX,AX)
Leave

Sub FreeMem(P as Pointer,N as Word)
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ LES BX,[P]:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,P,&H06,&H53
\ PUSH [N] \
  InLine &HFF,&HB6,N
\ CALL FAR @FreeMem \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
Leave

Def MemAvail as LongWord
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ CALL FAR @MemAvail \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
  Result=(DX,AX)
Leave

Def MaxAvail as LongWord
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ CALL FAR @MaxAvail \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
  Result=(DX,AX)
Leave

Def Random(Range as Word) as Word
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ PUSH [Range] \
  InLine &HFF,&HB6,Range
\ CALL FAR @Random \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
  Result=AX
Leave

Sub Randomize
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ CALL FAR @Randomize \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
Leave

Def FileExists(S as String) as Byte
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ LES BX,@S:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,S,&H06,&H53
\ CALL FAR @FileExists \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
  Result=AX
Leave

Def FileLength(S as String) as LongWord
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ LES BX,@S:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,S,&H06,&H53
\ CALL FAR @FileLength \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
  Result=(DX,AX)
Leave

Sub BLoad(Buf as Pointer,S as String)
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ LES BX,[Buf]:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,Buf,&H06,&H53
\ LES BX,@S:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,S,&H06,&H53
\ CALL FAR @BLoad \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
Leave

Sub BSave(Buf as Pointer,N as Word,S as String)
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ LES BX,[Buf]:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,Buf,&H06,&H53
\ PUSH [N] \
  InLine &HFF,&HB6,N
\ LES BX,@S:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,S,&H06,&H53
\ CALL FAR @BLoad \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
Leave

Sub Assign(F as @File,S as String)
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ LES BX,@F:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,F,&H06,&H53
\ LES BX,@S:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,S,&H06,&H53
\ CALL FAR @Assign \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
Leave

Sub Reset(F as @File,N as Word)
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ LES BX,@F:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,F,&H06,&H53
\ PUSH [N] \
  InLine &HFF,&HB6,N
\ 6 de moins que pour BSave \
\ CALL FAR @Reset \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
Leave

Sub Rewrite(F as @File,N as Word)
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ LES BX,@F:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,F,&H06,&H53
\ PUSH [N] \
  InLine &HFF,&HB6,N
\ 6 de moins que pour BSave \
\ CALL FAR @Rewrite \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
Leave

Def FileSize(F as @File) as LongWord
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ LES BX,@F:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,F,&H06,&H53
\ CALL FAR @FileSize \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
  Result=(DX,AX)
Leave

Def EOF(F as @File) as Byte
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ LES BX,@F:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,F,&H06,&H53
\ CALL FAR @EOF \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
  Result=AX
Leave

Sub BlockRead(F as @File,Buf as Reference,N as Word)
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ LES BX,@S:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,F,&H06,&H53
\ LES BX,[Buf]:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,Buf,&H06,&H53
\ PUSH [N] \
  InLine &HFF,&HB6,N
\ CALL FAR @BRead \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
Leave

Sub BlockWrite(F as @File,Buf as Reference,N as Word)
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ LES BX,@S:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,F,&H06,&H53
\ LES BX,[Buf]:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,Buf,&H06,&H53
\ PUSH [N] \
  InLine &HFF,&HB6,N
\ CALL FAR @BWrite \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
Leave

Sub Close(F as @File)
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ LES BX,@F:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,F,&H06,&H53
\ CALL FAR @Close \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
Leave

Sub Mark(P as @Pointer)
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ LES BX,@P:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,P,&H06,&H53
\ CALL FAR @Mark \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
Leave

Sub Release(P as @Pointer)
Enter
\ PUSH DS \
  InLine &H1E
\ DS <- DSRuntime \
  InLine &H8E,&H1E,DSRuntime
\ LES BX,@P:PUSH ES:PUSH BX \
  InLine &HC4,&H9E,P,&H06,&H53
\ CALL FAR @Release \
  InLine &H9A,&HAA,&HAA,&HAA,&HAA
\ POP DS \
  InLine &H1F
Leave

PP,PPF as ^Pointer

Enter
  PP=Pointer(0,&H200)
  PP=PP^
\ DS(Runtime lib) \
  DSRuntime=Word(LongWord(PP^))
\ GetMem \
  PPF=Pointer(@GetMem)
  (PPF+&H51)^=(PP+4)^
\ FreeMem \
  PPF=Pointer(@FreeMem)
  (PPF+24)^=(PP+8)^
\ MemAvail \
  PPF=Pointer(@MemAvail)
  (PPF+17)^=(PP+12)^
\ MaxAvail \
  PPF=Pointer(@MaxAvail)
  (PPF+17)^=(PP+16)^
\ Random \
  PPF=Pointer(@Random)
  (PPF+21)^=(PP+20)^
\ Randomize \
  PPF=Pointer(@Randomize)
  (PPF+14)^=(PP+24)^
\ FileExists
  PPF=Pointer(@FileExists)
  (PPF+23)^=(PP+40)^\
\ FileLength
  PPF=Pointer(@FileLength)
  (PPF+23)^=(PP+44)^\
\ BLoad
  PPF=Pointer(@BLoad)
  (PPF+26)^=(PP+48)^\
\ BSave
  PPF=Pointer(@BSave)
  (PPF+30)^=(PP+52)^\
\ Assign
  PPF=Pointer(@Assign)
  (PPF+26)^=(PP+56)^\
\ Reset
  PPF=Pointer(@Reset)
  (PPF+24)^=(PP+60)^\
\ Rewrite
  PPF=Pointer(@Rewrite)
  (PPF+24)^=(PP+64)^\
\ FileSize
  PPF=Pointer(@FileSize)
  (PPF+23)^=(PP+68)^\
\ EOF
  PPF=Pointer(@EOF)
  (PPF+23)^=(PP+72)^\
\ BlockRead
  PPF=Pointer(@BlockRead)
  (PPF+30)^=(PP+76)^\
\ BlockWrite
  PPF=Pointer(@BlockWrite)
  (PPF+30)^=(PP+80)^\
\ Close
  PPF=Pointer(@Close)
  (PPF+20)^=(PP+84)^\
\ Mark \
  PPF=Pointer(@Mark)
  (PPF+20)^=(PP+88)^
\ Release \
  PPF=Pointer(@Release)
  (PPF+20)^=(PP+92)^
  PrintS "Runtime start done":PrintCR
Leave