/*
 * File: fxgrafx.r
 *
 *  Contents: XDrawArc, XDrawCurve, XDrawLine, XDrawSegment, XDrawPoint,
 *   XDrawString, XDrawRectangle, XFillArc, XFillRectangle, XFillPolygon
 */
#ifdef XIcon

/*
 *	XDrawArc(w, x1, y1, width1, height1, angle11, angle21,...,
 *		   xN, yN, widthN, heightN, angle1N, angle2N)
 */
"XDrawArc(argv[]){1} - draw arc"

function{1} XDrawArc(argv[argc])

   abstract {
      return file
      }

   body {
      wbp _w_;
      int i, j, warg = 0, n = 0;
      XArc thearcs[MAXXOBJS];
      int dx, dy;
#ifdef PresentationManager
      SHORT angle1, angle2;
      int bheight;
#endif					/* PresentationManager */

      OptWindow;

      /*
       * Check the arguments for a multiple of 6; exactly
       * 3 or 4 arguments have special-cased defaulting behavior
       */
      if (argc-warg != 4 && argc-warg != 3) {
	 CheckArgMultiple(6);
	 }

#ifdef PresentationManager
      bheight = _w_->window->bitHeight;
#endif					/* PresentationManager */
      dx = _w_->context->dx;
      dy = _w_->context->dy;
      if(argc-warg < 6) {
	 if (argc-warg < 3) runerr(101);
         CnvCShort(argv[warg], thearcs[0].x);
         CnvCShort(argv[warg + 1], thearcs[0].y);
#ifndef PresentationManager
         CnvCUShort(argv[warg + 2], thearcs[0].width);
         if (argc-warg >= 4) {
            CnvCUShort(argv[warg + 3], thearcs[0].height);
            }
         else thearcs[0].height = thearcs[0].width;
	 thearcs[0].x += dx;
	 thearcs[0].y += dy;
         /*
	  * what to do if width or height is 0?  fail for now...
	  */
	 if (thearcs[0].width==0) fail;
	 if (thearcs[0].height==0) fail;
	 thearcs[0].width--;
	 thearcs[0].height--;
	 thearcs[0].angle2 = 360<<6;
#else					/* PresentationManager */
         CnvCUShort(argv[warg + 2], thearcs[0].arcp.lP);
         if (argc-warg >= 4) {
            CnvCUShort(argv[warg + 3], thearcs[0].arcp.lQ);
            }
         else thearcs[0].arcp.lQ = thearcs[0].arcp.lP;
         /* width and height must be from center point... half them */
         thearcs[0].arcp.lP >>= 1;
         thearcs[0].arcp.lQ >>= 1;
         thearcs[0].arcp.lR = thearcs[0].arcp.lS = 0;
	 thearcs[0].x += dx + thearcs[0].arcp.lP;
         thearcs[0].y = bheight - (thearcs[0].y + dy + thearcs[0].arcp.lQ) - 1;
	 /*
	  * what to do if width or height is 0?  fail for now...
	  */         
         if (thearcs[0].arcp.lP == 0 || thearcs[0].arcp.lQ == 0) fail;
         thearcs[0].angle2 = MAKEFIXED(360, 0);
#endif					/* PresentationManager */
	 thearcs[0].angle1 = 0;
	 drawarcs(_w_, thearcs, 1);
         }
      else {
         for (i=0, j=0; i < n; i++, j++) {
	    int base = warg + i * 6;
            if (j == MAXXOBJS) {
	       drawarcs(_w_, thearcs, MAXXOBJS);
               j = 0;
               }
            CnvCShort(argv[base], thearcs[j].x);
            CnvCShort(argv[base + 1], thearcs[j].y);
#ifndef PresentationManager
	    thearcs[j].x += dx;
	    thearcs[j].y += dy;
            CnvCUShort(argv[base + 2], thearcs[j].width);
            CnvCUShort(argv[base + 3], thearcs[j].height);
            CnvCShort(argv[base + 4], thearcs[j].angle1);
            thearcs[j].angle1 %= (360<<6);
            CnvCShort(argv[base + 5], thearcs[j].angle2);
	      if ((thearcs[j].angle2 > (360<<6)) ||
		  (thearcs[j].angle2 < -(360<<6)))
		thearcs[j].angle2 = (360<<6);
	    /*
	     * what to do if width or height is 0?  fail for now...
	     */
	    if (thearcs[j].width==0) fail;
	    if (thearcs[j].height==0) fail;
            thearcs[j].width--;
            thearcs[j].height--;
#else					/* PresentationManager */
            CnvCUShort(argv[base + 2], thearcs[j].arcp.lP);
            CnvCUShort(argv[base + 3], thearcs[j].arcp.lQ);
            thearcs[j].arcp.lP >>= 1;
            thearcs[j].arcp.lQ >>= 1;
            thearcs[0].arcp.lR = thearcs[0].arcp.lS = 0;
	    thearcs[j].x += dx + thearcs[j].arcp.lP;
            thearcs[0].y = bheight - (thearcs[0].y + dy + thearcs[j].arcp.lQ)- 1;
            CnvCShort(argv[base + 4], angle1);
            CnvCShort(argv[base + 5], angle2);
            /* have to convert from 1/64 of degrees to 1/65536 */
            thearcs[j].angle1 = MAKEFIXED(((angle1 >> 6) % 360),
                                           ((angle1 % 64) << 10));
            thearcs[j].angle2 = (angle2 > (360 << 6) || angle2 < -(360 << 6)) ?
                                MAKEFIXED(360, 0) :
                                MAKEFIXED(((angle2 >> 6) % 360),
                                          ((angle2 % 64) << 10));
	    /*
	     * what to do if width or height is 0?  fail for now...
	     */
            if (thearcs[j].arcp.lP == 0 || thearcs[j].arcp.lQ == 0) fail;
#endif					/* PresentationManager */
         }

	 drawarcs(_w_, thearcs, j);
         }
      ReturnWindow;
      }
end


/*
 *	XDrawCurve(w,x1,y1,...xN,yN)
 *	Draw a smooth curve through the given points.
 */
"XDrawCurve(argv[]){1} - draw curve"

function{1} XDrawCurve(argv[argc])

   abstract {
      return file
      }

   body {
      wbp _w_;
      int i, j, n, closed = 0, warg = 0;
      int dx, dy;
#ifndef PresentationManager
      int x[MAXXOBJS], y[MAXXOBJS];
#else					/* PresentationManager */
      XPoint points[MAXXOBJS];
      int bheight;
      int x, y;
#endif					/* PresentationManager */
 

      OptWindow;

      CheckArgMultiple(2);

      dx = _w_->context->dx;
      dy = _w_->context->dy;

#ifdef PresentationManager
      bheight = _w_->window->bitHeight;
#endif					/* PresentationManager */     
      if (n > 1) {
#ifndef PresentationManager
         if ((IntVal(argv[warg]) == IntVal(argv[argc-2])) &&
             (IntVal(argv[warg + 1]) == IntVal(argv[argc-1]))) {
            closed = 1;               /* duplicate the next to last point */
            x[0] = IntVal(argv[argc-4]);
            y[0] = IntVal(argv[argc-3]);
	    x[0] += _w_->context->dx;
	    y[0] += _w_->context->dy;
            }
         else if (argc > 1) {        /* duplicate the first point */
            x[0] = IntVal(argv[warg]);
            y[0] = IntVal(argv[warg + 1]);
	    x[0] += _w_->context->dx;
	    y[0] += _w_->context->dy;
            }
         for (i = 0, j = 1; i < n; i++, j++) {
	    int base = warg + i * 2;
            if (j == MAXXOBJS) {
               drawCurve(_w_, x, y, MAXXOBJS);
	       x[0] = x[j-3];
	       y[0] = y[j-3];         /* duplicate the last three points */
	       x[1] = x[j-2];         /*  for the next call, to insure   */
	       y[1] = y[j-2];         /*  continuity                     */
	       x[2] = x[j-1];
	       y[2] = y[j-1];
#else					/* PresentationManager */
         for (i = 0, j = 0; i < n; i++, j++) {
	    int base = warg + i * 2;
            if (j == MAXXOBJS) {
               drawCurve(_w_, points, MAXXOBJS);
               points[0] = points[j - 3];
               points[1] = points[j - 2];
               points[2] = points[j - 1];
#endif					/* PresentationManager */
	       j = 3;
               }
#ifndef PresentationManager
            CnvCInteger(argv[base], x[j]);
            CnvCInteger(argv[base + 1], y[j]);
	    x[j] += dx;
	    y[j] += dy;
#else					/* PresentationManager */
            CnvCInteger(argv[base], x);
            CnvCInteger(argv[base + 1], y);
            points[j].x = x + dx;
            points[j].y = bheight - (y + dy) - 1;
#endif					/* PresentationManager */
            }
#ifndef PresentationManager
         if (closed) {                /* duplicate the second point */
            x[j] = x[2];
            y[j] = y[2];
            }
         else {                       /* duplicate the last point */
            x[j] = x[j-1];
            y[j] = y[j-1];
            }
         drawCurve(_w_, x, y, j+1);
#else					/* PresentationManager */
         drawCurve(_w_, points, j);
#endif					/* PresentationManager */
         }
      ReturnWindow;
      }
end

/*
 *	XDrawLine(w,x1,y1,...xN,yN)
 */
"XDrawLine(argv[]){1} - draw line"

function{1} XDrawLine(argv[argc])

   abstract {
      return file
      }

   body {
      wbp _w_;
      int i, j, n, warg = 0;
      XPoint thepoints[MAXXOBJS];
      int dx, dy;
#ifdef PresentationManager
      int bheight;
#endif					/* PresentationManager */

      OptWindow;

      CheckArgMultiple(2);

#ifdef PresentationManager 
      bheight = _w_->window->bitHeight;
#endif					/* PresentationManager */
      dx = _w_->context->dx;
      dy = _w_->context->dy;
      for(i=0, j=0;i<n;i++, j++) {
	 int base = warg + i * 2;
         if (j==MAXXOBJS) {
	    drawlines(_w_, thepoints, MAXXOBJS);
   	    j = 0;
            }
         CnvCShort(argv[base], thepoints[j].x);
         CnvCShort(argv[base + 1], thepoints[j].y);
	 thepoints[j].x += dx;
#ifndef PresentationManager
	 thepoints[j].y += dy;
#else
         thepoints[j].y = bheight - (thepoints[j].y + dy) - 1;
#endif					/* PresentationManager */
         }

      drawlines(_w_, thepoints, j);
      ReturnWindow;
      }
end

/*
 *	XDrawPoint(w, x1, y1, ...xN, yN)
 */
"XDrawPoint(argv[]){1} - draw point"

function{1} XDrawPoint(argv[argc])

   abstract {
      return file
      }

   body {
      wbp _w_;
      int i, j, n, warg = 0;
      XPoint thepoints[MAXXOBJS];
      int dx, dy;
#ifdef PresentationManager 
      int bheight;
#endif					/* PresentationManager */

      OptWindow;

      CheckArgMultiple(2);

#ifdef PresentationManager
      bheight = _w_->window->bitHeight;
#endif					/* PresentationManager */
      dx = _w_->context->dx;
      dy = _w_->context->dy;
      for(i=0, j=0; i < n; i++, j++) {
	 int base = warg + i * 2;
         if (j == MAXXOBJS) {
	    drawpoints(_w_, thepoints, MAXXOBJS);
            j = 0;
            }
         CnvCShort(argv[base], thepoints[j].x);
         CnvCShort(argv[base + 1], thepoints[j].y);
	 thepoints[j].x += dx;
#ifndef PresentationManager
	 thepoints[j].y += dy;
#else					/* PresentationManager */
         thepoints[j].y = bheight - (thepoints[j].y + dy) - 1;
#endif					/* PresentationManager */
       }

      drawpoints(_w_, thepoints, j);
      ReturnWindow;
      }
end

/*
 *	XDrawRectangle(w, x1, y1, width1, height1, ..., xN, yN, widthN,heightN)
 */
"XDrawRectangle(argv[]){1} - draw rectangle"

function{1} XDrawRectangle(argv[argc])

   abstract {
      return file
      }

   body {
      wbp _w_;
      int i, j, n, warg = 0;
      XRectangle recs[MAXXOBJS];
      int dx, dy;
#ifdef PresentationManager
      int bheight, width, height;
#endif					/* PresentationManager */

      OptWindow;

      CheckArgMultiple(4);

#ifdef PresentationManager
      bheight = _w_->window->bitHeight;
#endif					/* PresentationManager */
      dx = _w_->context->dx;
      dy = _w_->context->dy;
      for(i=0, j=0; i < n; i++, j++) {
	 int base = warg + i * 4;
         if (j == MAXXOBJS) {
	    drawrectangles(_w_,recs,MAXXOBJS);
            j = 0;
            }
#ifndef PresentationManager
         CnvCShort(argv[base], recs[j].x);
         CnvCShort(argv[base + 1], recs[j].y);
	 recs[j].x += dx;
	 recs[j].y += dy;
         CnvCUShort(argv[base + 2], recs[j].width);
         CnvCUShort(argv[base + 3], recs[j].height);
#else 					/* PresentationManager */
         CnvCShort(argv[base], recs[j].xLeft);
         CnvCShort(argv[base + 1], recs[j].yTop);
	 recs[j].xLeft += dx;
	 recs[j].yTop = bheight - (recs[j].yTop + dy) - 1;
         CnvCUShort(argv[base + 2], width);
         CnvCUShort(argv[base + 3], height);
         recs[j].xRight = recs[j].xLeft + width;
         recs[j].yBottom = recs[j].yTop - height;
#endif					/* PresentationManager */
         }

      drawrectangles(_w_,recs,j);
      ReturnWindow;
      }
end

/*
 *	XDrawSegment(x11,y11,x12,y12,...,xN1,yN1,xN2,yN2)
 */
"XDrawSegment(argv[]){1} - draw line segment"

function{1} XDrawSegment(argv[argc])

   abstract {
      return file
      }

   body {
      wbp _w_;
      int i, j, n, warg = 0;
      XSegment thesegs[MAXXOBJS];
      int dx, dy;
#ifdef PresentationManager
      int bheight;
#endif					/* PresentationManager */

      OptWindow;

      CheckArgMultiple(4);

#ifdef PresentationManager
      bheight = _w_->window->bitHeight;
#endif 					/* PresentationManager */
      dx = _w_->context->dx;
      dy = _w_->context->dy;
      for(i=0, j=0; i < n; i++, j++) {
	 int base = warg + i * 4;
         if (j == MAXXOBJS) {
	    drawsegments(_w_, thesegs, MAXXOBJS);
            j = 0;
            }
         CnvCShort(argv[base], thesegs[j].x1);
         CnvCShort(argv[base + 1], thesegs[j].y1);
         CnvCShort(argv[base + 2], thesegs[j].x2);
         CnvCShort(argv[base + 3], thesegs[j].y2);
	 thesegs[j].x1 += dx;
	 thesegs[j].x2 += dx;
#ifndef PresentationManager
	 thesegs[j].y1 += dy;
	 thesegs[j].y2 += dy;
#else					/* PresentationManager */
/* for PM, since the coord system is different, we will fix up the
   y values for bitmap drawing (since we will always have to draw to
   a bitmap... in draw segments, the fixup for the window will also have
   to be done */
         thesegs[j].y1 = bheight - (thesegs[j].y1 + dy) - 1;
         thesegs[j].y2 = bheight - (thesegs[j].y2 + dy) - 1;
#endif					/* PresentationManager */

         }

      drawsegments(_w_, thesegs, j);
      ReturnWindow;
      }
end

/*
 *	XDrawString(w, x1, y1, s1, ..., xN, yN, sN)
 */
"XDrawString(argv[]){1} - draw text"

function{1} XDrawString(argv[argc])

   abstract {
      return file
      }

   body {
      wbp _w_;
      int i, n, len, warg = 0;
      char *s;
      struct descrip str;
      int dx, dy;

      OptWindow;

      CheckArgMultiple(3);

      dx = _w_->context->dx;
      dy = _w_->context->dy;
      for(i=0; i < n; i++) {
         int x, y, j, base = warg + i * 3;
         CnvCInteger(argv[base], x);
         CnvCInteger(argv[base + 1], y);
	 x += _w_->context->dx;
	 y += _w_->context->dy;
         CnvTmpString(argv[base + 2], str);
	 s = StrLoc(argv[base + 2]);
	 len = StrLen(argv[base + 2]);
	 for(j=0; j < len; j++) {
	    if (s[j] == '\n') {
/* for PM, the coordinate fixup occurs on the other side of this call */
	       drawstring(_w_, x, y, s, j);
	       s += j+1;
	       len -= j+1;
	       j = -1;
#ifndef PresentationManager
	       y += _w_->context->font->leading;
#else					/* PresentationManager */
               y += _w_->context->fntLeading;
#endif					/* PresentationManager */
	       }
	    }
	 drawstring(_w_, x, y, s, len);
         }
      ReturnWindow;
      }
end

/*
 *	XFillArc(w, x1, y1, width1, height1, angle11, angle21, ..., 
 *		   xN, yN, widthN, heightN, angle1N, angle2N)
 */
"XFillArc(argv[]){1} - draw filled arc"

function{1} XFillArc(argv[argc])

   abstract {
      return file
      }

   body {
      wbp _w_;
      int i, j, n = 0, warg = 0;
      XArc thearcs[MAXXOBJS];
      int dx, dy;
#ifdef PresentationManager
      SHORT angle1, angle2;
      int bheight;
#endif					/* PresentationManager */

      OptWindow

      /*
       * Check the arguments for a multiple of 6; exactly
       * 3 or 4 arguments have special-cased defaulting behavior
       */
      if (argc-warg != 4 && argc-warg != 3) {
	 CheckArgMultiple(6)
	 }

#ifdef PresentationManager
      bheight = _w_->window->bitHeight;
#endif					/* PresentationManager */
      dx = _w_->context->dx;
      dy = _w_->context->dy;
      for(i=0, j=0; i < n; i++, j++) {
	 int base = warg + i * 6;
         if (j == MAXXOBJS) {
	    fillarcs(_w_, thearcs, MAXXOBJS);
            j = 0;
            }
         CnvCShort(argv[base], thearcs[j].x);
         CnvCShort(argv[base + 1], thearcs[j].y);
#ifndef PresentationManager 
	 thearcs[j].x += dx;
	 thearcs[j].y += dy;
         CnvCUShort(argv[base + 2], thearcs[j].width);
         CnvCUShort(argv[base + 3], thearcs[j].height);
         CnvCShort(argv[base + 4], thearcs[j].angle1);
         thearcs[j].angle1 %= (360<<6);
         CnvCShort(argv[base + 5], thearcs[j].angle2);
	 if ((thearcs[j].angle2 > (360<<6)) || (thearcs[j].angle2 < -(360<<6)))
	    thearcs[j].angle2 = (360<<6);
#else					/* PresentationManager */
         CnvCUShort(argv[base + 2], thearcs[j].arcp.lP);
         CnvCUShort(argv[base + 3], thearcs[j].arcp.lQ);
         /* width and height must be from center point... half them */
         thearcs[j].arcp.lP >>= 1;
         thearcs[j].arcp.lQ >>= 1;
         thearcs[0].arcp.lR = thearcs[0].arcp.lS = 0;
	 thearcs[0].x += dx + thearcs[j].arcp.lP;
         thearcs[0].y = bheight - (thearcs[0].y + dy + thearcs[0].arcp.lQ) - 1;
         CnvCShort(argv[base + 4], angle1);
         CnvCShort(argv[base + 5], angle2);

         /* have to convert from 1/64 of degrees to 1/65536 */
         thearcs[j].angle1 = MAKEFIXED(((angle1 >> 6) % 360),
                                       ((angle1 % 64) << 10));
         thearcs[j].angle2 = (angle2 > (360 << 6) || angle2 < -(360 << 6)) ?
                              MAKEFIXED(360, 0) :
                              MAKEFIXED(((angle2 >> 6) % 360),
                                        ((angle2 % 64) << 10));
         if (thearcs[j].arcp.lP == 0 || thearcs[j].arcp.lQ == 0) fail;

#endif					/* PresentationManager */
         }

      if ((argc-warg == 3) || (argc-warg == 4)) {
         /*
          * Have to convert these because they were missed by
	  * preceding for loop
          */
         CnvCShort(argv[warg], thearcs[0].x);
         CnvCShort(argv[warg + 1], thearcs[0].y);
#ifndef PresentationManager
	 thearcs[0].x += dx;
	 thearcs[0].y += dy;
         CnvCUShort(argv[warg + 2], thearcs[0].width);
	 if (argc-warg == 4) {
	    CnvCUShort(argv[warg + 3], thearcs[0].height);
	    }
	 else {
	    thearcs[0].height = thearcs[0].width;
	    }
	 thearcs[0].angle2 = 360<<6;
#else					/* PresentationManager */
         CnvCUShort(argv[warg + 2], thearcs[0].arcp.lP);
         if (argc-warg >= 4) {
            CnvCUShort(argv[warg + 3], thearcs[0].arcp.lQ);
            }
         else thearcs[0].arcp.lQ = thearcs[0].arcp.lP;
         /* width and height must be from center point... half them */
         thearcs[0].arcp.lP >>= 1;
         thearcs[0].arcp.lQ >>= 1;
         thearcs[0].arcp.lR = thearcs[0].arcp.lS = 0;
	 thearcs[0].x += dx + thearcs[0].arcp.lP;
         thearcs[0].y = bheight - (thearcs[0].y + dy + thearcs[0].arcp.lQ) - 1;
         if (thearcs[0].arcp.lP == 0 || thearcs[0].arcp.lQ == 0) fail;
         thearcs[0].angle2 = MAKEFIXED(360, 0);
#endif					/* PresentationManager */
	 thearcs[0].angle1 = 0;
         j = 1;
         }
      fillarcs(_w_, thearcs, j);
      ReturnWindow;
      }
end

/*
 *	XFillPolygon(w, x1, y1, ...xN, yN)
 */
"XFillPolygon(argv[]){1} - fill polygon"

function{1} XFillPolygon(argv[argc])

   abstract {
      return file
      }

   body {
      register int j;
      wbp _w_;
      int i, n, warg = 0;
      XPoint thepoints[MAXXOBJS];
      int dx, dy;
#ifdef PresentationManager
      int bheight;
#endif					/* PresentationManager */

      OptWindow

      CheckArgMultiple(2)

#ifdef PresentationManager
      bheight = _w_->window->bitHeight;
#endif					/* PresentationManager */
      n = argc>>1;
      dx = _w_->context->dx;
      dy = _w_->context->dy;
      for(i=0, j=0;i<n;i++, j++) {
	 int base = warg + i * 2;
         if (j == MAXXOBJS) {
	    fillpolygon(_w_, thepoints, MAXXOBJS);
            j = 0;
            }
         CnvCShort(argv[base], thepoints[j].x);
         CnvCShort(argv[base + 1], thepoints[j].y);
	 thepoints[j].x += dx;
#ifdef XWindows
         thepoints[j].y += dy;
#endif					/* XWindows */
#ifdef PresentationManager
         /* fix-up the point for bitmap drawing.. */
         thepoints[j].y = bheight - (thepoints[j].y + dy) - 1;
#endif					/* PresentationManager */
         }

      fillpolygon(_w_, thepoints, j);
      ReturnWindow;
      }
end

/*
 *	XFillRectangle(w, x1, y1, width1, height1,...,xN, yN, widthN, heightN)
 */
"XFillRectangle(argv[]){1} - draw filled rectangle"

function{1} XFillRectangle(argv[argc])

   abstract {
      return file
      }

   body {
      wbp _w_;
      int i, j, n, warg = 0;
      XRectangle recs[MAXXOBJS];
      int dx, dy;
#ifdef PresentationManager
      int bheight;
      int width, height;
#endif					/* PresentationManager */

      OptWindow;

      /*
       * missing arguments are treated as &null, which isn't convertible
       * to integer.
       */
      CheckArgMultiple(4);

#ifdef PresentationManager
      bheight = _w_->window->bitHeight;
#endif					/* PresentationManager */
      dx = _w_->context->dx;
      dy = _w_->context->dy;
      for(i=0, j=0; i < n; i++, j++) {
	 int base = warg + i * 4;
         if (j == MAXXOBJS) {
	    fillrectangles(_w_,recs,MAXXOBJS);
            j = 0;
            }
#ifndef PresentationManager
         CnvCShort(argv[base], recs[j].x);
         CnvCShort(argv[base + 1], recs[j].y);
	 recs[j].x += dx;
	 recs[j].y += dy;
         CnvCUShort(argv[base + 2], recs[j].width);
         CnvCUShort(argv[base + 3], recs[j].height);
#else					/* PresentationManager */
         CnvCShort(argv[base], recs[j].xLeft);
         CnvCShort(argv[base + 1], recs[j].yTop);
	 recs[j].xLeft += dx;
/* we fix up with respect to the bitmap - since we know there will always
   be a bitmap as opposed to always having a window.  This keeps us from
   running through a loop another time, fixing up values for the bitmap.. */
	 recs[j].yTop = bheight - (recs[j].yTop + dy) - 1;
         CnvCUShort(argv[base + 2], width);
         CnvCUShort(argv[base + 3], height);
         /* have to do an offset here to match the XIcon way of doing things */
         recs[j].xRight = recs[j].xLeft + width - 1;
         recs[j].yBottom = recs[j].yTop - height + 1;
#endif					/* PresentationManager */
         }

      fillrectangles(_w_,recs,j);
      ReturnWindow;
      }
end

#else					/* XIcon */
static char x;			/* avoid empty module */
#endif					/* XIcon */
