// flatlib.h                     1111                           3/28/00

// An modification of "b-lib" "b" library for "flat real" mode programs.
// These programs will be 16-bit "com" programs but will "own" all free
// memory.

// NOTE: Most "string" functions returning "int" are really returning
// string pointers which are of size "int".  This greaty simplifies
// parsing of the function prototypes.

typedef MEMPTR
     {
     int .probase;            // linear address of program segment
     int .freeadd;            // linear address of free memory above stack
     int .freecount;
     }

char GDT[] = {0, 0, 0, 0, 0, 0, 0, 0, 0xFF, 0xFF, 0, 0, 0, 0x92, 0xCF, 0};
char GDTR[] = {16, 0, 0, 0, 0, 0};
char attrib = 0x1E;
char btemp;
char bval;
char chr;
char chval;
char col;
char command[127];
char copy[200];
char flag;
char exitcode;
char next;
char *argv[10];
char *dptr;
char *filptr;
char *limit;
char *oldptr;
char *ptr;
char *sbegin;
char *send;
char *sptr;
char *ssave;
char *vptr[5];
char mode;
char row;
char xval;
char yval;
char outstring[200];          // destination of formatted string
char page;                    // video display "page"
char tail[127];
int argc;
int buffsize;
int digit;
int divisor;
int ercode;
int fbytes;
int first;
int found;
int handle;
int j;
int keyval;
int length;
int membase;
int memsize;
int memtop;
int n;
int oldfile;
int rowcount;
int spsave;
int stdin;
int stdout = 1;
int testval;
int vcount;
int wtemp;
int wval;

int Sprintf(char *fmt, char *tail); // print formatted string to "outstring"
int a20_on(void);             // main function to turn on A20 line
int atoi(char *src);          // convert "src" to decimal number
void beep(void);              // "display" BEL character
void blockcur(void);          // display block cursor
void clear(void);             // clear screen with "attrib"
int cprintf(char *fmt, ...);  // display formatted string on monitor
void delay(void);             // insert a short delay
int escpy(char *s1, char *s2, int n); // copy "n" bytes from "s2" to "ES:s1"
void fclose(int file);        // close open file
int fgetc(int file);          // read one byte from "file"
int fgets(char *dest, int length, int file); // read line from "file" to "dest"
int find_free(void);          // find largest available memory block
int fopen(char *nameptr, int mode); // open file for read or write
int fprintf(char *file, char *fmt, ...);  // print formatted string to "file"
int fputc(char ch, int file); // write "ch" to "file"
void fputs(char *ptr, int fname); // write string at "ptr" to "fname"
int fread(char *dest, int count, int file); // read "count" bytes from "file" 
void free(int memadd);        // free memory allocated with "malloc()"
void free_mem(void);          // free unneeded conventional memory
int fwrite(char *src, int count, int file); // write "count" bytes to "file"
int getchar(void);            // get character from STDIN
char getche(void);            // get keypress with echo to screen
void getkey(void);            // get keypress in al
void get_memdata(void);       // get program addresses in "mem" structure
char get_mode(void);          // get video mode
int get_rows(void);           // read byte at 40:84 to get screen rows
int get_tail(void);           // get "command tail" from PSP
void getxy(void);             // set "xval" and "yval" to cursor position
void go_flat(void);           // switch CPU to flat real mode
int hma_a20_on(void);         // turn on A20 line using "himem.sys"
char inportb(int port);       // return contents of "port"
int kbhit(void);              // returns "1" if key pressed
void kp_a20_on(void);         // turn on A20 line using keyboard port
void make_dec(int size, char cval, int wval, char *str); // convert to decimal string
void make_hex(int size, char cval, int wval, char *str); // convert "cval" or "wval"
int malloc(int bytecount);    // get "bytecount" bytes of memory
int memcpy(char *dest, char *src, int num); // copy "num" bytes from "src" to "dest"
void memset(char *dest, char val int num); // set "num" bytes at "dest" to "val"
void nocur(void);             // hide text cursor
void normcur(void);           // "normal" underline cursor
char num_to_asc(char valu);   // convert number to ASCII character
void outportb(int port, char ch); // output "ch" to "port"
void outportw(int port, int oword); // output "oword" to "port" and "port" + 1
int paralign(int inadd);      // return next 16-bit aligned address
void parse_tail(void);        // parse "command tail"
int printf(char *fmt, ...);   // print formatted string to "stdout"
void putcur(char scol, char srow); // move cursor to scol:srow
int segread(int segnum, int off, int count, int file); // read file to "progseg" 
int segwrite(int segnum, int off, int count, int file); // write file from "segnum"
void show_char(void);         // display "chval" at current cursor position
int show_text(char *tex);     // show "tex" at current cursor position
int sprintf(char *dest, char *fmt, ...);  // print formatted string to "dest"
int strcat(char *pt1, char *pt2) // concatenate pt2 to pt1
int strchr(char *s, char c);  // find first "c" in "s"
int strcmp(char *pt1, char *pt2); // compare pt1 to pt2; 0 => =, 1 => >, 2 => <
int strcspn(char *str1, char *str2); // find index of 1st "str2" char in "str1"
int strcpy(char *strdest, char *src); // copy "src" to "dest"
int strspn(char *str3, char *str4); // find index of 1st "str3" char not in "str4"
int strlen(char *ptr);        // return length of string
int strstr(char *s1, char *s2); // find "s2" in "s1"
int strtok(char *t, char *delim); // find "token" in "t"
void system(char *proname);   // spawn program "proname"
int test_a20(void);           // return 1 if a20 is on
char tolower(char inch);      // convert "inch" to lower case
char toupper(char inch);      // convert "inch" to upper case
int xtoi(char *src);          // convert "src" to hexadecimal number
