/***************************************************************************
 *     EMSLIST vers 1.11, DOS                                              *
 *     Lists EMS handle numbers, names, and pages allocated                *
 *     02/09/90                                                            *
 *     by James W. Birdsall                                                *
 *                                                                         *
 *     compiles under Turbo C 2.0                                          *
 *                                                                         *
 *   EMSLIST lists EMS handle numbers and pages allocated for all versions *
 *   of the LIM EMS specification 3.0 and greater (specifically 3.0, 3.2,  *
 *   and 4.0). For version 4.0, EMSLIST also displays the names, if any,   *
 *   associated with the handles. The character  is displayed when no     *
 *   name is associated with a handle.                                     *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <io.h>
#include <dos.h>



#define VERSION 1.11



char copyright[] = "Copyright (c) 1990 James W. Birdsall. All Rights Reserved";



struct hanbuff {                  /* structure to hold data returned by  */
   unsigned int handle;           /* EMS function 4Dh: Get Pages for All */
   unsigned int pages;            /* Handles                             */
   };



int checkEMM(void);



/***************************************************************************
 *     FUNCTION MAIN                                                       *
 ***************************************************************************/
main(int argc)
{
   int loop;
   int tothand;
   union REGS r;
   struct SREGS s;
   struct hanbuff *buffer;
   char vers;
   char buffer2[9];


   /* check for arguments */
   if (argc > 1) {
      printf("\n");
      printf("EMSLIST vers %.2f by James W. Birdsall\n", VERSION);
      printf("   Lists active EMS handles, names, and pages for each.\n");
      printf("   Usage: EMSLIST\n");
      printf("\n");
      printf("   EMSLIST lists all active handles, including handle 0 (the\n");
      printf("   OS handle) for LIM EMS versions 3.0 and greater. EMSLIST\n");
      printf("   also displays the names, if any, associated with the\n");
      printf("   handles under version 4.0. If there is no name,  is\n");
      printf("   printed.\n\n");
      exit(1);
      }

   /* check for functioning EMM */
   if (checkEMM() != 1) {
      printf("EMS manager not present or malfunctioning.\n");
      exit(3);
      }

   /* get version */
   r.h.ah = 0x46;
   int86(0x67, &r, &r);
   if (r.h.ah != 0) {
      printf("Error 0x%x talking to EMS manager.\n", r.h.ah);
      exit(3);
      }
   vers = r.h.al;
   /* check version */
   if ((vers >> 4) < 3) {
      printf("EMSLIST requires LIM EMS version 3.0 or greater.\n");
      exit(2);
      }
   /* get number of active handles */
   r.h.ah = 0x4B;
   int86(0x67, &r, &r);
   if (r.h.ah != 0) {
      printf("Error 0x%x talking to EMS manager.\n", r.h.ah);
      exit(3);
      }
   tothand = r.x.bx;
   /* print version, number of active handles */
   printf("LIM EMS %d.%d     ", (vers>>4), (vers&0x0F));
   /* set up vers:  0 if less than 4.0, 1 otherwise */
   vers = ((vers >> 4) <= 4) ? 1 : 0;
   /* get total and free pages */
   r.h.ah = 0x42;
   int86(0x67, &r, &r);
   if (r.h.ah != 0) {
      printf("\nError 0x%x talking to EMS manager.\n", r.h.ah);
      exit(3);
      }
   printf("%d total pages, %d free     ", r.x.dx, r.x.bx);
   printf("%d handles:\n", tothand);

   /* allocate buffer for handle/page list */
   if ((buffer = (struct hanbuff *) calloc(tothand, sizeof(struct hanbuff)))
                                                       == NULL) {
      printf("Error allocating memory.\n");
      exit(3);
      }
   /* get list of handles and pages allocated to each */
   r.h.ah = 0x4D;
   r.x.di = (unsigned int) buffer;
   s.es = _DS;
   int86x(0x67, &r, &r, &s);
   if (r.h.ah != 0) {
      printf("Error 0x%x talking to EMS manager.\n", r.h.ah);
      exit(3);
      }

   /* print out data */
   buffer2[8] = 0x0;
   for(loop = 0; loop < tothand; loop++) {
      printf("Handle number: %d  ", buffer[loop].handle);
      /* if version 4.0 or greater, get handle name and print */
      if (vers) {
         r.x.ax = 0x5300;
         r.x.dx = buffer[loop].handle;
         r.x.di = (unsigned int) buffer2;
         s.es = _DS;
         int86x(0x67, &r, &r, &s);
         if (r.h.ah != 0) {
            printf("Error 0x%x talking to EMS manager.\n", r.h.ah);
            exit(3);
            }
         /* if handle not named, print  */
         if (buffer2[0] == 0x0) {
            buffer2[0] = '';
            }
         printf("%8s", buffer2);
         }
      printf("   %d page", buffer[loop].pages);
      if (buffer[loop].pages != 1) {
         printf("s");
         }
      printf("\n");
      }

   /* cleanup and exit */
   free(buffer);
   exit(0);
} /* end of function main */


/***************************************************************************
 *     FUNCTION CHECKEMM                                                   *
 *   Checks for function EMM. 1 = OK, 0 = error                            *
 ***************************************************************************/
int checkEMM(void)
{
   FILE *tempfile;
   int temphandle;

   /* check if EMM is present */
   if ((tempfile = fopen("EMMXXXX0","rb")) == NULL)
      return 0;
   /* make sure we've found a device and not a file */
   temphandle = fileno(tempfile);
   if ((ioctl(temphandle, 0) & 0x80) != 0x80)
      return 0;
   /* check status of EMM */
   if (ioctl(temphandle, 7) <= 0)
      return 0;
   /* close and return */
   fclose(tempfile);
   return 1;
} /* end of function checkEMM */

/* end of file EMSLIST.C */