
/* Gcd.c

compute GCD using Euclid Algorithm

eg, GCD 156562431911123 442677773754356 = 7

Source to GCD.BIN.  Rebuild with Borland C++:

	bcc -c -mt! gcd
	tlink x02 gcd /t/x/c,gcd.bin,,fp ld

If you are using a coprocessor, you can also build with:

	bcc -c -mt! gcd
	tlink x01 gcd f87 /t/x/c,gcd.bin,,fp ld

With older versions of Borland C++ (Turbo C), compile with:

	tcc -c -mt gcd
*/

#include "mathl.h"

long double gcd(long double x, long double y)
{
	long double z;
	do
	{
		z = fmodl(x,y);
		x = y;
		y = z;
	}
	while (z != 0);
	return x;
}

void pascal xmain(double far *x)
{
	x[0] = gcd(x[1],x[2]);
}
