/* 
FSU - ULTRA	The greatest random number generator that ever was
		or ever will be.  Way beyond Super-Duper.
		(Just kidding, but we think its a good one.)

Authors:	Arif Zaman (arif@stat.fsu.edu) and
		George Marsaglia (geo@stat.fsu.edu).

Date:		27 May 1992

Version:	1.05

Copyright:	To obtain permission to incorporate this program into
		any commercial product, please contact the authors at
		the e-mail address given above or at

		Department of Statistics and
		Supercomputer Computations Research Institute
		Florida State University
		Tallahassee, FL 32306.

See Also:	README		for a brief description
		ULTRA.DOC	for a detailed description

-----------------------------------------------------------------------
*/ 
/******************************************************************
 *   This demo calls the various subroutines of ultra as a test   *
 *                                                                *
 *   It prints the first few and the 10,000-th values that are    *
 *   returned by the various routines, after the initialization   *
 *   to the default rinit(1234567,7654321).                       *
 *                                                                *
 *   This serves as a test, for any implementation, but the       *
 *   output often varies in the last digit for the floating       *
 *   point numbers due to rounding methods for printouts.         *
 ******************************************************************/

#include "ultra.h"

#define test(format,x,function,n)				\
  rinit(1234567,7654321); for (i=1;i<10001;i++) { x=function();	\
  if ((i<n) || (i==10000)) printf(format,x);	};  printf("\n");

main()
{ short	i;
  float f;
  double d;
  long  l;

  printf("\nA Sample Printout:\n");
  printf("No rinit call: ");
  for (i=1;i<10001;i++) 
  if ((i<4) || (i==10000)) printf("%16li",i32bit()); else i32bit();
  printf("\n");

  printf("Signed 4 byte: "); test("%16li",l, i32bit,4);
  printf("Uns. 4 byte:   "); test("%16li",l, i31bit,4);
  printf("Signed 2 byte: "); test("%8hi",l,  i16bit,8);
  printf("Uns. 2 byte:   "); test("%8hi",l,  i15bit,8);
  printf("Signed byte:   "); test("%4hi",l,  i8bit,16);
  printf("Uns. byte:     "); test("%4hi",l,  i7bit,16);
  printf("Random bits:   "); test("%2hi",l,  i1bit,32);
  printf("Signed Single: "); test("%16.7f",f,   vni,4);
  printf("Uns. Single:   "); test("%16.7f",f,   uni,4);
  printf("Signed Double: "); test("%32.15lg",d,dvni,2);
  printf("Unsigned Dble: "); test("%32.15lg",d,duni,2);

  return 0;
}
