;verb.lex  12-Apr-91
;INCLUDE file for english.lex

;Copyright (C) 1991, Summer Institute of Linguistics, Inc.
;All rights reserved
;See ENGLEX.DOC for fair use policy.

;edit history
;18-Nov-91	version 0.9
;25-Nov-91  added entries for lying, belying, dying, tying, vying
;26-Nov-91	version 1.0

;File Contents
;LEXICON AUX
;  auxiliaries
;    BE and HAVE
;    modal auxiliaries
;  misc. negative contractions
;  archaic forms
;LEXICON VERB
;  DO
;  irregular verbs
;  regular verbs

LEXICON AUX
;auxiliaries (do not take prefixes)
;BE and HAVE (see under LEXICON VERB for DO)
be	End	"AUX(be)"
`being	End	"AUX(be)+PRG"
been	End	"AUX(be)+PTC"
am	End	"AUX(be).1SG"
are	End	"AUX(be).2SG/PL" ;2SG/1PL/2PL/3PL"
aren't	End	"AUX(be).2SG/PL+AV(not)" ;2SG/1PL/2PL/3PL
is	End	"AUX(be).3SG"
isn't	End	"AUX(be).3SG+AV(not)"
ain't	End	"AUX(be/have)+AV(not)"
aint	End	"AUX(be/have)+AV(not)"
was	End	"AUX(be).PST.1SG/3SG"
wasn't	End	"AUX(be).PST.1SG/3SG+AV(not)"
were	End	"AUX(be).PST.2SG/PL" ;2SG/1PL/2PL/3PL"
weren't	End	"AUX(be).PST.2SG/PL+AV(not)" ;2SG/1PL/2PL/3PL
have	End	"V/AUX(have).1SG/2SG/PL"
haven't	End	"V/AUX(have).2SG/PL+AV(not)" ;2SG/1PL/2PL/3PL
`having	End	"V/AUX(have)+PRG"
had	End	"V/AUX(have).PST"
hadn't	End	"V/AUX(have).PST+AV(not)"
has	End	"V/AUX(have).3SG"
hasn't	End	"V/AUX(have).3SG+AV(not)"

;modal auxiliaries
can	End	"AUX(can)"
`cannot	End	"AUX(can)+AV(not)"
can't	End	"AUX(can)+AV(not)"
could	End	"AUX(could)"
`couldn't	End	"AUX(could)+AV(not)"
may	End	"AUX(may)"
mayn't	End	"AUX(may)+AV(not)"
might	End	"AUX(might)"
mightn't	End	"AUX(might)+AV(not)"
ought	End	"AUX(ought)" ;ought to
oughtn't	End	"AUX(ought)+AV(not)"
used	End	"AUX(used)" ;used to
usedn't	End	"AUX(used)+AV(not)"
shall	End	"AUX(shall)"
shan't	End	"AUX(shall)+AV(not)"
should	End	"AUX(should)"
shouldn't	End	"AUX(should)+AV(not)"
will	End	"AUX(will)"
won't	End	"AUX(will)+AV(not)"
would	End	"AUX(would)"
wouldn't	End	"AUX(would)+AV(not)"
must	End	"AUX(must)"
mustn't	End	"AUX(must)+AV(not)"

;misc. negative contractions
didn't	End	"V/AUX(do).PST+AV(not)"
doesn't	End	"V/AUX/AUX(do).3SG+AV(not)"
don't	End	"V/AUX(do)+AV(not)"
needn't	End	"V(need)+AV(not)"

;archaic forms
canst	End	"AUX(can)+2SG"
couldest	End	"AUX(could)+2SG"
didst	End	"V/AUX(do).PST.2SG"
doest	End	"V/AUX(do).2SG"
dost	End	"V/AUX(do).2SG"
doeth	End	"V/AUX(do).3SG"
doth	End	"V/AUX(do).3SG"
hadst	End	"V/AUX(have).PST.2SG"
hast	End	"V/AUX(have).2SG"
hath	End	"V/AUX(have).3SG"
mayest	End	"AUX(may)+2SG"
mightest	End	"AUX(might)+2SG"
oughtest	End	"AUX(ought)+2SG"
shalt	End	"AUX(shall)+2SG"
shouldest	End	"AUX(should)+2SG"
wast	End	"AUX(be).PST.2SG"
wert	End	"AUX(be).PST.2SG"
wilt	End	"AUX(will)+2SG"
wouldst	End	"AUX(would)+2SG"
wouldest	End	"AUX(would)+2SG"
would'st	End	"AUX(would)+2SG"

LEXICON VERB
;DO as a full verb can take prefixes
do	End	"V/AUX(do)"
does	End	"V/AUX(do).3SG"
`doing	PTC_SUFFIX	"V/AUX(do)+PRG"
did	End	"V/AUX(do).PST"
done	PTC_SUFFIX	"V/AUX(do).PTC"

;irregular verbs
a`bide	V	"V"
a`bode	End	"V(a`bide).PTC" ;PST/PTC
;a`bode	End	"V(a`bide).PTC"
a`rise	V	"V"
a`rose	End	"V(a`rise).PST"
a`risen	End	"V(a`rise).PTC"
a`wake	V	"V"
a`woke	End	"V(a`wake).PST"
a`woken	End	"V(a`wake).PTC"
`babysit	V	"V"
`babysat	End	"V(`babysit).PTC" ;PST/PTC
;`babysat	End	"V(`babysit).PTC"
`bear	V	"V"
`bore	End	"V(`bear).PST"
`borne	End	"V(`bear).PTC"
`beat	V	"V"
`beat	End	"V(`beat).PTC" ;PST/PTC
;`beat	End	"V(`beat).PTC"
`beaten	End	"V(`beat).PTC"
be`come	V	"V"
be`came	End	"V(be`come).PST"
be`come	End	"V(be`come).PTC"
be`fall	V	"VR2+V(`fall)"
be`fell	End	"VR2+V(`fall).PST"
be`fallen	End	"VR2+V(`fall).PTC"
be`get	V	"V"
be`got	End	"V(be`get).PST"
be`gat	End	"V(be`get).PST"
be`gotten	End	"V(be`get).PTC"
be`gin	V	"V"
be`gan	End	"V(be`gin).PST"
be`gun	End	"V(be`gin).PTC"
be`gird	V	"V"
be`girt	End	"V(be`gird).PST"
be`hold	V	"V"
be`held	End	"V(be`hold).PTC" ;PST/PTC
;be`held	End	"V(be`hold).PTC"
`bend	V-to-N	"V"
`bent	End	"V(`bend).PTC" ;PST/PTC
;`bent	End	"V(`bend).PTC"
be`reave	V	"V"
be`reft	End	"V(be`reave).PTC" ;PST/PTC
;be`reft	End	"V(be`reave).PTC"
be`seech	V	"V"
be`sought	End	"V(be`seech).PTC" ;PST/PTC
;be`sought	End	"V(be`seech).PTC"
be`set	V	"V"
be`set	End	"V(be`set).PTC" ;PST/PTC
;be`set	End	"V(be`set).PTC"
be`speak	V	"VR2+V(`stride)"
be`spoke	End	"VR2+V(`stride).PST"
be`spoken	End	"VR2+V(`stride).PTC"
be`stride	V	"VR2+V(`stride)"
be`strode	End	"VR2+V(`stride).PTC" ;PST/PTC
;be`strode	End	"VR2+V(`stride).PTC"
be`stridden	End	"VR2+V(`stride).PTC"
be`strid	End	"VR2+V(`stride).PTC"
;`bet	V	"V" ;noun.lex
`bet	End	"V(`bet).PTC" ;PST/PTC
;`bet	End	"V(`bet).PTC"
be`take	V	"VR2+V(`take)"
be`took	End	"VR2+V(`take).PST"
be`taken	End	"VR2+V(`take).PTC"
be`think	V	"VR2+V(`think)"
be`thought	End	"VR2+V(`think).PTC" ;PST/PTC
;be`thought	End	"VR2+V(`think).PTC"
`bid	V-to-N	"V"
`bid	End	"V(`bid).PTC" ;PST/PTC
;`bid	End	"V(`bid).PTC"
`bade	End	"V(`bid).PTC" ;PST/PTC  ;also bad
;`bade	End	"V(`bid).PTC"
`bidden	End	"V(`bid).PTC"
`bind	V	"V"
`bound	End	"V(`bind).PTC" ;PST/PTC
;`bound	End	"V(`bind).PTC"
`bite	V	"V"
`bit	End	"V(`bite).PTC" ;PST/PTC
;`bit	End	"V(`bite).PTC"
`bitten	End	"V(`bite).PTC"
`bleed	V	"V"
`bled	End	"V(`bleed).PTC" ;PST/PTC
;`bled	End	"V(`bleed).PTC"
`blow	V	"V"
`blew	End	"V(`blow).PST"
`blown	End	"V(`blow).PTC"
`break	V-to-N	"V"
`broke	End	"V(`break).PST"
`broken	PTC_SUFFIX	"V(`break).PTC"
`breed	V-to-N	"V"
`bred	End	"V(`breed).PTC" ;PST/PTC
;`bred	End	"V(`breed).PTC"
`bring	V	"V"
`brought	End	"V(`bring).PTC" ;PST/PTC
;`brought	End	"V(`bring).PTC"
`broadcast	V-to-N	"V"
`broadcast	End	"V(`broadcast).PTC" ;PST/PTC
;`broadcast	End	"V(`broadcast).PTC"
`browbeat	V	"V"
`browbeat	End	"V(`browbeat).PTC" ;PST/PTC
;`browbeat	End	"V(`browbeat).PTC"
`browbeaten	End	"V(`browbeat).PTC"
`build	V	"V"
`built	End	"V(`build).PTC" ;PST/PTC
;`built	End	"V(`build).PTC"
`burn	V-to-N	"V"
`burnt	End	"V(`burn).PTC" ;PST/PTC
;`burnt	End	"V(`burn).PTC"
`burst	V	"V"
`burst	End	"V(`burst).PTC" ;PST/PTC
;`burst	End	"V(`burst).PTC"
`bust	V	"V" ;nonstandard
`bust	End	"V(`bust).PTC" ;PST/PTC
;`bust	End	"V(`bust).PTC"
`buy	V	"V"
`bought	End	"V(`buy).PTC" ;PST/PTC
;`bought	End	"V(`buy).PTC"
`cast	V-to-N	"V"
`cast	End	"V(`cast).PTC" ;PST/PTC
;`cast	End	"V(`cast).PTC"
`catch	V-to-N	"V"
`caught	End	"V(`catch).PTC" ;PST/PTC
;`caught	End	"V(`catch).PTC"
`chide	V	"V"
`chid	End	"V(`chide).PTC" ;PST/PTC
;`chid	End	"V(`chide).PTC"
`chidden	End	"V(`chide).PTC"
`choose	V	"V"
`chose	End	"V(`choose).PST"
`chosen	End	"V(`choose).PTC"
`cleave	V	"V"
`cleft	End	"V(`cleave).PTC" ;PST/PTC
;`cleft	End	"V(`cleave).PTC"
`clove	End	"V(`cleave).PST"
`cloven	End	"V(`cleave).PTC"
`cling	V	"V"
`clung	End	"V(`cling).PTC" ;PST/PTC
;`clung	End	"V(`cling).PTC"
`come	V	"V"
`came	End	"V(`come).PST"
`camest	End	"V(`come).PST+2SG" ;archaic
`come	End	"V(`come).PTC"
;`cost	V	"V" ;noun.lex
`cost	End	"V(`cost).PTC" ;PST/PTC
;`cost	End	"V(`cost).PTC"
`creep	V	"V"
`crept	End	"V(`creep).PTC" ;PST/PTC
;`crept	End	"V(`creep).PTC"
`cut	V-to-N	"V"
`cut	End	"V(`cut).PTC" ;PST/PTC
;`cut	End	"V(`cut).PTC"
`dare	V-to-N	"V"
`durst	End	"V(`dare).PTC" ;archaic
`deal	V-to-N	"V"
`dealt	End	"V(`deal).PTC" ;PST/PTC
;`dealt	End	"V(`deal).PTC"
deep`freeze	V	"V"
deep`froze	End	"V(deep`freeze).PST"
deep`frozen	PTC_SUFFIX	"V(deep`freeze).PTC"
`dig	V	"V"
`dug	End	"V(`dig).PTC" ;PST/PTC
;`dug	End	"V(`dig).PTC"
`dive	V-to-N	"V"
`dove	End	"V(`dive).PST"
`draw	V	"V"
`drew	End	"V(`draw).PST"
`drawn	End	"V(`draw).PTC"
`dream	V-to-N	"V"
`dreamt	End	"V(`dream).PTC" ;PST/PTC
;`dreamt	End	"V(`dream).PTC"
`drink	V-to-N	"V"
`drank	End	"V(`drink).PST"
`drunk	End	"V(`drink).PTC"
`drive	V-to-N	"V"
`drove	End	"V(`drive).PST"
`driven	End	"V(`drive).PTC"
`dwell	V	"V"
`dwelt	End	"V(`dwell).PTC" ;PST/PTC
;`dwelt	End	"V(`dwell).PTC"
`eat	V	"V"
`ate	End	"V(`eat).PST"
`eaten	End	"V(`eat).PTC"
`fall	V-to-N	"V"
`fell	End	"V(`fall).PST"
`fallen	PTC_SUFFIX	"V(`fall).PTC"
`feed	V	"V"
`fed	End	"V(`feed).PTC" ;PST/PTC
;`fed	End	"V(`feed).PTC"
`feel	V	"V"
`felt	End	"V(`feel).PTC" ;PST/PTC
;`felt	End	"V(`feel).PTC"
`fight	V-to-N	"V"
`fought	End	"V(`fight).PTC" ;PST/PTC
;`fought	End	"V(`fight).PTC"
`find	V-to-N	"V"
`found	End	"V(`find).PTC" ;PST/PTC
;`found	End	"V(`find).PTC"
`fit	V-to-N	"V"
`fit	End	"V(`fit).PTC" ;PST/PTC
`flee	V	"V"
`fled	End	"V(`flee).PTC" ;PST/PTC
;`fled	End	"V(`flee).PTC"
`fling	V	"V"
`flung	End	"V(`fling).PTC" ;PST/PTC
;`flung	End	"V(`fling).PTC"
`fly	V	"V"
`flew	End	"V(`fly).PST"
`flown	End	"V(`fly).PTC"
for`bear	V	"V"
for`bore	End	"V(for`bear).PST"
for`borne	End	"V(for`bear).PTC"
for`bid	V	"V"
for`bade	End	"V(for`bid).PST"
for`bad	End	"V(for`bid).PST"
for`bidden	PTC_SUFFIX	"V(for`bid).PTC"
for`bid	End	"V(for`bid).PTC"
`forecast	V	"V"
`forecast	End	"V(`forecast).PTC" ;PST/PTC
;`forecast	End	"V(`forecast).PTC"
fore`see	V	"V"
fore`saw	End	"V(fore`see).PST"
fore`seen	End	"V(fore`see).PTC"
fore`tell	V	"V"
fore`told	End	"V(fore`tell).PTC" ;PST/PTC
;fore`told	End	"V(fore`tell).PTC"
for`get	V	"V"
for`got	End	"V(for`get).PTC" ;PST/PTC
for`gotten	PTC_SUFFIX	"V(for`get).PTC"
;for`got	End	"V(for`get).PTC"
for`give	V	"V"
for`gave	End	"V(for`give).PST"
for`given	PTC_SUFFIX	"V(for`give).PTC"
for`go	V	"V"
for`went	End	"V(for`go).PST"
for`gone	End	"V(for`go).PTC"
for`sake	V	"V"
for`sook	End	"V(for`sake).PST"
for`saken	PTC_SUFFIX	"V(for`sake).PTC"
for`swear	V	"V"
for`swore	End	"V(for`swear).PST"
for`sworn	End	"V(for`swear).PTC"
`freeze	V-to-N	"V"
`froze	End	"V(`freeze).PST"
`frozen	PTC_SUFFIX	"V(`freeze).PTC"
`frostbite	V-to-N	"V"
`frostbit	V	"V(`frostbite).PST"
`frostbitten	PTC_SUFFIX	"V(`frostbite).PTC"
`gainsay	V	"V"
`gainsaid	End	"V(`gainsay).PTC" ;PST/PTC
;`gainsaid	End	"V(`gainsay).PTC"
`get	V	"V"
`got	End	"V(`get).PTC" ;PST/PTC
;`got	End	"V(`get).PTC"
`gotten	End	"V(`get).PTC"
`ghostwrite	V	"V"
`ghostwrote	End	"V(`ghostwrite).PST"
`ghostwritten	End	"V(`ghostwrite).PTC"
`gird	V	"V"
`girt	End	"V(`gird).PST"
`give	V	"V"
`gave	End	"V(`give).PST"
`gavest	End	"V(`give).PST+2SG" ;archaic
`given	End	"V(`give).PTC"
`go	V	"V"
`went	End	"V(`go).PST"
`gone	End	"V(`go).PTC"
`grind	V	"V"
`ground	End	"V(`grind).PTC" ;PST/PTC
;`ground	End	"V(`grind).PTC"
`grow	V	"V"
`grew	End	"V(`grow).PST"
`grown	End	"V(`grow).PTC"
`hamstring	V	"V"
`hamstrung	End	"V(`hamstring).PTC" ;PST/PTC
;`hamstrung	End	"V(`hamstring).PTC"
`handwrite	V	"V"
`handwrote	End	"V(`handwrite).PST"
`handwritten	End	"V(`handwrite).PTC"
`hang	V	"V"
`hung	End	"V(`hang).PTC" ;PST/PTC
;`hung	End	"V(`hang).PTC"
`hear	V	"V"
`heard	End	"V(`hear).PTC" ;PST/PTC
;`heard	End	"V(`hear).PTC"
`heave	V	"V"
`hove	End	"V(`heave).PTC" ;PST/PTC
;`hove	End	"V(`heave).PTC"
`hew	V	"V"
`hewn	End	"V(`hew).PTC"
`hide	V	"V"
`hid	End	"V(`hide).PTC" ;PST/PTC
;`hid	End	"V(`hide).PTC"
`hidden	PTC_SUFFIX	"V(`hide).PTC"
`hit	V-to-N	"V"
`hit	End	"V(`hit).PTC" ;PST/PTC
;`hit	End	"V(`hit).PTC"
`hold	V	"V"
`held	End	"V(`hold).PTC" ;PST/PTC
;`held	End	"V(`hold).PTC"
`housebreak	V	"V"
`housebroke	End	"V(`housebreak).PST"
`housebroken	PTC_SUFFIX	"V(`housebreak).PTC"
`hurt	V-to-N	"V"
`hurt	End	"V(`hurt).PTC" ;PST/PTC
;`hurt	End	"V(`hurt).PTC"
`inbreed	V-to-N	"V"
`inbred	End	"V(`inbreed).PTC" ;PST/PTC
;`inbred	End	"V(`inbreed).PTC"
`inset	V	"V"
`inset	End	"V(`inset).PTC" ;PST/PTC
;`inset	End	"V(`inset).PTC"
`keep	V	"V"
`kept	End	"V(`keep).PTC" ;PST/PTC
;`kept	End	"V(`keep).PTC"
`kneel	V	"V"
`knelt	End	"V(`kneel).PTC" ;PST/PTC
;`knelt	End	"V(`kneel).PTC"
`knit	V	"V"
`knit	End	"V(`knit).PTC" ;PST/PTC
;`knit	End	"V(`knit).PTC"
`know	V	"V"
`knew	End	"V(`know).PST"
`knew	End	"V(`know).PST+2SG" ;archaic
`known	End	"V(`know).PTC"
`wist	End	"V(`know).PST" ;archaic
`lay	V	"V"
`laid	End	"V(`lay).PTC" ;PST/PTC
;`laid	End	"V(`lay).PTC"
`lead	V	"V"
`led	End	"V(`lead).PTC" ;PST/PTC
;`led	End	"V(`lead).PTC"
`lean	V	"V"
`leant	End	"V(`lean).PTC" ;PST/PTC
;`leant	End	"V(`lean).PTC"
`leap	V-to-N	"V"
`leapt	End	"V(`leap).PTC" ;PST/PTC
;`leapt	End	"V(`leap).PTC"
`learn	V	"V"
`learnt	End	"V(`learn).PTC" ;PST/PTC
;`learnt	End	"V(`learn).PTC"
`leave	V	"V"
`left	End	"V(`leave).PTC" ;PST/PTC
;`left	End	"V(`leave).PTC"
`lend	V	"V"
`lent	End	"V(`lend).PTC" ;PST/PTC
;`lent	End	"V(`lend).PTC"
`let	V	"V"
`let	End	"V(`let).PTC" ;PST/PTC
;`let	End	"V(`let).PTC"
`let's	End	"V(`let)+PR(us).1PL"
`lie	V	"V"
`lying	End	"V(`lie)+PRG"
`lying	End	"N(`lie).VR0+PRG"
`lay	End	"V(`lie).PST"
`lain	End	"V(`lie).PTC"
;`light	V	"V" ;see noun.lex
`lit	End	"V(`light).PTC" ;PST/PTC
;`lit	End	"V(`light).PTC"
`lipread	V	"V"
`lipread	End	"V(`lipread).PTC" ;PST/PTC
`lose	V	"V"
`lost	PTC_SUFFIX	"V(`lose).PTC" ;PST/PTC
;`lost	PTC_SUFFIX	"V(`lose).PTC"
`make	V	"V"
`made	End	"V(`make).PTC" ;PST/PTC
`madest	End	"V(`make).PTC+2SG" ;archaic
;`made	End	"V(`make).PTC"
`mean	V	"V"
`meant	End	"V(`mean).PTC" ;PST/PTC
;`meant	End	"V(`mean).PTC"
`meet	V	"V"
`met	End	"V(`meet).PTC" ;PST/PTC
;`met	End	"V(`meet).PTC"
me`think	V	"V"
me`thought	End	"V(me`think).PTC" ;PST/PTC
;me`thought	End	"V(me`think).PTC"
`mow	V	"V"
`mown	End	"V(`mow).PTC"
off`set	V	"V"
off`set	End	"V(off`set).PTC" ;PST/PTC
;off`set	End	"V(off`set).PTC"
par`take	V	"V"
par`took	End	"V(par`take).PST"
par`taken	End	"V(par`take).PTC"
`pay	V	"V"
`paid	End	"V(`pay).PTC" ;PST/PTC
;`paid	End	"V(`pay).PTC"
`plead	V	"V"
`pled	End	"V(`plead).PTC" ;PST/PTC
;`pled	End	"V(`plead).PTC"
`proofread	V	"V"
`proofread	End	"V(`proofread).PTC" ;PST/PTC
`prove	V	"V"
`proven	End	"V(`prove).PTC"
`put	V	"V"
`put	End	"V(`put).PTC" ;PST/PTC
;`put	End	"V(`put).PTC"
`quit	V	"V"
`quit	End	"V(`quit).PTC" ;PST/PTC
;`quit	End	"V(`quit).PTC"
`quoth	End	"V.PTC"
`read	V	"V"
`read	End	"V(`read).PTC" ;PST/PTC
;`read	End	"V(`read).PTC"
`rid	V	"V"
`rid	End	"V(`rid).PTC" ;PST/PTC
;`rid	End	"V(`rid).PTC"
`ride	V	"V"
`rode	End	"V(`ride).PST"
`ridden	End	"V(`ride).PTC"
`ring	V	"V"
`rang	End	"V(`ring).PST"
`rung	End	"V(`ring).PST"
`rung	End	"V(`ring).PTC"
`rise	V	"V"
`rose	End	"V(`rise).PST"
`risen	End	"V(`rise).PTC"
`rive	V	"V"
`riven	V	"V(`rive).PST"
`run	V	"V"
`ran	End	"V(`run).PST"
`run	End	"V(`run).PTC"
;`saw	V	"V"
`sawn	End	"N(`saw).VR0.PTC"
`say	V	"V"
`said	End	"V(`say).PTC" ;PST/PTC
;`said	End	"V(`say).PTC"
`saith	End	"V(`say).PTC.3SG" ;archaic
`see	V	"V"
`saw	End	"V(`see).PST"
`seen	End	"V(`see).PTC"
`seek	V	"V"
`sought	End	"V(`seek).PTC" ;PST/PTC
;`sought	End	"V(`seek).PTC"
`sell	V	"V"
`sold	End	"V(`sell).PTC" ;PST/PTC
;`sold	End	"V(`sell).PTC"
`send	V	"V"
`sent	End	"V(`send).PTC" ;PST/PTC
;`sent	End	"V(`send).PTC"
`set	V	"V"
`set	End	"V(`set).PTC" ;PST/PTC
;`set	End	"V(`set).PTC"
`sew	V	"V"
`sewn	End	"V(`sew).PTC"
`shake	V-to-N	"V"
`shook	End	"V(`shake).PST"
`shaken	End	"V(`shake).PTC"
`shave	V-to-N	"V"
`shaven	End	"V(`shave).PTC"
`shear	V	"V"
`shorn	End	"V(`shear).PTC"
`shed	V	"V"
`shed	End	"V(`shed).PTC" ;PST/PTC
;`shed	End	"V(`shed).PTC"
`shine	V-to-N	"V"
`shone	End	"V(`shine).PTC" ;PST/PTC
;`shone	End	"V(`shine).PTC"
;`shoe	V	"V"
`shod	End	"V(`shoe).PTC" ;PST/PTC
;`shod	End	"V(`shoe).PTC"
`shoot	V	"V"
`shot	End	"V(`shoot).PTC" ;PST/PTC
;`shot	End	"V(`shoot).PTC"
`show	V	"V"
`shown	End	"V(`show).PTC"
`shew	V	"V"             ;archaic
`shewn	End	"V(`shew).PTC"  ;archaic
`shred	V-to-N	"V"
`shred	End	"V(`shred).PTC" ;PST/PTC
;`shred	End	"V(`shred).PTC"
`shrink	V	"V"
`shrank	End	"V(`shrink).PST"
`shrunk	End	"V(`shrink).PTC"
`shrive	V	"V"
`shrove	End	"V(`shrive).PST"
`shriven	End	"V(`shrive).PTC"
`shut	V	"V"
`shut	End	"V(`shut).PTC" ;PST/PTC
;`shut	End	"V(`shut).PTC"
`sing	V	"V"
`sang	End	"V(`sing).PST"
`sung	End	"V(`sing).PTC" ;PST/PTC
;`sung	End	"V(`sing).PTC"
`sink	V	"V"
`sank	End	"V(`sink).PST"
`sunk	End	"V(`sink).PTC" ;PST/PTC
;`sunk	End	"V(`sink).PTC"
`sit	V	"V"
`sat	End	"V(`sit).PTC" ;PST/PTC
;`sat	End	"V(`sit).PTC"
`slay	V	"V"
`slew	End	"V(`slay).PST"
`slain	End	"V(`slay).PTC"
`sleep	V-to-N	"V"
`slept	End	"V(`sleep).PTC" ;PST/PTC
;`slept	End	"V(`sleep).PTC"
`slide	V	"V"
`slid	End	"V(`slide).PTC" ;PST/PTC
;`slid	End	"V(`slide).PTC"
`sling	V	"V"
`slung	End	"V(`sling).PTC" ;PST/PTC
;`slung	End	"V(`sling).PTC"
`slink	V	"V"
`slunk	End	"V(`slink).PTC" ;PST/PTC
;`slunk	End	"V(`slink).PTC"
`slit	V-to-N	"V"
`slit	End	"V(`slit).PTC" ;PST/PTC
;`slit	End	"V(`slit).PTC"
`smell	V-to-N	"V"
`smelt	End	"V(`smell).PTC" ;PST/PTC
;`smelt	End	"V(`smell).PTC"
`smite	V	"V"
`smote	End	"V(`smite).PST"
`smitten	End	"V(`smite).PTC"
`sow	V	"V"
`sown	End	"V(`sow).PTC"
`speak	V	"V"
`spoke	End	"V(`speak).PST"
`spoken	End	"V(`speak).PTC"
`spake	End	"V(`speak).PST"
;`speed	V	"V"
`sped	End	"V(`speed).PTC" ;PST/PTC
;`sped	End	"V(`speed).PTC"
`spell	V	"V"
`spelt	End	"V(`spell).PTC" ;PST/PTC
;`spelt	End	"V(`spell).PTC"
`spend	V	"V"
`spent	End	"V(`spend).PTC" ;PST/PTC
;`spent	End	"V(`spend).PTC"
`spill	V-to-N	"V"
`spilt	End	"V(`spill).PTC" ;PST/PTC
;`spilt	End	"V(`spill).PTC"
`spin	V-to-N	"V"
`span	End	"V(`spin).PST"
`spun	End	"V(`spin).PTC" ;PST/PTC
;`spun	End	"V(`spin).PTC"
`spit	V-to-N	"V"
`spit	End	"V(`spit).PTC" ;PST/PTC
;`spit	End	"V(`spit).PTC"
`spat	End	"V(`spit).PTC" ;PST/PTC
;`spat	End	"V(`spit).PTC"
`split	V-to-N	"V"
`split	End	"V(`split).PTC" ;PST/PTC
;`split	End	"V(`split).PTC"
`spoil	V	"V"
`spoilt	End	"V(`spoil).PTC" ;PST/PTC
;`spoilt	End	"V(`spoil).PTC"
`spread	V	"V"
`spread	End	"V(`spread).PTC" ;PST/PTC
;`spread	End	"V(`spread).PTC"
`spring	V	"V"
`sprang	End	"V(`spring).PST"
`sprung	End	"V(`spring).PTC"
`stand	V	"V"
`stood	End	"V(`stand).PTC" ;PST/PTC
;`stood	End	"V(`stand).PTC"
`steal	V-to-N	"V"
`stole	End	"V(`steal).PST"
`stolen	End	"V(`steal).PTC"
`stick	V	"V"
`stuck	End	"V(`stick).PTC" ;PST/PTC
;`stuck	End	"V(`stick).PTC"
`sting	V-to-N	"V"
`stung	End	"V(`sting).PTC" ;PST/PTC
;`stung	End	"V(`sting).PTC"
`stink	V-to-N	"V"
`stank	End	"V(`stink).PST"
`stunk	End	"V(`stink).PTC" ;PST/PTC
;`stunk	End	"V(`stink).PTC"
`strew	V	"V"
`strewn	End	"V(`strew).PTC"
`stride	V	"V"
`strode	End	"V(`stride).PTC" ;PST/PTC
;`strode	End	"V(`stride).PTC"
`stridden	End	"V(`stride).PTC"
`strid	End	"V(`stride).PTC"
`strike	V-to-N	"V"
`struck	End	"V(`strike).PTC" ;PST/PTC
;`struck	End	"V(`strike).PTC"
`stricken	End	"V(`strike).PTC"
`string	V	"V"
`strung	End	"V(`string).PTC" ;PST/PTC
;`strung	End	"V(`string).PTC"
`strive	V	"V"
`strove	End	"V(`strive).PST"
`striven	End	"V(`strive).PTC"
`swear	V	"V"
`swore	End	"V(`swear).PST"
`sworn	End	"V(`swear).PTC"
`sware	End	"V(`swear).PST" ;archaic
`sweat	V	"V"
`sweat	End	"V(`sweat).PTC" ;PST/PTC
;`sweat	End	"V(`sweat).PTC"
`sweep	V	"V"
`swept	End	"V(`sweep).PTC" ;PST/PTC
;`swept	End	"V(`sweep).PTC"
`swell	V	"V"
`swollen	PTC_SUFFIX	"V(`swell).PTC"
`swim	V	"V"
`swam	End	"V(`swim).PST"
`swum	End	"V(`swim).PTC" ;PST/PTC
;`swum	End	"V(`swim).PTC"
`swing	V	"V"
`swung	End	"V(`swing).PTC" ;PST/PTC
;`swung	End	"V(`swing).PTC"
`take	V	"V"
`took	End	"V(`take).PST"
`taken	PTC_SUFFIX	"V(`take).PTC"
`teach	V	"V"
`taught	End	"V(`teach).PTC" ;PST/PTC
;`taught	End	"V(`teach).PTC"
`tear	V-to-N	"V"
`tore	End	"V(`tear).PST"
`torn	End	"V(`tear).PTC"
`telecast	V-to-N	"V"
`telecast	End	"V(`telecast).PTC" ;PST/PTC
;`telecast	End	"V(`telecast).PTC"
`tell	V	"V"
`told	End	"V(`tell).PTC" ;PST/PTC
;`told	End	"V(`tell).PTC"
`think	V	"V"
`thought	End	"V(`think).PTC" ;PST/PTC
;`thought	End	"V(`think).PTC"
`thrive	V	"V"
`throve	End	"V(`thrive).PST"
`thriven	End	"V(`thrive).PTC"
`throw	V-to-N	"V"
`threw	End	"V(`throw).PST"
`thrown	End	"V(`throw).PTC"
`thrust	V-to-N	"V"
`thrust	End	"V(`thrust).PTC" ;PST/PTC
;`thrust	End	"V(`thrust).PTC"
`tread	V-to-N	"V"
`trod	End	"V(`tread).PTC" ;PST/PTC
;`trod	End	"V(`tread).PTC"
`trodden	End	"V(`tread).PTC"
`typeset	V	"V"
`typeset	End	"V(`typeset).PTC" ;PST/PTC
`typewrite	V	"V"
`typewrote	End	"V(`typewrite).PST"
`typewritten	End	"V(`typewrite).PTC"
under`stand	V	"V"
under`stood	End	"V(under`stand).PTC" ;PST/PTC
;under`stood	End	"V(under`stand).PTC"
up`hold	V	"V"
up`held	End	"V(up`hold).PTC" ;PST/PTC
;up`held	End	"V(up`hold).PTC"
up`rise	V	"V"
up`rose	End	"V(up`rise).PST"
up`risen	End	"V(up`rise).PTC"
up`set	V	"V"
up`set	End	"V(up`set).PTC" ;PST/PTC
;up`set	End	"V(up`set).PTC"
`wake	V	"V"
`woke	End	"V(`wake).PST"
`woken	End	"V(`wake).PTC"
`waylay	V	"V"
`waylaid	End	"V(`waylay).PTC" ;PST/PTC
;`waylaid	End	"V(`waylay).PTC"
`wear	V	"V"
`wore	End	"V(`wear).PST"
`worn	End	"V(`wear).PTC"
`weave	V	"V"
`wove	End	"V(`weave).PST"
`woven	End	"V(`weave).PTC"
`wed	V	"V"
`wed	End	"V(`wed).PTC" ;PST/PTC
;`wed	End	"V(`wed).PTC"
`weep	V	"V"
`wept	End	"V(`weep).PTC" ;PST/PTC
;`wept	End	"V(`weep).PTC"
`wet	V	"V"
`wet	End	"V(`wet).PTC" ;PST/PTC
;`wet	End	"V(`wet).PTC"
`win	V-to-N	"V"
`won	End	"V(`win).PTC" ;PST/PTC
;`won	End	"V(`win).PTC"
`wind	V	"V"
`wound	End	"V(`wind).PTC" ;PST/PTC
;`wound	End	"V(`wind).PTC"
with`draw	V	"V"
with`drew	End	"V(with`draw).PST"
with`drawn	End	"V(with`draw).PTC"
with`hold	V	"V"
with`held	End	"V(with`hold).PTC" ;PST/PTC
;with`held	End	"V(with`hold).PTC"
with`stand	V	"V"
with`stood	End	"V(with`stand).PTC" ;PST/PTC
;with`stood	End	"V(with`stand).PTC"
`wring	V	"V"
`wrung	End	"V(`wring).PTC" ;PST/PTC
;`wrung	End	"V(`wring).PTC"
`write	V	"V"
`wrote	End	"V(`write).PST"
`written	End	"V(`write).PTC"

;regular verbs
a`bandon	V	"V"
a`base	V	"V"
a`bash	V	"V"
a`bate	V	"V"
ab`breviate	V	"V"
`abdicate	V	"V"
ab`duct	V	"V"
`aberrate	V	"V"
a`bet	V	"V"
ab`hor	V	"V"
ab`jure	V	"V"
ab`late	V	"V"
a`bolish	V	"V"
a`bominate	V	"V"
a`bort	V	"V"
a`bound	V	"V"
a`brade	V	"V"
abre`act	V	"V"
a`bridge	V	"V"
`abrogate	V	"V"
ab`scond	V	"V"
ab`solve	V	"V"
ab`sorb	V	"V"
ab`stain	V	"V"
ab`stract	V	"V"
a`buse	V	"V" ;a`byuz
a`but	V	"V"
ac`cede	V	"V"
ac`celerate	V	"V"
ac`centuate	V	"N(`accent)+VR3"
ac`cept	V	"V"
ac`claim	V	"V"
`acclimate	V	"V"
ac`climatise	V	"V"
ac`climatize	V	"V"
ac`commodate	V	"V"
ac`company	V	"V"
ac`complish	V	"V"
ac`cord	V-to-N	"V"
ac`cost	V	"V"
ac`count	V	"V"
ac`credit	V	"V"
ac`crete	V	"V"
ac`crue	V	"V"
ac`culturate	V	"V"
ac`cumulate	V	"V"
ac`cuse	V	"V"
ac`custom	V	"V"
`ache	V-to-N	"V"
a`chieve	V	"V"
ac`knowledge	V	"V"
ac`quaint	V	"V"
acqui`esce	V	"V"
ac`quire	V	"V"
ac`quit	V	"V"
`act	V-to-N	"V"
`activate	V	"V(`act)+AJR26+VR3"
`actuate	V	"V"
a`dapt	V	"V"
`add	V	"V"
ad`dict	V	"V"
`addle	V	"V"
ad`dress	V	"N(`address).VR0"
ad`duce	V	"V"
ad`here	V	"V"
ad`join	V	"V"
ad`journ	V	"V"
ad`judicate	V	"V"
ad`judge	V	"V"
ad`jure	V	"V"
ad`just	V	"V"
ad`minister	V	"V"
ad`ministrate	V	"V(ad`minister)+VR3"
ad`mire	V	"V"
ad`mit	V	"V"
ad`mix	V	"V"
ad`monish	V	"V"
a`dopt	V	"V"
a`dore	V	"V"
a`dorn	V	"V"
ad`sorb	V	"V"
`adulate	V	"V"
a`dulterate	V	"V"
a`dumbrate	V	"V"
ad`vance	V	"V"
ad`vert	V	"V"
`advertise	V	"V"
ad`vise	V	"V"
`advocate	V	"V" ;[-eyt]
`aerate	V	"V"
af`fect	V	"V"
af`fiance	V	"V"
af`filiate	V-to-N	"V"
af`firm	V	"V"
af`fix	V	"V"
af`flict	V	"V"
af`ford	V	"V"
af`forest	V	"V"
af`fright	V-to-N	"V" ;archaic
af`front	V-to-N	"V"
ag`glomerate	V	"V"
ag`glutinate	V	"V"
ag`grandise	V	"V"
ag`grandize	V	"V"
`aggravate	V	"V"
ag`grieve	V	"V"
`agitate	V	"V"
a`gree	V	"V"
`aid	V-to-N	"V"
`ail	V	"V"
`aim	V-to-N	"V"
`airdrop	V	"V"
`airlift	V	"V"
`airmail	V	"V"
a`larm	V-to-N	"V"
`alienate	V	"N(`alien)+VR3"
a`light	V	"V"
a`lign	V	"V"
al`lay	V	"V"
al`lege	V	"V"
al`leviate	V	"V"
al`literate	V	"V"
`allocate	V	"V"
al`lot	V	"V"
al`low	V	"V"
al`lude	V	"V"
al`lure	V	"V"
al`ly	V-to-N	"V"
`alter	V	"V"
`altercate	V	"V"
`alternate	V-to-N	"V"
a`malgamate	V	"N(a`malgam)+VR3"
a`mass	V	"V"
a`maze	V	"V"
`amble	V	"V"
`ambulate	V	"V"
`ambush	V-to-N	"V"
a`meliorate	V	"V"
a`mend	V	"V"
`amortize	V	"V"
`amputate	V	"V"
a`muse	V	"V"
`analyse	V	"V" ;British
`analyze	V	"V"
a`nesthetize	V	"V"
`anglicise	V	"V" ;British
`anglicize	V	"V"
`angle	V	"V" ;fish
animad`vert	V	"V"
`animate	V	"V" ;[-eyt]
an`neal	V	"V"
an`nex	V	"V"
an`nihilate	V	"V"
`annotate	V	"V"
an`nounce	V	"V"
an`noy	V	"V"
an`nul	V	"V"
an`nunciate	V	"V"
a`noint	V	"V"
`answer	V-to-N	"V"
an`ticipate	V	"V"
`antiquate	V	"V"
a`pologise	V	"N(a`pology)+VR6" ;British
a`pologize	V	"N(a`pology)+VR6"
ap`pall	V	"V"
ap`peal	V	"V"
ap`pear	V	"V"
ap`pease	V	"V"
ap`pend	V	"V"
apper`tain	V	"V"
ap`plaud	V	"V"
ap`ply	V	"V"
ap`point	V	"V"
ap`portion	V	"V"
ap`praise	V	"V"
ap`preciate	V	"V"
appre`hend	V	"V"
ap`prise	V	"V"
ap`proach	V-to-N	"V"
`approbate	V	"V"
ap`propriate	V	"V" ;[-eyt]
ap`prove	V	"V"
;ap`proximate	V	"Adj(ap`proximate).VR0" ;[-eyt
`arbitrate	V	"V"
`argue	V	"V"
a`rouse	V	"V"
a`rraign	V	"V"
ar`range	V	"V"
ar`ray	V-to-N	"V"
ar`rest	V-to-N	"V"
ar`rive	V	"V"
`arrogate	V	"V"
;ar`ticulate	V	"V" ;[-eyt]
as`cend	V	"V"
ascer`tain	V	"V"
as`cribe	V	"V"
`ask	V	"V"
as`phyxiate	V	"V"
`aspirate	V	"V" ;[-eyt]
as`pire	V	"V"
as`sail	V	"V"
as`sassinate	V	"N(as`sassin)+VR3"
as`sault	V-to-N	"V"
as`say	V	"V"
as`semble	V	"V"
as`sent	V-to-N	"V"
as`sert	V	"V"
as`sess	V	"V"
as`sign	V	"V"
as`similate	V	"V"
as`sist	V	"V"
as`sociate	V	"V"
as`sort	V	"V"
as`suage	V	"V"
as`sume	V	"V"
as`sure	V	"V"
as`tonish	V	"V"
as`tound	V	"V"
a`tone	V	"V"
`atrophy	V	"V"
at`tach	V	"V"
at`tack	V-to-N	"V"
at`tain	V	"V"
at`tempt	V-to-N	"V"
at`tend	V	"V"
at`tenuate	V	"V"
at`test	V	"V"
at`tract	V	"V"
at`tribute	V	"V"
at`tune	V	"V"
`audit	V-to-N	"V"
aug`ment	V	"V"
`augur	V	"V"
au`thenticate	V	"AJ(au`thentic)+VR3"
`authorise	V	"V"
`authorize	V	"V"
`automate	V	"V"
a`vail	V	"V"
a`vast	Clitics	"V" ;only imperative
a`venge	V	"V"
a`ver	V	"V"
a`vert	V	"V"
`aviate	V	"V"
a`void	V	"V"
a`vow	V	"V"
a`wait	V	"V"
a`waken	V	"V"
a`ward	V-to-N	"V"

`babble	V	"V"
`backbite	V	"V"
`backfill	V	"V"
`backorder	V	"V"
`backscatter	V	"V"
`backstitch	V	"V"
`backtrack	V	"V"
`backup	V-to-N	"V"
`baffle	V	"V"
`bail	V	"V"
`bake	V	"V"
`balance	V	"V"
`balk	V-to-N	"V"
bam`boozle	V	"V"
`ban	V-to-N	"V"
`bandy	V	"V"
`bang	V-to-N	"V"
`banish	V	"V"
`banter	V-to-N	"V"
`baptize	V	"V"
`barbecue	V-to-N	"V"
`bare	V	"V"
`barge	V	"V"
`bark	V-to-N	"V"
`barkeep	V	"V"
`barnstorm	V	"V"
`barter	V	"V"
`bash	V-to-N	"V"
`bask	V	"V"
`baste	V	"V"
`bathe	V	"V"
`batten	V	"V"
`batter	V	"V"
`bawl	V	"V"
`bay	V	"V"
`beachcomb	V	"V"
be`atify	V	"V"
`beautify	V	"N(`beauty)+VR5"
be`calm	V	"VR2+AJ(`calm)"
`beckon	V	"V"
be`cloud	V	"VR2+N(`cloud)"
be`dazzle	V	"VR2+V(`dazzle)"
be`daub	V	"VR2+V(`daub)"
be`deck	V	"VR2+V(`deck)"
be`devil	V	"VR2+N(`devil)"
be`dim	V	"VR2+AJ(`dim)"
be`draggle	V	"V"
`beep	V-to-N	"V"
be`fit	V	"V"
be`fog	V	"VR2+N(`fog)"
be`fool	V	"VR2+N(`fool)"
be`foul	V	"VR2+AJ(`foul)"
be`friend	V	"VR2+N(`friend)"
be`fuddle	V	"VR2+V(`fuddle)"
`beg	V	"V"
be`gone	Clitics	"V" ;only imperative
be`grime	V	"VR2+N(`grime)"
be`grudge	V	"VR2+N(`grudge)"
be`guile	V	"V"
be`have	V	"V"
be`head	V	"VR2+N(`head)"
be`hoove	V	"V"
be`hove	V	"V"
be`labor	V	"VR2+V(`labor)"
be`labour	V	"VR2+V(`labour)" ;British
be`lay	V	"V"
`belch	V-to-N	"V"
be`leaguer	V	"V"
be`lie	V	"VR2+N(`lie)"
be`lying	V	"VR2+N(`lie)+PRG"
be`lieve	V	"V"
be`little	V	"VR2+AJ(`little)"
`bellow	V-to-N	"V"
be`long	V	"V"
be`madden	V	"VR2+AJ(`mad)+VR4"
be`moan	V	"VR2+V(`moan)"
be`muse	V	"V"
be`night	V	"VR2+N(`night)"
be`plaster	V	"VR2+N(`plaster)"
be`queath	V	"V"
be`rate	V	"V"
be`ribbon	V	"VR2+N(`ribbon)"
be`siege	V	"VR2+N(`siege)"
be`smirch	V	"V"
be`sot	V	"V"
be`smear	V	"VR2+V(`smear)"
be`spatter	V	"VR2+V(`spatter)"
be`streak	V	"VR2+N(`streak)"
be`stir	V	"VR2+V(`stir)"
be`stow	V	"V"
be`tide	V	"V"
be`token	V	"V"
be`tray	V	"V"
be`troth	V	"V"
`better	V	"AJ(`good).CMP.VR0"
be`wail	V	"VR2+V(`wail)"
be`ware	Clitics	"V" ;only imperative
be`whisker	V	"VR2+N(`whisker)"
be`wilder	V	"V"
be`witch	V	"VR2+N(`witch)"
`bicker	V	"V"
`bide	V	"V"
`bifurcate	V	"V"
`bilk	V	"V"
`birdwatch	V	"V"
`bisect	V	"V"
bi`variate	V	"V"
`blab	V	"V"
`blackball	V	"V"
`blackmail	V	"V"
`blame	V-to-N	"V"
`blanch	V	"V"
`blandish	V	"V"
`blare	V	"V"
`blaspheme	V	"V"
`blat	V	"V"
`blazon	V	"V"
`bleach	V-to-N	"V"
`bleat	V	"V"
`blend	V-to-N	"V"
`bless	V	"V"
`blink	V-to-N	"V"
`bloat	V	"V"
block`ade	V	"V"
`bloody	V	"N(`blood)+AJR14.VR0"
`bloom	V-to-N	"V"
`blubber	V	"V"
`bludgeon	V	"V"
`bluff	V-to-N	"V"
`blunder	V-to-N	"V"
`blur	V-to-N	"V"
`blurt	V	"V"
`blush	V	"V"
`bluster	V	"V"
`board	V	"V"
`boast	V-to-N	"V"
`bob	V	"V"
`bobble	V	"V"
`bode	V	"V"
`boggle	V	"V"
`boil	V-to-N	"V" ;as water
`bolster	V	"V"
`bolt	V	"V" ;run away
bom`bard	V	"V"
`boom	V-to-N	"V" ;make noise
`boost	V-to-N	"V"
`bootleg	V	"V"
`bore	V-to-N	"V" ;make hole
;`bore	V-to-N	"V" ;uninteresting
`borrow	V	"V"
`botch	V	"V"
`bother	V-to-N	"V"
`bounce	V-to-N	"V"
`bound	V	"V"
`bow	V-to-N	"V" ;[baw] bend over
`bowdlerize	V	"V"
`bowl	V	"V"
`boycott	V-to-N	"V"
`brag	V	"V"
`braid	V-to-N	"V"
`brainwash	V	"V"
`brandish	V	"V"
`brawl	V-to-N	"V"
`bray	V	"V"
`breathe	V	"V"
`brew	V-to-N	"V"
`brief	V	"V"
`brim	V	"V" ;derived from noun?
`broach	V	"V"
`broil	V	"V"
`browbeat	V	"V"
`browse	V	"V"
`bruise	V-to-N	"V"
`buck	V-to-N	"V" ;throw
`budge	V	"V"
`buffet	V	"V"
`bug	V	"V" ;irritate
`bulge	V-to-N	"V"
`bulldoze	V	"V"
`bumble	V	"V"
`bunt	V	"V"
`bungle	V	"V"
`burble	V	"V"
`burgeon	V	"V"
`burnish	V-to-N	"V"
`burp	V-to-N	"V"
`bury	V	"V"
`buss	V	"V"
`bushwhack	V	"V"
`bustle	V	"V"
`butcher	V-to-N	"V"
`butt	V	"V"
`buzz	V-to-N	"V"
`bypass	V-to-N	"V"

`cackle	V-to-N	"V"
ca`jole	V	"V"
`calcify	V	"V"
`calculate	V	"V"
`calibrate	V	"N(`caliber)+VR3"
`call	V-to-N	"V"
ca`lumniate	V	"N(`calumny)+VR3"
`calve	V	"V"
`cancel	V	"V"
`canvass	V	"V"
`caper	V-to-N	"V"
ca`pitulate	V	"V"
`capsize	V	"V"
`captivate	V	"V"
`capture	V-to-N	"V"
`carbonate	V	"N(`carbon)+VR3"
`care	V-to-N	"V"
ca`reen	V	"V"
ca`ress	V-to-N	"V"
ca`rouse	V	"V"
`carp	V	"V" ;complain
`carry	V	"V"
`carve	V	"V"
`castigate	V	"V"
`castrate	V	"V"
`catechize	V	"V"
`categorize	V	"N(`category)+VR6"
`catenate	V	"V"
`cater	V	"V"
`cause	V-to-N	"V"
`cavil	V	"V"
`cavitate	V	"V"
ca`vort	V	"V"
`caw	V	"V"
`cease	V-to-N	"V"
`cede	V	"V"
`celebrate	V	"V"
`cense	V	"V"
`censure	V	"V"
`cerebrate	V	"V"
`certify	V	"V"
`chafe	V	"V"
`challenge	V-to-N	"V"
`chamfer	V	"V"
`champ	V	"V"
`change	V-to-N	"V"
`chant	V-to-N	"V"
`chap	V	"V"
`char	V	"V"
`charge	V-to-N	"V"
`chase	V-to-N	"V"
chas`tise	V	"V"
`chat	V-to-N	"V"
`chatter	V-to-N	"V"
`cheat	V	"V"
`check	V-to-N	"V"
`checker	V	"V"
`checkmate	V-to-N	"V"
`cherish	V	"V"
`chew	V-to-N	"V"
`chime	V-to-N	"V"
`chirp	V-to-N	"V"
`chlorinate	V	"N(chlor`ine)+VR3"
`choke	V	"V"
`chomp	V	"V"
`chop	V-to-N	"V" ;cut
`choreograph	V	"V"
`chortle	V	"V"
`christen	V	"V"
`chuck	V	"V"
`chuckle	V-to-N	"V"
`chuff	V	"V"
`chug	V	"V"
`churn	V	"V"
`circulate	V	"V"
`circumcise	V	"V"
`circumscribe	V	"V"
`circumvent	V	"V"
`cite	V	"V"
`citify	V	"N(`city)+VR5"
`clad	V	"V"
`claim	V-to-N	"V"
`clamber	V	"V"
`clamor	V-to-N	"V"
`clamour	V-to-N	"V" ;British
`clang	V	"V"
`clank	V	"V"
`clap	V-to-N	"V"
`clarify	V	"V" ;clear+ify
`clash	V-to-N	"V"
`clatter	V-to-N	"V"
`cleanse	V	"V"
`clench	V	"V"
`click	V-to-N	"V"
`climb	V	"V"
`clinch	V	"V"
`clink	V	"V"
`clip	V-to-N	"V"
`clobber	V	"V"
`clog	V	"V"
`clomp	V	"V"
`close	V	"V"
`clothe	V	"V"
`cloy	V	"V"
`cluck	V	"V"
`clutch	V	"V" ;hold
`coach	V-to-N	"V"
co`agulate	V	"V"
coa`lesce	V	"V"
`coast	V	"V"
`coax	V	"V"
`cobble	V	"V"
`cock	V	"V"
`coddle	V	"V"
co`erce	V	"V"
`cogitate	V	"V"
co`here	V	"V"
coin`cide	V	"V"
col`laborate	V	"V"
col`lapse	V-to-N	"V"
`collate	V	"V"
col`lect	V	"V"
col`lide	V	"V"
`collocate	V	"V"
col`lude	V	"V"
`colorate	V	"N(`color)+VR3"
`comb	V-to-N	"V"
`combat	V-to-N	"V"
com`bine	V	"V"
com`bust	V	"V"
com`mand	V-to-N	"V"
comman`deer	V	"V"
com`memorate	V	"V"
com`mence	V	"V"
com`mend	V	"V"
com`mingle	V	"V"
com`miserate	V	"V"
com`mit	V	"V"
com`mune	V	"V"
com`municate	V	"V"
`commutate	V	"V"
com`mute	V	"V"
com`pact	V	"V"
com`pare	V	"V"
`compass	V	"V"
com`pel	V	"V"
`compensate	V	"V"
com`pete	V	"V"
com`pile	V	"V"
com`plain	V	"V"
`complicate	V	"V"
com`ply	V	"V"
com`port	V	"V"
com`pose	V	"V"
compre`hend	V	"V"
com`press	V	"V"
com`prise	V	"V"
`compromise	V	"V"
com`pute	V	"V"
con`catenate	V	"V"
con`ceal	V	"V"
con`cede	V	"V"
con`ceive	V	"V"
`concentrate	V	"V"
con`cert	V	"V"
con`ciliate	V	"V"
con`clude	V	"V"
con`coct	V	"V"
con`cord	V	"V"
con`cur	V	"V"
con`cuss	V	"V"
con`demn	V	"V"
`condensate	V	"V"
con`dense	V	"V"
condes`cend	V	"V"
con`done	V	"V"
con`duce	V	"V"
con`duct	V	"V"
con`fabulate	V	"V"
con`fect	V	"V"
con`fer	V	"V"
con`fess	V	"V"
con`fide	V	"V"
con`figure	V	"V"
con`fine	V	"V"
con`firm	V	"V"
`confiscate	V	"V"
con`flict	V	"V"
con`form	V	"V"
con`found	V	"V"
con`front	V	"V"
con`fuse	V	"V"
con`fute	V	"V"
con`geal	V	"V"
con`gest	V	"V"
con`gratulate	V	"V"
`congregate	V	"V"
con`join	V	"V"
`conjugate	V	"V"
con`jure	V	"V"
con`nect	V	"V"
con`nive	V	"V"
con`note	V	"V"
`conquer	V	"V"
con`script	V	"V"
`consecrate	V	"V"
con`sent	V-to-N	"V"
con`serve	V	"V"
con`sider	V	"V"
con`sign	V	"V"
con`sist	V	"V"
con`sole	V	"V"
con`solidate	V	"V"
con`sort	V	"V"
con`spire	V	"V"
`constellate	V	"V"
`consternate	V	"V"
`constipate	V	"V"
`constitute	V	"V"
con`strain	V	"V"
con`strict	V	"V"
con`struct	V	"V"
con`strue	V	"V"
con`sult	V	"V"
con`sume	V	"V"
;`consummate	V	"V"
con`tain	V	"V"
con`taminate	V	"V"
`contemplate	V	"V"
con`tend	V	"V"
con`tent	V	"V"
con`test	V	"V"
con`tinue	V	"V"
con`tort	V	"V"
con`tract	V	"V"
contra`dict	V	"V"
con`trast	V	"V"
contra`vene	V	"V"
con`tribute	V	"V"
con`trive	V	"V"
con`trol	V	"V"
`controvert	V	"V"
con`tuse	V	"V"
conva`lesce	V	"V"
con`vect	V	"V"
con`vene	V	"V"
con`verge	V	"V"
con`verse	V	"V"
con`vert	V	"V"
con`vey	V	"V"
con`vict	V	"V"
con`vince	V	"V"
con`voke	V	"V"
`convolute	V	"V"
con`volve	V	"V"
con`vulse	V	"V"
`coo	V-to-N	"V"
`cook	V	"V"
co`operate	V	"V"
`cope	V	"V"
`copy	V-to-N	"V"
`correlate	V	"V"
corres`pond	V	"V"
cor`roborate	V	"V"
cor`rode	V	"V"
`corrugate	V	"V"
co`ruscate	V	"V"
`couch	V	"V"
`cough	V-to-N	"V"
`count	V-to-N	"V"
`counter	V	"V"
`countermand	V-to-N	"V"
counter`vail	V	"V"
`countrify	V	"N(`country)+VR5"
`couple	V	"V"
`course	V	"V"
`court	V	"V"
`covet	V	"V"
`cover	V-to-N	"V"
`cower	V	"V"
`cozen	V	"V"
`crack	V-to-N	"V"
`crackle	V-to-N	"V"
`craft	V	"V"
`cram	V	"V"
`cramp	V-to-N	"V"
`crash	V-to-N	"V"
`crave	V	"V"
`crawl	V	"V"
`craze	V	"V"
`creak	V-to-N	"V"
cre`ate	V	"V"
`cremate	V	"V"
`crimp	V-to-N	"V"
`cringe	V	"V"
`crinkle	V	"V"
`crisscross	V-to-N	"V"
`criss-cross	V-to-N	"V"
`croak	V-to-N	"V"
cro`chet	V	"V"
`croon	V	"V"
`crop	V	"V" ;cut short
`cross	V	"V" ;cross street
cross-ex`amine	V	"V"
`crosshatch	V	"V"
`crouch	V	"V"
`crow	V	"V" ;brag
`crucify	V	"V"
`cruise	V-to-N	"V"
`crumble	V	"V"
`crump	V	"V"
`crumple	V	"V"
`crunch	V-to-N	"V"
`crush	V	"V"
`cry	V-to-N	"V"
crypt`analyze	V	"V"
`cuddle	V	"V"
`cuff	V-to-N	"V" ;hit
`cull	V	"V"
`culminate	V	"V"
`cultivate	V	"V"
`culture	V-to-N	"V" ;grow in lab
`cumulate	V	"V"
`curb	V	"V" ;limit
`curdle	V	"V"
`curl	V-to-N	"V"
`curry	V	"V"
`curse	V-to-N	"V"
cur`tail	V	"V"
`cuss	V	"V"
`cycled	PTC_SUFFIX	"N(`cycle).VR0+PTC" ;PST/PTC
`cycling	PTC_SUFFIX	"N(`cycle).VR0+PRG"

`dabble	V	"V"
`dally	V	"V"
`damage	V-to-N	"V"
`damn	V	"V"
`dance	V-to-N	"V"
`dangle	V	"V"
`dapple	V	"V"
dare`say	V	"V" ;only 1st pres. sing.
`darkle	V	"V"
`darn	V	"V"
`dash	V-to-N	"V" ;run
`daub	V-to-N	"V"
`daunt	V	"V"
`daze	V-to-N	"V"
`dazzle	V	"V"
de`base	V	"V"
de`bate	V	"V"
de`bauch	V	"V"
de`bilitate	V	"V"
de`bunk	V	"V"
de`buted	PTC_SUFFIX	"N(de`but).VR0+PTC"
de`buting	PTC_SUFFIX	"N(de`but).VR0+PRG"
de`caffeinate	V	"REV2+N(caf`feine)+VR3"
de`cant	V	"V"
de`capitate	V	"V"
de`cay	V-to-N	"V"
de`cease	V	"V"
de`ceive	V	"V"
de`celerate	V	"REV2+V(ac`celerate)"
de`centralize	V	"REV2+N(`center)+AJR17+VR6"
de`cide	V	"V"
`decimate	V	"V"
de`cipher	V	"REV2+N(`cipher).VR0"
`deck	V	"V"
de`claim	V	"V"
de`clare	V	"V"
de`classify	V	"REV2+N(`class)+VR5"
de`cline	V-to-N	"V"
de`coct	V	"V"
de`code	V	"REV2+N(`code).VR0"
decom`mission	V	"REV2+N(com`mission).VR0"
`decorate	V	"V"
de`corticate	V	"V"
de`crease	V-to-N	"V"
`decrement	V	"V"
de`cry	V	"V"
de`crypt	V	"V"
`dedicate	V	"V"
de`duce	V	"V"
de`duct	V	"V"
`deem	V	"V"
de`face	V	"V"
de`fame	V	"V"
de`fat	V	"REV2+N(`fat).VR0"
de`feat	V-to-N	"V"
`defecate	V	"V"
de`fect	V	"V" ;turn traitor
de`fend	V	"V"
de`fer	V	"V"
de`file	V	"V"
de`fine	V	"V"
de`flate	V	"V"
de`flect	V	"V"
de`foliate	V	"V"
de`forest	V	"REV2+N(`forest).VR0"
de`form	V	"V"
de`fraud	V	"V"
de`fray	V	"V"
de`frock	V	"V"
de`frost	V	"REV2+N(`frost).VR0"
de`fuse	V	"V"
de`fy	V	"V"
de`germ	V	"REV2+N(`germ).VR0"
de`grade	V	"V"
de`grease	V	"REV2+N(`grease).VR0"
de`gum	V	"REV2+N(`gum).VR0"
de`horn	V	"REV2+N(`horn).VR0"
dehu`midify	V	"REV2+AJ(`humid)+VR5"
de`hydrate	V	"REV2+V(`hydrate)"
`deify	V	"V"
`deign	V	"V"
de`ject	V	"V"
de`lay	V-to-N	"V"
`delegate	V	"V" ;[-eyt]
de`lete	V	"V"
;de`liberate	V	"V" ;[-eyt]
de`light	V-to-N	"V"
de`limit	V	"V"
de`lineate	V	"V"
deli`quesce	V	"V"
de`liver	V	"V"
de`louse	V	"REV2+N(`louse).VR0"
de`lude	V	"V"
`delve	V	"V"
de`mand	V-to-N	"V"
de`marcate	V	"V"
de`mark	V	"V"
de`mean	V	"V"
de`mit	V	"V"
de`mobilize	V	"REV2+AJ(`mobile)+VR6"
de`molish	V	"V"
`demonstrate	V	"V"
de`moralize	V	"REV2+AJ(`moral)+VR6"
de`mote	V	"V"
de`mur	V	"V"
demy`thologize	V	"REV2+N(my`thology)+VR6"
de`nature	V	"V"
`denigrate	V	"V"
de`note	V	"V"
de`nounce	V	"V"
de`nude	V	"REV2+Adj(`nude).VR0"
de`ny	V	"V"
de`odorise	V	"REV2+N(`odor)+VR6" ;British
de`odorize	V	"REV2+N(`odor)+VR6"
de`part	V	"V"
de`pend	V	"V"
de`pict	V	"V"
de`plane	V	"REV2+N(`plane).VR0"
de`plete	V	"V"
de`plore	V	"V"
de`ploy	V	"V"
de`port	V	"V"
de`pose	V	"V"
de`posit	V-to-N	"V"
de`prave	V	"V"
`deprecate	V	"V"
de`preciate	V	"V"
`depredate	V	"V"
de`press	V	"V"
de`prive	V	"V"
de`pute	V	"V"
`deputize	V	"N(`deputy)+VR6"
de`rail	V	"V"
de`range	V	"V"
de`rate	V	"V"
de`reference	V	"REV2+N(`reference).VR0"
de`ride	V	"V"
de`rive	V	"V"
`derogate	V	"V"
de`salinate	V	"REV2+AJ(`saline)+VR3"
des`cend	V	"V"
des`cribe	V	"V"
de`scry	V	"V"
`desecrate	V	"V"
de`sert	V	"V" ;leave
de`serve	V	"V"
`desicate	V	"V"
de`sign	V-to-N	"V"
`designate	V-to-N	"V"
de`sire	V-to-N	"V"
de`sist	V	"V"
de`spair	V-to-N	"V"
de`spise	V	"V"
de`spoil	V	"V"
de`spond	V	"V"
`destine	V	"V"
de`stroy	V	"V"
de`struct	V	"V"
de`tach	V	"V"
de`tail	V	"V"
de`tain	V	"V"
de`tect	V	"V"
de`ter	V	"V"
de`teriorate	V	"V"
de`termine	V	"V"
de`test	V	"V"
de`throne	V	"REV2+N(`throne).VR0"
`detonate	V	"V"
de`toxify	V	"REV2+N(`toxin)+VR5"
de`tract	V	"V"
`devastate	V	"V"
de`velop	V	"V"
de`vein	V	"REV2+N(`vein).VR0"
`deviate	V	"V"
de`vise	V	"V"
de`volve	V	"V"
de`vote	V	"V"
de`vour	V	"V"
diag`nose	V	"V"
`dictate	V	"V"
`diddle	V	"V"
`die	V	"V"
`dying	V	"V(`die)+PRG"
`differ	V	"V"
differ`entiate	V	"Adj(`different)+VR3"
dif`fract	V	"V"
dif`fuse	V	"V"
di`gest	V	"V"
`dignify	V	"V"
di`gress	V	"V"
di`lapidate	V	"V"
`dilate	V	"V"
di`lute	V	"V"
di`minish	V	"V"
`dine	V	"V"
`dip	V-to-N	"V"
di`rect	V	"V"
dis`able	V	"REV3+AJ(`able).VR0"
disam`biguate	V	"REV3+Adj(am`biguous)+VR3"
dis`appoint	V	"V"
dis`burse	V	"V"
dis`card	V	"V"
dis`cern	V	"V"
dis`comfit	V	"V"
dis`concert	V	"V"
dis`count	V	"V"
dis`courage	V	"V"
dis`cover	V	"V"
dis`criminate	V	"V"
dis`cuss	V	"V"
disem`bowel	V	"REV3+VR1+N(`bowel)"
dis`guise	V	"V"
dis`gruntle	V	"V"
di`shevel	V	"V"
disil`lusion	V	"V"
dis`joint	V	"REV3+N(`joint).VR0"
dis`mantle	V	"V"
dis`mast	V	"REV3+N(`mast).VR0"
dis`may	V-to-N	"V"
dis`member	V	"REV3+N(`member).VR0"
dis`miss	V	"V"
dis`parage	V	"V"
dis`pel	V	"V"
dis`pense	V	"V"
dis`perse	V	"V"
dis`pose	V	"V"
dis`play	V-to-N	"V"
dis`pute	V	"V"
dis`rupt	V	"V"
dis`sect	V	"V"
dis`sent	V-to-N	"V"
dis`semble	V	"V"
dis`seminate	V	"V"
`dissipate	V	"V"
`dissertate	V	"V"
dis`sociate	V	"V"
dis`solve	V	"V"
dis`suade	V	"V"
dis`till	V	"V"
dis`tinguish	V	"V"
dis`tort	V	"V"
dis`tract	V	"V"
dis`tribute	V	"V"
dis`turb	V	"V"
`dither	V-to-N	"V"
di`verge	V	"V"
di`vert	V	"V"
di`vest	V	"V"
di`vide	V	"V"
di`vine	V	"V"
di`vorce	V-to-N	"V"
di`vulge	V	"V"
`dock	V	"V" ;shorten
`dodge	V	"V"
`doff	V	"V"
`dole	V	"V"
do`mesticate	V	"AJ(do`mestic)+VR3"
`dominate	V	"V"
domi`neer	V	"V"
`don	V	"V"
`donate	V	"V"
`dote	V	"V"
`doubt	V-to-N	"V"
`douse	V	"V"
`down	V	"V"
`downgrade	V-to-N	"V"
`download	V-to-N	"V"
`downplay	V	"V"
`downsize	V	"V"
`doze	V	"V"
`draft	V-to-N	"V" ;conscript
`drag	V	"V"
`draggle	V	"V"
`drain	V-to-N	"V"
`dramatize	V	"N(`drama)+VR6"
`drawl	V-to-N	"V"
`dread	V-to-N	"V"
`dredge	V	"V"
`drench	V	"V"
`dress	V-to-N	"V"
`dribble	V-to-N	"V"
`drift	V-to-N	"V"
`drill	V-to-N	"V"
`drip	V-to-N	"V"
`drone	V	"V"
`drool	V-to-N	"V"
`droop	V	"V"
`drop	V-to-N	"V"
`drown	V	"V"
`drowse	V	"V"
`drub	V	"V"
`dub	V	"V"
`duck	V	"V" ;lower head
`duel	V-to-N	"V"
`dump	V-to-N	"V"
`dun	V	"V"
`dunk	V-to-N	"V"
`dupe	V-to-N	"V"
`dwindle	V	"V"

`earn	V	"V"
`eavesdrop	V	"V"
`ebb	V-to-N	"V"
`echo	V-to-N	"V"
ec`lipse	V-to-N	"V"
`edify	V	"V"
`edit	V	"V"
`educate	V	"V"
ef`face	V	"V"
ef`fect	V-to-N	"V"
ef`fectuate	V	"V"
effer`vesce	V	"V"
efflo`resce	V	"V"
ef`fuse	V	"V"
e`jaculate	V	"V"
e`ject	V	"V"
`eke	V	"V"
e`lapse	V	"V"
e`late	V	"V"
e`lectrify	V	"AJ(e`lectric)+VR5"
e`lectrocute	V	"V"
`elevate	V	"V"
e`licit	V	"V"
e`lide	V	"V"
e`liminate	V	"V"
e`longate	V	"V"
e`lope	V	"V"
e`lucidate	V	"V"
e`lude	V	"V"
e`maciate	V	"V"
`emanate	V	"V"
e`mancipate	V	"V"
e`masculate	V	"V"
em`balm	V	"V"
em`bank	V	"VR1+N(`bank)"
em`battle	V	"VR1+N(`battle)"
em`bark	V	"V"
em`barrass	V	"V"
em`bed	V	"V"
em`bellish	V	"V"
em`bezzle	V	"V"
em`bitter	V	"VR1+AJ(`bitter)"
em`blazon	V	"VR1+N(`blazon)"
em`body	V	"VR1+N(`body)"
em`bolden	V	"VR1+AJ(`bold)+VR4"
em`boss	V	"V"
em`bower	V	"V"
em`brace	V	"V"
em`brittle	V	"VR1+AJ(`brittle)"
em`broider	V	"V"
em`broil	V	"V"
e`mend	V	"V"
e`merge	V	"V"
`emigrate	V	"V"
e`mit	V	"V"
`emphasize	V	"N(`emphasis)+VR6"
em`place	V	"VR1+N(`place)"
em`ploy	V	"V"
em`power	V	"VR1+N(`power)"
`emulate	V	"V"
e`mulsify	V	"V"
en`able	V	"VR1+AJ(`able)"
en`act	V	"VR1+V(`act)"
en`amor	V	"V"
en`amour	V	"V" ;British
en`camp	V	"VR1+N(`camp)"
en`capsulate	V	"VR1+N(`capsule)+VR3"
en`case	V	"VR1+N(`case)"
en`chant	V	"V"
en`circle	V	"VR1+N(`circle)"
en`close	V	"VR1+V(`close)"
en`code	V	"VR1+N(`code)"
en`compass	V	"V"
en`counter	V-to-N	"V"
en`courage	V	"VR1+N(`courage)"
en`crypt	V	"V"
en`croach	V	"V"
en`crust	V	"VR1+N(`crust)"
en`cumber	V	"V"
en`danger	V	"VR1+N(`danger)"
en`dear	V	"VR1+AJ(`dear)"
en`deavor	V-to-N	"V"
en`deavour	V-to-N	"V" ;British
en`dorse	V	"V"
en`dow	V	"V"
en`due	V	"V"
en`dure	V	"V"
`energize	V	"N(`energy)+VR6"
`enervate	V	"V"
en`feeble	V	"VR1+AJ(`feeble)"
en`fold	V	"VR1+V(`fold)"
en`force	V	"VR1+V(`force)"
en`franchise	V	"VR1+N(`franchise)"
en`gage	V	"V"
en`gender	V	"V"
engin`eer	V	"N(`engine)+NR10.VR0"
en`graft	V	"VR1+V(`graft)"
en`grave	V	"V"
en`gross	V	"V"
en`gulf	V	"V"
en`hance	V	"V"
en`join	V	"V"
en`joy	V	"VR1+N(`joy)"
en`kindle	V	"VR1+V(`kindle)"
en`large	V	"VR1+AJ(`large)"
en`lighten	V	"VR1+N(`light)+VR4"
en`liven	V	"VR1+AJ(`live)+VR4"
en`list	V	"V"
en`noble	V	"VR1+AJ(`noble)"
en`quire	V	"V"
en`rage	V	"VR1+N(`rage)"
en`rapture	V	"VR1+N(`rapture)"
en`rich	V	"VR1+AJ(`rich)"
en`roll	V	"V"
en`sanguine	V	"V"
en`sconce	V	"V"
en`shrine	V	"VR1+N(`shrine)"
en`slave	V	"VR1+N(`slave)"
en`snare	V	"VR1+N(`snare)"
en`soul	V	"VR1+N(`soul)"
en`sue	V	"V"
en`sure	V	"VR1+AJ(`sure)"
`enter	V	"V"
enter`tain	V	"V"
en`tail	V	"V"
en`tangle	V	"VR1+V(`tangle)"
en`thrall	V	"V"
en`throne	V	"VR1+N(`throne)"
en`tice	V	"V"
en`title	V	"VR1+N(`title)"
en`tomb	V	"VR1+N(`tomb)"
en`trance	V	"VR1+N(`trance)"
en`trap	V	"VR1+N(`trap)"
en`treat	V	"V"
en`trench	V	"VR1+N(`trench)"
en`trust	V	"VR1+N(`trust)"
en`twine	V	"VR1+N(`twine)"
e`numerate	V	"V"
e`nunciate	V	"V"
en`velop	V	"V"
en`visage	V	"V"
en`vision	V	"VR1+N(`vision)"
`envy	V-to-N	"V"
e`quate	V	"V"
e`quilibrate	V	"V"
e`quip	V	"V"
`equipoise	V	"V"
e`quivocate	V	"V"
e`radicate	V	"V"
e`rase	V	"V"
e`rode	V	"V"
`err	V	"V"
e`rupt	V	"V"
`escalate	V	"V"
es`cape	V-to-N	"V"
es`chew	V	"V"
es`cort	V	"V"
es`pouse	V	"V"
es`py	V	"V"
es`say	V	"V"
es`tablish	V	"V"
es`teem	V-to-N	"V"
`estimate	V-to-N	"V"
es`top	V	"V"
es`trange	V	"V"
`etch	V	"V"
`eulogize	V	"N(`eulogy)+VR6"
e`vacuate	V	"V"
e`vade	V	"V"
e`valuate	V	"V"
evan`esce	V	"V"
e`vaporate	V	"V"
e`ventuate	V	"V"
e`vict	V	"V"
e`vince	V	"V"
e`voke	V	"V"
e`volve	V	"V"
ex`acerbate	V	"V"
ex`act	V	"V"
ex`aggerate	V	"V"
ex`alt	V	"V"
ex`amine	V	"V"
ex`asperate	V	"V"
`excavate	V	"V"
ex`ceed	V	"V"
ex`cel	V	"V"
ex`cept	V	"V"
ex`change	V-to-N	"V"
ex`cise	V	"V"
ex`cite	V	"V"
ex`claim	V	"V"
ex`clude	V	"V"
excom`municate	V	"V"
ex`coriate	V	"V"
ex`crete	V	"V"
ex`cruciate	V	"V"
ex`culpate	V	"V"
ex`cuse	V-to-N	"V"
`execrate	V	"V"
`execute	V	"V"
ex`emplify	V	"V"
`exercise	V-to-N	"V"
ex`ert	V	"V"
ex`hale	V	"V"
ex`haust	V-to-N	"V"
ex`hibit	V-to-N	"V"
ex`hilarate	V	"V"
ex`hort	V	"V"
ex`hume	V	"V"
`exile	V-to-N	"V"
ex`ist	V	"V"
`exit	V-to-N	"V"
ex`onerate	V	"V"
`exorcise	V	"V"
ex`pand	V	"V"
ex`patiate	V	"V"
ex`patriate	V	"V"
ex`pect	V	"V"
ex`pectorate	V	"V"
`expedite	V	"V"
ex`pel	V	"V"
ex`pend	V	"V"
ex`perience	V-to-N	"V"
ex`periment	V-to-N	"V"
`expiate	V	"V"
ex`pire	V	"V"
ex`plain	V	"V"
`explicate	V	"V"
ex`plode	V	"V"
ex`ploit	V	"V"
ex`plore	V	"V"
expo`nentiate	V	"N(ex`ponent)+VR3"
ex`port	V	"V"
ex`pose	V	"V"
ex`posit	V	"V"
ex`pound	V	"V"
ex`press	V	"V"
ex`propriate	V	"V"
ex`punge	V	"V"
`expurgate	V	"V"
ex`sanguinate	V	"V"
ex`tend	V	"V"
ex`tenuate	V	"V"
ex`terminate	V	"V"
ex`tinguish	V	"V"
`extirpate	V	"V"
ex`tol	V	"V"
ex`tort	V	"V"
ex`tract	V	"V"
`extradite	V	"V"
ex`trapolate	V	"V"
`extricate	V	"V"
ex`trude	V	"V"
ex`ude	V	"V"
ex`ult	V	"V"

`fabricate	V	"V"
fa`cilitate	V	"V"
`fade	V	"V"
`fake	V-to-N	"V"
`fag	V	"V"
`fail	V	"V"
`faint	V	"V"
`falter	V	"V"
`famish	V	"V"
`fan	V	"V"
`fancy	V-to-N	"V"
`fantasize	V	"N(`fantasy)+VR6"
`fare	V	"V"
`farrow	V-to-N	"V"
`fascinate	V	"V"
`fast	V-to-N	"V"
;`fasten	V	"V"
`fathom	V	"V"
`favor	V-to-N	"V"
`favour	V-to-N	"V" ;British
`fawn	V	"V"
`faze	V	"V"
`fear	V-to-N	"V"
`feign	V	"V"
`feint	V	"V"
`fell	V	"V" ;fell a tree
`fend	V	"V"
fer`ment	V	"V"
`fetch	V	"V"
`fib	V-to-N	"V"
`fidget	V	"V"
`filch	V	"V"
`file	V-to-N	"V"
`filibuster	V-to-N	"V"
`fill	V	"V"
`fillip	V	"V"
`filter	V-to-N	"V"
`finish	V	"V"
`fix	V-to-N	"V"
`fixate	V	"V"
`fizzle	V	"V"
`flabbergast	V	"V"
`flagellate	V	"V"
`flag	V	"V"
`flail	V	"V"
`flap	V	"V"
`flare	V-to-N	"V"
`flash	V-to-N	"V"
`flatter	V	"V"
`flaunt	V	"V"
`fledge	V	"V"
`fletch	V	"V"
`flex	V	"V"
`flick	V	"V"
`flinch	V	"V"
`flip	V	"V"
`flipflop	V	"V"
`flirt	V-to-N	"V"
`flit	V	"V"
`float	V	"V"
`flog	V	"V"
`flop	V-to-N	"V"
`flounce	V	"V"
`flounder	V	"V"
`flourish	V	"V"
`flout	V	"V"
`flow	V-to-N	"V"
`flub	V	"V"
`fluctuate	V	"V"
`flunk	V	"V"
fluo`resce	V	"V"
`fluoridate	V	"N(`fluoride)+VR3"
`flush	V	"V"
`fluster	V	"V"
`flutter	V	"V"
`foil	V	"V"
`foist	V	"V"
`fold	V-to-N	"V"
`foliate	V	"V"
`follow	V	"V"
`foment	V	"V"
`fondle	V	"V"
`forage	V	"V"
`force	V-to-N	"V"
`ford	V	"V"
fore`bode	V	"V"
`forfend	V	"V"
`forge	V-to-N	"V"
`formulate	V	"V"
`fornicate	V	"V"
`fortify	V	"V"
`forward	V	"V"
`foster	V	"V"
`found	V	"V"
`founder	V	"V"
`fractionate	V	"N(`fraction)+VR3"
`fraternize	V	"V"
`fray	V	"V"
`frazzle	V	"V"
free`wheel	V	"V"
`fret	V	"V"
`frighten	V	"N(`fright)+VR4"
`frisk	V	"V"
`fritter	V	"V"
`frizzle	V	"V"
`frolic	V-to-N	"V"
`frolicked	PTC_SUFFIX	"V(`frolic)+PTC" ;PST/PTC
`frolicking	PTC_SUFFIX	"V(`frolic)+PRG"
`frown	V-to-N	"V"
`fructify	V	"V"
`frustrate	V	"V"
`fry	V	"V"
`fuddle	V	"V"
ful`fil	V	"V"
ful`fill	V	"V"
`fulminate	V	"V"
`fumble	V-to-N	"V"
`fumigate	V	"V"
`furbish	V	"V"
`furl	V	"V"
`furnish	V	"V"
`further	V	"V"
`fuse	V	"V"
`fuss	V-to-N	"V"

`gab	V	"V"
`gabble	V	"V"
`gad	V	"V"
`gag	V	"V"
`gain	V-to-N	"V"
`gallivant	V	"V"
`gallop	V-to-N	"V"
`galvanize	V	"V"
`gamble	V-to-N	"V"
`gambol	V	"V"
`gander	V	"V"
`gape	V	"V"
`garble	V	"V"
`gargle	V	"V"
`gasify	V	"N(`gas)+VR5" ;exception to Gemination
`gasp	V-to-N	"V"
`gather	V	"V"
`gawk	V	"V"
`gaze	V	"V"
`gee	V	"V"
`geld	V	"V"
`generate	V	"V"
`germinate	V	"V"
`gestate	V	"V"
ges`ticulate	V	"V"
`gesture	V-to-N	"V"
`gibe	V-to-N	"V"
`giddap	V	"V" ;imperative only
`giggle	V-to-N	"V"
`gild	V	"V"
`glaciate	V	"V"
`glance	V-to-N	"V"
`glare	V-to-N	"V"
`gleam	V-to-N	"V"
`glean	V	"V"
`glide	V	"V"
`glimmer	V	"V"
`glimpse	V-to-N	"V"
`glint	V	"V"
glis`sade	V-to-N	"V"
`glisten	V	"V"
`glister	V	"V"
`glitter	V	"V"
`gloat	V	"V"
`glom	V	"V"
`glorify	V	"N(`glory)+VR5"
`glow	V-to-N	"V"
`glower	V	"V"
`glycerinate	V	"N(`glycerin)+VR3"
`gnarl	V	"V"
`gnash	V	"V"
`gnaw	V	"V"
`gobble	V	"V"
`goggle	V	"V"
`goof	V-to-N	"V"
`gore	V	"V"
`gorge	V	"V"
`gouge	V	"V"
`govern	V	"V"
`grab	V-to-N	"V"
`gradate	V	"V"
`grade	V-to-N	"V"
`graduate	V-to-N	"V"
`graft	V-to-N	"V"
`grant	V-to-N	"V"
`granulate	V	"N(`granule)+VR3"
`grapple	V	"V"
`grasp	V-to-N	"V"
`grate	V	"V"
`gratify	V	"V"
`gravitate	V	"V"
`graze	V	"V"
`greet	V	"V"
`grieve	V	"V"
`grimace	V-to-N	"V"
`grin	V-to-N	"V"
`grip	V-to-N	"V"
`gripe	V-to-N	"V"
`grizzle	V	"V"
`groan	V-to-N	"V"
`grope	V	"V"
`gross	V	"V"
`grovel	V	"V"
`growl	V-to-N	"V"
`grumble	V	"V"
`grunt	V-to-N	"V"
`guard	V-to-N	"V"
`guess	V-to-N	"V"
`guide	V-to-N	"V"
`gulp	V-to-N	"V"
`gurgle	V-to-N	"V"
`gush	V	"V"
`gutter	V	"V"
`guzzle	V	"V"
`gyp	V	"V"
`gyrate	V	"V"

ha`bituate	V	"N(`habit)+VR3"
`hack	V-to-N	"V"
`hackney	V	"V"
`haggle	V	"V"
`hallow	V	"V"
hal`lucinate	V	"V"
`halt	V-to-N	"V"
`halve	V	"V"
`hamper	V	"V"
`handle	V	"V"
`hanker	V	"V"
`happen	V	"V"
ha`rangue	V-to-N	"V"
ha`rass	V	"V"
`hardboil	V	"V"
`hark	V	"V"
`harken	V	"V"
`harm	V-to-N	"V"
`harmonize	V	"N(`harmony)+VR6"
`harp	V	"V"
`harrass	V	"V"
`harrow	V	"V"
`harry	V	"V"
`harvest	V-to-N	"V"
`hassle	V-to-N	"V"
`hasten	V	"N(`haste)+VR4"
`hatch	V	"V"
`hate	V-to-N	"V"
`haul	V-to-N	"V"
`haunt	V	"V"
`hawk	V	"V"
`head	V	"V"
`headquarter	V	"V"
`heal	V	"V"
`hearken	V	"V"
`hearten	V	"V"
`heckle	V	"V"
`hector	V	"V"
`heed	V-to-N	"V"
`heel	V	"V" ;tilt
`heft	V	"V"
`heighten	V	"AJ(`high)+VR4"
`help	V-to-N	"V"
`hemorrhage	V-to-N	"V"
`henpeck	V	"V"
`herald	V-to-N	"V"
`hesitate	V	"V"
`hex	V-to-N	"V"
`hibernate	V	"V"
`hie	V	"V"
`hying	V	"V(`hie)+PRG"
`hightail	V	"V"
`hijack	V	"V"
`hinder	V	"V"
`hike	V-to-N	"V"
`hire	V	"V"
`hiss	V-to-N	"V"
`hitch	V-to-N	"V"
`hitchhike	V	"V"
`hobble	V	"V"
`hoe	V-to-N	"V"
`hoist	V-to-N	"V"
`holler	V-to-N	"V"
ho`mogenize	V	"V"
`hone	V	"V"
`honk	V-to-N	"V"
`hoodwink	V	"V"
`hoot	V-to-N	"V"
`hop	V-to-N	"V"
`hope	V-to-N	"V"
`horrify	V	"V"
`hove	V	"V"
`hover	V	"V"
`howl	V-to-N	"V"
`huddle	V	"V"
`huff	V	"V"
`hug	V-to-N	"V"
`hum	V	"V"
hu`miliate	V	"V"
`hunch	V	"V"
`hunker	V	"V"
`hunt	V-to-N	"V"
`hurl	V	"V"
`hurry	V-to-N	"V"
`hurtle	V	"V"
`hush	V-to-N	"V"
`hustle	V	"V"
`hybridize	V	"N(`hybrid).AJR0+VR6"
`hydrogenate	V	"N(`hydrogen)+VR3"
`hyped	PTC_SUFFIX	"N(`hype).VR0+PTC"
`hyping	PTC_SUFFIX	"N(`hype).VR0+PRG"
`hyphenate	V	"N(`hyphen)+VR3"
`hypnotize	V	"V"
hy`pothesize	V	"V"

`ideate	V	"N(i`dea)+VR3"
i`dentify	V	"V"
ig`nite	V	"V"
ig`nore	V	"V"
il`luminate	V	"V"
il`lumine	V	"V"
`illustrate	V	"V"
i`magine	V	"V"
im`bed	V	"V"
im`bibe	V	"V"
im`brue	V	"V"
im`bue	V	"V"
`imitate	V	"V"
im`merse	V	"V"
`immigrate	V	"V" ;im+migrate?
`immolate	V	"V"
im`pair	V	"V"
im`pale	V	"V"
im`part	V	"V"
im`passion	V	"VR1+N(`passion)"
im`peach	V	"V"
im`pede	V	"V"
im`pel	V	"V"
im`pend	V	"V"
im`peril	V	"VR1+N(`peril)"
im`personate	V	"VR1+N(`person)+VR3"
im`pinge	V	"V"
im`plant	V	"VR1+V(`plant)"
`implement	V-to-N	"V"
`implicate	V	"V"
im`plode	V	"V"
im`plore	V	"V"
im`port	V	"V"
impor`tune	V	"V"
im`pose	V	"V"
im`pound	V	"V"
im`poverish	V	"V"
`imprecate	V	"V"
im`pregnate	V	"V"
im`press	V	"V"
im`print	V	"V"
im`prison	V	"VR1+N(`prison)"
im`prove	V	"V"
`improvise	V	"V"
im`pugn	V	"V"
im`pute	V	"V"
i`naugurate	V	"V"
in`cant	V	"V"
inca`pacitate	V	"NEG2+N(ca`pacity)+VR3"
in`carcerate	V	"V"
in`cinerate	V	"V"
in`cise	V	"V"
in`cite	V	"V"
in`cline	V	"V"
in`close	V	"V"
in`clude	V	"V"
in`corporate	V	"V"
in`crease	V	"V"
`increment	V-to-N	"V"
in`criminate	V	"V"
`incubate	V	"V"
in`culcate	V	"V"
in`cur	V	"V"
in`demnify	V	"V"
in`dent	V	"V"
`indicate	V	"V"
in`dict	V	"V"
indi`viduate	V	"N(indi`vidual)+VR"
in`doctrinate	V	"VR1+N(`doctrine)+VR3"
in`duce	V	"V"
in`duct	V	"V"
in`dulge	V	"V"
in`dwell	V	"V"
in`ebriate	V	"V"
in`farct	V	"V"
in`fatuate	V	"V"
in`fect	V	"V"
in`fer	V	"V"
in`fest	V	"V"
`infight	V	"V"
in`filtrate	V	"V"
in`flame	V	"V"
in`flate	V	"V"
in`flect	V	"V"
in`flict	V	"V"
in`form	V	"V"
in`fract	V	"V"
in`fringe	V	"V"
in`furiate	V	"V"
in`fuse	V	"V"
`ingather	V	"V"
in`gest	V	"V"
in`gratiate	V	"V"
in`habit	V	"V"
in`hale	V	"V"
in`here	V	"V"
in`herit	V	"V"
in`hibit	V	"V"
i`nitiate	V	"V"
in`ject	V	"V"
`injure	V	"V"
`inlay	V	"V"
`innovate	V	"V"
i`noculate	V	"V"
`input	V-to-N	"V"
in`quire	V	"V"
in`scribe	V	"V"
in`seminate	V	"V"
in`sert	V	"V"
in`sinuate	V	"V"
in`sist	V	"V"
in`spect	V	"V"
in`spire	V	"V"
in`stall	V	"V"
in`stantiate	V	"N(`instance)+VR3"
in`state	V	"V"
`instigate	V	"V"
in`still	V	"V"
`institute	V-to-N	"V"
in`struct	V	"V"
`insulate	V	"V"
in`sult	V	"V"
in`sure	V	"V"
`integrate	V	"V"
in`tend	V	"V"
in`ter	V	"V"
inter`calate	V	"V"
inter`cept	V	"V"
inter`dict	V	"V"
`interest	V-to-N	"V"
inter`fere	V	"V"
inter`ject	V	"V"
inter`mit	V	"V"
`intern	V	"V" ;to confine
in`terpolate	V	"V"
in`terpret	V	"V"
in`terrogate	V	"V"
inter`rupt	V	"V"
inter`sect	V	"V"
inter`sperse	V	"V"
in`terstice	V	"V"
inter`twine	V	"V"
inter`vene	V	"V"
`interview	V-to-N	"V"
`intimate	V	"V"
in`timidate	V	"V"
`intonate	V	"V"
in`tone	V	"V"
in`toxicate	V	"V"
in`trench	V	"V"
in`trigue	V	"V"
intro`duce	V	"V"
intro`ject	V	"V"
intro`spect	V	"V"
`introvert	V-to-N	"V"
in`trude	V	"V"
in`tuit	V	"V"
`inundate	V	"V"
i`nure	V	"V"
in`vade	V	"V"
in`validate	V	"NEG2+AJ(`valid)+VR3"
in`veigh	V	"V"
in`veigle	V	"V"
in`vent	V	"V"
in`vert	V	"V"
in`vest	V	"V"
in`vestigate	V	"V"
in`vigorate	V	"V"
in`vite	V	"V"
`invocate	V	"V"
in`voke	V	"V"
`involute	V	"V"
in`volve	V	"V"
`irk	V	"V"
ir`radiate	V	"V"
`irrigate	V	"V"
`irritate	V	"V"
ir`rupt	V	"V"
`isolate	V	"V"
`issue	V-to-N	"V"
`itch	V-to-N	"V"
`iterate	V	"V"

`jab	V-to-N	"V"
`jabber	V	"V"
`jade	V	"V"
`jag	V	"V"
`jam	V-to-N	"V"
`jangle	V	"V"
`jeer	V-to-N	"V"
`jeopardize	V	"N(`jeopardy)+VR6"
`jerk	V-to-N	"V"
`jest	V-to-N	"V"
`jettison	V	"V"
`jibe	V-to-N	"V"
`jiggle	V-to-N	"V"
`jilt	V	"V"
`jingle	V-to-N	"V"
`jive	V	"V"
`jog	V	"V"
`joggle	V	"V"
`join	V	"V"
`jolt	V-to-N	"V"
`jostle	V	"V"
`jot	V-to-N	"V"
`jounce	V	"V"
`joust	V	"V"
`jubilate	V	"V"
`judge	V-to-N	"V"
`juggle	V	"V"
`juke	V	"V"
`jumble	V-to-N	"V"
`jump	V-to-N	"V"
`jumpstart	V-to-N	"V"
`jut	V	"V"
`juxtapose	V	"V"

`kern	V	"V"
ki`bitz	V	"V"
`kick	V-to-N	"V"
`kid	V	"V"
`kidnap	V	"V"
`kill	V	"V"
`kindle	V	"V"
`kiss	V-to-N	"V"
`knead	V	"V"
`knock	V-to-N	"V"
`kowtow	V	"V"

`labor	V-to-N	"V"
`labour	V-to-N	"V" ;British
`lacerate	V	"V"
`lack	V-to-N	"V"
`lactate	V	"V"
`lade	V	"V"
`laden	V	"V"
`lag	V-to-N	"V"
`lam	V-to-N	"V"
la`ment	V-to-N	"V"
`laminate	V	"V"
lam`poon	V	"V"
`lance	V-to-N	"V"
`landscape	V	"V"
`languish	V	"V"
`lap	V	"V"
`lapse	V-to-N	"V"
`lash	V-to-N	"V"
`last	V	"V"
`lather	V-to-N	"V"
`laud	V	"V"
`laugh	V-to-N	"V"
`launch	V	"V"
`launder	V	"V"
`lave	V	"V"
`laze	V	"V"
`leach	V	"V"
`leak	V-to-N	"V"
`leapfrog	V	"V"
`lease	V-to-N	"V"
`leer	V	"V"
le`gate	V	"V"
`legislate	V	"V"
le`gitimize	V	"AJ(le`gitimate)+VR6"
`lengthen	V	"AJ(`long)+VR4"
`lessen	V	"V"
`levitate	V	"V"
`levy	V	"V"
`liberate	V	"V"
`lick	V-to-N	"V"
`lift	V-to-N	"V"
`like	V-to-N	"V"
`liken	V	"V"
`lilt	V-to-N	"V"
`limit	V-to-N	"V"
`limp	V-to-N	"V"
`line	V	"V" ;as line a coat
`linger	V	"V"
`link	V-to-N	"V"
`liquefy	V	"AJ(`liquid)+VR5"
`liquify	V	"AJ(`liquid)+VR5"
`liquidate	V	"AJ(`liquid)+VR3"
`lisp	V-to-N	"V"
`list	V	"V" ;lean to one side
`listen	V	"V"
`litigate	V	"V"
`live	V	"V"
`load	V-to-N	"V"
`loaf	V	"V"
`loan	V-to-N	"V"
`loathe	V	"V"
`lob	V	"V"
`lobby	V	"V"
`locate	V	"V"
`locomote	V	"V"
`lodge	V-to-N	"V"
`loft	V	"V"
`loiter	V	"V"
`loll	V	"V"
`long	V	"V"
`look	V-to-N	"V"
`loom	V	"V"
`lop	V	"V"
`lope	V	"V"
`lounge	V-to-N	"V"
`love	V-to-N	"V"
`low	V	"V"
`lower	V	"V"
`lubricate	V	"V"
`lug	V	"V"
`lull	V	"V"
`lumber	V	"V"
lumi`nesce	V	"V"
`lunge	V-to-N	"V"
`lurch	V-to-N	"V"
`lure	V-to-N	"V"
`lurk	V	"V"
lux`uriate	V	"N(`luxury)+VR3"
`lynch	V	"V"

`magnify	V	"V"
`mail	V-to-N	"V"
`maim	V	"V"
main`tain	V	"V"
;maladapt	V	"V"
;maladjust	V	"V"
;maldistribute	V	"V"
male`dict	V	"V"
;malfunction	V	"V"
ma`lign	V	"V"
;maltreat	V	"V"
`manage	V	"V"
ma`neuver	V-to-N	"V"
`mangle	V	"V"
`manhandle	V	"V"
ma`nipulate	V	"V"
ma`noeuvre	V-to-N	"V" ;British
manu`mit	V	"V"
manu`facture	V	"V"
`mar	V	"V"
ma`raud	V	"V"
`marble	V	"V"
`march	V-to-N	"V"
`marinate	V	"V"
ma`roon	V	"V"
`marshal	V	"V"
`marry	V	"V"
`marvel	V-to-N	"V"
`mash	V	"V"
`massacre	V-to-N	"V"
mas`sage	V-to-N	"V"
`master	V-to-N	"V"
`masticate	V	"V"
`masturbate	V	"V"
`match	V	"V"
`matchmake	V	"V"
mat`riculate	V	"V"
`matter	V	"V"
`maturate	V	"AJ(ma`ture)+VR3"
`maul	V	"V"
me`ander	V	"V"
`measure	V-to-N	"V"
`mechanize	V	"V"
`meddle	V	"V"
`mediate	V	"V"
`medicate	V	"V"
`meditate	V	"V"
`meld	V-to-N	"V"
`meliorate	V	"V"
`melt	V	"V"
`memorize	V	"N(`memory)+VR6"
`mend	V	"V"
`menstruate	V	"V"
`mention	V-to-N	"V"
`merge	V	"V"
`merit	V-to-N	"V"
me`tabolize	V	"V"
meta`morphose	V	"V"
me`tastasize	V	"V"
me`tathesize	V	"V"
`mete	V	"V"
`mew	V	"V"
`miff	V	"V"
`migrate	V	"V"
`militarize	V	"N(`military)+VR6"
`militate	V	"V"
`mill	V-to-N	"V"
`mimic	V	"V"
`mimicked	PTC_SUFFIX	"V(`mimic)+PTC" ;PST/PTC
`mimicking	PTC_SUFFIX	"V(`mimic)+PRG"
`mince	V	"V"
`mind	V	"V"
`mingle	V	"V"
`minister	V-to-N	"V"
`mint	V	"V"
`miss	V-to-N	"V"
`mitigate	V	"V"
`mix	V-to-N	"V"
`moan	V-to-N	"V"
`mock	V	"V"
`modify	V	"V"
`modulate	V	"V"
mo`lest	V	"V"
`mollify	V	"V"
`mollycoddle	V	"V"
`molt	V	"V"
`monetarize	V	"N(`monetary)+VR6"
`monitor	V-to-N	"V"
mo`nopolize	V	"N(mo`noply)+VR6"
`moo	V	"V"
`moor	V	"V"
`mope	V	"V"
`mortify	V	"V"
`motivate	V	"V"
`mount	V	"V"
`mourn	V	"V"
`move	V-to-N	"V"
`muddle	V-to-N	"V"
`muddy	V	"N(`mud)+AJR14+VR0"
`muffle	V	"V"
`mug	V	"V"
`mulct	V	"V"
`mull	V	"V"
`multiplex	V	"V"
`multiply	V	"V"
`mum	V	"V"
`mumble	V	"V"
`mummify	V	"N(`mummy)+VR5"
`munch	V	"V"
`murder	V-to-N	"V"
`murmur	V-to-N	"V"
`muse	V	"V"
`muster	V-to-N	"V"
`mutate	V	"V"
`mutilate	V	"V"
`mutter	V	"V"
`muzzle	V-to-N	"V"
`mystify	V	"V"

`nab	V	"V"
`nag	V	"V"
`nap	V-to-N	"V"
`narrate	V	"V"
`nauseate	V	"N(`nausea)+VR3"
`navigate	V	"V"
ne`cessitate	V	"N(ne`cessity)+VR3"
`need	V-to-N	"V"
ne`gate	V	"V"
ne`glect	V-to-N	"V"
ne`gotiate	V	"V"
`nestle	V	"V"
`nibble	V	"V"
`niggle	V	"V"
`nip	V-to-N	"V"
`nitpick	V	"V"
`nix	V	"V"
`nod	V-to-N	"V"
`nominate	V	"V"
`nonplus	V	"V"
`notarize	V	"N(`notary)+VR6"
`notate	V	"N(`note)+VR3"
`note	V-to-N	"V"
`notice	V-to-N	"V"
`nourish	V	"V"
`nucleate	V	"N(`nucleus)+VR3"
`nudge	V	"V"
`numerate	V	"V"
`nurse	V-to-N	"V"
`nurture	V	"V"
`nuzzle	V	"V"

o`bey	V	"V"
ob`fuscate	V	"V"
ob`ject	V	"V"
`obligate	V	"V"
ob`lige	V	"V"
ob`literate	V	"V"
ob`serve	V	"V"
ob`sess	V	"V"
ob`struct	V	"V"
ob`tain	V	"V"
ob`trude	V	"V"
`obviate	V	"V"
oc`clude	V	"V"
`occupy	V	"V"
oc`cur	V	"V"
of`fend	V	"V"
`offer	V	"V"
of`ficiate	V	"V"
`offload	V	"V"
`ogle	V	"V"
o`mit	V	"V"
`operate	V	"V"
o`pine	V	"V"
op`pose	V	"V"
op`press	V	"V"
`opt	V	"V"
`optimise	V	"AJ(`optimal)+VR6"
`optimize	V	"AJ(`optimal)+VR6"
`orate	V	"V"
`orchestrate	V	"V"
or`dain	V	"V"
`order	V-to-N	"V"
`organize	V	"V"
`orient	V	"V"
o`riginate	V	"N(`origin)+VR3"
`oscillate	V	"V"
`ossify	V	"V"
`ostracize	V	"V"
`oust	V	"V"
out`flank	V	"DEG6+N(`flank).VR0"
out`fox	V	"DEG6+N(`fox).VR0"
out`gun	V	"DEG6+N(`gun).VR0"
out`number	V	"DEG6+N(`number).VR0"
out`poll	V	"DEG6+N(`poll).VR0"
out`strip	V	"V"
out`wit	V	"DEG6+N(`wit).VR0"
over`awe	V	"DEG7+N(`awe).VR0"
over`book	V	"DEG7+N(`book).VR0"
over`joy	V	"DEG7+N(`joy).VR0"
`ovulate	V	"V"
`owe	V	"V"
`own	V	"V"
`oxygenate	V	"N(`oxygen)+VR3"

`pace	V-to-N	"V"
`pacify	V	"V"
`pack	V	"V"
`paginate	V	"N(`page)+VR3"
`pall	V	"V"
`palliate	V	"V"
`palpitate	V	"V"
`pamper	V	"V"
`pander	V	"V"
`panicked	PTC_SUFFIX	"N(`panic).VR0+PTC" ;PST/PTC ;k insertion
`panicking	PTC_SUFFIX	"N(`panic).VR0+PRG" ;k insertion
`pant	V	"V"
`paralyse	V	"V" ;British
`paralyze	V	"V"
`paraphrase	V-to-N	"V"
`parboil	V	"V"
`parch	V	"V"
`pardon	V-to-N	"V"
`pare	V	"V"
pa`renthesize	V	"N(pa`renthesis)+VR6"
`parley	V-to-N	"V"
`parry	V	"V"
`parse	V-to-N	"V"
par`ticipate	V	"V"
`pass	V-to-N	"V"
`pat	V-to-N	"V"
`patter	V-to-N	"V"
pa`trol	V-to-N	"V"
pa`trolled	PTC_SUFFIX	"V(pa`trol)+PTC" ;PST/PTC
pa`trolling	PTC_SUFFIX	"V(pa`trol)+PRG"
`pause	V-to-N	"V"
`pave	V	"V"
`pawn	V	"V"
`peal	V-to-N	"V"
`peck	V-to-N	"V"
`peculate	V	"V"
`peddle	V	"V"
`pee	V	"V"
`peek	V-to-N	"V"
`peep	V-to-N	"V"
`peer	V	"V"
`pelt	V	"V"
`pend	V	"V"
`penetrate	V	"V"
per`ambulate	V	"V"
per`ceive	V	"V"
`perch	V	"V"
`percolate	V	"V"
per`cuss	V	"V"
per`fect	V	"AJ(`perfect).VR0"
`perforate	V	"V"
per`form	V	"V"
per`fuse	V	"V"
`perish	V	"V"
`perjure	V	"V"
`perk	V	"V"
`permeate	V	"V"
per`mit	V	"V"
per`mute	V	"V"
`perorate	V	"V"
`perpetrate	V	"V"
per`petuate	V	"V"
per`plex	V	"V"
`persecute	V	"V"
perse`vere	V	"V"
per`sist	V	"V"
per`sonify	V	"V"
per`spire	V	"V"
per`suade	V	"V"
per`tain	V	"V"
per`turb	V	"V"
`perturbate	V	"V"
pe`ruse	V	"V"
per`vade	V	"V"
per`vert	V	"V"
`pester	V	"V"
`pet	V	"V"
`peter	V	"V"
`petrify	V	"V"
phi`lander	V	"V"
phospho`resce	V	"V"
`photocopy	V-to-N	"V"
`pick	V	"V"
`picket	V	"V"
`pickle	V-to-N	"V"
`picnicked	PTC_SUFFIX	"N(`picnic).VR0+PTC" ;PST/PTC ;k insertion
`picnicking	PTC_SUFFIX	"N(`picnic).VR0+PRG" ;k insertion
`piddle	V	"V"
`pierce	V	"V"
`pilfer	V	"V"
`pillage	V	"V"
`pinch	V-to-N	"V"
`pine	V	"V"
`piss	V-to-N	"V"
`pitch	V-to-N	"V"
`pith	V	"V"
`placate	V	"V"
`plagiarize	V	"V"
`plait	V-to-N	"V"
`play	V-to-N	"V"
`please	V	"V"
`plod	V	"V"
`plop	V-to-N	"V"
`pluck	V	"V"
`plumb	V	"V"
`plummet	V	"V"
`plump	V	"V"
`plunder	V	"V"
`plunge	V-to-N	"V"
`plunk	V	"V"
`ply	V	"V"
`poach	V	"V"
`poise	V-to-N	"V"
`poke	V-to-N	"V"
`polish	V-to-N	"V"
`politick	V	"V"
`pollinate	V	"N(`pollen)+VR3"
pol`lute	V	"V"
`ponder	V	"V"
pon`tificate	V	"V"
`pop	V-to-N	"V"
`populate	V	"V"
`pore	V	"V"
por`tend	V	"V"
por`tray	V	"V"
`pose	V-to-N	"V"
`posit	V	"V"
pos`sess	V	"V"
`post	V	"V"
post`pone	V	"V"
`postulate	V	"V"
`pounce	V-to-N	"V"
`pound	V	"V"
`pour	V	"V"
`pout	V-to-N	"V"
`practice	V-to-N	"V"
`practise	V-to-N	"V"
`praise	V-to-N	"V"
`prance	V	"V"
`prate	V	"V"
`pray	V	"V"
`preach	V	"V"
pre`cede	V	"V"
pre`cess	V	"V"
pre`cipitate	V-to-N	"V"
pre`clude	V	"V"
pre`dict	V	"V"
pre`destinate	V	"V"
predis`pose	V	"V"
pre`dominate	V	"V"
pre`empt	V	"V"
`preen	V	"V"
pre`fer	V	"V"
pre`pare	V	"V"
pre`ponderate	V	"V"
pre`sage	V	"V"
pre`scribe	V	"V"
pre`sent	V	"V"
pre`serve	V	"V"
pre`side	V	"V"
`press	V-to-N	"V"
presti`digitate	V	"V"
pre`sume	V	"V"
pre`tend	V	"V"
pre`vail	V	"V"
pre`varicate	V	"V"
pre`vent	V	"V"
`prick	V-to-N	"V"
`prime	V	"V"
`primp	V	"V"
`print	V-to-N	"V"
`probe	V-to-N	"V"
`proceed	V	"V"
pro`cess	V	"V"
pro`claim	V	"V"
pro`crastinate	V	"V"
`procreate	V	"V"
pro`cure	V	"V"
`prod	V	"V"
pro`duce	V	"V"
pro`fess	V	"V"
`proffer	V	"V"
prog`nosticate	V	"V"
pro`gress	V	"V"
pro`hibit	V	"V"
pro`ject	V	"V"
pro`liferate	V	"V"
pro`long	V	"V"
pro`longate	V	"V"
pro`mote	V	"V"
`prompt	V-to-N	"V"
`promulgate	V	"V"
pro`nounce	V	"V"
`prop	V	"V"
propa`gandize	V	"N(propa`ganda)+VR6"
`propagate	V	"V"
pro`pel	V	"V"
`prophesy	V	"V"
pro`pitiate	V	"V"
pro`pose	V	"V"
pro`pound	V	"V"
`prorate	V	"V"
pro`rogue	V	"V"
pro`scribe	V	"V"
`prosecute	V	"V"
`prospect	V	"V"
`prosper	V	"V"
pro`tect	V	"V"
pro`test	V	"V"
pro`tract	V	"V"
pro`trude	V	"V"
pro`vide	V	"V"
pro`voke	V	"V"
`prowl	V	"V"
`prune	V	"V"
`pry	V	"V"
`psych	V	"V"
`publish	V	"V"
`pucker	V-to-N	"V"
`puff	V-to-N	"V"
`puke	V	"V"
`pull	V-to-N	"V"
`pulsate	V	"V"
`pulse	V-to-N	"V"
`pulverize	V	"V"
`pummel	V	"V"
`pump	V-to-N	"V"
`punch	V-to-N	"V"
`punctuate	V	"V"
`puncture	V-to-N	"V"
`punish	V	"V"
`punt	V-to-N	"V"
`pupate	V	"V"
`purchase	V-to-N	"V"
`purge	V-to-N	"V"
`purl	V	"V"
pur`loin	V	"V"
pur`port	V	"V"
`purr	V	"V"
`purse	V	"V"
pur`sue	V	"V"
pur`vey	V	"V"
`push	V-to-N	"V"
`putter	V	"V"
`putrefy	V	"AJ(`putrid)+VR5"

`quack	V-to-N	"V"
`quaff	V	"V"
`quail	V	"V"
`quake	V	"V"
`qualify	V	"V"
`quantify	V	"V"
`quarrel	V-to-N	"V"
`quash	V	"V"
`quaver	V	"V"
`quell	V	"V"
`quench	V	"V"
`queued	PTC_SUFFIX	"N(`queue).VR0+PTC" ;PST/PTC
`queuing	PTC_SUFFIX	"N(`queue).VR0+PRG"
`quibble	V	"V"
`quiver	V	"V"
`quizzes	Clitics	"N(`quiz).VR0+3SG"
`quizzed	PTC_SUFFIX	"N(`quiz).VR0+PTC" ;PST/PTC
`quizzing	PTC_SUFFIX	"N(`quiz).VR0+PRG"
`quote	V-to-N	"V"

`rack	V	"V"
racke`teer	V	"N(`racket)+NR10.VR0"
`radiate	V	"V"
`rag	V	"V"
`rail	V	"V"
`raise	V-to-N	"V"
`rally	V-to-N	"V"
`ram	V	"V"
`ramble	V	"V"
`ramify	V	"V"
`rank	V-to-N	"V"
`rankle	V	"V"
`ransack	V	"V"
`rant	V	"V"
`rap	V-to-N	"V"
`rape	V-to-N	"V"
rap`pel	V	"V"
`rarefy	V	"V"
`rasp	V	"V"
`rate	V-to-N	"V"
`ratify	V	"V"
rati`ocinate	V	"V"
`rattle	V-to-N	"V"
`ravage	V	"V"
`rave	V	"V"
`ravel	V	"V"
`raven	V	"V" ;plunder
`ravish	V	"V"
`raze	V	"V"
`razz	V	"V"
`reach	V	"V"
re`act	V	"V"
`ream	V	"V"
`reap	V	"V"
`rear	V	"V"
re`bel	V	"V"
re`buff	V-to-N	"V"
re`buke	V-to-N	"V"
re`but	V	"V"
re`cant	V	"V"
re`ceive	V	"V"
re`cess	V-to-N	"V"
re`ciprocate	V	"V"
`reckon	V	"V"
re`cline	V	"V"
`recognize	V	"V"
`recognise	V	"V" ;British
`recompence	V-to-N	"V"
`recompense	V-to-N	"V"
`reconcile	V	"V"
recon`noiter	V	"V"
recon`noitre	V	"V"
re`cord	V	"V"
re`cover	V	"V"
re`criminate	V	"V"
re`cruit	V-to-N	"V"
`rectify	V	"V"
re`cuperate	V	"V"
re`cur	V	"V"
re`curse	V	"V"
re`dact	V	"V"
re`dound	V	"V"
re`duce	V	"V"
`reek	V	"V"
re`fect	V	"V"
re`fer	V	"V"
refer`ee	V-to-N	"V"
re`fine	V	"V"
re`flect	V	"V"
re`fract	V	"V"
re`frain	V	"V"
re`fresh	V	"V"
re`frigerate	V	"V"
re`fund	V	"V"
re`fuse	V	"V"
re`fute	V	"V"
re`gale	V	"V"
re`gard	V-to-N	"V"
re`gress	V	"V"
re`gret	V-to-N	"V"
`regulate	V	"V"
re`gurgitate	V	"V"
reha`bilitate	V	"V"
re`hearse	V	"V"
`reign	V-to-N	"V"
reim`burse	V	"V"
rein`force	V	"V"
re`ject	V	"V"
re`joice	V	"V"
re`juvenate	V	"V"
re`late	V	"V"
re`lax	V	"V"
re`lay	V	"V"
re`lease	V-to-N	"V"
re`lent	V	"V"
re`lieve	V	"V"
re`linquish	V	"V"
`relish	V	"V"
re`ly	V	"V"
re`main	V	"V"
re`mand	V	"V"
re`mark	V	"V"
re`member	V	"V"
re`mind	V	"V"
remi`nisce	V	"V"
re`mit	V	"V"
re`monstrate	V	"V"
re`move	V	"V"
re`munerate	V	"V"
`rend	V	"V"
`render	V	"V"
re`nege	V	"V"
re`new	V	"ORD5+AJ(`new).VR0"
re`nounce	V	"V"
`renovate	V	"V"
`rent	V-to-N	"V"
re`nunciate	V	"V"
re`pair	V	"V"
re`patriate	V	"V"
re`peat	V	"V"
re`pel	V	"V"
re`pent	V	"V"
repre`hend	V	"V"
repre`sent	V	"V"
re`plenish	V	"V"
`replicate	V	"V"
re`press	V	"V"
re`prieve	V	"V"
`reprimand	V	"V"
re`prise	V	"V"
re`proach	V-to-N	"V"
re`pudiate	V	"V"
re`pulse	V	"V"
re`pute	V	"V"
re`quest	V-to-N	"V"
re`quire	V	"V"
re`scind	V	"V"
`rescue	V	"V"
re`semble	V	"V"
re`sent	V	"V"
re`serve	V	"V"
re`sign	V	"V"
re`sile	V	"V"
re`sist	V	"V"
re`solve	V	"V"
`resonate	V	"V"
re`sort	V	"V"
re`spect	V-to-N	"V"
`respirate	V	"V"
re`spire	V	"V"
re`spond	V	"V"
`rest	V-to-N	"V"
`restitute	V	"V"
re`store	V	"V"
re`strain	V	"V"
re`strict	V	"V"
re`sult	V-to-N	"V"
re`sume	V	"V"
re`surge	V	"V"
resur`rect	V	"V"
re`suscitate	V	"V"
`retail	V	"V"
re`tain	V	"V"
re`taliate	V	"V"
re`tard	V	"V"
`retch	V	"V"
re`ticulate	V	"V"
re`tire	V	"V"
re`tort	V	"V"
re`tract	V	"V"
re`trench	V	"V"
re`trieve	V	"V"
retro`cede	V	"V"
;retro`fit	V	"V"
retro`gress	V	"V"
`retrospect	V	"V"
`rev	V	"V"
`revved	PTC_SUFFIX	"V(`rev)+PTC" ;PST/PTC ;exception to Gemination
`revving	PTC_SUFFIX	"V(`rev)+PRG"
re`veal	V	"V"
`revel	V	"V"
re`verberate	V	"V"
re`vere	V	"V"
`reverence	V	"V(re`vere)+NR26.VR0"
re`verse	V	"V"
re`vert	V	"V"
re`vile	V	"V"
re`vise	V	"V"
re`vive	V	"V"
re`voke	V	"V"
re`volve	V	"V"
re`volt	V	"V"
`rhapsodize	V	"N(`rhapsody)+VR6"
`rhyme	V-to-N	"V"
`rhymed	PTC_SUFFIX	"V(`rhyme)+PTC" ;PST/PTC
`rhyming	PTC_SUFFIX	"V(`rhyme)+PRG"
`rib	V	"V"
`ricochet	V	"V"
`riddle	V	"V"
`ridicule	V	"V"
`riffle	V	"V"
`rifle	V	"V"
`rile	V	"V"
`rinse	V-to-N	"V"
`rip	V-to-N	"V"
`ripple	V-to-N	"V"
`roam	V	"V"
`roar	V-to-N	"V"
`roast	V-to-N	"V"
`rob	V	"V"
`rock	V	"V"
`roil	V	"V"
`roister	V	"V"
`roll	V-to-N	"V"
`rollick	V	"V"
`romp	V	"V"
`roost	V-to-N	"V"
`rot	V	"V"
`rotate	V	"V"
`rototill	V	"V"
`rouse	V	"V"
`roust	V	"V"
`rout	V	"V"
`rove	V	"V"
`row	V	"V"
`rub	V	"V"
`rue	V-to-N	"V"
`ruffle	V	"V"
ruin	V-to-N	"V"
`rule	V	"V"
rumble	V-to-N	"V"
`ruminate	V	"V"
`rummage	V-to-N	"V"
`rumple	V	"V"
`rupture	V-to-N	"V"
`rush	V-to-N	"V"
`rustle	V	"V"

`sack	V	"V"
`sag	V-to-N	"V"
`sail	V	"V"
`salivate	V	"N(sa`liva)+VR3"
sa`lute	V-to-N	"V"
`salvage	V	"V"
`sanctify	V	"V"
`sand	V	"V"
`sanitate	V	"V"
`sanitize	V	"V"
`sap	V	"V"
sa`shay	V	"V"
`sate	V	"V"
`satiate	V	"V"
`satisfy	V	"V"
`saturate	V	"V"
`saunter	V	"V"
sau`te	V	"V"
`save	V	"V"
`scald	V	"V"
`scale	V	"V"
`scamper	V	"V"
`scan	V	"V"
`scare	V-to-N	"V"
`scat	V	"V"
`scathe	V	"V"
`scatter	V	"V"
`scavenge	V	"V"
`scintillate	V	"V"
`scissor	V	"V"
`scoff	V	"V"
`scold	V	"V"
`scoot	V	"V"
`scorch	V	"V"
`scour	V	"V"
`scout	V-to-N	"V"
`scowl	V-to-N	"V"
`scrabble	V	"V"
`scram	V	"V"
`scramble	V	"V"
`scrape	V-to-N	"V"
`scratch	V-to-N	"V"
`scrawl	V-to-N	"V"
`scream	V-to-N	"V"
`screech	V-to-N	"V"
`scribble	V-to-N	"V"
`scrimp	V	"V"
`scrounge	V	"V"
`scrub	V	"V"
`scrutinize	V	"N(`scrutiny)+VR6"
`scud	V	"V"
`scuff	V	"V"
`scuffle	V	"V"
`sculpt	V	"V"
`scurry	V	"V"
`scuttle	V	"V"
`seal	V-to-N	"V"
`sear	V	"V"
`search	V-to-N	"V"
`season	V	"V"
se`cede	V	"V"
se`clude	V	"V"
`second	V	"V"
se`crete	V	"V"
se`duce	V	"V"
`seem	V	"V"
`seep	V	"V"
`seethe	V	"V"
`segregate	V	"V"
`seize	V	"V"
se`lect	V	"V"
se`quester	V	"V"
`serve	V	"V"
`settle	V	"V"
`sever	V	"V"
`shag	V	"V"
`shamble	V	"V"
`shatter	V	"V"
`sheathe	V	"V"
`sheer	V	"V"
shel`lacked	PTC_SUFFIX	"N(shel`lac).VR0+PTC" ;PST/PTC
shel`lacking	PTC_SUFFIX	"N(shel`lac).VR0+PRG"
`shelve	V	"N(`shelf)+VR0"
`shift	V-to-N	"V"
`shimmer	V-to-N	"V"
`shimmy	V-to-N	"V"
`shirk	V	"V"
`shirr	V	"V"
`shiver	V-to-N	"V"
`shoo	V	"V"
`shoplift	V	"V"
`shore	V	"V"
short`change	V	"V"
`shout	V-to-N	"V"
`shove	V-to-N	"V"
`shriek	V-to-N	"V"
`shrivel	V	"V"
`shrug	V-to-N	"V"
`shuck	V	"V"
`shudder	V-to-N	"V"
`shuffle	V-to-N	"V"
`shun	V	"V"
`shunt	V	"V"
`shy	V	"V"
`sic	V	"V"
`sidestep	V	"V"
`sidle	V	"V"
`sift	V	"V"
`sigh	V	"V"
`simmer	V	"V"
`simper	V-to-N	"V"
`simulate	V	"V"
`simulcast	V-to-N	"V"
`singe	V	"V"
`single	V	"V"
`sip	V-to-N	"V"
`situate	V	"V"
`sizzle	V	"V"
`skew	V	"V"
`skid	V-to-N	"V"
`skim	V	"V"
`skimp	V	"V"
`skip	V-to-N	"V"
`skulk	V	"V"
`skurry	V	"V"
`skyjack	V	"V"
`slake	V	"V"
`slam	V-to-N	"V"
`slap	V-to-N	"V"
`slash	V-to-N	"V"
`slate	V	"V"
`slaughter	V-to-N	"V"
`slaver	V	"V"
`sleepwalk	V	"V"
`slew	V	"V"
`slice	V-to-N	"V"
`slight	V-to-N	"V"
`slip	V-to-N	"V"
`slither	V	"V"
`slobber	V-to-N	"V"
`slog	V	"V"
`slop	V	"V"
`slosh	V	"V"
`slouch	V	"V"
`slug	V-to-N	"V"
`slumber	V-to-N	"V"
`slump	V-to-N	"V"
`slur	V-to-N	"V"
`slurp	V-to-N	"V"
`smack	V-to-N	"V"
`smart	V	"V"
`smash	V-to-N	"V"
`smatter	V	"V"
`smear	V-to-N	"V"
`smelt	V	"V" ;refine metal
`smile	V-to-N	"V"
`smirk	V-to-N	"V"
`smolder	V-to-N	"V"
`smooch	V	"V"
`smother	V	"V"
`smuggle	V	"V"
`snap	V-to-N	"V"
`snarl	V-to-N	"V"
`snatch	V	"V"
`sneak	V-to-N	"V"
`sneer	V-to-N	"V"
`sneeze	V-to-N	"V"
`snick	V	"V"
`snicker	V	"V"
`sniff	V-to-N	"V"
`sniffle	V-to-N	"V"
`snigger	V-to-N	"V"
`snip	V-to-N	"V"
`snipe	V	"V"
`snivel	V	"V"
`snoop	V	"V"
`snooze	V	"V"
`snore	V	"V"
`snort	V-to-N	"V"
`snub	V	"V"
`snuff	V	"V"
`snuffle	V	"V"
`snuggle	V	"V"
`soak	V	"V"
`soar	V	"V"
`sob	V-to-N	"V"
`sock	V-to-N	"V"
so`licit	V	"V"
so`liloquize	V	"N(so`liloquy)+VR6"
`solve	V	"V"
`soothe	V	"V"
`soothsay	V	"V"
so`phisticate	V	"V"
`souse	V	"V"
`spank	V	"V"
`spar	V	"V"
`spare	V	"V"
`sparge	V	"V"
`sparkle	V-to-N	"V"
`spatter	V	"V"
`spawn	V	"V"
`spay	V	"V"
`spearhead	V	"V"
`specify	V	"V"
`speculate	V	"V"
`spew	V	"V"
`spike	V	"V"
`splash	V-to-N	"V"
`splatter	V	"V"
`splay	V	"V"
`splice	V-to-N	"V"
`splutter	V	"V"
`spoof	V	"V"
`sport	V	"V"
`spot	V	"V"
`sprawl	V	"V"
`sprinkle	V-to-N	"V"
`sprint	V-to-N	"V"
`sprout	V-to-N	"V"
`spurn	V	"V"
`spurt	V-to-N	"V"
`sputter	V	"V"
`spy	V-to-N	"V"
`squall	V	"V"
`squander	V	"V"
`squash	V	"V"
`squat	V	"V"
`squawk	V-to-N	"V"
`squeak	V-to-N	"V"
`squeal	V-to-N	"V"
`squeeze	V-to-N	"V"
`squelch	V	"V"
`squint	V	"V"
`squirm	V	"V"
`squirt	V-to-N	"V"
`stab	V-to-N	"V"
`stabilize	V	"Adj(stable)+VR6"
`stagger	V	"V"
`stagnate	V	"V"
`stain	V-to-N	"V"
`stalk	V	"V"
`stall	V	"V"
`stammer	V	"V"
`stamp	V	"V"
`stanch	V	"V"
`stare	V	"V"
`stargaze	V	"V"
`start	V-to-N	"V"
`startle	V	"V"
`starve	V	"V"
`stash	V-to-N	"V"
`state	V	"V"
`stave	V	"V"
`stay	V-to-N	"V"
`steep	V	"V"
`steer	V-to-N	"V"
`stem	V	"V"
`stickle	V	"V"
`stifle	V	"V"
`stimulate	V	"V"
`stipple	V	"V"
`stipulate	V	"V"
`stir	V	"V"
`stoke	V	"V"
`stomp	V	"V"
`stonewall	V	"V"
`stoop	V	"V"
`stop	V-to-N	"V"
`store	V-to-N	"V"
`stow	V	"V"
`straddle	V	"V"
`strafe	V	"V"
`straggle	V	"V"
`straiten	V	"V"
`strand	V	"V"
`strangle	V	"V"
`strangulate	V	"V"
`stratify	V	"V"
`stray	V-to-N	"V"
`strengthen	V	"AJ(`strong)+VR4"
`stretch	V-to-N	"V"
`striate	V	"V"
`stroll	V-to-N	"V"
`struggle	V-to-N	"V"
`strum	V	"V"
`strut	V	"V"
`stub	V	"V"
`stud	V	"V"
`study	V-to-N	"V"
`stuff	V	"V"
`stultify	V	"V"
`stumble	V	"V"
`stun	V	"V"
`stump	V	"V"
`stunt	V	"V"
`stupefy	V	"V"
`stutter	V-to-N	"V"
`styled	PTC_SUFFIX	"N(`style).VR0+PTC" ;PST/PTC
`styling	PTC_SUFFIX	"N(`style).VR0+PRG"
`stylize	V	"N(`style)+VR6"
`stymie	V	"V"
`sub	V-to-N	"V" ;substitute
sub`due	V	"V"
sub`ject	V	"V"
`subjugate	V	"V"
`sublimate	V	"V"
sub`merse	V	"V"
sub`mit	V	"V"
`subrogate	V	"V"
sub`scribe	V	"V"
`subsidize	V	"N(`subsidy)+VR6"
sub`sist	V	"V"
sub`stantiate	V	"N(`substance)+VR3"
`substitute	V-to-N	"V"
sub`sume	V	"V"
sub`tract	V	"V"
sub`vert	V	"V"
suc`ceed	V	"V"
suc`cumb	V	"V"
`suck	V	"V"
`suckle	V	"V"
`sue	V	"V"
`suffer	V	"V"
suf`fice	V	"V"
`suffocate	V	"V"
suf`fuse	V	"V"
sugar`coat	V	"V"
sug`gest	V	"V"
`suit	V	"V"
`sulk	V	"V"
`sully	V	"V"
`summarize	V	"N(`summary)+VR6"
`summon	V	"V"
`sunbathe	V	"V"
`sunder	V	"V"
`sup	V	"V"
super`annuate	V	"V"
superin`tend	V	"V"
super`pose	V	"V"
super`sede	V	"V"
super`vene	V	"V"
`supervise	V	"V"
sup`plant	V	"V"
`supplicate	V	"V"
sup`ply	V-to-N	"V"
sup`port	V-to-N	"V"
sup`pose	V	"V"
sup`press	V	"V"
sur`cease	V	"V"
`surcharge	V-to-N	"DEG10+V(`charge)"
`surge	V-to-N	"V"
sur`mise	V	"V"
sur`mount	V	"V"
sur`pass	V	"V"
sur`prise	V-to-N	"V"
sur`render	V-to-N	"V"
sur`round	V	"V"
sur`veil	V	"V"
sur`vey	V	"V"
sur`vive	V	"V"
sus`pect	V	"V"
sus`pend	V	"V"
sus`tain	V	"V"
`swaddle	V	"V"
`swagger	V	"V"
`swap	V-to-N	"V"
`swarm	V-to-N	"V"
`swashbuckle	V	"V"
`swat	V	"V"
`swathe	V	"V"
`sway	V	"V"
`swelter	V	"V"
`swerve	V	"V"
`swig	V	"V"
`swindle	V-to-N	"V"
`swipe	V	"V"
`swish	V	"V"
`swoon	V	"V"
`swoop	V	"V"
syl`labify	V	"N(`syllable)+VR5"
`syllogize	V	"V"
`symbolise	V	"N(`symbol)+VR6"
`symbolize	V	"N(`symbol)+VR6"
`synchronize	V	"N(`synchrony)+VR6"
`syncopate	V	"V"
`syndicate	V-to-N	"V"
`synthesize	V	"V"
`systematize	V	"N(`system)+VR6"
`systemize	V	"N(`system)+VR6"
`swallow	V-to-N	"V"

`tabulate	V	"V"
`tackle	V-to-N	"V"
`tail	V	"V"
`taint	V	"V"
`talk	V-to-N	"V"
`tamp	V	"V"
`tamper	V	"V"
`tan	V-to-N	"V"
`tangle	V-to-N	"V"
`tantalize	V	"V"
`tap	V-to-N	"V" ;knock
`taper	V	"V"
`tarnish	V	"V"
`tarry	V	"V"
`taste	V-to-N	"V"
`tatter	V	"V"
`tattle	V	"V"
`taunt	V	"V"
`tax	V-to-N	"V"
`tease	V	"V"
`teem	V	"V"
`teeter	V	"V"
`teethe	V	"V"
`televise	V	"V"
`temper	V	"V"
`temporize	V	"V"
`tempt	V	"V"
`tend	V	"V"
`terminate	V	"V"
`terrify	V	"V"
`testify	V	"V"
`thank	V	"V"
`thaw	V-to-N	"V"
`theorize	V	"N(`theory)+VR6"
`thieve	V	"V"
`thrash	V	"V"
`threaten	V	"N(`threat)+VR4"
`thresh	V	"V"
`throb	V	"V"
`throttle	V	"V"
`thud	V-to-N	"V"
`thump	V-to-N	"V"
`thwack	V-to-N	"V"
`thwart	V	"V"
`tick	V-to-N	"V"
`tickle	V	"V"
`tide	V	"V"
`tie	V	"V"
`tying	V	"V(`tie)+PRG"
`till	V	"V"
`tilt	V-to-N	"V"
`tinge	V-to-N	"V"
`tingle	V-to-N	"V"
`tinker	V	"V"
`tinkle	V	"V"
`tipple	V	"V"
`tire	V	"V"
`tithe	V-to-N	"V"
`titillate	V	"V"
`titter	V	"V"
`toast	V-to-N	"V"
`toddle	V	"V"
`toggle	V-to-N	"V"
`toil	V-to-N	"V"
`tolerate	V	"V"
`toll	V	"V"
`toot	V-to-N	"V"
`tootle	V	"V"
`top	V	"V"
`topple	V-to-N	"V"
`torture	V-to-N	"V"
`toss	V-to-N	"V"
`tote	V	"V"
`totter	V	"V"
`touch	V-to-N	"V"
`tousle	V	"V"
`tout	V	"V"
`tow	V-to-N	"V"
`trace	V	"V"
`trade	V-to-N	"V"
`trafficked	PTC_SUFFIX	"N(`traffic).VR0+PTC" ;PST/PTC
`trafficking	PTC_SUFFIX	"N(`traffic).VR0+PRG"
`trail	V	"V"
`train	V	"V"
`traipse	V	"V"
tra`ject	V	"V"
`tramp	V-to-N	"V"
`trample	V	"V"
trans`act	V	"V"
tran`scend	V	"V"
tran`scribe	V	"V"
trans`duce	V	"V"
tran`sect	V	"V"
`transfer	V	"V"
trans`figure	V	"V"
trans`fix	V	"V"
trans`form	V	"V"
trans`fuse	V	"V"
trans`gress	V	"V"
`translate	V	"V"
trans`literate	V	"V"
trans`mit	V	"V"
trans`mogrify	V	"V"
trans`mute	V	"V"
tran`spire	V	"V"
trans`plant	V	"V"
trans`port	V	"V"
trans`pose	V	"V"
trans`ship	V	"V"
`traumatise	V	"N(`trauma)+VR6"
`traumatize	V	"N(`trauma)+VR6"
`travel	V-to-N	"V"
tra`verse	V	"V"
`trawl	V	"V"
`treat	V-to-N	"V"
`trek	V-to-N	"V"
`trekked	PTC_SUFFIX	"V(`trek)+PTC" ;PST/PTC
`trekking	PTC_SUFFIX	"V(`trek)+PRG"
`tremble	V	"V"
`trend	V-to-N	"V"
`trespass	V-to-N	"V"
tri`angulate	V	"V"
`tribulate	V	"V"
`trickle	V-to-N	"V"
`trifle	V-to-N	"V"
`trill	V-to-N	"V"
`trim	V	"V"
`trip	V	"V"
`trisect	V	"V"
`tromp	V	"V"
`trot	V	"V"
`trounce	V	"V"
`trudge	V	"V"
`truncate	V	"V"
`truss	V-to-N	"V"
`try	V-to-N	"V"
`tug	V-to-N	"V"
`tumble	V-to-N	"V"
`tune	V	"V"
`turn	V-to-N	"V"
`tweak	V-to-N	"V"
`tweeze	V	"V"
`twiddle	V	"V"
`twig	V	"V"
`twinge	V-to-N	"V"
`twinkle	V-to-N	"V"
`twirl	V-to-N	"V"
`twist	V-to-N	"V"
`twitch	V-to-N	"V"
`twitter	V-to-N	"V"
`type	V	"V"
`typed	PTC_SUFFIX	"V(`type)+PTC" ;PST/PTC
`typing	PTC_SUFFIX	"V(`type)+PRG"
`typify	V	"N(`type)+VR5"
`tyrannise	V	"N(`tyranny)+VR6" ;British
`tyrannize	V	"N(`tyranny)+VR6"

`uglify	V	"AJ(`ugly)+VR5"
`ulcerate	V	"N(`ulcer)+VR3"
`ululate	V	"V"
`underpin	V	"V"
`undulate	V	"V"
un`earth	V	"REV1+N(`earth).VR0"
un`horse	V	"REV1+N(`horse).VR0"
`unify	V	"V"
u`nite	V	"V"
`up	V	"V"
up`braid	V	"V"
`upchuck	V	"V"
`update	V	"V"
up`end	V	"V"
`upgrade	V-to-N	"V"
up`holster	V	"V"
up`heave	V	"V"
up`lift	V	"V"
`upload	V-to-N	"V"
up`raise	V	"V"
up`root	V	"V"
up`stage	V	"V"
`urge	V-to-N	"V"
`urinate	V	"N(`urine)+VR3"
`use	V-to-N	"V"
`usher	V-to-N	"V"
u`surp	V	"V"
`utter	V	"V"

`vacate	V	"V"
`vacillate	V	"V"
`vaccinate	V	"N(vac`cine)+VR3"
`validate	V	"AJ(`valid)+VR3"
`valuate	V	"AJ(`value)+VR3"
va`moose	V	"V"
`vanish	V	"V"
`vanquish	V	"V"
`variate	V	"V"
`variegate	V	"V"
`vary	V	"V"
`vault	V-to-N	"V"
`vaunt	V	"V"
`veer	V	"V"
`vegetate	V	"V"
`vend	V	"V"
`venerate	V	"V"
`venge	V	"V"
`vent	V-to-N	"V"
`ventilate	V	"V"
`venture	V-to-N	"V"
`verge	V-to-N	"V"
`verify	V	"V"
`verse	V	"V"
`vest	V	"V"
`vex	V	"V"
`vibrate	V	"V"
`vie	V	"V"
`vying	V	"V(`vie)+PRG"
`vilify	V	"V"
`vindicate	V	"V"
`violate	V	"V"
`visit	V-to-N	"V"
`vitiate	V	"V"
`vitrify	V	"V"
vi`tuperate	V	"V"
`vivify	V	"V"
`vivisect	V	"V"
vo`ciferate	V	"V"
`vomit	V-to-N	"V"
`vouch	V	"V"
vouch`safe	V	"V"

`waddle	V	"V"
`wade	V	"V"
`waffle	V	"V"
`waft	V	"V"
`wag	V	"V"
`wage	V	"V"
`waggle	V	"V"
`wail	V-to-N	"V"
`wait	V-to-N	"V"
`waive	V	"V"
`waken	V	"V"
`walk	V-to-N	"V"
`wallop	V-to-N	"V"
`wallow	V	"V"
`wander	V	"V"
`wane	V	"V"
`wangle	V	"V"
`want	V	"V"
`warble	V	"V"
`ward	V	"V"
`warn	V	"V"
`warp	V	"V"
`warrant	V	"V"
`wash	V-to-N	"V"
`waste	V-to-N	"V"
`watch	V	"V"
`waterlog	V	"V"
`wave	V-to-N	"V"
`waver	V	"V"
`wean	V	"V"
`weatherstrip	V	"V"
`weigh	V	"V"
`welcome	V-to-N	"V"
`weld	V-to-N	"V"
`well	V	"V"
`welsh	V	"V"
`welter	V-to-N	"V"
`wend	V	"V"
`whack	V-to-N	"V"
`wham	V-to-N	"V"
`wheedle	V	"V"
`wheeze	V-to-N	"V"
`whelm	V	"V"
`whelp	V	"V"
`whet	V	"V"
`whiff	V-to-N	"V"
`while	V	"V"
`whimper	V-to-N	"V"
`whine	V-to-N	"V"
`whinny	V-to-N	"V"
`whir	V-to-N	"V"
`whirl	V-to-N	"V"
`whish	V-to-N	"V"
`whisper	V-to-N	"V"
`whistle	V-to-N	"V"
`whitewash	V	"V"
`whittle	V	"V"
`whiz	V-to-N	"V"
`whizzed	PTC_SUFFIX	"V(`whiz)+PTC"
`whizzing	PTC_SUFFIX	"V(`whiz)+PRG"
`whoop	V-to-N	"V"
`whop	V-to-N	"V"
`whump	V-to-N	"V"
`wield	V	"V"
`wig	V	"V"
`wiggle	V	"V"
`wilt	V	"V"
`wince	V-to-N	"V"
`wink	V-to-N	"V"
`winnow	V	"V"
`wipe	V-to-N	"V"
`wish	V-to-N	"V"
`wither	V	"V"
`wizen	V	"V"
`wobble	V-to-N	"V"
`wonder	V-to-N	"V"
`woo	V	"V"
`work	V-to-N	"V"
`worry	V-to-N	"V"
`wot	V	"V"
`wow	V	"V"
`wrack	V	"V"
`wrangle	V-to-N	"V"
`wrap	V	"V"
`wreak	V	"V"
`wreathe	V	"V"
`wreck	V-to-N	"V"
`wrench	V-to-N	"V"
`wrest	V	"V"
`wrestle	V	"V"
`wriggle	V	"V"
`writhe	V	"V"

`yammer	V	"V"
`yank	V-to-N	"V"
`yap	V-to-N	"V"
`yaw	V	"V"
`yawn	V-to-N	"V"
`yearn	V	"V"
`yell	V-to-N	"V"
`yield	V	"V"
`yip	V-to-N	"V"
`yodel	V	"V"
`yowl	V-to-N	"V"

`zap	V	"V"
`zero	V	"V"
`zip	V	"V"
`zoom	V-to-N	"V"

END
