#************************************************************************
#* MODULE INFORMATION*
#*********************
#*     FILE     NAME:       BUFM.MAK
#*     SYSTEM   NAME:       BEHOLDER
#*     ORIGINAL AUTHOR(S):  Jan van Oorschot
#*     VERSION  NUMBER:     1.00
#*     CREATION DATE:       16-10-90
#*
#* DESCRIPTION: Global makefile for the Buffer Management
#*              library.
#************************************************************************
#* CHANGES INFORMATION **
#************************
#* REVISION:    $Revision:   1.1  $
#* WORKFILE:    $Workfile:   BUFM.mak  $
#* LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/BUFM/VCS/BUFM.MAV  $
#  
#     Rev 1.1   01 Feb 1991 10:17:56   etstjan
#  
#     Rev 1.0   01 Feb 1991 10:16:58   etstjan
#  Initial revision.
#************************************************************************
HOMEDIR=..
NEWTREE=.^\
MODEL=L
MODE=r
CFLAGS=/W4 /Ox /A$(MODEL) /L$(MODE) /I$(HOMEDIR)\INCLUDE /I..\INCLUDE
LFLAGS=/STACK:8000
MFLAGS = HOMEDIR=$(HOMEDIR) CFLAGS="$(CFLAGS)" LFLAGS="$(LFLAGS)" MODE=$(MODE) MODEL=$(MODEL)
ID=$(HOMEDIR)\INCLUDE
LD=$(HOMEDIR)\LIB
PUTNOTE="No explicit note"

SYSTEM=BUFM
LIBS=$(LD)\$(MODEL)$(SYSTEM)$(MODE).lib
CS= BUFM.C
AS=
CTS= IPBMTST.C
HS=BUFM.H
MAKS=$(SYSTEM).mak IPBMTST.MAK
DOCS=
SRCS=$(CS) $(AS) $(HS) $(DOCS) $(CTS) 
OBJS=BUFM.OBJ
TOBJS=
EXES=
TEXES= 
EXPORTS=$(ID)\BUFM.H \
        $(LD)\$(MODEL)$(SYSTEM)$(MODE).lib
#************************************************************************
#*  Supported make commands:
#*
#*      all     -->     do a full make of this system part
#*      compile -->     do a compile of all c-files
#*      lib     -->     collect all obj's in a lib
#*      exe     -->     make exe's
#*      clean   -->     throw out all garbage
#*      collect -->     copy all .lib and .h files to global directories
#*      put     -->     do a PVCS put of the sources 
#*      get     -->     do a PVCS get of the sources
#*      getlock -->     do a PVCS get of the sources and put a lock on them
#*      makedir -->     Make all subdirectories in the given
#*                      tree $(NEWTREE)
#************************************************************************
all:  lib 
    @echo .... Ready  $(MODEL)$(SYSTEM)$(MODE).lib


compile:    $(OBJS)

lib: $(MODEL)$(SYSTEM)$(MODE).lib

exe:   $(EXE) $(TEXES)

clean:
    @-del *.obj 2>nul
    @-del *.lib 2>nul
    @-del *.bak 2>nul
    @-del *.err 2>nul


collect: $(EXPORTS)
    !-copy $(**F) $**


put:    $(SRCS) $(MAKS)
    !@-PUT -l -n -t$(PUTNOTE) $**

getlock:    $(SRCS)
    !-GET -l $**


get:    $(SRCS)
    !GET  $**

makedir:
    mkdir $(NEWTREE)\VCS

#************************************************************************
#*  actual components and relations
#************************************************************************
$(MODEL)$(SYSTEM)$(MODE).lib : $(OBJS)
    !LIB $@ -+$**;
    copy $(MODEL)$(SYSTEM)$(MODE).lib $(LD)

$(SRCS) :

$(EXPORTS) :

