/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       mat.c
**     SYSTEM   NAME:       BEHOLDER
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     1
**     CREATION DATE:       1991/1/14
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   MAT.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/MAT/VCS/MAT.C_V  $
**              
**                 Rev 1.0   31 Jan 1991 16:47:02   etstjan
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/MAT/VCS/MAT.C_V   1.0   31 Jan 1991 16:47:02   etstjan  $";
#endif

#define IPS_DOS

#include <stdlib.h>
#include <stdio.h>
#include <beholder.h>
#include <power3.h>
#include <bufm.h>
#include <snmp.h>
#include <mib2.h>
#include <dp.h>
#include <futil.h>
#include <ml.h>
#include <mat.h>      
#include <error.h>


#define MATGETHOST       1,3,6,1,4,1,99,2,4,1
#define MATGETHOSTLEN    10 
#define MATGETCONN       1,3,6,1,4,1,99,2,5,1
#define MATGETCONNLEN    10 
#define MATSETOJI        1,3,6,1,4,1,99,2,6,0
#define MATSETOJILEN     9 

typedef struct _MAT_PAR
{
    int Hosts;
    int Conns;
    int Hash;
    int Over;
}   MAT_PAR;

typedef struct _MAT_DUMP
{
    FILE            *File;
    MAT_CONN        *Conn;
    MAT_HOST        *Src;
    MAT_HOST        *Dst;
    unsigned        Ind;
    unsigned        Dev;
}   MAT_DUMP;

static int  ProcessEvent (DPEVENT Event);
static void Init (void);
static void ReceivePkt (void);
static void Reset (void);
static void Start (void);
static void Stop (void);
static void FreeTime (void);
static void Show (void);
static void Hide (void);
static void KeyPressed (void);
static void Timer (void);

static unsigned MatGetConn(pkt_obj *Obj, void *Arg);
static unsigned MatNxtConn(pkt_obj *Obj, void *Arg);
static unsigned MatGetHost(pkt_obj *Obj, void *Arg);
static unsigned MatNxtHost(pkt_obj *Obj, void *Arg);
static unsigned MatSet(pkt_obj *Obj, void *Arg);

static int              MatInit=0;
static int              MatVisible=0;
static int              MatDevFocus=0;
static unsigned         MatDevCount;
static unsigned         MatApps;
SDM_MATRIX              *MatSdm[DPMAXDEV];
MAT_PAR                 MatPar[DPMAXDEV];
MAT_DUMP                MatDump={NULL,NULL,NULL,NULL,0,0};


DPAPPS DpaMat = {
    "Matrix",
    ProcessEvent,
    0,                                     
    DPE_START | DPE_STOP | DPE_RESET | DPE_RECEIVEPKT | DPE_FREETIME | DPE_INIT,
    DPE_START | DPE_RESET,
    DPE_RESET,
    5000,
    0,
    0,
    0,
    0,                                      /* Count of active filters      */
    {0}                                     /* List of active Filters       */
};



static int ProcessEvent (DPEVENT Event)
{
    switch (Event)
    {
        case DPE_INIT:          Init();         break;
        case DPE_RECEIVEPKT:    ReceivePkt();   break;
        case DPE_RESET:         Reset ();       break;
        case DPE_START:         Start ();       break;
        case DPE_STOP:          Stop ();        break;
        case DPE_FREETIME:      FreeTime ();    break;
    }
    return 0;
}



static void Reset (void)
{
    unsigned        Dev;
    
    ERR_DEB(ERR_MAT,2, "Matrix reset");
    for (Dev=0; Dev<MatDevCount; Dev++)
    {                       
        if (MatSdm[Dev]!=NULL)
            SdmClear(MatSdm[Dev]);
    }
}


static void Init (void)
{
    char Section[16], Variable[6];
    unsigned Dev;
    FILE *Cfg;
    
    MatDevCount = DpDevGetCount();
    MatApps = DpAppsGetApps("Matrix");
    ERR_DEB(ERR_MAT,2, "Matrix is Apps %d",MatApps);
    if ((Cfg = fopen (ConfigFile,"r")) == NULL)
    {
        ERR_ERR (ERR_MAT, ERR_CRITICAL, "Cannot open configfile\n");
        return;
    }
    for (Dev=0;Dev<MatDevCount;Dev++)
    {
        MatPar[Dev].Hosts=800;
        MatPar[Dev].Conns=1600;
        MatPar[Dev].Hash=1000;
        MatPar[Dev].Over=500;
        sprintf(Section,"MATRIX%d",Dev);
        if (FFindSection (Cfg, Section) >= 0)
        {
            if (FGetVar (Cfg, "HOSTTABLELENGTH", Variable, 5, UPC) >= 0)
                MatPar[Dev].Hosts=atoi(Variable);
            else
                ERR_ERR (ERR_MAT, ERR_WARNING, "Cannot find HostTableLength");
            if (FGetVar (Cfg, "CONNECTIONTABLELENGTH", Variable, 5, UPC) >= 0)
                MatPar[Dev].Conns=atoi(Variable);
            else
                ERR_ERR (ERR_MAT, ERR_WARNING, "Cannot find ConnectionTableLength");
            if (FGetVar (Cfg, "HASHTABLELENGTH", Variable, 5, UPC) >= 0)
                MatPar[Dev].Hash=atoi(Variable);
            else
                ERR_ERR (ERR_MAT, ERR_WARNING, "Cannot find HashTableLength");
            if (FGetVar (Cfg, "HASHOVERFLOW", Variable, 5, UPC) >= 0)
                MatPar[Dev].Over=atoi(Variable);
            else
                ERR_ERR (ERR_MAT, ERR_WARNING, "Cannot find HashOverflow");
            if ((MatSdm[Dev]=SdmCreate(6,sizeof(MAT_HOST),sizeof(MAT_CONN),
                MatPar[Dev].Hosts,MatPar[Dev].Conns,MatPar[Dev].Hash,MatPar[Dev].Over))==NULL)
            {
                ERR_ERR(ERR_MAT, ERR_FATAL,"No room for matrix");
                return;
            }
        }
        else
        {
            ERR_ERR (ERR_MAT, ERR_WARNING, "Cannot find section %s", Section);
            MatSdm[Dev]=NULL;
        }
    }
    fclose (Cfg);
    Reset();
}


static void Start (void)
{
    mib_prf *Prf;
    unsigned Dev;
    unsigned GetConn[] = {MATGETCONN};
    unsigned GetHost[] = {MATGETHOST};
    unsigned SetOji[] = {MATSETOJI};

    if (MatInit == 0)
    {
        if ((Prf = MibAddPrf ("public", 6)) == NULL)
            return;
        if ((MibAddObj (Prf, GetHost, MATGETHOSTLEN, MatGetHost, MatNxtHost, NULL, NULL)) < 0)
            return;
        if ((MibAddObj (Prf, GetConn, MATGETCONNLEN, MatGetConn, MatNxtConn, NULL, NULL)) < 0)
            return;
        for (Dev=0;Dev<MatDevCount;Dev++)
        {
            SetOji[MATSETOJILEN+0]=Dev;
            if ((MibAddObj (Prf, SetOji, MATSETOJILEN+1, NULL, NULL, MatSet, NULL)) < 0)
                return;
        }
        MatInit = 1;
    }
}

static void Stop (void)
{
    return;
}



static void ReceivePkt (void)
{
    DPBUF               *Buf;
    int                 Dev;
    unsigned            Length, Type;
    long unsigned       Time;
    BYTE                Src[20], Dst[20];
    SDM_CONN_DATA       *Data;
    MAT_CONN            *Conn;
    unsigned            New;

    Buf = DpReceivePkt ();
    Dev = Buf->Dev;
    if (MatSdm[Dev]==NULL)
        return;
    Length = MLGetLength (Buf);
    Type = MLGetProtocol (Buf);
    MLGetSrcAddress (Buf, Src);
    MLGetDstAddress (Buf, Dst);
    if (memcmp(Dst,"\xFF\xFF\xFF\xFF\xFF\xFF",6)==0 && SdmGetHost(MatSdm[Dev],Src)==NULL)
        return;
    Data = SdmCreateConn (MatSdm[Dev], Src, Dst, &New);
    Time = DpAppsGetTimer(MatApps);
    ERR_DEB(ERR_MAT,5,"%02x:%02x:%02x:%02x:%02x:%02x %02x:%02x:%02x:%02x:%02x:%02x %u\n",
    Src[0],Src[1],Src[2],Src[3],Src[4],Src[5],
    Dst[0],Dst[1],Dst[2],Dst[3],Dst[4],Dst[5],
    New); 
    if (Data!=NULL)
    {
        Conn=(MAT_CONN *)(Data->Conn);
        if (New & SDM_MASK_CONN)
        {
            Conn->Packets=1;
            Conn->Bytes=Length;
            Conn->Bits=0;
        }
        else
        {
            Conn->Packets++;
            Conn->Bytes+=Length;
        }
        Conn->TimeLast=Time;
    }
}

static void FreeTime (void)
{
    SDM_CONN_DATA           *Data;
    MAT_CONN                *Conn;
    BYTE                    *Src,*Dst;
    
    if (MatDump.File!=NULL)
    {
        Conn=(MAT_CONN *)(MatDump.Conn);
        Src=(BYTE *)(MatDump.Src);
        Dst=(BYTE *)(MatDump.Dst);
        fprintf(MatDump.File,"%u %u %02x:%02x:%02x:%02x:%02x:%02x %02x:%02x:%02x:%02x:%02x:%02x %lu %lu %lu %lu\n",
        MatDump.Ind++,
        MatDump.Dev,
        Src[0],Src[1],Src[2],Src[3],Src[4],Src[5],
        Dst[0],Dst[1],Dst[2],Dst[3],Dst[4],Dst[5],
        DpAppsGetTimer(MatApps),
        Conn->Packets, Conn->Bytes, Conn->TimeLast); 
        Data=SdmNextConn(MatSdm[MatDump.Dev],Src,Dst);
        if (Data==NULL)
        {
            fclose(MatDump.File);
            MatDump.File=NULL;
        }
        else
        {
            MatDump.Conn=Data->Conn;
            MatDump.Src=Data->Src;
            MatDump.Dst=Data->Dst;
        }
    }
    return;
}




/* <Variable>.<Col>.<Dev>.<Source[n]>.<Destination[n]> */
/* Length:    1     1     n           n                */
/* Offset:    0     1     2           2+n              */

static unsigned MatGetConn(pkt_obj *Obj, void *Arg)
{
    unsigned Dev, Col, Len, Ind;
    BYTE Src[20], Dst[20];
    SDM_CONN_DATA *Conn;
    MAT_CONN *Data;
    
    Col=Obj->ObjOji[MATGETCONNLEN+0];
    if (Col<1 || Col>7)
        return(PKT_NOSUCHNAME);
    Dev=Obj->ObjOji[MATGETCONNLEN+1];
    if (Dev>=MatDevCount)
        return(PKT_NOSUCHNAME);
    Len=MatSdm[Dev]->AddrSize;
    if (Obj->ObjOjiLen!=MATGETCONNLEN+1+1+2*Len)
        return(PKT_NOSUCHNAME);
    for (Ind=0;Ind<Len;Ind++)
    {
        Src[Ind]=(BYTE)Obj->ObjOji[MATGETCONNLEN+2+Ind];
        Dst[Ind]=(BYTE)Obj->ObjOji[MATGETCONNLEN+2+Len+Ind];
    }
    if ((Conn=SdmGetConn(MatSdm[Dev],Src,Dst))==NULL)
        return(PKT_NOSUCHNAME);
    Data=(MAT_CONN *)(Conn->Conn);
    switch(Col)
    {
        case 1:
            Obj->ObjTag=PKT_INTEGER;
            Obj->ObjSyn.SynLngInt=Dev;
            break;
        case 2:
            Obj->ObjTag=PKT_OCTETSTRING;
            memcpy(Obj->ObjSyn.SynBufChr, Conn->Src, Len);
            Obj->ObjSynLen=Len;
            break;
        case 3:
            Obj->ObjTag=PKT_OCTETSTRING;
            memcpy(Obj->ObjSyn.SynBufChr, Conn->Dst, Len);
            Obj->ObjSynLen=Len;
            break;
        case 4:
            Obj->ObjTag=PKT_TIMETICKS;
	        Obj->ObjSyn.SynLngInt= DpAppsGetTimer(MatApps)/10;
            break;
        case 5:
            Obj->ObjTag=PKT_COUNTER;
	        Obj->ObjSyn.SynLngInt=Data->Packets;
            break;
        case 6:
            Obj->ObjTag=PKT_COUNTER;
	        Obj->ObjSyn.SynLngInt=Data->Bytes;
            break;
        case 7:
            Obj->ObjTag=PKT_TIMETICKS;
	        Obj->ObjSyn.SynLngInt=Data->TimeLast/10;
            break;
    }
    return(PKT_NOERROR);
}

static unsigned MatNxtConn(pkt_obj *Obj, void *Arg)
{
    unsigned Dev, Col, Len, Ind;
    BYTE Src[20], Dst[20];
    SDM_CONN_DATA *Conn;
    MAT_CONN *Data;
    
    if (Obj->ObjOjiLen<=MATGETCONNLEN)
    {
        Col=Obj->ObjOji[MATGETCONNLEN+0]=1;
        (Obj->ObjOjiLen)++;
    }
    else
    {
        Col=Obj->ObjOji[MATGETCONNLEN+0];
        if (Col<1 || Col>7)
            return(PKT_NOSUCHNAME);
    }
    if (Obj->ObjOjiLen<=MATGETCONNLEN+1)
    {
        Dev=Obj->ObjOji[MATGETCONNLEN+1]=0;
        (Obj->ObjOjiLen)++;
    }
    else
    {
        Dev=Obj->ObjOji[MATGETCONNLEN+1];
        if (Dev>=MatDevCount)
            return(PKT_NOSUCHNAME);
    }
    Len=MatSdm[Dev]->AddrSize;
    while (Obj->ObjOjiLen < MATGETCONNLEN+1+1+2*Len)
    {
        Obj->ObjOji[(Obj->ObjOjiLen)]=0;
        (Obj->ObjOjiLen)++;
    }
    for (Ind=0;Ind<Len;Ind++)
    {
        Src[Ind]=(BYTE)Obj->ObjOji[MATGETCONNLEN+2+Ind];
        Dst[Ind]=(BYTE)Obj->ObjOji[MATGETCONNLEN+2+Len+Ind];
    }
    Conn=SdmNextConn(MatSdm[Dev],Src,Dst);
    while (Conn==NULL)
    {
        if (Dev++>=MatDevCount)
        {
            Dev=0;
            if (++Col>7)
                return(PKT_NOSUCHNAME);
        }
        Conn=SdmFirstConn(MatSdm[Dev]);
    }
    Obj->ObjOji[MATGETCONNLEN+0]=Col;
    Obj->ObjOji[MATGETCONNLEN+1]=Dev;
    for (Ind=0;Ind<Len;Ind++)
    {
        Obj->ObjOji[MATGETCONNLEN+2+Ind]    =((BYTE *)(Conn->Src))[Ind];
        Obj->ObjOji[MATGETCONNLEN+2+Len+Ind]=((BYTE *)(Conn->Dst))[Ind];
    }
    Data=(MAT_CONN *)(Conn->Conn);
    switch(Col)
    {
        case 1:
            Obj->ObjTag=PKT_INTEGER;
            Obj->ObjSyn.SynLngInt=Dev;
            break;
        case 2:
            Obj->ObjTag=PKT_OCTETSTRING;
            memcpy(Obj->ObjSyn.SynBufChr, Conn->Src, Len);
            Obj->ObjSynLen=Len;
            break;
        case 3:
            Obj->ObjTag=PKT_OCTETSTRING;
            memcpy(Obj->ObjSyn.SynBufChr, Conn->Dst, Len);
            Obj->ObjSynLen=Len;
            break;
        case 4:
            Obj->ObjTag=PKT_TIMETICKS;
	        Obj->ObjSyn.SynLngInt= DpAppsGetTimer(MatApps)/10;
            break;
        case 5:
            Obj->ObjTag=PKT_COUNTER;
	        Obj->ObjSyn.SynLngInt=Data->Packets;
            break;
        case 6:
            Obj->ObjTag=PKT_COUNTER;
	        Obj->ObjSyn.SynLngInt=Data->Bytes;
            break;
        case 7:
            Obj->ObjTag=PKT_TIMETICKS;
	        Obj->ObjSyn.SynLngInt=Data->TimeLast/10;
            break;
    }
    return(PKT_NOERROR);
}
static unsigned MatGetHost(pkt_obj *Obj, void *Arg)
{
    unsigned Dev, Col, Len, Ind;
    BYTE Addr[20];
    BYTE *Host;
    
    Col=Obj->ObjOji[MATGETCONNLEN+0];
    if (Col<1 || Col>2)
        return(PKT_NOSUCHNAME);
    Dev=Obj->ObjOji[MATGETCONNLEN+1];
    if (Dev>=MatDevCount)
        return(PKT_NOSUCHNAME);
    Len=MatSdm[Dev]->AddrSize;
    if (Obj->ObjOjiLen!=MATGETCONNLEN+1+1+Len)
        return(PKT_NOSUCHNAME);
    for (Ind=0;Ind<Len;Ind++)
    {
        Addr[Ind]=(BYTE)Obj->ObjOji[MATGETCONNLEN+2+Ind];
    }
    if ((Host=SdmGetHost(MatSdm[Dev],Addr))==NULL)
        return(PKT_NOSUCHNAME);
    switch(Col)
    {
        case 1:
            Obj->ObjTag=PKT_INTEGER;
            Obj->ObjSyn.SynLngInt=Dev;
            break;
        case 2:
            Obj->ObjTag=PKT_OCTETSTRING;
            memcpy(Obj->ObjSyn.SynBufChr, Host, Len);
            Obj->ObjSynLen=Len;
            break;
    }
    return(PKT_NOERROR);
}

static unsigned MatNxtHost(pkt_obj *Obj, void *Arg)
{
    unsigned Dev, Col, Len, Ind;
    BYTE Addr[20];
    BYTE *Host;
    
    if (Obj->ObjOjiLen<=MATGETHOSTLEN)
    {
        Col=Obj->ObjOji[MATGETHOSTLEN+0]=1;
        (Obj->ObjOjiLen)++;
    }
    else
    {
        Col=Obj->ObjOji[MATGETHOSTLEN+0];
        if (Col<1 || Col>2)
            return(PKT_NOSUCHNAME);
    }
    if (Obj->ObjOjiLen<=MATGETHOSTLEN+1)
    {
        Dev=Obj->ObjOji[MATGETHOSTLEN+1]=0;
        (Obj->ObjOjiLen)++;
    }
    else
    {
        Dev=Obj->ObjOji[MATGETHOSTLEN+1];
        if (Dev>=MatDevCount)
            return(PKT_NOSUCHNAME);
    }
    Len=MatSdm[Dev]->AddrSize;
    while (Obj->ObjOjiLen < MATGETHOSTLEN+1+1+Len)
    {
        Obj->ObjOji[(Obj->ObjOjiLen)]=0;
        (Obj->ObjOjiLen)++;
    }
    for (Ind=0;Ind<Len;Ind++)
    {
        Addr[Ind]=(BYTE)Obj->ObjOji[MATGETHOSTLEN+2+Ind];
    }
    Host=SdmNextHost(MatSdm[Dev],Addr);
    while (Host==NULL)
    {
        if (Dev++>=MatDevCount)
        {
            Dev=0;
            if (++Col>2)
                return(PKT_NOSUCHNAME);
        }
        Host=SdmFirstHost(MatSdm[Dev]);
    }
    Obj->ObjOji[MATGETHOSTLEN+0]=Col;
    Obj->ObjOji[MATGETHOSTLEN+1]=Dev;
    for (Ind=0;Ind<Len;Ind++)
    {
        Obj->ObjOji[MATGETHOSTLEN+2+Ind]=Host[Ind];
    }
    switch(Col)
    {
        case 1:
            Obj->ObjTag=PKT_INTEGER;
            Obj->ObjSyn.SynLngInt=Dev;
            break;
        case 2:
            Obj->ObjTag=PKT_OCTETSTRING;
            memcpy(Obj->ObjSyn.SynBufChr, Host, Len);
            Obj->ObjSynLen=Len;
            break;
    }
    return(PKT_NOERROR);
}

static unsigned MatSet(pkt_obj *Obj, void *Arg)
{
    unsigned        Dev;
    SDM_CONN_DATA   *Data;
    
    if (Obj->ObjOjiLen!=MATSETOJILEN+1)
        return(PKT_NOSUCHNAME);
    Dev=Obj->ObjOji[MATSETOJILEN+0];
    if (Dev>=MatDevCount)
        return(PKT_NOSUCHNAME);
    if (Obj->ObjTag!=PKT_OCTETSTRING)
        return(PKT_BADVALUE);
    if (MatDump.File!=NULL)
        return(PKT_GENERR);
    Obj->ObjSyn.SynBufChr[Obj->ObjSynLen]='\0';
    MatDump.File=fopen(Obj->ObjSyn.SynBufChr,"w");
    if (MatDump.File==NULL)
        return(PKT_GENERR);
    MatDump.Dev=Dev;
    MatDump.Ind=1;
    Data=SdmFirstConn(MatSdm[Dev]);
    MatDump.Conn=Data->Conn;
    MatDump.Src=Data->Src;
    MatDump.Dst=Data->Dst;
    return(PKT_NOERROR);
}
