	if1
	%out	TOGGLE.ASM
	endif
	if2
	%out	*** PASS 2
	endif
	name	TOGGLE
	title	TOGGLE
	page	,132

; ************************************************************************
; **									**
; ** filename:	toggle.asm						**
; **									**
; **	Provides an MS-DOS utility to control CAPS LOCK, NUM LOCK, and	**
; ** SCROLL LOCK.							**
; **									**
; ************************************************************************

code	segment

	assume	cs:code,ds:code,es:code

	org	100H

toggle	proc	far

	push	ds			;
	pop	di			; store data segment register
	mov	ax,0			;
	push	ax			;
	pop	ds			; point data segment to paragraph 0
	mov	bx,0417H		; point to shift status byte
	mov	si,80H			; point to parameter count
	mov	cl,cs:[si]		; load parameter count
	mov	ch,0			; cx = paramter count
	add	si,2			; point to parameters
	dec	cx			; adjust counter - done?

find_slash:
	jcxz	done			; yes - terminate

	mov	al,cs:[si]		; no - load character
	inc	si			; point to next character
	dec	cx			; retard counter
	cmp	al,'/'			; slash?
	jne	find_slash		; no - continue

find_cmd:
	jcxz	done			; done? - yes - terminate

	mov	al,cs:[si]		; no - load character
	inc	si			; point to next character
	dec	cx			; retard counter
	and	al,not('a' xor 'A')	; convert character to upper case
	cmp	al,'C'			; C?
	jne	find_cmd_05		; no - test for N

	jmp	C_switch		; yes - determine CAPS ON or OFF

find_cmd_05:
	cmp	al,'N'			; N?
	jne	find_cmd_10		; no - test for S

	jmp	N_switch		; yes - determine NUM ON or OFF

find_cmd_10:
	cmp	al,'S'			; S?
	jne	find_slash		; no - find slash

	jmp	S_switch		; no - determine SCROLL ON or OFF

C_switch:
	jcxz	done			; end of paramters? - yes - done

	mov	al,cs:[si]		; no - load character
	inc	si			; point to next character
	dec	cx			; retard counter
	cmp	al,'+'			; +?
	jne	C_switch_05		; no - test for -

	call	caps_on			; yes - turn on CAPS
	jmp	find_slash		; continue

C_switch_05:
	cmp	al,'-'			; -?
	je	C_switch_10		; yes - turn off CAPS

	jmp	find_slash		; no - continue

C_switch_10:
	call	caps_off		; yes - turn off CAPS
	jmp	find_slash		; continue

N_switch:
	jcxz	done			; end of paramters? - yes - done

	mov	al,cs:[si]		; no - load character
	inc	si			; point to next character
	dec	cx			; retard counter
	cmp	al,'+'			; +?
	jne	N_switch_05		; no - test for -

	call	num_on			; yes - turn on NUM
	jmp	find_slash		; continue

N_switch_05:
	cmp	al,'-'			; -?
	je	N_switch_10		; yes - turn off NUM

	jmp	find_slash		; no - continue

N_switch_10:
	call	num_off			; yes - turn off NUM
	jmp	find_slash		; continue

S_switch:
	jcxz	done			; end of paramters? - yes - done

	mov	al,cs:[si]		; no - load character
	inc	si			; point to next character
	dec	cx			; retard counter
	cmp	al,'+'			; +?
	jne	S_switch_05		; no - test for -

	call	scroll_on		; yes - turn on SCROLL
	jmp	find_slash		; continue

S_switch_05:
	cmp	al,'-'			; -?
	je	S_switch_10		; yes - turn off SCROLL

	jmp	find_slash		; no - continue

S_switch_10:
	call	scroll_off		; yes - turn off SCROLL
	jmp	find_slash		; continue

done:
	push	di			;
	pop	ds			; restore data segment register
	int	20H			; return to DOS

toggle	endp
	page
subs	proc	near

caps_on:
	mov	al,[bx]			; load shift status byte
	or	al,01000000B		; turn CAPS LOCK on
	mov	[bx],al			; store shift status byte
	ret				;

caps_off:
	mov	al,[bx]			; load shift status byte
	and	al,10111111B		; turn CAPS LOCK off
	mov	[bx],al			; store shift status byte
	ret				;

num_on:
	mov	al,[bx]			; load shift status byte
	or	al,00100000B		; turn NUM LOCK on
	mov	[bx],al			; store shift status byte
	ret				;

num_off:
	mov	al,[bx]			; load shift status byte
	and	al,11011111B		; turn NUM LOCK off
	mov	[bx],al			; store shift status byte
	ret				;

scroll_on:
	mov	al,[bx]			; load shift status byte
	or	al,00010000B		; turn SCROLL LOCK on
	mov	[bx],al			; store shift status byte
	ret				;

scroll_off:
	mov	al,[bx]			; load shift status byte
	and	al,11101111B		; turn SCROLL LOCK off
	mov	[bx],al			; store shift status byte
	ret				;

subs	endp

code	ends

	end	toggle
